/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.FunctionKind;
import com.blazebit.persistence.parser.JPQLNextParser;
import com.blazebit.persistence.parser.JPQLNextParserBaseVisitor;
import com.blazebit.persistence.parser.antlr.CharStream;
import com.blazebit.persistence.parser.antlr.ParserRuleContext;
import com.blazebit.persistence.parser.antlr.Token;
import com.blazebit.persistence.parser.antlr.misc.Interval;
import com.blazebit.persistence.parser.antlr.tree.ErrorNode;
import com.blazebit.persistence.parser.antlr.tree.ParseTree;
import com.blazebit.persistence.parser.antlr.tree.TerminalNode;
import com.blazebit.persistence.parser.expression.AggregateExpression;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.ArithmeticOperator;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.LiteralExpression;
import com.blazebit.persistence.parser.expression.MacroFunction;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.NumericType;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SyntaxErrorException;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.Trimspec;
import com.blazebit.persistence.parser.expression.TypeFunctionExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.expression.WindowFrameExclusionType;
import com.blazebit.persistence.parser.expression.WindowFrameMode;
import com.blazebit.persistence.parser.expression.WindowFramePositionType;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateQuantifier;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JPQLNextExpressionVisitorImpl
extends JPQLNextParserBaseVisitor<Expression> {
    private final Map<String, FunctionKind> functions;
    private final Map<String, Class<Enum<?>>> enums;
    private final Map<String, Class<Enum<?>>> enumsForLiterals;
    private final Map<String, Class<?>> entities;
    private final int minEnumSegmentCount;
    private final int minEntitySegmentCount;
    private final Map<String, MacroFunction> macros;
    private final Set<String> usedMacros;
    private final boolean allowOuter;
    private final boolean allowQuantifiedPredicates;
    private final boolean allowObjectExpression;
    private final CharStream input;

    public JPQLNextExpressionVisitorImpl(Map<String, FunctionKind> functions, Map<String, Class<Enum<?>>> enums, Map<String, Class<Enum<?>>> enumsForLiterals, Map<String, Class<?>> entities, int minEnumSegmentCount, int minEntitySegmentCount, Map<String, MacroFunction> macros, Set<String> usedMacros, boolean allowOuter, boolean allowQuantifiedPredicates, boolean allowObjectExpression, CharStream input) {
        this.functions = functions;
        this.enums = enums;
        this.enumsForLiterals = enumsForLiterals;
        this.entities = entities;
        this.minEnumSegmentCount = minEnumSegmentCount;
        this.minEntitySegmentCount = minEntitySegmentCount;
        this.macros = macros;
        this.usedMacros = usedMacros;
        this.allowOuter = allowOuter;
        this.allowQuantifiedPredicates = allowQuantifiedPredicates;
        this.allowObjectExpression = allowObjectExpression;
        this.input = input;
    }

    @Override
    public Expression visitParseSelectExpression(JPQLNextParser.ParseSelectExpressionContext ctx) {
        return ctx.getChild(0).accept(this);
    }

    @Override
    public Expression visitParsePathExpression(JPQLNextParser.ParsePathExpressionContext ctx) {
        return ctx.getChild(0).accept(this);
    }

    @Override
    public Expression visitParseExpression(JPQLNextParser.ParseExpressionContext ctx) {
        return ctx.getChild(0).accept(this);
    }

    @Override
    public Expression visitParseInItemExpression(JPQLNextParser.ParseInItemExpressionContext ctx) {
        return ctx.getChild(0).accept(this);
    }

    @Override
    public Predicate visitParsePredicate(JPQLNextParser.ParsePredicateContext ctx) {
        return (Predicate)ctx.getChild(0).accept(this);
    }

    @Override
    public Expression visitGroupedExpression(JPQLNextParser.GroupedExpressionContext ctx) {
        return ctx.expression().accept(this);
    }

    @Override
    public Expression visitConcatenationExpression(JPQLNextParser.ConcatenationExpressionContext ctx) {
        Expression left = ctx.lhs.accept(this);
        Expression right = ctx.rhs.accept(this);
        if (left instanceof FunctionExpression && "CONCAT".equalsIgnoreCase(((FunctionExpression)left).getFunctionName())) {
            ((FunctionExpression)left).getExpressions().add(right);
            return left;
        }
        if (right instanceof FunctionExpression && "CONCAT".equalsIgnoreCase(((FunctionExpression)right).getFunctionName())) {
            ((FunctionExpression)right).getExpressions().add(0, left);
            return right;
        }
        ArrayList<Expression> args = new ArrayList<Expression>(2);
        args.add(left);
        args.add(right);
        return new FunctionExpression("CONCAT", args);
    }

    @Override
    public Expression visitMultiplicativeExpression(JPQLNextParser.MultiplicativeExpressionContext ctx) {
        Expression lhs = ctx.getChild(0).accept(this);
        Expression rhs = ctx.getChild(2).accept(this);
        TerminalNode terminalNode = (TerminalNode)ctx.getChild(1);
        switch (terminalNode.getSymbol().getType()) {
            case 131: {
                return new ArithmeticExpression(lhs, rhs, ArithmeticOperator.DIVISION);
            }
            case 130: {
                return new ArithmeticExpression(lhs, rhs, ArithmeticOperator.MULTIPLICATION);
            }
            case 132: {
                ArrayList<Expression> args = new ArrayList<Expression>(2);
                args.add(lhs);
                args.add(rhs);
                return new FunctionExpression("MOD", args);
            }
        }
        throw new SyntaxErrorException("Invalid multiplicative operator: " + terminalNode.getText());
    }

    @Override
    public Expression visitAdditiveExpression(JPQLNextParser.AdditiveExpressionContext ctx) {
        Expression lhs = ctx.getChild(0).accept(this);
        Expression rhs = ctx.getChild(2).accept(this);
        TerminalNode terminalNode = (TerminalNode)ctx.getChild(1);
        switch (terminalNode.getSymbol().getType()) {
            case 128: {
                return new ArithmeticExpression(lhs, rhs, ArithmeticOperator.ADDITION);
            }
            case 129: {
                return new ArithmeticExpression(lhs, rhs, ArithmeticOperator.SUBTRACTION);
            }
        }
        throw new SyntaxErrorException("Invalid additive operator: " + terminalNode.getText());
    }

    @Override
    public Expression visitUnaryMinusExpression(JPQLNextParser.UnaryMinusExpressionContext ctx) {
        return new ArithmeticFactor(ctx.expression().accept(this), true);
    }

    @Override
    public Expression visitUnaryPlusExpression(JPQLNextParser.UnaryPlusExpressionContext ctx) {
        return ctx.expression().accept(this);
    }

    @Override
    public Expression visitSimpleCaseExpression(JPQLNextParser.SimpleCaseExpressionContext ctx) {
        List<JPQLNextParser.SimpleCaseWhenContext> simpleCaseWhenContexts = ctx.simpleCaseWhen();
        ArrayList<WhenClauseExpression> whenClauses = new ArrayList<WhenClauseExpression>(simpleCaseWhenContexts.size());
        for (int i = 0; i < simpleCaseWhenContexts.size(); ++i) {
            whenClauses.add(this.visitSimpleCaseWhen(simpleCaseWhenContexts.get(i)));
        }
        return new SimpleCaseExpression(ctx.operand.accept(this), whenClauses, ctx.otherwise == null ? null : ctx.otherwise.accept(this));
    }

    @Override
    public Expression visitGeneralCaseExpression(JPQLNextParser.GeneralCaseExpressionContext ctx) {
        List<JPQLNextParser.SearchedCaseWhenContext> searchedCaseWhenContexts = ctx.searchedCaseWhen();
        ArrayList<WhenClauseExpression> whenClauses = new ArrayList<WhenClauseExpression>(searchedCaseWhenContexts.size());
        for (int i = 0; i < searchedCaseWhenContexts.size(); ++i) {
            whenClauses.add(this.visitSearchedCaseWhen(searchedCaseWhenContexts.get(i)));
        }
        JPQLNextParser.ExpressionContext elseExpressionCtx = ctx.expression();
        return new GeneralCaseExpression(whenClauses, elseExpressionCtx == null ? null : elseExpressionCtx.accept(this));
    }

    @Override
    public WhenClauseExpression visitSimpleCaseWhen(JPQLNextParser.SimpleCaseWhenContext ctx) {
        return this.handleWhenClause(ctx.when, ctx.then);
    }

    @Override
    public WhenClauseExpression visitSearchedCaseWhen(JPQLNextParser.SearchedCaseWhenContext ctx) {
        return this.handleWhenClause(ctx.predicate(), ctx.expression());
    }

    private WhenClauseExpression handleWhenClause(ParserRuleContext condition, ParserRuleContext result) {
        return new WhenClauseExpression(condition.accept(this), result.accept(this));
    }

    @Override
    public Expression visitTimestampLiteral(JPQLNextParser.TimestampLiteralContext ctx) {
        return new TimestampLiteral(TypeUtils.TIMESTAMP_CONVERTER.convert(this.unquote(ctx.dateTimeLiteralText().getText())));
    }

    @Override
    public Expression visitDateLiteral(JPQLNextParser.DateLiteralContext ctx) {
        return new DateLiteral(TypeUtils.DATE_CONVERTER.convert(this.unquote(ctx.dateTimeLiteralText().getText())));
    }

    @Override
    public Expression visitTimeLiteral(JPQLNextParser.TimeLiteralContext ctx) {
        return new TimeLiteral(TypeUtils.TIME_CONVERTER.convert(this.unquote(ctx.dateTimeLiteralText().getText())));
    }

    private String unquote(String s) {
        return s.substring(1, s.length() - 1);
    }

    @Override
    public Expression visitNamedParameter(JPQLNextParser.NamedParameterContext ctx) {
        return new ParameterExpression(ctx.identifier().getText());
    }

    @Override
    public Expression visitPositionalParameter(JPQLNextParser.PositionalParameterContext ctx) {
        return new ParameterExpression(ctx.INTEGER_LITERAL().getText());
    }

    @Override
    public Expression visitEntityType(JPQLNextParser.EntityTypeContext ctx) {
        JPQLNextParser.ParameterContext parameter = ctx.parameter();
        Expression expression = parameter == null ? this.visitPath(ctx.path()) : parameter.accept(this);
        return new TypeFunctionExpression(expression);
    }

    @Override
    public Expression visitEntityTypeOrEnumLiteral(JPQLNextParser.EntityTypeOrEnumLiteralContext ctx) {
        String literalStr = ctx.getText();
        Expression literalExpression = this.createEnumLiteral(literalStr);
        if (literalExpression != null) {
            return literalExpression;
        }
        literalExpression = this.createEntityTypeLiteral(literalStr);
        if (literalExpression != null) {
            return literalExpression;
        }
        throw new SyntaxErrorException("Invalid literal: " + literalStr);
    }

    @Override
    public Expression visitTerminal(TerminalNode node) {
        if (node.getSymbol().getType() == -1) {
            return null;
        }
        switch (node.getSymbol().getType()) {
            case 70: {
                return NullExpression.INSTANCE;
            }
            case 8: 
            case 9: {
                String text = node.getText();
                StringBuilder sb = new StringBuilder(text.length());
                int end = text.length() - 1;
                char delimiter = text.charAt(0);
                for (int i = 1; i < end; ++i) {
                    int c = text.charAt(i);
                    block12 : switch (c) {
                        case 39: {
                            if (delimiter != '\'') break;
                            ++i;
                            break;
                        }
                        case 34: {
                            if (delimiter != '\"') break;
                            ++i;
                            break;
                        }
                        case 92: {
                            if (i + 1 >= end) break;
                            char nextChar = text.charAt(++i);
                            switch (nextChar) {
                                case 'b': {
                                    c = 8;
                                    break block12;
                                }
                                case 't': {
                                    c = 9;
                                    break block12;
                                }
                                case 'n': {
                                    c = 10;
                                    break block12;
                                }
                                case 'f': {
                                    c = 12;
                                    break block12;
                                }
                                case 'r': {
                                    c = 13;
                                    break block12;
                                }
                                case '\\': {
                                    c = 92;
                                    break block12;
                                }
                                case '\'': {
                                    c = 39;
                                    break block12;
                                }
                                case '\"': {
                                    c = 34;
                                    break block12;
                                }
                                case '`': {
                                    c = 96;
                                    break block12;
                                }
                                case 'u': {
                                    c = (char)Integer.parseInt(text.substring(i + 1, i + 5), 16);
                                    i += 4;
                                    break block12;
                                }
                            }
                            sb.append('\\');
                            c = nextChar;
                            break;
                        }
                    }
                    sb.append((char)c);
                }
                return new StringLiteral(sb.toString());
            }
            case 100: {
                return new BooleanLiteral(true);
            }
            case 41: {
                return new BooleanLiteral(false);
            }
            case 3: {
                return new NumericLiteral(node.getText(), NumericType.BIG_INTEGER);
            }
            case 2: {
                return new NumericLiteral(node.getText(), NumericType.INTEGER);
            }
            case 4: {
                return new NumericLiteral(node.getText(), NumericType.LONG);
            }
            case 5: {
                return new NumericLiteral(node.getText(), NumericType.FLOAT);
            }
            case 6: {
                return new NumericLiteral(node.getText(), NumericType.DOUBLE);
            }
            case 7: {
                return new NumericLiteral(node.getText(), NumericType.BIG_DECIMAL);
            }
        }
        throw new IllegalStateException("Terminal node '" + node.getText() + "' not handled");
    }

    @Override
    public Expression visitTrimFunction(JPQLNextParser.TrimFunctionContext ctx) {
        JPQLNextParser.TrimSpecificationContext trimSpecificationContext = ctx.trimSpecification();
        Trimspec trimspec = trimSpecificationContext != null ? Trimspec.valueOf(trimSpecificationContext.getText().toUpperCase()) : Trimspec.BOTH;
        Expression trimCharacter = null;
        JPQLNextParser.TrimCharacterContext trimCharacterContext = ctx.trimCharacter();
        if (trimCharacterContext != null) {
            trimCharacter = trimCharacterContext.accept(this);
        }
        return new TrimExpression(trimspec, trimCharacter, ctx.expression().accept(this));
    }

    @Override
    public Expression visitTemporalFunction(JPQLNextParser.TemporalFunctionContext ctx) {
        return new FunctionExpression(ctx.name.getText(), Collections.emptyList());
    }

    @Override
    public Expression visitTemporalFunctionExpression(JPQLNextParser.TemporalFunctionExpressionContext ctx) {
        return new FunctionExpression(ctx.name.getText(), Collections.emptyList());
    }

    @Override
    public Expression visitCountFunction(JPQLNextParser.CountFunctionContext ctx) {
        List<Expression> arguments;
        boolean distinct;
        boolean bl = distinct = ctx.DISTINCT() != null;
        if (ctx.ASTERISK() == null) {
            arguments = new ArrayList(1);
            arguments.add(ctx.expression().accept(this));
        } else {
            arguments = Collections.emptyList();
        }
        return this.handleFunction("COUNT", distinct, arguments, ctx, null, ctx.whereClause(), ctx.windowName, ctx.windowDefinition());
    }

    @Override
    public Expression visitGenericFunctionInvocation(JPQLNextParser.GenericFunctionInvocationContext ctx) {
        boolean distinct = ctx.DISTINCT() != null;
        List<JPQLNextParser.ExpressionContext> expressions = ctx.expression();
        int size = expressions.size();
        ArrayList<Expression> arguments = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            arguments.add(expressions.get(i).accept(this));
        }
        return this.handleFunction(ctx.name.getText(), distinct, arguments, ctx, ctx.orderByClause(), ctx.whereClause(), ctx.windowName, ctx.windowDefinition());
    }

    private Expression handleFunction(String name, boolean distinct, List<Expression> arguments, ParserRuleContext ctx, JPQLNextParser.OrderByClauseContext orderByClauseContext, JPQLNextParser.WhereClauseContext whereClauseContext, JPQLNextParser.IdentifierContext windowName, JPQLNextParser.WindowDefinitionContext windowDefinitionContext) {
        FunctionKind functionKind;
        String lowerName;
        switch (lowerName = name.toLowerCase()) {
            case "current_date": 
            case "current_time": 
            case "current_timestamp": {
                this.assertNormalFunctionInvocation(distinct, ctx, orderByClauseContext, whereClauseContext, windowName, windowDefinitionContext);
                return new FunctionExpression(name, Collections.emptyList());
            }
            case "outer": {
                if (!this.allowOuter) {
                    throw new SyntaxErrorException("Invalid disallowed use of OUTER in: " + this.getInputText(ctx));
                }
            }
            case "concat": 
            case "substring": 
            case "lower": 
            case "upper": 
            case "length": 
            case "locate": 
            case "abs": 
            case "sqrt": 
            case "mod": 
            case "coalesce": 
            case "nullif": {
                this.assertNormalFunctionInvocation(distinct, ctx, orderByClauseContext, whereClauseContext, windowName, windowDefinitionContext);
                return new FunctionExpression(name, arguments);
            }
            case "trim": {
                this.assertNormalFunctionInvocation(distinct, ctx, orderByClauseContext, whereClauseContext, windowName, windowDefinitionContext);
                return new TrimExpression(Trimspec.BOTH, null, arguments.get(0));
            }
            case "size": {
                this.assertNormalFunctionInvocation(distinct, ctx, orderByClauseContext, whereClauseContext, windowName, windowDefinitionContext);
                ((PathExpression)arguments.get(0)).setUsedInCollectionFunction(true);
                return new FunctionExpression(name, arguments);
            }
            case "index": {
                this.assertNormalFunctionInvocation(distinct, ctx, orderByClauseContext, whereClauseContext, windowName, windowDefinitionContext);
                PathExpression listIndexPath = (PathExpression)arguments.get(0);
                listIndexPath.setCollectionQualifiedPath(true);
                return new ListIndexExpression(listIndexPath);
            }
            case "key": {
                this.assertNormalFunctionInvocation(distinct, ctx, orderByClauseContext, whereClauseContext, windowName, windowDefinitionContext);
                PathExpression mapKeyPath = (PathExpression)arguments.get(0);
                mapKeyPath.setCollectionQualifiedPath(true);
                return new MapKeyExpression(mapKeyPath);
            }
            case "value": {
                this.assertNormalFunctionInvocation(distinct, ctx, orderByClauseContext, whereClauseContext, windowName, windowDefinitionContext);
                PathExpression mapValuePath = (PathExpression)arguments.get(0);
                mapValuePath.setCollectionQualifiedPath(true);
                return new MapValueExpression(mapValuePath);
            }
            case "entry": {
                this.assertNormalFunctionInvocation(distinct, ctx, orderByClauseContext, whereClauseContext, windowName, windowDefinitionContext);
                PathExpression mapEntryPath = (PathExpression)arguments.get(0);
                mapEntryPath.setCollectionQualifiedPath(true);
                return new MapEntryExpression(mapEntryPath);
            }
            case "type": {
                this.assertNormalFunctionInvocation(distinct, ctx, orderByClauseContext, whereClauseContext, windowName, windowDefinitionContext);
                return new TypeFunctionExpression(arguments.get(0));
            }
            case "function": {
                this.assertNotDistinct(distinct, ctx);
                String functionName = ((StringLiteral)arguments.get(0)).getValue();
                functionKind = this.functions.get(functionName.toLowerCase());
                if (functionKind != null) break;
                functionKind = FunctionKind.DETERMINISTIC;
                break;
            }
            default: {
                functionKind = this.functions.get(lowerName);
            }
        }
        if (functionKind == null) {
            this.assertNormalFunctionInvocation(distinct, ctx, orderByClauseContext, whereClauseContext, windowName, windowDefinitionContext);
            return this.handleMacro(name, arguments, ctx);
        }
        switch (functionKind) {
            case AGGREGATE: {
                if (orderByClauseContext != null) {
                    throw new SyntaxErrorException("Invalid use of WITHIN GROUP for function: " + this.getInputText(ctx));
                }
                if (windowName == null && windowDefinitionContext == null) {
                    if (whereClauseContext == null) {
                        return new AggregateExpression(distinct, name, arguments);
                    }
                    return new AggregateExpression(distinct, "window_" + name, arguments, null, (Predicate)whereClauseContext.predicate().accept(this));
                }
                if (distinct) {
                    arguments.add(0, new StringLiteral("DISTINCT"));
                }
                return new FunctionExpression("window_" + name, arguments, null, this.createWindowDefinition(whereClauseContext, windowName, windowDefinitionContext, functionKind));
            }
            case ORDERED_SET_AGGREGATE: {
                if (windowName == null && windowDefinitionContext == null) {
                    if (orderByClauseContext == null && whereClauseContext == null) {
                        return new AggregateExpression(distinct, name, arguments);
                    }
                    return new AggregateExpression(distinct, name, arguments, this.createOrderByItems(orderByClauseContext), whereClauseContext == null ? null : (Predicate)whereClauseContext.predicate().accept(this));
                }
                if (distinct) {
                    arguments.add(0, new StringLiteral("DISTINCT"));
                }
                return new FunctionExpression(name, arguments, this.createOrderByItems(orderByClauseContext), this.createWindowDefinition(whereClauseContext, windowName, windowDefinitionContext, functionKind));
            }
            case WINDOW: {
                if (orderByClauseContext != null) {
                    throw new SyntaxErrorException("Invalid use of WITHIN GROUP for function: " + this.getInputText(ctx));
                }
                if (distinct) {
                    arguments.add(0, new StringLiteral("DISTINCT"));
                }
                return new FunctionExpression(name, arguments, null, this.createWindowDefinition(whereClauseContext, windowName, windowDefinitionContext, functionKind));
            }
        }
        this.assertNormalFunctionInvocation(distinct, ctx, orderByClauseContext, whereClauseContext, windowName, windowDefinitionContext);
        return new FunctionExpression(name, arguments, null, null);
    }

    private Expression handleMacro(String name, List<Expression> arguments, ParserRuleContext ctx) {
        String macroName = name.toUpperCase();
        MacroFunction macro = this.macros.get(macroName);
        if (macro == null) {
            throw new SyntaxErrorException("No function or macro with the name '" + name + "' could not be found!");
        }
        if (this.usedMacros != null) {
            this.usedMacros.add(macroName);
        }
        try {
            return macro.apply(arguments);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Could not apply the macro for the expression: " + this.getInputText(ctx), ex);
        }
    }

    private void assertNormalFunctionInvocation(boolean distinct, ParserRuleContext ctx, JPQLNextParser.OrderByClauseContext orderByClauseContext, JPQLNextParser.WhereClauseContext whereClauseContext, JPQLNextParser.IdentifierContext windowName, JPQLNextParser.WindowDefinitionContext windowDefinitionContext) {
        this.assertNotDistinct(distinct, ctx);
        if (orderByClauseContext != null) {
            throw new SyntaxErrorException("Invalid use of WITHIN GROUP for function: " + this.getInputText(ctx));
        }
        if (whereClauseContext != null) {
            throw new SyntaxErrorException("Invalid use of FILTER for function: " + this.getInputText(ctx));
        }
        if (windowName != null || windowDefinitionContext != null) {
            throw new SyntaxErrorException("Invalid use of OVER for function: " + this.getInputText(ctx));
        }
    }

    private void assertNotDistinct(boolean distinct, ParserRuleContext ctx) {
        if (distinct) {
            throw new SyntaxErrorException("Invalid use of DISTINCT for function: " + this.getInputText(ctx));
        }
    }

    private WindowDefinition createWindowDefinition(JPQLNextParser.WhereClauseContext whereClauseContext, JPQLNextParser.IdentifierContext windowNameIdentifier, JPQLNextParser.WindowDefinitionContext windowDefinitionContext, FunctionKind functionKind) {
        List<Expression> partitionExpressions;
        JPQLNextParser.PartitionByClauseContext partitionByClauseContext;
        Predicate filterPredicate = null;
        if (whereClauseContext != null) {
            filterPredicate = (Predicate)whereClauseContext.predicate().accept(this);
        }
        String windowName = null;
        if (windowNameIdentifier != null) {
            windowName = windowNameIdentifier.getText();
        }
        if (windowDefinitionContext == null) {
            if (windowName != null || filterPredicate != null || functionKind == FunctionKind.WINDOW) {
                return new WindowDefinition(windowName, filterPredicate);
            }
            return null;
        }
        JPQLNextParser.IdentifierContext identifierContext = windowDefinitionContext.identifier();
        if (identifierContext != null) {
            windowName = identifierContext.getText();
        }
        if ((partitionByClauseContext = windowDefinitionContext.partitionByClause()) == null) {
            partitionExpressions = Collections.emptyList();
        } else {
            List<JPQLNextParser.GroupingValueContext> groupingValueContexts = partitionByClauseContext.groupingValue();
            int size = groupingValueContexts.size();
            partitionExpressions = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                partitionExpressions.add(groupingValueContexts.get(i).accept(this));
            }
        }
        List<OrderByItem> orderByExpressions = this.createOrderByItems(windowDefinitionContext.orderByClause());
        WindowFrameMode frameMode = null;
        WindowFramePositionType frameStartType = null;
        WindowFramePositionType frameEndType = null;
        Expression frameStartExpression = null;
        Expression frameEndExpression = null;
        WindowFrameExclusionType frameExclusionType = null;
        JPQLNextParser.FrameClauseContext frameClauseContext = windowDefinitionContext.frameClause();
        if (frameClauseContext != null) {
            JPQLNextParser.FrameExclusionClauseContext frameExclusionContext;
            frameMode = WindowFrameMode.valueOf(frameClauseContext.frameMode.getText().toUpperCase());
            JPQLNextParser.FrameStartContext frameStartContext = frameClauseContext.frameStart();
            JPQLNextParser.ParameterOrNumberLiteralContext parameterOrNumberLiteralContext = frameStartContext.parameterOrNumberLiteral();
            if (parameterOrNumberLiteralContext != null) {
                frameStartExpression = parameterOrNumberLiteralContext.accept(this);
                frameStartType = frameStartContext.PRECEDING() != null ? WindowFramePositionType.BOUNDED_PRECEDING : WindowFramePositionType.BOUNDED_FOLLOWING;
            } else if (frameStartContext.CURRENT() != null) {
                frameStartType = WindowFramePositionType.CURRENT_ROW;
            } else if (frameStartContext.PRECEDING() != null) {
                frameStartType = WindowFramePositionType.UNBOUNDED_PRECEDING;
            } else {
                throw new IllegalStateException("Unexpected state!");
            }
            JPQLNextParser.FrameEndContext frameEndContext = frameClauseContext.frameEnd();
            if (frameEndContext != null) {
                parameterOrNumberLiteralContext = frameEndContext.parameterOrNumberLiteral();
                if (parameterOrNumberLiteralContext != null) {
                    frameEndExpression = parameterOrNumberLiteralContext.accept(this);
                    frameEndType = frameEndContext.PRECEDING() != null ? WindowFramePositionType.BOUNDED_PRECEDING : WindowFramePositionType.BOUNDED_FOLLOWING;
                } else if (frameEndContext.CURRENT() != null) {
                    frameEndType = WindowFramePositionType.CURRENT_ROW;
                } else if (frameEndContext.FOLLOWING() != null) {
                    frameEndType = WindowFramePositionType.UNBOUNDED_FOLLOWING;
                } else {
                    throw new IllegalStateException("Unexpected state!");
                }
            }
            if ((frameExclusionContext = frameClauseContext.frameExclusionClause()) != null) {
                if (frameExclusionContext.CURRENT() != null) {
                    frameExclusionType = WindowFrameExclusionType.EXCLUDE_CURRENT_ROW;
                } else if (frameExclusionContext.GROUP() != null) {
                    frameExclusionType = WindowFrameExclusionType.EXCLUDE_GROUP;
                } else if (frameExclusionContext.NO() != null) {
                    frameExclusionType = WindowFrameExclusionType.EXCLUDE_NO_OTHERS;
                } else if (frameExclusionContext.TIES() != null) {
                    frameExclusionType = WindowFrameExclusionType.EXCLUDE_TIES;
                } else {
                    throw new IllegalStateException("Unexpected state!");
                }
            }
        }
        return new WindowDefinition(windowName, partitionExpressions, orderByExpressions, filterPredicate, frameMode, frameStartType, frameStartExpression, frameEndType, frameEndExpression, frameExclusionType);
    }

    private List<OrderByItem> createOrderByItems(JPQLNextParser.OrderByClauseContext ctx) {
        List<OrderByItem> orderByExpressions;
        if (ctx == null) {
            orderByExpressions = Collections.emptyList();
        } else {
            List<JPQLNextParser.OrderByItemContext> orderByItemContexts = ctx.orderByItem();
            int size = orderByItemContexts.size();
            orderByExpressions = new ArrayList<OrderByItem>(size);
            for (int i = 0; i < size; ++i) {
                orderByExpressions.add(this.createOrderByItem(orderByItemContexts.get(i)));
            }
        }
        return orderByExpressions;
    }

    private OrderByItem createOrderByItem(JPQLNextParser.OrderByItemContext ctx) {
        Expression expression = ctx.expression().accept(this);
        boolean asc = true;
        boolean nullsFirst = true;
        if (ctx.STRING_LITERAL() != null) {
            throw new SyntaxErrorException("Collations are not yet supported: " + this.getInputText(ctx));
        }
        if (ctx.DESC() != null) {
            asc = false;
        }
        if (ctx.FIRST() == null) {
            nullsFirst = false;
        }
        return new OrderByItem(asc, nullsFirst, expression);
    }

    @Override
    public Expression visitPathExpression(JPQLNextParser.PathExpressionContext ctx) {
        List<PathElementExpression> expressions;
        Expression expression = this.visitPath(ctx.path());
        if (!this.allowObjectExpression && (expression instanceof PathExpression ? (expressions = ((PathExpression)expression).getExpressions()).size() == 1 && expressions.get(0) instanceof TreatExpression : expression instanceof TreatExpression)) {
            throw new SyntaxErrorException("A top level treat expression is not allowed. Consider to further dereference the expression: " + this.getInputText(ctx));
        }
        return expression;
    }

    @Override
    public Expression visitTreatPath(JPQLNextParser.TreatPathContext ctx) {
        Expression expression = this.visitPath(ctx.path());
        if (expression instanceof PathElementExpression) {
            ArrayList<PathElementExpression> pathElements = new ArrayList<PathElementExpression>(1);
            pathElements.add((PathElementExpression)expression);
            expression = new PathExpression(pathElements);
        }
        return new TreatExpression(expression, ctx.entityName().getText());
    }

    @Override
    public Expression visitObjectSelectExpression(JPQLNextParser.ObjectSelectExpressionContext ctx) {
        return ctx.identifier().accept(this);
    }

    @Override
    public Expression visitValuePath(JPQLNextParser.ValuePathContext ctx) {
        return new MapValueExpression((PathExpression)this.visitPath(ctx.path()));
    }

    @Override
    public Expression visitMapKeyPath(JPQLNextParser.MapKeyPathContext ctx) {
        PathExpression collectionPath = (PathExpression)this.visitPath(ctx.path());
        collectionPath.setCollectionQualifiedPath(true);
        return new MapKeyExpression(collectionPath);
    }

    @Override
    public Expression visitMapEntrySelectExpression(JPQLNextParser.MapEntrySelectExpressionContext ctx) {
        return new MapEntryExpression((PathExpression)this.visitPath(ctx.path()));
    }

    @Override
    public Expression visitConstructorExpression(JPQLNextParser.ConstructorExpressionContext ctx) {
        List<JPQLNextParser.ConstructorItemContext> constructorItemContexts = ctx.constructorItem();
        int size = constructorItemContexts.size();
        ArrayList<Expression> arguments = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            arguments.add(constructorItemContexts.get(i).accept(this));
        }
        return new FunctionExpression("NEW " + ctx.simpleSubpath().getText(), arguments);
    }

    @Override
    public Expression visitPath(JPQLNextParser.PathContext ctx) {
        JPQLNextParser.QualifiedPathContext qualifiedPathContext = ctx.qualifiedPath();
        JPQLNextParser.GeneralSubpathContext generalSubpathContext = ctx.generalSubpath();
        if (qualifiedPathContext == null) {
            return this.visitGeneralSubpath(generalSubpathContext, null);
        }
        if (generalSubpathContext == null) {
            return qualifiedPathContext.accept(this);
        }
        return this.visitGeneralSubpath(generalSubpathContext, (PathElementExpression)qualifiedPathContext.accept(this));
    }

    @Override
    public Expression visitMacroPath(JPQLNextParser.MacroPathContext ctx) {
        List<JPQLNextParser.ExpressionContext> expressions = ctx.expression();
        int size = expressions.size();
        ArrayList<Expression> arguments = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            arguments.add(expressions.get(i).accept(this));
        }
        return this.handleMacro(ctx.identifier().getText(), arguments, ctx);
    }

    @Override
    public Expression visitOuterPath(JPQLNextParser.OuterPathContext ctx) {
        ArrayList<Expression> arguments = new ArrayList<Expression>(1);
        JPQLNextParser.SimpleSubpathContext simpleSubpathContext = ctx.simpleSubpath();
        arguments.add(simpleSubpathContext == null ? ctx.macroPath().accept(this) : simpleSubpathContext.accept(this));
        return new FunctionExpression("OUTER", arguments);
    }

    @Override
    public Expression visitGeneralSubpath(JPQLNextParser.GeneralSubpathContext ctx) {
        return this.visitGeneralSubpath(ctx, null);
    }

    @Override
    public Expression visitSimpleSubpath(JPQLNextParser.SimpleSubpathContext ctx) {
        String literalStr;
        Expression literalExpression;
        int size = ctx.getChildCount() + 1 >> 1;
        if (size >= this.minEnumSegmentCount ? (literalExpression = this.createEnumLiteral(literalStr = ctx.getText())) != null : (size >= this.minEntitySegmentCount || size == 1) && (literalExpression = this.createEntityTypeLiteral(literalStr = ctx.getText())) != null) {
            return literalExpression;
        }
        ArrayList<PathElementExpression> pathElementExpressions = new ArrayList<PathElementExpression>(size);
        for (int i = 0; i < ctx.children.size(); i += 2) {
            pathElementExpressions.add(new PropertyExpression(((ParseTree)ctx.children.get(i)).getText()));
        }
        return new PathExpression(pathElementExpressions);
    }

    public Expression visitGeneralSubpath(JPQLNextParser.GeneralSubpathContext ctx, PathElementExpression initialPathElement) {
        List identifierContexts = ctx.simpleSubpath().children;
        JPQLNextParser.PredicateOrExpressionContext expression = ctx.predicateOrExpression();
        boolean literalPossible = true;
        int size = identifierContexts.size() + 1 >> 1;
        int initialSize = size + (initialPathElement == null ? 0 : 1);
        ArrayList<PathElementExpression> pathElementExpressions = new ArrayList<PathElementExpression>(initialSize);
        PathExpression pathExpression = new PathExpression(pathElementExpressions);
        if (initialPathElement != null) {
            pathElementExpressions.add(initialPathElement);
        }
        while (true) {
            boolean processPathElements = true;
            if (literalPossible) {
                String literalStr;
                Expression literalExpression;
                if (size >= this.minEnumSegmentCount) {
                    String literalStr2 = ctx.simpleSubpath().getText();
                    literalExpression = this.createEnumLiteral(literalStr2);
                    if (literalExpression != null) {
                        return literalExpression;
                    }
                } else if ((size >= this.minEntitySegmentCount || size == 1) && (literalExpression = this.createEntityTypeLiteral(literalStr = ctx.simpleSubpath().getText())) != null) {
                    if (expression == null) {
                        return literalExpression;
                    }
                    pathElementExpressions.add(new ArrayExpression(literalExpression, expression.accept(this)));
                    processPathElements = false;
                }
            }
            if (processPathElements) {
                for (int i = 0; i < identifierContexts.size(); i += 2) {
                    pathElementExpressions.add(new PropertyExpression(((ParseTree)identifierContexts.get(i)).getText()));
                }
                if (expression != null) {
                    int index = initialSize - 1;
                    pathElementExpressions.set(index, new ArrayExpression(pathElementExpressions.get(index), expression.accept(this)));
                }
            }
            if ((ctx = ctx.generalSubpath()) == null) break;
            literalPossible = false;
            identifierContexts = ctx.simpleSubpath().children;
            expression = ctx.predicateOrExpression();
            size = identifierContexts.size() + 1 >> 1;
            pathElementExpressions.ensureCapacity(initialSize += size);
        }
        return pathExpression;
    }

    @Override
    public Expression visitGroupedPredicate(JPQLNextParser.GroupedPredicateContext ctx) {
        return ctx.predicate().accept(this);
    }

    @Override
    public Expression visitOrPredicate(JPQLNextParser.OrPredicateContext ctx) {
        List<JPQLNextParser.PredicateContext> predicate = ctx.predicate();
        Predicate left = (Predicate)predicate.get(0).accept(this);
        if (left instanceof CompoundPredicate && ((CompoundPredicate)left).getOperator() == CompoundPredicate.BooleanOperator.OR) {
            ((CompoundPredicate)left).getChildren().add((Predicate)predicate.get(1).accept(this));
            return left;
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(2);
        predicates.add(left);
        predicates.add((Predicate)predicate.get(1).accept(this));
        return new CompoundPredicate(CompoundPredicate.BooleanOperator.OR, predicates);
    }

    @Override
    public Expression visitAndPredicate(JPQLNextParser.AndPredicateContext ctx) {
        List<JPQLNextParser.PredicateContext> predicate = ctx.predicate();
        Predicate left = (Predicate)predicate.get(0).accept(this);
        if (left instanceof CompoundPredicate && ((CompoundPredicate)left).getOperator() == CompoundPredicate.BooleanOperator.AND) {
            ((CompoundPredicate)left).getChildren().add((Predicate)predicate.get(1).accept(this));
            return left;
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(2);
        predicates.add(left);
        predicates.add((Predicate)predicate.get(1).accept(this));
        return new CompoundPredicate(CompoundPredicate.BooleanOperator.AND, predicates);
    }

    @Override
    public Expression visitNegatedPredicate(JPQLNextParser.NegatedPredicateContext ctx) {
        Predicate predicate = (Predicate)ctx.predicate().accept(this);
        if (ctx.NOT() != null) {
            if (predicate.isNegated()) {
                predicate = new CompoundPredicate(CompoundPredicate.BooleanOperator.AND, predicate);
            }
            predicate.negate();
        }
        return predicate;
    }

    @Override
    public Expression visitExistsSimplePredicate(JPQLNextParser.ExistsSimplePredicateContext ctx) {
        return new ExistsPredicate(ctx.identifier().accept(this), ctx.NOT() != null);
    }

    @Override
    public Expression visitIsNullPredicate(JPQLNextParser.IsNullPredicateContext ctx) {
        return new IsNullPredicate(ctx.expression().accept(this), ctx.NOT() != null);
    }

    @Override
    public Expression visitIsEmptyPredicate(JPQLNextParser.IsEmptyPredicateContext ctx) {
        PathExpression collectionPath = (PathExpression)ctx.expression().accept(this);
        collectionPath.setUsedInCollectionFunction(true);
        return new IsEmptyPredicate(collectionPath, ctx.NOT() != null);
    }

    @Override
    public Expression visitQuantifiedSimpleLessThanOrEqualPredicate(JPQLNextParser.QuantifiedSimpleLessThanOrEqualPredicateContext ctx) {
        this.failQuantified(ctx, ctx.quantifier);
        return new LePredicate(ctx.expression().accept(this), ctx.identifier().accept(this), this.toQuantifier(ctx.quantifier), false);
    }

    @Override
    public Expression visitQuantifiedSimpleGreaterThanPredicate(JPQLNextParser.QuantifiedSimpleGreaterThanPredicateContext ctx) {
        this.failQuantified(ctx, ctx.quantifier);
        return new GtPredicate(ctx.expression().accept(this), ctx.identifier().accept(this), this.toQuantifier(ctx.quantifier), false);
    }

    @Override
    public Expression visitQuantifiedSimpleInequalityPredicate(JPQLNextParser.QuantifiedSimpleInequalityPredicateContext ctx) {
        this.failQuantified(ctx, ctx.quantifier);
        return new EqPredicate(ctx.expression().accept(this), ctx.identifier().accept(this), this.toQuantifier(ctx.quantifier), true);
    }

    @Override
    public Expression visitQuantifiedSimpleLessThanPredicate(JPQLNextParser.QuantifiedSimpleLessThanPredicateContext ctx) {
        this.failQuantified(ctx, ctx.quantifier);
        return new LtPredicate(ctx.expression().accept(this), ctx.identifier().accept(this), this.toQuantifier(ctx.quantifier), false);
    }

    @Override
    public Expression visitQuantifiedSimpleEqualityPredicate(JPQLNextParser.QuantifiedSimpleEqualityPredicateContext ctx) {
        this.failQuantified(ctx, ctx.quantifier);
        return new EqPredicate(ctx.expression().accept(this), ctx.identifier().accept(this), this.toQuantifier(ctx.quantifier), false);
    }

    @Override
    public Expression visitQuantifiedSimpleGreaterThanOrEqualPredicate(JPQLNextParser.QuantifiedSimpleGreaterThanOrEqualPredicateContext ctx) {
        this.failQuantified(ctx, ctx.quantifier);
        return new GePredicate(ctx.expression().accept(this), ctx.identifier().accept(this), this.toQuantifier(ctx.quantifier), false);
    }

    private void failQuantified(ParserRuleContext ctx, Token qualifier) {
        if (qualifier != null && !this.allowQuantifiedPredicates) {
            throw new SyntaxErrorException("The use of quantifiers is not allowed in the context of the expression: " + this.getInputText(ctx));
        }
    }

    @Override
    public Expression visitInequalityPredicate(JPQLNextParser.InequalityPredicateContext ctx) {
        return new EqPredicate(ctx.lhs.accept(this), ctx.rhs.accept(this), PredicateQuantifier.ONE, true);
    }

    @Override
    public Expression visitLessThanOrEqualPredicate(JPQLNextParser.LessThanOrEqualPredicateContext ctx) {
        return new LePredicate(ctx.lhs.accept(this), ctx.rhs.accept(this), PredicateQuantifier.ONE, false);
    }

    @Override
    public Expression visitEqualityPredicate(JPQLNextParser.EqualityPredicateContext ctx) {
        return new EqPredicate(ctx.lhs.accept(this), ctx.rhs.accept(this), PredicateQuantifier.ONE, false);
    }

    @Override
    public Expression visitGreaterThanPredicate(JPQLNextParser.GreaterThanPredicateContext ctx) {
        return new GtPredicate(ctx.lhs.accept(this), ctx.rhs.accept(this), PredicateQuantifier.ONE, false);
    }

    @Override
    public Expression visitLessThanPredicate(JPQLNextParser.LessThanPredicateContext ctx) {
        return new LtPredicate(ctx.lhs.accept(this), ctx.rhs.accept(this), PredicateQuantifier.ONE, false);
    }

    @Override
    public Expression visitGreaterThanOrEqualPredicate(JPQLNextParser.GreaterThanOrEqualPredicateContext ctx) {
        return new GePredicate(ctx.lhs.accept(this), ctx.rhs.accept(this), PredicateQuantifier.ONE, false);
    }

    @Override
    public Expression visitInPredicate(JPQLNextParser.InPredicateContext ctx) {
        Expression left = ctx.expression().accept(this);
        JPQLNextParser.InListContext inListContext = ctx.inList();
        List<JPQLNextParser.ExpressionContext> expressions = inListContext.expression();
        int size = expressions.size();
        ArrayList<Expression> right = new ArrayList<Expression>(size);
        if (size == 1 && inListContext.LP() == null) {
            JPQLNextParser.ExpressionContext expressionContext = expressions.get(0);
            Expression expression = expressionContext.accept(this);
            boolean collectionValuedAllowed = true;
            right.add(expression);
            if (expressionContext instanceof JPQLNextParser.FunctionExpressionContext && expressionContext.getChild(0) instanceof JPQLNextParser.GenericFunctionInvocationContext) {
                collectionValuedAllowed = false;
            }
            if (collectionValuedAllowed && expression instanceof ParameterExpression) {
                ((ParameterExpression)expression).setCollectionValued(true);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                right.add(expressions.get(i).accept(this));
            }
        }
        return new InPredicate(ctx.NOT() != null, left, right);
    }

    @Override
    public Expression visitBetweenPredicate(JPQLNextParser.BetweenPredicateContext ctx) {
        return new BetweenPredicate(ctx.lhs.accept(this), ctx.start.accept(this), ctx.end.accept(this), ctx.NOT() != null);
    }

    @Override
    public Expression visitLikePredicate(JPQLNextParser.LikePredicateContext ctx) {
        Expression escapeCharacter;
        if (ctx.escape == null) {
            escapeCharacter = null;
        } else {
            escapeCharacter = ctx.escape.accept(this);
            if (!(escapeCharacter instanceof LiteralExpression) && !(escapeCharacter instanceof ParameterExpression)) {
                throw new SyntaxErrorException("Only a character literal or parameter expression is allowed as escape character in like predicate: " + this.getInputText(ctx));
            }
        }
        return new LikePredicate(ctx.lhs.accept(this), ctx.like.accept(this), true, escapeCharacter, ctx.NOT() != null);
    }

    @Override
    public Expression visitMemberOfPredicate(JPQLNextParser.MemberOfPredicateContext ctx) {
        PathExpression collectionPath = (PathExpression)this.visitPath(ctx.path());
        collectionPath.setUsedInCollectionFunction(true);
        return new MemberOfPredicate(ctx.expression().accept(this), collectionPath, ctx.NOT() != null);
    }

    @Override
    public Expression visitErrorNode(ErrorNode node) {
        throw new SyntaxErrorException("Parsing failed: " + node.getText());
    }

    @Override
    public Expression visitIdentifier(JPQLNextParser.IdentifierContext ctx) {
        String text = ctx.getText();
        Expression entityLiteral = this.createEntityTypeLiteral(text);
        if (entityLiteral != null) {
            return entityLiteral;
        }
        ArrayList<PathElementExpression> pathElems = new ArrayList<PathElementExpression>(1);
        pathElems.add(new PropertyExpression(text));
        return new PathExpression(pathElems);
    }

    @Override
    protected Expression aggregateResult(Expression aggregate, Expression nextResult) {
        return aggregate == null ? nextResult : aggregate;
    }

    private PredicateQuantifier toQuantifier(Token token) {
        if (token == null) {
            return PredicateQuantifier.ONE;
        }
        switch (token.getType()) {
            case 13: {
                return PredicateQuantifier.ANY;
            }
            case 93: {
                return PredicateQuantifier.ANY;
            }
            case 11: {
                return PredicateQuantifier.ALL;
            }
        }
        return PredicateQuantifier.ONE;
    }

    private Expression createEnumLiteral(String enumStr) {
        int lastDotIdx = enumStr.lastIndexOf(46);
        if (lastDotIdx == -1) {
            return null;
        }
        String enumTypeStr = enumStr.substring(0, lastDotIdx);
        String enumValueStr = enumStr.substring(lastDotIdx + 1);
        Class<Enum<?>> enumType = this.enums.get(enumTypeStr);
        if (enumType == null) {
            return null;
        }
        Enum<?> enumValue = Enum.valueOf(enumType, enumValueStr);
        if (this.enumsForLiterals.containsKey(enumTypeStr)) {
            return new EnumLiteral(enumValue, enumStr);
        }
        return new ParameterExpression(enumStr.replace('.', '_'), enumValue);
    }

    private Expression createEntityTypeLiteral(String entityLiteralStr) {
        Class<?> entityType = this.entities.get(entityLiteralStr);
        if (entityType == null) {
            return null;
        }
        return new EntityLiteral(entityType, entityLiteralStr);
    }

    private String getInputText(ParserRuleContext ctx) {
        int from = ctx.start.getStartIndex();
        int to = ctx.stop.getStopIndex();
        Interval interval = new Interval(from, to);
        return this.input.getText(interval);
    }
}

