/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.AbstractExpression;
import com.blazebit.persistence.parser.expression.BaseNode;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import java.util.ArrayList;
import java.util.List;

public class PathExpression
extends AbstractExpression
implements Expression {
    private List<PathElementExpression> pathProperties;
    private PathReference pathReference;
    private boolean usedInCollectionFunction = false;
    private boolean collectionQualifiedPath;

    public PathExpression() {
        this(new ArrayList<PathElementExpression>(), false);
    }

    public PathExpression(PathElementExpression pathElementExpression) {
        this(PathExpression.list(pathElementExpression), false);
    }

    public PathExpression(List<PathElementExpression> pathProperties) {
        this(pathProperties, false);
    }

    public PathExpression(List<PathElementExpression> pathProperties, boolean isCollectionKeyPath) {
        this.pathProperties = pathProperties;
        this.collectionQualifiedPath = isCollectionKeyPath;
    }

    public PathExpression(List<PathElementExpression> pathProperties, PathReference pathReference, boolean usedInCollectionFunction, boolean collectionQualifiedPath) {
        this.pathProperties = pathProperties;
        this.pathReference = pathReference;
        this.usedInCollectionFunction = usedInCollectionFunction;
        this.collectionQualifiedPath = collectionQualifiedPath;
    }

    private static List<PathElementExpression> list(PathElementExpression elementExpression) {
        ArrayList<PathElementExpression> list = new ArrayList<PathElementExpression>(1);
        list.add(elementExpression);
        return list;
    }

    @Override
    public Expression copy(ExpressionCopyContext copyContext) {
        Expression expression;
        if (this.pathProperties.size() == 1 && this.pathProperties.get(0) instanceof PropertyExpression && (expression = copyContext.getExpressionForAlias(this.pathProperties.get(0).toString())) != null) {
            return expression;
        }
        int size = this.pathProperties.size();
        ArrayList<PathElementExpression> newPathProperties = new ArrayList<PathElementExpression>(size);
        for (int i = 0; i < size; ++i) {
            newPathProperties.add(this.pathProperties.get(i).copy(copyContext));
        }
        return new PathExpression(newPathProperties, copyContext.isCopyResolved() ? this.pathReference : null, this.usedInCollectionFunction, this.collectionQualifiedPath);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public List<PathElementExpression> getExpressions() {
        return this.pathProperties;
    }

    public void setExpressions(List<PathElementExpression> expressions) {
        this.pathProperties = expressions;
    }

    public PathReference getPathReference() {
        return this.pathReference;
    }

    public void setPathReference(PathReference pathReference) {
        this.pathReference = pathReference;
    }

    public BaseNode getBaseNode() {
        if (this.pathReference == null) {
            return null;
        }
        return this.pathReference.getBaseNode();
    }

    public String getField() {
        if (this.pathReference == null) {
            return null;
        }
        return this.pathReference.getField();
    }

    public boolean isUsedInCollectionFunction() {
        return this.usedInCollectionFunction;
    }

    public void setUsedInCollectionFunction(boolean collectionValued) {
        this.usedInCollectionFunction = collectionValued;
    }

    public String getPath() {
        return this.toString();
    }

    public boolean isCollectionQualifiedPath() {
        return this.collectionQualifiedPath;
    }

    public void setCollectionQualifiedPath(boolean collectionQualifiedPath) {
        this.collectionQualifiedPath = collectionQualifiedPath;
    }

    public PathExpression withoutFirst() {
        int size = this.pathProperties.size();
        if (size == 0) {
            return this;
        }
        ArrayList<PathElementExpression> list = new ArrayList<PathElementExpression>(size - 1);
        for (int i = 1; i < size; ++i) {
            list.add(this.pathProperties.get(i));
        }
        return new PathExpression(list);
    }

    public int hashCode() {
        int hash = 3;
        hash = this.pathReference != null ? 31 * hash + this.pathReference.hashCode() : 31 * hash + (this.pathProperties != null ? this.pathProperties.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathExpression other = (PathExpression)obj;
        if (this.pathReference != null || other.pathReference != null) {
            if (this.pathReference == null) {
                if (this.pathProperties == other.pathProperties || this.pathProperties != null && this.pathProperties.equals(other.pathProperties)) {
                    return true;
                }
                return this.getPath().equals(other.getPath());
            }
            if (other.pathReference == null) {
                if (other.pathProperties == this.pathProperties || other.pathProperties != null && other.pathProperties.equals(this.pathProperties)) {
                    return true;
                }
                return this.getPath().equals(other.getPath());
            }
            if (this.pathReference == other.pathReference) {
                return true;
            }
            return this.pathReference.equals(other.pathReference);
        }
        return this.pathProperties == other.pathProperties || this.pathProperties != null && this.pathProperties.equals(other.pathProperties);
    }
}

