/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.entity;

import com.blazebit.persistence.testsuite.entity.Ownable;
import com.blazebit.persistence.testsuite.entity.Person;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;

@Entity
public class DocumentWithNullableName
extends Ownable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Person friend;
    private List<Person> people = new ArrayList<Person>();

    public DocumentWithNullableName() {
    }

    public DocumentWithNullableName(Long id) {
        super(id);
    }

    public DocumentWithNullableName(String name) {
        this.name = name;
    }

    public DocumentWithNullableName(String name, Person owner) {
        this(name);
        this.setOwner(owner);
        this.setFriend(owner);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="friend_id")
    public Person getFriend() {
        return this.friend;
    }

    public void setFriend(Person friend) {
        this.friend = friend;
    }

    @OneToMany
    @OrderColumn(name="people_idx", nullable=false)
    @JoinTable(name="documentnullablename_people")
    public List<Person> getPeople() {
        return this.people;
    }

    public void setPeople(List<Person> people) {
        this.people = people;
    }
}

