/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.entity;

import com.blazebit.persistence.testsuite.entity.Document;
import com.blazebit.persistence.testsuite.entity.LongSequenceEntity;
import com.blazebit.persistence.testsuite.entity.NameObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="person")
public class Person
extends LongSequenceEntity {
    private static final long serialVersionUID = 1L;
    private String name;
    private NameObject nameObject = new NameObject();
    private long age;
    private Person friend;
    private Document partnerDocument;
    private Set<Document> ownedDocuments = new HashSet<Document>();
    private Set<Document> ownedDocuments2 = new HashSet<Document>();
    private Set<Document> favoriteDocuments = new HashSet<Document>();
    private Integer defaultLanguage;
    private Map<Integer, String> localized = new HashMap<Integer, String>();

    public Person() {
    }

    public Person(Long id) {
        super(id);
    }

    public Person(String name) {
        this.name = name;
    }

    public Person(String name, long age) {
        this.name = name;
        this.age = age;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public Document getPartnerDocument() {
        return this.partnerDocument;
    }

    public void setPartnerDocument(Document partnerDocument) {
        this.partnerDocument = partnerDocument;
    }

    @OneToMany(mappedBy="owner")
    public Set<Document> getOwnedDocuments() {
        return this.ownedDocuments;
    }

    public void setOwnedDocuments(Set<Document> ownedDocuments) {
        this.ownedDocuments = ownedDocuments;
    }

    @OneToMany
    @JoinColumn(name="responsible_person_id", referencedColumnName="id")
    public Set<Document> getOwnedDocuments2() {
        return this.ownedDocuments2;
    }

    public void setOwnedDocuments2(Set<Document> ownedDocuments2) {
        this.ownedDocuments2 = ownedDocuments2;
    }

    @OneToMany
    @JoinTable(name="person_favorite_documents")
    public Set<Document> getFavoriteDocuments() {
        return this.favoriteDocuments;
    }

    public void setFavoriteDocuments(Set<Document> favoriteDocuments) {
        this.favoriteDocuments = favoriteDocuments;
    }

    @Basic(optional=false)
    @Column(length=30)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Embedded
    public NameObject getNameObject() {
        return this.nameObject;
    }

    public void setNameObject(NameObject nameObject) {
        this.nameObject = nameObject;
    }

    public Integer getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(Integer defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    @ElementCollection
    @MapKeyColumn(nullable=false)
    @CollectionTable(name="person_localized")
    public Map<Integer, String> getLocalized() {
        return this.localized;
    }

    public void setLocalized(Map<Integer, String> localized) {
        this.localized = localized;
    }

    public long getAge() {
        return this.age;
    }

    public void setAge(long age) {
        this.age = age;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="friend_id")
    public Person getFriend() {
        return this.friend;
    }

    public void setFriend(Person friend) {
        this.friend = friend;
    }
}

