/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.entity;

import com.blazebit.persistence.testsuite.entity.PolymorphicBaseContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class PolymorphicBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private PolymorphicBase parent;
    private List<PolymorphicBase> list = new ArrayList<PolymorphicBase>();
    private Set<PolymorphicBase> children = new HashSet<PolymorphicBase>();
    private Map<String, PolymorphicBase> map = new HashMap<String, PolymorphicBase>();
    private PolymorphicBaseContainer container;

    @Id
    @GeneratedValue
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    public PolymorphicBase getParent() {
        return this.parent;
    }

    public void setParent(PolymorphicBase parent) {
        this.parent = parent;
    }

    @OneToMany
    @OrderColumn(name="list_idx", nullable=false)
    @JoinTable(name="polymorphic_list")
    public List<PolymorphicBase> getList() {
        return this.list;
    }

    public void setList(List<PolymorphicBase> list) {
        this.list = list;
    }

    @OneToMany(mappedBy="parent")
    public Set<PolymorphicBase> getChildren() {
        return this.children;
    }

    public void setChildren(Set<PolymorphicBase> children) {
        this.children = children;
    }

    @OneToMany
    @JoinTable(name="polymorphic_map")
    @MapKeyColumn(length=20, nullable=false)
    public Map<String, PolymorphicBase> getMap() {
        return this.map;
    }

    public void setMap(Map<String, PolymorphicBase> map) {
        this.map = map;
    }

    @OneToOne(mappedBy="owner")
    public PolymorphicBaseContainer getContainer() {
        return this.container;
    }

    public void setContainer(PolymorphicBaseContainer container) {
        this.container = container;
    }
}

