/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.entity;

import com.blazebit.persistence.testsuite.entity.PrimitivePerson;
import com.blazebit.persistence.testsuite.entity.PrimitiveVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;

@Entity
@Table(name="prim_doc")
public class PrimitiveDocument
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private String name;
    private boolean deleted;
    private PrimitivePerson owner;
    private Set<PrimitivePerson> partners = new HashSet<PrimitivePerson>();
    private Map<Integer, PrimitivePerson> contacts = new HashMap<Integer, PrimitivePerson>();
    private List<PrimitivePerson> people = new ArrayList<PrimitivePerson>();
    private List<PrimitivePerson> peopleListBag = new ArrayList<PrimitivePerson>();
    private Collection<PrimitivePerson> peopleCollectionBag = new ArrayList<PrimitivePerson>();
    private PrimitiveDocument parent;
    private PrimitiveVersion version;

    public PrimitiveDocument() {
    }

    public PrimitiveDocument(String name) {
        this.name = name;
    }

    @Id
    @GeneratedValue
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Basic(optional=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Basic(optional=false)
    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public PrimitivePerson getOwner() {
        return this.owner;
    }

    public void setOwner(PrimitivePerson owner) {
        this.owner = owner;
    }

    @OneToMany(mappedBy="partnerDocument")
    public Set<PrimitivePerson> getPartners() {
        return this.partners;
    }

    public void setPartners(Set<PrimitivePerson> partners) {
        this.partners = partners;
    }

    @OneToMany
    @JoinTable(name="prim_contacts")
    @MapKeyColumn(nullable=false)
    public Map<Integer, PrimitivePerson> getContacts() {
        return this.contacts;
    }

    public void setContacts(Map<Integer, PrimitivePerson> localized) {
        this.contacts = localized;
    }

    @OneToMany
    @OrderColumn(name="people_idx", nullable=false)
    @JoinTable(name="prim_document_people")
    public List<PrimitivePerson> getPeople() {
        return this.people;
    }

    public void setPeople(List<PrimitivePerson> people) {
        this.people = people;
    }

    @OneToMany
    @JoinTable(name="prim_document_people_list_bag")
    public List<PrimitivePerson> getPeopleListBag() {
        return this.peopleListBag;
    }

    public void setPeopleListBag(List<PrimitivePerson> peopleListBag) {
        this.peopleListBag = peopleListBag;
    }

    @OneToMany
    @JoinTable(name="prim_document_people_coll_bag")
    public Collection<PrimitivePerson> getPeopleCollectionBag() {
        return this.peopleCollectionBag;
    }

    public void setPeopleCollectionBag(Collection<PrimitivePerson> peopleCollectionBag) {
        this.peopleCollectionBag = peopleCollectionBag;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id")
    public PrimitiveDocument getParent() {
        return this.parent;
    }

    public void setParent(PrimitiveDocument parent) {
        this.parent = parent;
    }

    @OneToOne(mappedBy="document", cascade={CascadeType.ALL})
    public PrimitiveVersion getVersion() {
        return this.version;
    }

    public void setVersion(PrimitiveVersion version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrimitiveDocument)) {
            return false;
        }
        PrimitiveDocument that = (PrimitiveDocument)o;
        return this.getId() == that.getId();
    }

    public int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }
}

