/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.entity;

import com.blazebit.persistence.testsuite.entity.LongSequenceEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.AttributeConverter;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="sing_list_tbl")
public class SingularListEntity
extends LongSequenceEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private List<String> list = new ArrayList<String>();

    public SingularListEntity() {
    }

    public SingularListEntity(Long id) {
        super(id);
    }

    public SingularListEntity(String name) {
        this.name = name;
    }

    @Basic(optional=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="list_val")
    @Convert(converter=ListConverter.class)
    public List<String> getList() {
        return this.list;
    }

    public void setList(List<String> list) {
        this.list = list;
    }

    public static class ListConverter
    implements AttributeConverter<List<String>, String> {
        public String convertToDatabaseColumn(List<String> strings) {
            if (strings == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (String string : strings) {
                sb.append(string);
                sb.append(',');
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        public List<String> convertToEntityAttribute(String s) {
            if (s == null) {
                return null;
            }
            return new ArrayList<String>(Arrays.asList(s.split(",")));
        }
    }
}

