/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.treat.entity;

import com.blazebit.persistence.testsuite.treat.entity.Base;
import com.blazebit.persistence.testsuite.treat.entity.SingleTableEmbeddable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;

@Entity
@Table(name="single_table_base")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
public abstract class SingleTableBase
implements Serializable,
Base<SingleTableBase, SingleTableEmbeddable> {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private Integer value;
    private SingleTableBase parent;
    private SingleTableEmbeddable embeddable = new SingleTableEmbeddable();
    private List<SingleTableBase> list = new ArrayList<SingleTableBase>();
    private Set<SingleTableBase> children = new HashSet<SingleTableBase>();
    private Map<SingleTableBase, SingleTableBase> map = new HashMap<SingleTableBase, SingleTableBase>();

    public SingleTableBase() {
    }

    public SingleTableBase(String name) {
        this.name = name;
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Column(name="val")
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    public SingleTableBase getParent() {
        return this.parent;
    }

    @Override
    public void setParent(SingleTableBase parent) {
        this.parent = parent;
    }

    @Override
    @Embedded
    public SingleTableEmbeddable getEmbeddable() {
        return this.embeddable;
    }

    @Override
    public void setEmbeddable(SingleTableEmbeddable embeddable) {
        this.embeddable = embeddable;
    }

    @Override
    @ManyToMany
    @OrderColumn(name="list_idx", nullable=false)
    @JoinTable(name="stb_list")
    public List<SingleTableBase> getList() {
        return this.list;
    }

    @Override
    public void setList(List<? extends SingleTableBase> list) {
        this.list = list;
    }

    @Override
    @OneToMany(mappedBy="parent")
    public Set<SingleTableBase> getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Set<? extends SingleTableBase> children) {
        this.children = children;
    }

    @Override
    @ManyToMany
    @JoinTable(name="stb_map")
    @MapKeyColumn(name="stb_map_key", nullable=false, length=20)
    public Map<SingleTableBase, SingleTableBase> getMap() {
        return this.map;
    }

    @Override
    public void setMap(Map<? extends SingleTableBase, ? extends SingleTableBase> map) {
        this.map = map;
    }
}

