/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.testsuite.tx;

import com.blazebit.persistence.testsuite.tx.TxVoidWork;
import com.blazebit.persistence.testsuite.tx.TxWork;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

public class TxSupport {
    private TxSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transactional(EntityManager em, TxVoidWork r) {
        EntityTransaction tx = em.getTransaction();
        boolean success = false;
        try {
            tx.begin();
            r.work(em);
            if (tx.getRollbackOnly()) {
                tx.rollback();
            } else {
                tx.commit();
            }
            success = true;
        }
        finally {
            if (!success) {
                try {
                    tx.rollback();
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    public static <V> V transactional(EntityManager em, TxWork<V> c) {
        EntityTransaction tx = em.getTransaction();
        boolean success = false;
        try {
            tx.begin();
            V result = c.work(em);
            if (tx.getRollbackOnly()) {
                tx.rollback();
            } else {
                tx.commit();
            }
            success = true;
            V v = result;
            return v;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!success) {
                tx.rollback();
            }
        }
    }
}

