/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view;

import com.blazebit.persistence.view.spi.EntityViewConfiguration;
import com.blazebit.persistence.view.spi.EntityViewConfigurationProvider;
import java.util.Iterator;
import java.util.ServiceLoader;

public class EntityViews {
    private static volatile EntityViewConfigurationProvider cachedDefaultProvider;

    private EntityViews() {
    }

    public static EntityViewConfigurationProvider getDefaultProvider() {
        EntityViewConfigurationProvider defaultEntityViewConfigurationProvider = cachedDefaultProvider;
        if (defaultEntityViewConfigurationProvider == null) {
            ServiceLoader<EntityViewConfigurationProvider> serviceLoader = ServiceLoader.load(EntityViewConfigurationProvider.class);
            Iterator<EntityViewConfigurationProvider> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                cachedDefaultProvider = iterator.next();
                return cachedDefaultProvider;
            }
            throw new IllegalStateException("No EntityViewConfigurationProvider found on the class path. Please check if a valid implementation is on the class path.");
        }
        return defaultEntityViewConfigurationProvider;
    }

    public static EntityViewConfiguration createDefaultConfiguration() {
        return EntityViews.getDefaultProvider().createConfiguration();
    }
}

