/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.view.Sorter;
import com.blazebit.persistence.view.SubGraph;
import com.blazebit.persistence.view.metamodel.AttributeFilterMapping;
import com.blazebit.persistence.view.metamodel.AttributeFilterMappingPath;
import com.blazebit.persistence.view.metamodel.AttributePath;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.MethodPluralAttribute;
import com.blazebit.persistence.view.metamodel.MethodSingularAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class EntityViewSetting<T, Q extends FullQueryBuilder<T, Q>>
implements SubGraph<T> {
    private final Class<T> entityViewClass;
    private final String viewConstructorName;
    private final Object entityId;
    private final int firstResult;
    private final int maxResults;
    private final boolean paginated;
    private final Set<String> viewNamedFilters;
    private final Map<String, Sorter> attributeSorters;
    private final Map<String, List<AttributeFilterActivation>> attributeFilters;
    private final Map<String, Object> optionalParameters;
    private final Map<String, Object> properties;
    private final Set<String> fetches;
    private KeysetPage keysetPage;
    private boolean keysetPaginated;

    private EntityViewSetting(Class<T> entityViewClass, Object entityId, int maxResults, boolean paginate, String viewConstructorName) {
        this.entityViewClass = entityViewClass;
        this.viewConstructorName = viewConstructorName;
        this.entityId = entityId;
        this.firstResult = -1;
        this.maxResults = maxResults;
        this.paginated = paginate;
        this.viewNamedFilters = new LinkedHashSet<String>();
        this.attributeSorters = new LinkedHashMap<String, Sorter>();
        this.attributeFilters = new LinkedHashMap<String, List<AttributeFilterActivation>>();
        this.optionalParameters = new HashMap<String, Object>();
        this.properties = new HashMap<String, Object>();
        this.fetches = new HashSet<String>();
    }

    private EntityViewSetting(Class<T> entityViewClass, int firstResult, int maxResults, boolean paginate, String viewConstructorName) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Invalid negative value for firstResult");
        }
        this.entityViewClass = entityViewClass;
        this.viewConstructorName = viewConstructorName;
        this.entityId = null;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.paginated = paginate;
        this.viewNamedFilters = new LinkedHashSet<String>();
        this.attributeSorters = new LinkedHashMap<String, Sorter>();
        this.attributeFilters = new LinkedHashMap<String, List<AttributeFilterActivation>>();
        this.optionalParameters = new HashMap<String, Object>();
        this.properties = new HashMap<String, Object>();
        this.fetches = new HashSet<String>();
    }

    private EntityViewSetting(EntityViewSetting<? super T, ?> original, Class<T> subtype) {
        this.entityViewClass = subtype;
        this.viewConstructorName = original.viewConstructorName;
        this.entityId = original.entityId;
        this.firstResult = original.firstResult;
        this.maxResults = original.maxResults;
        this.paginated = original.paginated;
        this.keysetPage = original.keysetPage;
        this.keysetPaginated = original.keysetPaginated;
        this.viewNamedFilters = new LinkedHashSet<String>(original.viewNamedFilters);
        this.attributeSorters = new LinkedHashMap<String, Sorter>(original.attributeSorters);
        this.attributeFilters = new LinkedHashMap<String, List<AttributeFilterActivation>>(original.attributeFilters);
        this.optionalParameters = new HashMap<String, Object>(original.optionalParameters);
        this.properties = new HashMap<String, Object>(original.properties);
        this.fetches = new HashSet<String>(original.fetches);
    }

    public static <T> EntityViewSetting<T, CriteriaBuilder<T>> create(Class<T> entityViewClass) {
        return new EntityViewSetting(entityViewClass, 0, Integer.MAX_VALUE, false, null);
    }

    public static <T> EntityViewSetting<T, CriteriaBuilder<T>> create(Class<T> entityViewClass, String viewConstructorName) {
        return new EntityViewSetting(entityViewClass, 0, Integer.MAX_VALUE, false, viewConstructorName);
    }

    public static <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> create(Class<T> entityViewClass, int firstResult, int maxResults) {
        return new EntityViewSetting(entityViewClass, firstResult, maxResults, true, null);
    }

    public static <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> create(Class<T> entityViewClass, Object entityId, int maxResults) {
        return new EntityViewSetting(entityViewClass, entityId, maxResults, true, null);
    }

    public static <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> create(Class<T> entityViewClass, int firstResult, int maxResults, String viewConstructorName) {
        return new EntityViewSetting(entityViewClass, firstResult, maxResults, true, viewConstructorName);
    }

    public static <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> create(Class<T> entityViewClass, Object entityId, int maxResults, String viewConstructorName) {
        return new EntityViewSetting(entityViewClass, entityId, maxResults, true, viewConstructorName);
    }

    public <X extends T, Y extends FullQueryBuilder<X, Y>> EntityViewSetting<X, Y> forSubtype(Class<X> subtype) {
        return new EntityViewSetting<X, Q>(this, subtype);
    }

    public Class<T> getEntityViewClass() {
        return this.entityViewClass;
    }

    public String getViewConstructorName() {
        return this.viewConstructorName;
    }

    public Object getEntityId() {
        return this.entityId;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public boolean isPaginated() {
        return this.paginated;
    }

    public KeysetPage getKeysetPage() {
        return this.keysetPage;
    }

    public EntityViewSetting<T, Q> withKeysetPage(KeysetPage keysetPage) {
        this.keysetPage = keysetPage;
        this.keysetPaginated = true;
        return this;
    }

    public boolean isKeysetPaginated() {
        return this.keysetPaginated;
    }

    public void addAttributeSorters(Map<String, Sorter> attributeSorters) {
        this.attributeSorters.putAll(attributeSorters);
    }

    public void addAttributeSorter(String attributeName, Sorter sorter) {
        this.attributeSorters.put(attributeName, sorter);
    }

    public EntityViewSetting<T, Q> withAttributeSorter(String attributeName, Sorter sorter) {
        this.addAttributeSorter(attributeName, sorter);
        return this;
    }

    public void addAttributeSorter(MethodAttribute<T, ?> attribute, Sorter sorter) {
        this.attributeSorters.put(attribute.getName(), sorter);
    }

    public EntityViewSetting<T, Q> withAttributeSorter(MethodAttribute<T, ?> attribute, Sorter sorter) {
        this.addAttributeSorter(attribute.getName(), sorter);
        return this;
    }

    public void addAttributeSorter(AttributePath<T, ?, ?> attributePath, Sorter sorter) {
        this.attributeSorters.put(attributePath.getPath(), sorter);
    }

    public EntityViewSetting<T, Q> withAttributeSorter(AttributePath<T, ?, ?> attributePath, Sorter sorter) {
        this.addAttributeSorter(attributePath.getPath(), sorter);
        return this;
    }

    public boolean hasAttributeSorters() {
        return !this.attributeSorters.isEmpty();
    }

    public Map<String, Sorter> getAttributeSorters() {
        return this.attributeSorters;
    }

    public void addAttributeFilters(Map<String, Object> attributeFilters) {
        for (Map.Entry<String, Object> attributeFilterEntry : attributeFilters.entrySet()) {
            this.addAttributeFilter(attributeFilterEntry.getKey(), attributeFilterEntry.getValue());
        }
    }

    public void addAttributeFilter(String attributeName, Object filterValue) {
        this.addAttributeFilterActivation(attributeName, "", filterValue);
    }

    public EntityViewSetting<T, Q> withAttributeFilter(String attributeName, Object filterValue) {
        this.addAttributeFilter(attributeName, filterValue);
        return this;
    }

    public void addAttributeFilter(String attributeName, String filterName, Object filterValue) {
        this.addAttributeFilterActivation(attributeName, filterName, filterValue);
    }

    public EntityViewSetting<T, Q> withAttributeFilter(String attributeName, String filterName, Object filterValue) {
        this.addAttributeFilter(attributeName, filterName, filterValue);
        return this;
    }

    public <FilterValue> void addAttributeFilter(AttributeFilterMapping<T, FilterValue> attributeFilter, FilterValue filterValue) {
        this.addAttributeFilterActivation(attributeFilter.getDeclaringAttribute().getName(), attributeFilter.getName(), filterValue);
    }

    public <FilterValue> EntityViewSetting<T, Q> withAttributeFilter(AttributeFilterMapping<T, FilterValue> attributeFilter, FilterValue filterValue) {
        this.addAttributeFilter(attributeFilter, filterValue);
        return this;
    }

    public <FilterValue> void addAttributeFilter(AttributeFilterMappingPath<T, FilterValue> attributeFilter, FilterValue filterValue) {
        String path = attributeFilter.getAttributePath().getPath();
        this.addAttributeFilterActivation(path, attributeFilter.getFilterName(), filterValue);
    }

    public <FilterValue> EntityViewSetting<T, Q> withAttributeFilter(AttributeFilterMappingPath<T, FilterValue> attributeFilter, FilterValue filterValue) {
        this.addAttributeFilter(attributeFilter, filterValue);
        return this;
    }

    private void addAttributeFilterActivation(String attributeName, String attributeFilterName, Object filterValue) {
        List<AttributeFilterActivation> attributeFilterActivations = this.attributeFilters.get(attributeName);
        if (attributeFilterActivations == null) {
            attributeFilterActivations = new ArrayList<AttributeFilterActivation>(1);
            this.attributeFilters.put(attributeName, attributeFilterActivations);
        }
        attributeFilterActivations.add(new AttributeFilterActivation(attributeFilterName, filterValue));
    }

    public boolean hasAttributeFilters() {
        return !this.attributeFilters.isEmpty();
    }

    public Map<String, AttributeFilterActivation> getAttributeFilters() {
        LinkedHashMap<String, AttributeFilterActivation> filters = new LinkedHashMap<String, AttributeFilterActivation>(this.attributeFilters.size());
        for (Map.Entry<String, List<AttributeFilterActivation>> entry : this.attributeFilters.entrySet()) {
            filters.put(entry.getKey(), entry.getValue().get(0));
        }
        return filters;
    }

    public Map<String, List<AttributeFilterActivation>> getAttributeFilterActivations() {
        return this.attributeFilters;
    }

    public void addViewFilter(String filterName) {
        this.viewNamedFilters.add(filterName);
    }

    public EntityViewSetting<T, Q> withViewFilter(String filterName) {
        this.addViewFilter(filterName);
        return this;
    }

    public boolean hasViewFilters() {
        return !this.viewNamedFilters.isEmpty();
    }

    public Set<String> getViewFilters() {
        return this.viewNamedFilters;
    }

    public void addOptionalParameters(Map<String, Object> optionalParameters) {
        this.optionalParameters.putAll(optionalParameters);
    }

    public void addOptionalParameter(String parameterName, Object value) {
        this.optionalParameters.put(parameterName, value);
    }

    public EntityViewSetting<T, Q> withOptionalParameter(String parameterName, Object value) {
        this.addOptionalParameter(parameterName, value);
        return this;
    }

    public boolean hasOptionalParameters() {
        return !this.optionalParameters.isEmpty();
    }

    public Map<String, Object> getOptionalParameters() {
        return this.optionalParameters;
    }

    public void setProperty(String propertyName, Object value) {
        this.properties.put(propertyName, value);
    }

    public EntityViewSetting<T, Q> withProperty(String propertyName, Object value) {
        this.setProperty(propertyName, value);
        return this;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public <X> SubGraph<X> fetch(String path) {
        this.fetches.add(path);
        return new SubGraphImpl(path);
    }

    @Override
    public <X> SubGraph<X> fetch(MethodSingularAttribute<T, X> attribute) {
        return this.fetch(attribute.getName());
    }

    @Override
    public <X> SubGraph<X> fetch(MethodPluralAttribute<T, ?, X> attribute) {
        return this.fetch(attribute.getName());
    }

    public Collection<String> getFetches() {
        return Collections.unmodifiableSet(this.fetches);
    }

    public static class AttributeFilterActivation
    implements Serializable {
        private final String attributeFilterName;
        private final Object filterValue;

        private AttributeFilterActivation(Object filterValue) {
            this("", filterValue);
        }

        private AttributeFilterActivation(String attributeFilterName, Object filterValue) {
            this.attributeFilterName = attributeFilterName;
            this.filterValue = filterValue;
        }

        public String getAttributeFilterName() {
            return this.attributeFilterName;
        }

        public Object getFilterValue() {
            return this.filterValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AttributeFilterActivation)) {
                return false;
            }
            AttributeFilterActivation that = (AttributeFilterActivation)o;
            if (!this.getAttributeFilterName().equals(that.getAttributeFilterName())) {
                return false;
            }
            return Objects.deepEquals(this.getFilterValue(), that.getFilterValue());
        }

        public int hashCode() {
            int result = this.getAttributeFilterName().hashCode();
            result = 31 * result + this.getFilterValue().hashCode();
            return result;
        }
    }

    private class SubGraphImpl<X>
    implements SubGraph<X> {
        private final String parent;

        private SubGraphImpl(String parent) {
            this.parent = parent;
        }

        @Override
        public <Y> SubGraph<Y> fetch(String path) {
            String newParent = this.parent + "." + path;
            return EntityViewSetting.this.fetch(newParent);
        }

        @Override
        public <Y> SubGraph<Y> fetch(MethodSingularAttribute<X, Y> attribute) {
            return this.fetch(attribute.getName());
        }

        @Override
        public <Y> SubGraph<Y> fetch(MethodPluralAttribute<X, ?, Y> attribute) {
            return this.fetch(attribute.getName());
        }
    }
}

