/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.KeysetPage;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.view.Sorter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class EntityViewSetting<T, Q extends FullQueryBuilder<T, Q>> {
    private final Class<T> entityViewClass;
    private final String viewConstructorName;
    private final Object entityId;
    private final int firstResult;
    private final int maxResults;
    private final boolean paginated;
    private final Set<String> viewNamedFilters;
    private final Map<String, Sorter> attributeSorters;
    private final Map<String, AttributeFilterActivation> attributeFilters;
    private final Map<String, Object> optionalParameters;
    private final Map<String, Object> properties;
    private KeysetPage keysetPage;
    private boolean keysetPaginated;

    private EntityViewSetting(Class<T> entityViewClass, Object entityId, int maxResults, boolean paginate, String viewConstructorName) {
        this.entityViewClass = entityViewClass;
        this.viewConstructorName = viewConstructorName;
        this.entityId = entityId;
        this.firstResult = -1;
        this.maxResults = maxResults;
        this.paginated = paginate;
        this.viewNamedFilters = new LinkedHashSet<String>();
        this.attributeSorters = new LinkedHashMap<String, Sorter>();
        this.attributeFilters = new LinkedHashMap<String, AttributeFilterActivation>();
        this.optionalParameters = new HashMap<String, Object>();
        this.properties = new HashMap<String, Object>();
    }

    private EntityViewSetting(Class<T> entityViewClass, int firstResult, int maxResults, boolean paginate, String viewConstructorName) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Invalid negative value for firstResult");
        }
        this.entityViewClass = entityViewClass;
        this.viewConstructorName = viewConstructorName;
        this.entityId = null;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.paginated = paginate;
        this.viewNamedFilters = new LinkedHashSet<String>();
        this.attributeSorters = new LinkedHashMap<String, Sorter>();
        this.attributeFilters = new LinkedHashMap<String, AttributeFilterActivation>();
        this.optionalParameters = new HashMap<String, Object>();
        this.properties = new HashMap<String, Object>();
    }

    private EntityViewSetting(EntityViewSetting<? super T, ?> original, Class<T> subtype) {
        this.entityViewClass = subtype;
        this.viewConstructorName = original.viewConstructorName;
        this.entityId = original.entityId;
        this.firstResult = original.firstResult;
        this.maxResults = original.maxResults;
        this.paginated = original.paginated;
        this.keysetPage = original.keysetPage;
        this.keysetPaginated = original.keysetPaginated;
        this.viewNamedFilters = new LinkedHashSet<String>(original.viewNamedFilters);
        this.attributeSorters = new LinkedHashMap<String, Sorter>(original.attributeSorters);
        this.attributeFilters = new LinkedHashMap<String, AttributeFilterActivation>(original.attributeFilters);
        this.optionalParameters = new HashMap<String, Object>(original.optionalParameters);
        this.properties = new HashMap<String, Object>(original.properties);
    }

    public static <T> EntityViewSetting<T, CriteriaBuilder<T>> create(Class<T> entityViewClass) {
        return new EntityViewSetting(entityViewClass, 0, Integer.MAX_VALUE, false, null);
    }

    public static <T> EntityViewSetting<T, CriteriaBuilder<T>> create(Class<T> entityViewClass, String viewConstructorName) {
        return new EntityViewSetting(entityViewClass, 0, Integer.MAX_VALUE, false, viewConstructorName);
    }

    public static <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> create(Class<T> entityViewClass, int firstResult, int maxResults) {
        return new EntityViewSetting(entityViewClass, firstResult, maxResults, true, null);
    }

    public static <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> create(Class<T> entityViewClass, Object entityId, int maxResults) {
        return new EntityViewSetting(entityViewClass, entityId, maxResults, true, null);
    }

    public static <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> create(Class<T> entityViewClass, int firstResult, int maxResults, String viewConstructorName) {
        return new EntityViewSetting(entityViewClass, firstResult, maxResults, true, viewConstructorName);
    }

    public static <T> EntityViewSetting<T, PaginatedCriteriaBuilder<T>> create(Class<T> entityViewClass, Object entityId, int maxResults, String viewConstructorName) {
        return new EntityViewSetting(entityViewClass, entityId, maxResults, true, viewConstructorName);
    }

    public <X extends T, Y extends FullQueryBuilder<X, Y>> EntityViewSetting<X, Y> forSubtype(Class<X> subtype) {
        return new EntityViewSetting<X, Q>(this, subtype);
    }

    public Class<T> getEntityViewClass() {
        return this.entityViewClass;
    }

    public String getViewConstructorName() {
        return this.viewConstructorName;
    }

    public Object getEntityId() {
        return this.entityId;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public boolean isPaginated() {
        return this.paginated;
    }

    public KeysetPage getKeysetPage() {
        return this.keysetPage;
    }

    public EntityViewSetting<T, Q> withKeysetPage(KeysetPage keysetPage) {
        this.keysetPage = keysetPage;
        this.keysetPaginated = true;
        return this;
    }

    public boolean isKeysetPaginated() {
        return this.keysetPaginated;
    }

    public void addAttributeSorters(Map<String, Sorter> attributeSorters) {
        this.attributeSorters.putAll(attributeSorters);
    }

    public void addAttributeSorter(String attributeName, Sorter sorter) {
        this.attributeSorters.put(attributeName, sorter);
    }

    public boolean hasAttributeSorters() {
        return !this.attributeSorters.isEmpty();
    }

    public Map<String, Sorter> getAttributeSorters() {
        return this.attributeSorters;
    }

    public void addAttributeFilters(Map<String, Object> attributeFilters) {
        for (Map.Entry<String, Object> attributeFilterEntry : attributeFilters.entrySet()) {
            this.addAttributeFilter(attributeFilterEntry.getKey(), attributeFilterEntry.getValue());
        }
    }

    public void addAttributeFilter(String attributeName, Object filterValue) {
        this.checkExistingFiltersForAttribute(attributeName, "");
        this.attributeFilters.put(attributeName, new AttributeFilterActivation(filterValue));
    }

    public void addAttributeFilter(String attributeName, String filterName, Object filterValue) {
        this.checkExistingFiltersForAttribute(attributeName, filterName);
        this.attributeFilters.put(attributeName, new AttributeFilterActivation(filterName, filterValue));
    }

    private void checkExistingFiltersForAttribute(String attributeName, String attributeFilterName) {
        AttributeFilterActivation attributeFilterActivation = this.attributeFilters.get(attributeName);
        if (attributeFilterActivation != null && !attributeFilterActivation.getAttributeFilterName().equals(attributeFilterName)) {
            throw new IllegalArgumentException("At most one active attribute filter per attribute is allowed! attributeName = '" + attributeName + "'");
        }
    }

    public boolean hasAttributeFilters() {
        return !this.attributeFilters.isEmpty();
    }

    public Map<String, AttributeFilterActivation> getAttributeFilters() {
        return this.attributeFilters;
    }

    public void addViewFilter(String filterName) {
        this.viewNamedFilters.add(filterName);
    }

    public boolean hasViewFilters() {
        return !this.viewNamedFilters.isEmpty();
    }

    public Set<String> getViewFilters() {
        return this.viewNamedFilters;
    }

    public void addOptionalParameters(Map<String, Object> optionalParameters) {
        this.optionalParameters.putAll(optionalParameters);
    }

    public void addOptionalParameter(String parameterName, Object value) {
        this.optionalParameters.put(parameterName, value);
    }

    public boolean hasOptionalParameters() {
        return !this.optionalParameters.isEmpty();
    }

    public Map<String, Object> getOptionalParameters() {
        return this.optionalParameters;
    }

    public void setProperty(String propertyName, Object value) {
        this.properties.put(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public static class AttributeFilterActivation {
        private final String attributeFilterName;
        private final Object filterValue;

        private AttributeFilterActivation(Object filterValue) {
            this("", filterValue);
        }

        private AttributeFilterActivation(String attributeFilterName, Object filterValue) {
            this.attributeFilterName = attributeFilterName;
            this.filterValue = filterValue;
        }

        public String getAttributeFilterName() {
            return this.attributeFilterName;
        }

        public Object getFilterValue() {
            return this.filterValue;
        }
    }
}

