/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.view.ConvertOperationBuilder;
import com.blazebit.persistence.view.ConvertOption;
import com.blazebit.persistence.view.EntityViewBuilder;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.EntityViewSetting;
import com.blazebit.persistence.view.FlushOperationBuilder;
import com.blazebit.persistence.view.change.SingularChangeModel;
import com.blazebit.persistence.view.metamodel.ViewMetamodel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import javax.persistence.EntityManager;

public class SerializableEntityViewManager
implements EntityViewManager,
Serializable {
    public static final String EVM_FIELD_NAME = "ENTITY_VIEW_MANAGER";
    public static final String SERIALIZABLE_EVM_FIELD_NAME = "SERIALIZABLE_ENTITY_VIEW_MANAGER";
    private final Class<?> entityViewClass;
    private volatile transient EntityViewManager evm;

    public SerializableEntityViewManager(Class<?> entityViewClass, EntityViewManager evm) {
        this.entityViewClass = entityViewClass;
        this.evm = evm;
    }

    private EntityViewManager getEvm() {
        EntityViewManager evm = this.evm;
        if (evm == null) {
            try {
                Field field = this.entityViewClass.getDeclaredField(EVM_FIELD_NAME);
                this.evm = evm = (EntityViewManager)field.get(null);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Could not access entity view manager of entity view class: " + this.entityViewClass.getName(), ex);
            }
        }
        return evm;
    }

    @Override
    public ViewMetamodel getMetamodel() {
        return this.getEvm().getMetamodel();
    }

    @Override
    public Map<String, Object> getOptionalParameters() {
        return this.getEvm().getOptionalParameters();
    }

    @Override
    public <T> T find(EntityManager entityManager, Class<T> entityViewClass, Object entityId) {
        return this.getEvm().find(entityManager, entityViewClass, entityId);
    }

    @Override
    public <T> T find(EntityManager entityManager, EntityViewSetting<T, CriteriaBuilder<T>> entityViewSetting, Object entityId) {
        return this.getEvm().find(entityManager, entityViewSetting, entityId);
    }

    @Override
    public <T> T getReference(Class<T> entityViewClass, Object id) {
        return this.getEvm().getReference(entityViewClass, id);
    }

    @Override
    public <T> T getEntityReference(EntityManager entityManager, Object entityView) {
        return this.getEvm().getEntityReference(entityManager, entityView);
    }

    @Override
    public <T> SingularChangeModel<T> getChangeModel(T entityView) {
        return this.getEvm().getChangeModel(entityView);
    }

    @Override
    public <T> T create(Class<T> entityViewClass) {
        return this.getEvm().create(entityViewClass);
    }

    @Override
    public <T> T create(Class<T> entityViewClass, Map<String, Object> optionalParameters) {
        return this.getEvm().create(entityViewClass, optionalParameters);
    }

    @Override
    public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz) {
        return this.getEvm().createBuilder(clazz);
    }

    @Override
    public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz, String constructorName) {
        return this.getEvm().createBuilder(clazz, constructorName);
    }

    @Override
    public <X> EntityViewBuilder<X> createBuilder(X view) {
        return this.getEvm().createBuilder(view);
    }

    @Override
    public <X> EntityViewBuilder<X> createBuilder(X view, String constructorName) {
        return this.getEvm().createBuilder(view, constructorName);
    }

    @Override
    public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz, Map<String, Object> optionalParameters) {
        return this.getEvm().createBuilder(clazz, optionalParameters);
    }

    @Override
    public <X> EntityViewBuilder<X> createBuilder(Class<X> clazz, Map<String, Object> optionalParameters, String constructorName) {
        return this.getEvm().createBuilder(clazz, optionalParameters, constructorName);
    }

    @Override
    public <X> EntityViewBuilder<X> createBuilder(X view, Map<String, Object> optionalParameters) {
        return this.getEvm().createBuilder(view, optionalParameters);
    }

    @Override
    public <X> EntityViewBuilder<X> createBuilder(X view, Map<String, Object> optionalParameters, String constructorName) {
        return this.getEvm().createBuilder(view, optionalParameters, constructorName);
    }

    @Override
    public <T> T convert(Object source, Class<T> entityViewClass, ConvertOption ... convertOptions) {
        return this.getEvm().convert(source, entityViewClass, convertOptions);
    }

    @Override
    public <T> T convert(Object source, Class<T> entityViewClass, String constructorName, ConvertOption ... convertOptions) {
        return this.getEvm().convert(source, entityViewClass, constructorName, convertOptions);
    }

    @Override
    public <T> T convert(Object source, Class<T> entityViewClass, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
        return this.getEvm().convert(source, entityViewClass, optionalParameters, convertOptions);
    }

    @Override
    public <T> T convert(Object source, Class<T> entityViewClass, String constructorName, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
        return this.getEvm().convert(source, entityViewClass, constructorName, optionalParameters, convertOptions);
    }

    @Override
    public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, ConvertOption ... convertOptions) {
        return this.getEvm().convertWith(source, entityViewClass, convertOptions);
    }

    @Override
    public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, String constructorName, ConvertOption ... convertOptions) {
        return this.getEvm().convertWith(source, entityViewClass, constructorName, convertOptions);
    }

    @Override
    public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
        return this.getEvm().convertWith(source, entityViewClass, optionalParameters, convertOptions);
    }

    @Override
    public <T> ConvertOperationBuilder<T> convertWith(Object source, Class<T> entityViewClass, String constructorName, Map<String, Object> optionalParameters, ConvertOption ... convertOptions) {
        return this.getEvm().convertWith(source, entityViewClass, constructorName, optionalParameters, convertOptions);
    }

    @Override
    public void save(EntityManager entityManager, Object view) {
        this.getEvm().save(entityManager, view);
    }

    @Override
    public void saveFull(EntityManager entityManager, Object view) {
        this.getEvm().saveFull(entityManager, view);
    }

    @Override
    public void saveTo(EntityManager entityManager, Object view, Object entity) {
        this.getEvm().saveTo(entityManager, view, entity);
    }

    @Override
    public void saveFullTo(EntityManager entityManager, Object view, Object entity) {
        this.getEvm().saveFullTo(entityManager, view, entity);
    }

    @Override
    @Deprecated
    public void update(EntityManager entityManager, Object view) {
        this.getEvm().update(entityManager, view);
    }

    @Override
    @Deprecated
    public void updateFull(EntityManager entityManager, Object view) {
        this.getEvm().updateFull(entityManager, view);
    }

    @Override
    public FlushOperationBuilder saveWith(EntityManager entityManager, Object view) {
        return this.getEvm().saveWith(entityManager, view);
    }

    @Override
    public FlushOperationBuilder saveFullWith(EntityManager entityManager, Object view) {
        return this.getEvm().saveFullWith(entityManager, view);
    }

    @Override
    public FlushOperationBuilder saveWithTo(EntityManager entityManager, Object view, Object entity) {
        return this.getEvm().saveWithTo(entityManager, view, entity);
    }

    @Override
    public FlushOperationBuilder saveFullWithTo(EntityManager entityManager, Object view, Object entity) {
        return this.getEvm().saveFullWithTo(entityManager, view, entity);
    }

    @Override
    public void remove(EntityManager entityManager, Object view) {
        this.getEvm().remove(entityManager, view);
    }

    @Override
    public FlushOperationBuilder removeWith(EntityManager entityManager, Object view) {
        return this.getEvm().removeWith(entityManager, view);
    }

    @Override
    public void remove(EntityManager entityManager, Class<?> entityViewClass, Object viewId) {
        this.getEvm().remove(entityManager, entityViewClass, viewId);
    }

    @Override
    public FlushOperationBuilder removeWith(EntityManager entityManager, Class<?> entityViewClass, Object viewId) {
        return this.getEvm().removeWith(entityManager, entityViewClass, viewId);
    }

    @Override
    public <T, Q extends FullQueryBuilder<T, Q>> Q applySetting(EntityViewSetting<T, Q> setting, CriteriaBuilder<?> criteriaBuilder) {
        return this.getEvm().applySetting(setting, criteriaBuilder);
    }

    @Override
    public <T, Q extends FullQueryBuilder<T, Q>> Q applySetting(EntityViewSetting<T, Q> setting, CriteriaBuilder<?> criteriaBuilder, String entityViewRoot) {
        return this.getEvm().applySetting(setting, criteriaBuilder, entityViewRoot);
    }

    public <T> T getService(Class<T> serviceClass) {
        return (T)this.getEvm().getService(serviceClass);
    }
}

