/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.view.impl.entity.EntityLoader;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.lang.reflect.Constructor;
import java.util.List;

public class EntityIdLoader
implements EntityLoader {
    protected final Constructor<Object> entityIdConstructor;

    public EntityIdLoader(Class<?> entityClass) {
        try {
            Constructor<?> constructor = entityClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.entityIdConstructor = constructor;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't find required no-arg constructor for entity id class: " + entityClass.getName(), e);
        }
    }

    @Override
    public Class<?> getEntityClass() {
        return this.entityIdConstructor.getDeclaringClass();
    }

    @Override
    public Object getEntityId(UpdateContext context, Object entity) {
        return entity;
    }

    @Override
    public void toEntities(UpdateContext context, List<Object> views, List<Object> ids) {
        for (int i = 0; i < views.size(); ++i) {
            views.set(i, this.toEntity(context, views.get(i), ids.get(i)));
        }
    }

    @Override
    public Object toEntity(UpdateContext context, Object view, Object id) {
        if (id == null) {
            try {
                return this.entityIdConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't map entity view to entity!", e);
            }
        }
        return id;
    }
}

