/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.tx;

import com.blazebit.persistence.view.spi.TransactionAccess;
import jakarta.transaction.Synchronization;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SynchronizationRegistry
implements Synchronization,
TransactionAccess {
    private static final ConcurrentMap<Thread, SynchronizationRegistry> REGISTRY = new ConcurrentHashMap<Thread, SynchronizationRegistry>();
    private final TransactionAccess transactionAccess;
    private final List<Synchronization> synchronizations;
    private final Thread key;

    public SynchronizationRegistry(TransactionAccess transactionAccess) {
        this.transactionAccess = transactionAccess;
        this.synchronizations = new ArrayList<Synchronization>(1);
        this.key = Thread.currentThread();
        transactionAccess.registerSynchronization((Synchronization)this);
        REGISTRY.put(this.key, this);
    }

    public static SynchronizationRegistry getRegistry() {
        return (SynchronizationRegistry)REGISTRY.get(Thread.currentThread());
    }

    public TransactionAccess getTransactionAccess() {
        return this.transactionAccess;
    }

    public boolean isActive() {
        return this.transactionAccess.isActive();
    }

    public void markRollbackOnly() {
        this.transactionAccess.markRollbackOnly();
    }

    public void registerSynchronization(Synchronization synchronization) {
        this.synchronizations.add(synchronization);
    }

    public void beforeCompletion() {
        ArrayList<Exception> suppressedExceptions = null;
        for (int i = 0; i < this.synchronizations.size(); ++i) {
            Synchronization synchronization = this.synchronizations.get(i);
            try {
                synchronization.beforeCompletion();
                continue;
            }
            catch (Exception ex) {
                if (suppressedExceptions == null) {
                    suppressedExceptions = new ArrayList<Exception>();
                }
                suppressedExceptions.add(ex);
            }
        }
        if (suppressedExceptions != null) {
            if (suppressedExceptions.size() == 1) {
                if (suppressedExceptions.get(0) instanceof RuntimeException) {
                    throw (RuntimeException)suppressedExceptions.get(0);
                }
                throw new RuntimeException("Error during beforeCompletion invocation of synchronizations", (Throwable)suppressedExceptions.get(0));
            }
            RuntimeException runtimeException = new RuntimeException("Error during beforeCompletion invocation of synchronizations");
            for (Exception supressedException : suppressedExceptions) {
                runtimeException.addSuppressed(supressedException);
            }
            throw runtimeException;
        }
    }

    public void afterCompletion(int status) {
        ArrayList<Exception> suppressedExceptions = null;
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                Synchronization synchronization;
                int i;
                REGISTRY.remove(this.key);
                for (i = 0; i < this.synchronizations.size(); ++i) {
                    synchronization = this.synchronizations.get(i);
                    try {
                        synchronization.afterCompletion(status);
                        continue;
                    }
                    catch (Exception ex) {
                        if (suppressedExceptions == null) {
                            suppressedExceptions = new ArrayList<Exception>();
                        }
                        suppressedExceptions.add(ex);
                    }
                }
                break;
            }
            default: {
                Synchronization synchronization;
                int i;
                if (REGISTRY.remove(this.key) == null) break;
                for (i = this.synchronizations.size() - 1; i >= 0; --i) {
                    synchronization = this.synchronizations.get(i);
                    try {
                        synchronization.afterCompletion(status);
                        continue;
                    }
                    catch (Exception ex) {
                        if (suppressedExceptions == null) {
                            suppressedExceptions = new ArrayList();
                        }
                        suppressedExceptions.add(ex);
                    }
                }
            }
        }
        if (suppressedExceptions != null) {
            if (suppressedExceptions.size() == 1) {
                if (suppressedExceptions.get(0) instanceof RuntimeException) {
                    throw (RuntimeException)suppressedExceptions.get(0);
                }
                throw new RuntimeException("Error during afterCompletion invocation of synchronizations", (Throwable)suppressedExceptions.get(0));
            }
            RuntimeException runtimeException = new RuntimeException("Error during afterCompletion invocation of synchronizations");
            for (Exception supressedException : suppressedExceptions) {
                runtimeException.addSuppressed(supressedException);
            }
            throw runtimeException;
        }
    }
}

