/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.lang.reflect.Method;

public abstract class AbstractLocalDateTypeConverter<T>
implements TypeConverter<T, Object> {
    protected static final long MILLISECOND_CONVERSION_FACTOR = 86400000L;
    private static final Method OF_EPOCH_DAY;
    private static final Method TO_EPOCH_DAY;

    protected final Object ofEpochDay(long epochDay) {
        try {
            return OF_EPOCH_DAY.invoke(null, epochDay);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final long toEpochDay(Object object) {
        try {
            return (Long)TO_EPOCH_DAY.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Method ofEpochDay = null;
        Method toEpochDay = null;
        try {
            Class<?> c = Class.forName("java.time.LocalDate");
            ofEpochDay = c.getDeclaredMethod("ofEpochDay", Long.TYPE);
            toEpochDay = c.getDeclaredMethod("toEpochDay", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        OF_EPOCH_DAY = ofEpochDay;
        TO_EPOCH_DAY = toEpochDay;
    }
}

