/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.InverseElementToEntityMapper;
import com.blazebit.persistence.view.impl.mapper.Mapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import jakarta.persistence.Query;
import jakarta.persistence.metamodel.EntityType;

public class InverseEntityToEntityMapper<E>
implements InverseElementToEntityMapper<E> {
    private static final String ID_PARAM_NAME = "_id";
    private final String updatePrefixString;
    private final String updatePostfixString;
    private final String fullUpdateQueryString;
    private final AttributeAccessor entityIdAccessor;
    private final DirtyAttributeFlusher<?, ?, ?> inverseAttributeFlusher;
    private final Mapper<Object, Object> parentEntityOnChildEntityAddMapper;
    private final Mapper<Object, Object> parentEntityOnChildEntityRemoveMapper;

    public InverseEntityToEntityMapper(EntityViewManagerImpl evm, EntityType<?> entityType, Mapper<Object, Object> parentEntityOnChildEntityAddMapper, Mapper<Object, Object> parentEntityOnChildEntityRemoveMapper, DirtyAttributeFlusher<?, ?, ?> inverseAttributeFlusher) {
        this.updatePrefixString = "UPDATE " + entityType.getName() + " e SET ";
        this.updatePostfixString = " WHERE e." + JpaMetamodelUtils.getSingleIdAttribute(entityType).getName() + " = :" + ID_PARAM_NAME;
        this.parentEntityOnChildEntityAddMapper = parentEntityOnChildEntityAddMapper;
        this.parentEntityOnChildEntityRemoveMapper = parentEntityOnChildEntityRemoveMapper;
        this.inverseAttributeFlusher = inverseAttributeFlusher;
        this.fullUpdateQueryString = this.createQueryString(null, inverseAttributeFlusher);
        this.entityIdAccessor = evm.getEntityIdAccessor();
    }

    private String createQueryString(DirtyAttributeFlusher<?, ?, ?> nestedGraphNode, DirtyAttributeFlusher<?, ?, ?> inverseAttributeFlusher) {
        StringBuilder sb = new StringBuilder(this.updatePrefixString.length() + this.updatePostfixString.length() + 250);
        sb.append(this.updatePrefixString);
        inverseAttributeFlusher.appendUpdateQueryFragment(null, sb, "e.", "", ", ");
        if (nestedGraphNode != null) {
            sb.append(", ");
            int initialLength = sb.length();
            nestedGraphNode.appendUpdateQueryFragment(null, sb, "e.", "", ", ");
            if (sb.length() == initialLength) {
                sb.setLength(sb.length() - 2);
                sb.append(this.updatePostfixString);
                return sb.toString();
            }
            sb.append(this.updatePostfixString);
            return sb.toString();
        }
        sb.append(this.updatePostfixString);
        return sb.toString();
    }

    @Override
    public void flushEntity(UpdateContext context, Object oldParent, Object newParent, Object child, DirtyAttributeFlusher<?, E, Object> nestedGraphNode) {
        if (newParent == null) {
            this.parentEntityOnChildEntityRemoveMapper.map(oldParent, child);
        } else {
            this.parentEntityOnChildEntityAddMapper.map(newParent, child);
        }
        if (nestedGraphNode != null) {
            nestedGraphNode.flushEntity(context, null, child, null, child, null);
        }
    }

    @Override
    public Query createInverseUpdateQuery(UpdateContext context, Object element, DirtyAttributeFlusher<?, E, Object> nestedGraphNode, DirtyAttributeFlusher<?, ?, ?> inverseAttributeFlusher) {
        String queryString = inverseAttributeFlusher == this.inverseAttributeFlusher && nestedGraphNode == null ? this.fullUpdateQueryString : this.createQueryString(nestedGraphNode, inverseAttributeFlusher);
        Query query = null;
        if (queryString != null) {
            query = context.getEntityManager().createQuery(queryString);
            query.setParameter(ID_PARAM_NAME, this.entityIdAccessor.getValue(element));
        }
        return query;
    }
}

