/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.parser.expression.SyntaxErrorException;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.view.CTEProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.FlushMode;
import com.blazebit.persistence.view.FlushStrategy;
import com.blazebit.persistence.view.LockMode;
import com.blazebit.persistence.view.Mapping;
import com.blazebit.persistence.view.ViewFilterProvider;
import com.blazebit.persistence.view.ViewTransition;
import com.blazebit.persistence.view.impl.CorrelationProviderHelper;
import com.blazebit.persistence.view.impl.ScalarTargetResolvingExpressionVisitor;
import com.blazebit.persistence.view.impl.StaticCorrelationProvider;
import com.blazebit.persistence.view.impl.StaticPathCorrelationProvider;
import com.blazebit.persistence.view.impl.TypeExtractingCorrelationBuilder;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.AttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ConstructorMapping;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.FlatViewTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.InheritanceViewMapping;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MappingLiteral;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.MethodAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ParametersKey;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewRootImpl;
import com.blazebit.persistence.view.impl.metamodel.ViewTypeImpl;
import com.blazebit.persistence.view.metamodel.OrderByItem;
import com.blazebit.persistence.view.metamodel.ViewRoot;
import com.blazebit.persistence.view.spi.EntityViewAttributeMapping;
import com.blazebit.persistence.view.spi.EntityViewConstructorMapping;
import com.blazebit.persistence.view.spi.EntityViewRootMapping;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MappedSuperclassType;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ViewMappingImpl
implements ViewMapping {
    private final MetamodelBootContext context;
    private final Class<?> entityViewClass;
    private Class<?> entityClass;
    private Integer defaultBatchSize;
    private boolean updatable;
    private FlushMode flushMode;
    private FlushStrategy flushStrategy;
    private Method postCreateMethod;
    private Method postConvertMethod;
    private Method postLoadMethod;
    private Method prePersistMethod;
    private Method postPersistMethod;
    private Method preUpdateMethod;
    private Method postUpdateMethod;
    private Method preRemoveMethod;
    private Method postRemoveMethod;
    private Method postRollbackMethod;
    private Method postCommitMethod;
    private ViewTransition[] postRollbackTransitions;
    private ViewTransition[] postCommitTransitions;
    private List<Method> specialMethods = new ArrayList<Method>();
    private boolean creatable;
    private boolean validatePersistability;
    private final Set<String> excludedAttributes = new TreeSet<String>();
    private final Map<String, MethodAttributeMapping> attributes = new TreeMap<String, MethodAttributeMapping>();
    private final Map<ParametersKey, ConstructorMapping> constructors = new TreeMap<ParametersKey, ConstructorMapping>();
    private final Map<String, ConstructorMapping> constructorNameMap = new TreeMap<String, ConstructorMapping>();
    private MethodAttributeMapping idAttribute;
    private MethodAttributeMapping versionAttribute;
    private String lockOwner;
    private LockMode lockMode;
    private LockMode resolvedLockMode;
    private String inheritanceMapping;
    private boolean inheritanceSubtypesResolved;
    private Set<Class<?>> inheritanceSubtypeClasses = new LinkedHashSet();
    private final Set<ViewMapping> inheritanceSubtypes = new LinkedHashSet<ViewMapping>();
    private final Set<ViewMapping> inheritanceSupertypes;
    private InheritanceViewMapping defaultInheritanceViewMapping;
    private final Set<InheritanceViewMapping> inheritanceViewMappings;
    private boolean initialized;
    private boolean finished;
    private final List<Runnable> finishListeners = new ArrayList<Runnable>();
    private ManagedType<?> managedType;
    private ManagedViewTypeImplementor<?> viewType;
    private Map<EmbeddableOwner, ManagedViewTypeImplementor<?>> embeddableViewTypeMap;
    private Set<Class<? extends CTEProvider>> cteProviders;
    private Map<String, Class<? extends ViewFilterProvider>> viewFilterProviders;
    private Set<EntityViewRootMapping> entityViewRoots;
    private Set<ViewRoot> viewRoots;
    private Map<String, Type<?>> viewRootTypes;

    public ViewMappingImpl(Class<?> entityViewClass, Class<?> entityClass, MetamodelBootContext context) {
        this.entityViewClass = entityViewClass;
        this.entityClass = entityClass;
        this.context = context;
        this.inheritanceSupertypes = new HashSet<ViewMapping>();
        this.inheritanceViewMappings = new TreeSet<InheritanceViewMapping>();
    }

    @Override
    public InheritanceViewMapping getDefaultInheritanceViewMapping() {
        return this.defaultInheritanceViewMapping;
    }

    public Class<?> getEntityViewClass() {
        return this.entityViewClass;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public Integer getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    @Override
    public void setDefaultBatchSize(Integer defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public FlushStrategy getFlushStrategy() {
        return this.flushStrategy;
    }

    public void setFlushStrategy(FlushStrategy flushStrategy) {
        this.flushStrategy = flushStrategy;
    }

    public boolean isCreatable() {
        return this.creatable;
    }

    public void setCreatable(boolean creatable) {
        this.creatable = creatable;
    }

    public Method getPostCreateMethod() {
        return this.postCreateMethod;
    }

    public void setPostCreateMethod(Method postCreateMethod) {
        this.postCreateMethod = postCreateMethod;
    }

    public Method getPostConvertMethod() {
        return this.postConvertMethod;
    }

    public void setPostConvertMethod(Method postConvertMethod) {
        this.postConvertMethod = postConvertMethod;
    }

    public Method getPostLoadMethod() {
        return this.postLoadMethod;
    }

    public void setPostLoadMethod(Method postLoadMethod) {
        this.postLoadMethod = postLoadMethod;
    }

    public Method getPrePersistMethod() {
        return this.prePersistMethod;
    }

    public void setPrePersistMethod(Method prePersistMethod) {
        this.prePersistMethod = prePersistMethod;
    }

    public Method getPostPersistMethod() {
        return this.postPersistMethod;
    }

    public void setPostPersistMethod(Method postPersistMethod) {
        this.postPersistMethod = postPersistMethod;
    }

    public Method getPreUpdateMethod() {
        return this.preUpdateMethod;
    }

    public void setPreUpdateMethod(Method preUpdateMethod) {
        this.preUpdateMethod = preUpdateMethod;
    }

    public Method getPostUpdateMethod() {
        return this.postUpdateMethod;
    }

    public void setPostUpdateMethod(Method postUpdateMethod) {
        this.postUpdateMethod = postUpdateMethod;
    }

    public Method getPreRemoveMethod() {
        return this.preRemoveMethod;
    }

    public void setPreRemoveMethod(Method preRemoveMethod) {
        this.preRemoveMethod = preRemoveMethod;
    }

    public Method getPostRemoveMethod() {
        return this.postRemoveMethod;
    }

    public void setPostRemoveMethod(Method postRemoveMethod) {
        this.postRemoveMethod = postRemoveMethod;
    }

    public Method getPostRollbackMethod() {
        return this.postRollbackMethod;
    }

    public void setPostRollbackMethod(Method postRollbackMethod) {
        this.postRollbackMethod = postRollbackMethod;
    }

    public Method getPostCommitMethod() {
        return this.postCommitMethod;
    }

    public void setPostCommitMethod(Method postCommitMethod) {
        this.postCommitMethod = postCommitMethod;
    }

    public ViewTransition[] getPostRollbackTransitions() {
        return this.postRollbackTransitions;
    }

    public void setPostRollbackTransitions(ViewTransition[] postRollbackTransitions) {
        this.postRollbackTransitions = postRollbackTransitions;
    }

    public ViewTransition[] getPostCommitTransitions() {
        return this.postCommitTransitions;
    }

    public void setPostCommitTransitions(ViewTransition[] postCommitTransitions) {
        this.postCommitTransitions = postCommitTransitions;
    }

    @Override
    public List<Method> getSpecialMethods() {
        return this.specialMethods;
    }

    @Override
    public void setSpecialMethods(List<Method> specialMethods) {
        this.specialMethods = specialMethods;
    }

    @Override
    public Set<Class<? extends CTEProvider>> getCteProviders() {
        return this.cteProviders;
    }

    @Override
    public void setCteProviders(Set<Class<? extends CTEProvider>> cteProviders) {
        this.cteProviders = cteProviders;
    }

    @Override
    public Map<String, Class<? extends ViewFilterProvider>> getViewFilterProviders() {
        return this.viewFilterProviders;
    }

    @Override
    public void setViewFilterProviders(Map<String, Class<? extends ViewFilterProvider>> viewFilterProviders) {
        this.viewFilterProviders = viewFilterProviders;
    }

    @Override
    public Set<EntityViewRootMapping> getEntityViewRoots() {
        return this.entityViewRoots;
    }

    @Override
    public void setEntityViewRoots(Set<EntityViewRootMapping> entityViewRoots) {
        this.entityViewRoots = entityViewRoots;
        this.viewRoots = null;
        this.viewRootTypes = null;
    }

    @Override
    public Set<ViewRoot> getViewRoots(MetamodelBuildingContext context) {
        if (this.viewRoots == null) {
            this.initViewRoots(context);
        }
        return this.viewRoots;
    }

    @Override
    public Map<String, Type<?>> getViewRootTypes(MetamodelBuildingContext context) {
        if (this.viewRootTypes == null) {
            this.initViewRoots(context);
        }
        return this.viewRootTypes;
    }

    private void initViewRoots(MetamodelBuildingContext context) {
        if (this.entityViewRoots == null || this.entityViewRoots.isEmpty()) {
            this.viewRoots = Collections.emptySet();
            this.viewRootTypes = Collections.emptyMap();
        } else {
            this.viewRoots = new LinkedHashSet<ViewRoot>(this.entityViewRoots.size());
            this.viewRootTypes = new HashMap(this.entityViewRoots.size());
            HashSet<String> rootAliases = new HashSet<String>(this.entityViewRoots.size());
            for (EntityViewRootMapping entityViewRoot : this.entityViewRoots) {
                rootAliases.add(entityViewRoot.getName());
            }
            for (EntityViewRootMapping entityViewRoot : this.entityViewRoots) {
                List<OrderByItem> orderByItems;
                String offsetExpression;
                String limitExpression;
                String viewRootName = entityViewRoot.getName();
                Class entityClass = entityViewRoot.getManagedTypeClass();
                String joinExpression = entityViewRoot.getJoinExpression();
                Class correlationProvider = entityViewRoot.getCorrelationProvider();
                CorrelationProviderFactory correlationProviderFactory = null;
                Type<?> type = null;
                String conditionExpression = entityViewRoot.getConditionExpression();
                if (entityClass != null) {
                    if (joinExpression != null || correlationProvider != null) {
                        context.addError("Illegal entity view root mapping '" + viewRootName + "' at the class '" + this.entityViewClass.getName() + "'! Only one of the attributes entity, expression or correlator may be used!");
                    }
                    if (conditionExpression == null) {
                        context.addError("Illegal entity view root mapping '" + viewRootName + "' at the class '" + this.entityViewClass.getName() + "'! When using the entity attribute, a condition expression is required!");
                    } else {
                        correlationProviderFactory = new StaticCorrelationProvider(entityClass, viewRootName, conditionExpression, this.createPredicate(conditionExpression, context, viewRootName), rootAliases);
                    }
                } else if (joinExpression != null) {
                    if (correlationProvider != null) {
                        context.addError("Illegal entity view root mapping '" + viewRootName + "' at the class '" + this.entityViewClass.getName() + "'! Only one of the attributes entity, expression or correlator may be used!");
                    }
                    correlationProviderFactory = conditionExpression == null ? new StaticPathCorrelationProvider(joinExpression, viewRootName, "1=1", this.createPredicate("1=1", context, viewRootName), rootAliases) : new StaticPathCorrelationProvider(joinExpression, viewRootName, conditionExpression, this.createPredicate(conditionExpression, context, viewRootName), rootAliases);
                } else if (correlationProvider != null) {
                    if (conditionExpression != null) {
                        context.addError("Illegal entity view root mapping '" + viewRootName + "' at the class '" + this.entityViewClass.getName() + "'! When using the correlator attribute, using a condition expression is illegal!");
                    }
                    correlationProviderFactory = CorrelationProviderHelper.getFactory(correlationProvider);
                } else {
                    context.addError("Illegal entity view root mapping '" + viewRootName + "' at the class '" + this.entityViewClass.getName() + "'! One of the attributes entity, expression or correlator must be used for a valid entity view root definition!");
                }
                if (entityViewRoot.getLimitExpression() == null || entityViewRoot.getLimitExpression().isEmpty()) {
                    limitExpression = null;
                    offsetExpression = null;
                    orderByItems = Collections.emptyList();
                } else {
                    limitExpression = entityViewRoot.getLimitExpression();
                    offsetExpression = entityViewRoot.getOffsetExpression();
                    if (offsetExpression == null || offsetExpression.isEmpty()) {
                        offsetExpression = "0";
                    }
                    List orderByItemExpressions = entityViewRoot.getOrderByItems();
                    orderByItems = AbstractAttribute.parseOrderByItems(orderByItemExpressions);
                }
                try {
                    type = TypeExtractingCorrelationBuilder.extractType(correlationProviderFactory, viewRootName, context, new ScalarTargetResolvingExpressionVisitor(this.getManagedType(context), context.getEntityMetamodel(), context.getJpqlFunctions(), this.viewRootTypes));
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter();
                    sw.append("Illegal entity view root mapping '").append(viewRootName).append("' at the class '").append(this.entityViewClass.getName()).append("'! The given entity class is not a valid managed type:\n");
                    ex.printStackTrace(new PrintWriter(sw));
                    context.addError(sw.toString());
                }
                this.viewRootTypes.put(viewRootName, type);
                this.viewRoots.add(new ViewRootImpl(viewRootName, type, correlationProviderFactory, correlationProvider, entityViewRoot.getJoinType(), entityViewRoot.getFetches(), orderByItems, limitExpression, offsetExpression));
            }
        }
    }

    private Predicate createPredicate(String expression, MetamodelBuildingContext context, String viewRootName) {
        try {
            return context.getTypeValidationExpressionFactory().createBooleanExpression(expression, false);
        }
        catch (SyntaxErrorException ex) {
            context.addError("Syntax error in condition expression '" + expression + "' of the entity view root mapping '" + viewRootName + "' at the class '" + this.entityViewClass.getName() + "': " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            context.addError("An error occurred while trying to resolve the condition expression '" + expression + "' of the entity view root mapping '" + viewRootName + "' at the class '" + this.entityViewClass.getName() + "': " + ex.getMessage());
        }
        return null;
    }

    public boolean isValidatePersistability() {
        return this.validatePersistability;
    }

    public void setValidatePersistability(boolean validatePersistability) {
        this.validatePersistability = validatePersistability;
    }

    @Override
    public Set<String> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    @Override
    public MethodAttributeMapping getIdAttribute() {
        return this.idAttribute;
    }

    public void setIdAttribute(EntityViewAttributeMapping idAttribute) {
        this.setIdAttributeMapping((MethodAttributeMapping)idAttribute);
    }

    @Override
    public void setIdAttributeMapping(MethodAttributeMapping idAttribute) {
        this.idAttribute = idAttribute;
    }

    @Override
    public MethodAttributeMapping getVersionAttribute() {
        return this.versionAttribute;
    }

    public void setVersionAttribute(EntityViewAttributeMapping versionAttribute) {
        this.setVersionAttributeMapping((MethodAttributeMapping)versionAttribute);
    }

    @Override
    public void setVersionAttributeMapping(MethodAttributeMapping versionAttribute) {
        this.versionAttribute = versionAttribute;
    }

    public LockMode getLockMode() {
        return this.lockMode == null ? LockMode.AUTO : this.lockMode;
    }

    public void setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        this.resolvedLockMode = lockMode != LockMode.AUTO ? lockMode : null;
    }

    @Override
    public LockMode getResolvedLockMode() {
        return this.resolvedLockMode;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    public Map<String, EntityViewAttributeMapping> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Map<String, MethodAttributeMapping> getMethodAttributes() {
        return this.attributes;
    }

    public Map<String, EntityViewConstructorMapping> getConstructors() {
        return Collections.unmodifiableMap(this.constructorNameMap);
    }

    @Override
    public void addConstructor(ConstructorMapping constructorMapping) {
        if (this.constructorNameMap.put(constructorMapping.getName(), constructorMapping) != null) {
            this.context.addError("Constructor with duplicate view constructor name '" + constructorMapping.getName() + "' found: " + constructorMapping.getConstructor());
        }
        this.constructors.put(new ParametersKey(constructorMapping.getConstructor().getParameterTypes()), constructorMapping);
    }

    @Override
    public Map<ParametersKey, ConstructorMapping> getConstructorMappings() {
        return this.constructors;
    }

    @Override
    public String determineInheritanceMapping(MetamodelBuildingContext context) {
        if (this.inheritanceMapping == null && !this.inheritanceSupertypes.isEmpty()) {
            for (ViewMapping supertypeMapping : this.inheritanceSupertypes) {
                Class supertypeEntityClass = supertypeMapping.getEntityClass();
                if (supertypeEntityClass.isAssignableFrom(this.entityClass) && supertypeEntityClass != this.entityClass) continue;
                return this.inheritanceMapping;
            }
            return "TYPE(this) = " + context.getEntityMetamodel().entity(this.entityClass).getName();
        }
        return this.inheritanceMapping;
    }

    @Override
    public void setInheritanceMapping(String inheritanceMapping) {
        this.inheritanceMapping = inheritanceMapping;
    }

    @Override
    public boolean isInheritanceSubtypesResolved() {
        return this.inheritanceSubtypesResolved;
    }

    @Override
    public void setInheritanceSubtypesResolved(boolean inheritanceSubtypesResolved) {
        this.inheritanceSubtypesResolved = inheritanceSubtypesResolved;
    }

    @Override
    public Set<Class<?>> getInheritanceSubtypeClasses() {
        return this.inheritanceSubtypeClasses;
    }

    @Override
    public Set<ViewMapping> getInheritanceSubtypes() {
        return this.inheritanceSubtypes;
    }

    @Override
    public Set<ViewMapping> getInheritanceSupertypes() {
        return this.inheritanceSupertypes;
    }

    @Override
    public Set<InheritanceViewMapping> getInheritanceViewMappings() {
        return this.inheritanceViewMappings;
    }

    @Override
    public void onInitializeViewMappingsFinished(Runnable finishListener) {
        if (this.finished) {
            finishListener.run();
        } else {
            this.finishListeners.add(finishListener);
        }
    }

    @Override
    public boolean isCreatable(MetamodelBuildingContext context) {
        if (this.updatable) {
            if (!this.creatable && this.getManagedType(context) instanceof EmbeddableType) {
                this.setCreatable(true);
                this.setValidatePersistability(true);
            }
        } else if (this.creatable && this.getManagedType(context) instanceof EmbeddableType) {
            context.addError("Illegal creatable-only mapping at '" + this.getEntityViewClass().getName() + "'! Declaring @CreatableEntityView for an entity view that maps a JPA embeddable type is only allowed when also @UpdatableEntityView is defined!");
        }
        return this.creatable;
    }

    @Override
    public void initializeViewMappings(MetamodelBuildingContext context, Runnable finishListener) {
        if (this.initialized) {
            if (finishListener != null) {
                this.onInitializeViewMappingsFinished(finishListener);
            }
            return;
        }
        this.initialized = true;
        if (!this.inheritanceSubtypesResolved) {
            this.inheritanceSubtypeClasses = context.findSubtypes(this.entityViewClass);
            this.inheritanceSubtypeClasses.remove(this.entityViewClass);
            this.inheritanceSubtypesResolved = true;
        }
        this.defaultInheritanceViewMapping = new InheritanceViewMapping(this, this.inheritanceSubtypes);
        this.inheritanceViewMappings.add(this.defaultInheritanceViewMapping);
        this.initializeSubtypes(this.entityViewClass, context, this.inheritanceSubtypeClasses);
        for (MethodAttributeMapping attributeMapping : this.attributes.values()) {
            attributeMapping.initializeViewMappings(context);
        }
        for (ConstructorMapping constructorMapping : this.getConstructorMappings().values()) {
            constructorMapping.initializeViewMappings(context);
        }
        this.finished = true;
        if (finishListener != null) {
            finishListener.run();
        }
        for (Runnable listener : this.finishListeners) {
            listener.run();
        }
        this.finishListeners.clear();
    }

    @Override
    public boolean validateDependencies(MetamodelBuildingContext context, Set<Class<?>> dependencies, AttributeMapping originatingAttributeMapping, Class<?> excludeEntityViewClass, boolean reportError) {
        if (originatingAttributeMapping != null && this.containsAny(context, dependencies, this.entityViewClass, excludeEntityViewClass)) {
            if (reportError) {
                originatingAttributeMapping.circularDependencyError(dependencies);
            } else {
                originatingAttributeMapping.circularDependencyDebug(this, dependencies);
            }
            return true;
        }
        boolean error = false;
        for (InheritanceViewMapping inheritanceViewMapping : this.inheritanceViewMappings) {
            for (ViewMapping subtypeMapping : inheritanceViewMapping.getInheritanceSubtypeMappings().keySet()) {
                if (subtypeMapping == this || !subtypeMapping.validateDependencies(context, dependencies, originatingAttributeMapping, this.entityViewClass, reportError)) continue;
                error = true;
                if (reportError) continue;
                return true;
            }
        }
        dependencies.add(this.entityViewClass);
        dependencies.addAll(this.inheritanceSubtypeClasses);
        for (MethodAttributeMapping attributeMapping : this.attributes.values()) {
            if (!attributeMapping.validateDependencies(context, dependencies, reportError)) continue;
            error = true;
            if (reportError) continue;
            return true;
        }
        for (ConstructorMapping constructorMapping : this.getConstructorMappings().values()) {
            if (!constructorMapping.validateDependencies(context, dependencies, reportError)) continue;
            error = true;
            if (reportError) continue;
            return true;
        }
        dependencies.removeAll(this.inheritanceSubtypeClasses);
        dependencies.remove(this.entityViewClass);
        return error;
    }

    private boolean containsAny(MetamodelBuildingContext context, Set<Class<?>> dependencies, Class<?> entityViewClass, Class<?> excludeEntityViewClass) {
        if (dependencies.contains(entityViewClass)) {
            return true;
        }
        for (Class<?> clazz : context.findSupertypes(entityViewClass)) {
            if (clazz == excludeEntityViewClass || !dependencies.contains(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ManagedType<?> getManagedType(MetamodelBuildingContext context) {
        if (this.managedType != null) {
            return this.managedType;
        }
        this.managedType = context.getEntityMetamodel().getManagedType(this.entityClass);
        return this.managedType;
    }

    @Override
    public ManagedViewTypeImplementor<?> getManagedViewType(MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        ManagedViewTypeImpl viewType;
        if (this.idAttribute != null) {
            viewType = this.viewType;
        } else {
            if (this.embeddableViewTypeMap == null) {
                this.embeddableViewTypeMap = new HashMap(1);
            }
            viewType = this.embeddableViewTypeMap.get(embeddableMapping);
        }
        if (viewType == null) {
            ManagedType<?> managedType = this.getManagedType(context);
            if (managedType == null) {
                context.addError("The entity class '" + this.entityClass.getName() + "' used for the entity view '" + this.entityViewClass.getName() + "' could not be found in the persistence unit!");
                return null;
            }
            if (!(managedType instanceof MappedSuperclassType)) {
                if (!(managedType instanceof IdentifiableType)) {
                    if (this.idAttribute != null) {
                        context.addError("Invalid id attribute mapping for embeddable entity type '" + this.entityClass.getName() + "' at " + this.idAttribute.getErrorLocation() + " for managed view type '" + this.entityViewClass.getName() + "'!");
                    }
                    if (this.versionAttribute != null) {
                        context.addError("Invalid version attribute mapping for embeddable entity type '" + this.entityClass.getName() + "' at " + this.versionAttribute.getErrorLocation() + " for managed view type '" + this.entityViewClass.getName() + "'!");
                    }
                } else {
                    SingularAttribute versionAttribute;
                    if (this.isCreatable() || this.isUpdatable()) {
                        if (this.idAttribute == null) {
                            if (this.isUpdatable()) {
                                context.addError("Missing @IdMapping which is required for @UpdatableEntityView '" + this.entityViewClass.getName() + "'!");
                            } else {
                                context.addError("Missing @IdMapping which is required for @CreatableEntityView '" + this.entityViewClass.getName() + "'!");
                            }
                        } else if (this.resolvedLockMode == null) {
                            versionAttribute = JpaMetamodelUtils.getVersionAttribute((IdentifiableType)((IdentifiableType)managedType));
                            this.resolvedLockMode = versionAttribute == null ? LockMode.AUTO : LockMode.OPTIMISTIC;
                        }
                    } else {
                        this.resolvedLockMode = LockMode.NONE;
                    }
                    if (this.resolvedLockMode == LockMode.OPTIMISTIC) {
                        versionAttribute = JpaMetamodelUtils.getVersionAttribute((IdentifiableType)((IdentifiableType)managedType));
                        if (versionAttribute == null) {
                            context.addError("No version attribute could be found for entity type '" + managedType.getJavaType().getName() + "', but since OPTIMISTIC locking was specified for the entity view type '" + this.entityViewClass.getName() + "' it is required!");
                        } else {
                            MethodAttributeMapping versionAttributeMapping = null;
                            for (MethodAttributeMapping attributeMapping : this.attributes.values()) {
                                String mappingPath = this.getMappingPath(attributeMapping);
                                if (!versionAttribute.getName().equals(mappingPath)) continue;
                                versionAttributeMapping = attributeMapping;
                                break;
                            }
                            if (versionAttributeMapping == null) {
                                try {
                                    versionAttributeMapping = new MethodAttributeMapping(this, (Annotation)((Object)new MappingLiteral(versionAttribute.getName())), null, this.context, "$$_version", EntityViewProxy.class.getMethod("$$_getVersion", new Class[0]), -1, false, null, versionAttribute.getJavaType(), null, null, versionAttribute.getJavaType(), null, null, null, null, null);
                                    this.attributes.put("$$_version", versionAttributeMapping);
                                }
                                catch (NoSuchMethodException ex) {
                                    throw new RuntimeException(ex);
                                }
                            }
                            this.versionAttribute = versionAttributeMapping;
                        }
                    }
                }
            }
            viewType = this.idAttribute != null ? new ViewTypeImpl(this, managedType, context) : new FlatViewTypeImpl(this, managedType, context, embeddableMapping);
        }
        if (this.idAttribute != null) {
            this.viewType = viewType;
        } else {
            this.embeddableViewTypeMap.put(embeddableMapping, viewType);
        }
        return viewType;
    }

    private String getMappingPath(MethodAttributeMapping attributeMapping) {
        if (attributeMapping.getMapping() instanceof Mapping) {
            return AbstractAttribute.stripThisFromMapping(((Mapping)attributeMapping.getMapping()).value());
        }
        return null;
    }

    private void initializeSubtypes(Class<?> entityViewClass, MetamodelBuildingContext context, Set<Class<?>> subtypeClasses) {
        for (Class<?> subtypeClass : subtypeClasses) {
            if (entityViewClass == subtypeClass) {
                context.addError("Entity view type '" + entityViewClass.getName() + "' declared itself in @EntityViewInheritance as subtype which is not allowed!");
                continue;
            }
            if (!entityViewClass.isAssignableFrom(subtypeClass)) {
                context.addError("Entity view subtype '" + subtypeClass.getName() + "' was explicitly declared as subtype in '" + entityViewClass.getName() + "' but isn't a Java subtype!");
                continue;
            }
            final ViewMapping subtypeMapping = context.getViewMapping(subtypeClass);
            if (subtypeMapping == null) {
                this.unknownSubtype(entityViewClass, subtypeClass);
                continue;
            }
            subtypeMapping.initializeViewMappings(context, new Runnable(){

                @Override
                public void run() {
                    ViewMappingImpl.this.inheritanceSubtypes.add(subtypeMapping);
                    ViewMappingImpl.this.inheritanceSubtypes.addAll(subtypeMapping.getInheritanceSubtypes());
                    subtypeMapping.getInheritanceSupertypes().add(ViewMappingImpl.this);
                    ViewMappingImpl.this.defaultInheritanceViewMapping.getInheritanceSubtypeMappings().put(subtypeMapping, null);
                    for (ViewMapping inheritanceSubtypeMapping : subtypeMapping.getInheritanceSubtypes()) {
                        inheritanceSubtypeMapping.getInheritanceSupertypes().add(ViewMappingImpl.this);
                        ViewMappingImpl.this.defaultInheritanceViewMapping.getInheritanceSubtypeMappings().put(inheritanceSubtypeMapping, null);
                    }
                }
            });
        }
    }

    public void unknownSubtype(Class<?> entityViewClass, Class<?> subviewClass) {
        this.context.addError("An unknown or unregistered entity view subtype type '" + subviewClass.getName() + "' is used for the entity view: " + entityViewClass.getName() + "!");
    }

    @Override
    public int compareTo(ViewMapping o) {
        return this.getEntityViewClass().getName().compareTo(o.getEntityViewClass().getName());
    }
}

