/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder;

import com.blazebit.persistence.FromBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.objectbuilder.Limiter;
import com.blazebit.persistence.view.impl.objectbuilder.SecondaryMapper;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.JoinCorrelationBuilder;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.spi.ViewJpqlMacro;
import java.util.Map;

public class EntityViewRootSecondaryMapper
implements SecondaryMapper {
    private final String entityViewRootName;
    private final String attributePath;
    private final String viewPath;
    private final String embeddingViewPath;
    private final CorrelationProviderFactory correlationProviderFactory;
    private final JoinType joinType;
    private final String[] fetches;
    private final Limiter limiter;

    public EntityViewRootSecondaryMapper(String entityViewRootName, String attributePath, String viewPath, String embeddingViewPath, CorrelationProviderFactory correlationProviderFactory, JoinType joinType, String[] fetches, Limiter limiter) {
        this.entityViewRootName = entityViewRootName;
        this.attributePath = attributePath;
        this.viewPath = viewPath;
        this.embeddingViewPath = embeddingViewPath;
        this.correlationProviderFactory = correlationProviderFactory;
        this.joinType = joinType;
        this.fetches = fetches;
        this.limiter = limiter;
    }

    @Override
    public String getAttributePath() {
        return this.attributePath;
    }

    @Override
    public void apply(FullQueryBuilder<?, ?> fullQueryBuilder, ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, ViewJpqlMacro viewJpqlMacro, EmbeddingViewJpqlMacro embeddingViewJpqlMacro) {
        String oldViewPath = viewJpqlMacro.getViewPath();
        String oldEmbeddingViewPath = embeddingViewJpqlMacro.getEmbeddingViewPath();
        viewJpqlMacro.setViewPath(this.viewPath);
        embeddingViewJpqlMacro.setEmbeddingViewPath(this.embeddingViewPath);
        CorrelationProvider correlationProvider = this.correlationProviderFactory.create(parameterHolder, optionalParameters);
        String correlationAlias = this.limiter == null ? this.entityViewRootName : "_sub_" + this.entityViewRootName;
        JoinCorrelationBuilder correlationBuilder = new JoinCorrelationBuilder(parameterHolder, optionalParameters, (FromBuilder<?>)fullQueryBuilder, viewJpqlMacro.getViewPath(), correlationAlias, this.entityViewRootName, this.attributePath, this.joinType, this.limiter);
        correlationProvider.applyCorrelation((CorrelationBuilder)correlationBuilder, viewJpqlMacro.getViewPath());
        correlationBuilder.finish();
        fullQueryBuilder.fetch(this.fetches);
        embeddingViewJpqlMacro.setEmbeddingViewPath(oldEmbeddingViewPath);
        viewJpqlMacro.setViewPath(oldViewPath);
    }
}

