/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder;

import java.util.Arrays;

public class TupleRest {
    private static final Object[] ANY_OFFSET_TUPLE = new Object[0];
    private final Object[] tuple;
    private final Object[] offsetTuple;
    private final int index;

    public TupleRest(Object[] tuple, int index, int offset) {
        Object[] offsetTuple = new Object[offset];
        System.arraycopy(tuple, index, offsetTuple, 0, offset);
        this.tuple = tuple;
        this.offsetTuple = offsetTuple;
        this.index = index + offset;
    }

    public TupleRest(Object[] tuple, int index) {
        this.tuple = tuple;
        this.offsetTuple = ANY_OFFSET_TUPLE;
        this.index = index;
    }

    public int hashCode() {
        int hash = 7;
        int result = 1;
        for (int i = this.index; i < this.tuple.length; ++i) {
            Object element = this.tuple[i];
            result = 31 * result + TupleRest.elementHashCode(element);
        }
        hash = 53 * hash + result;
        return hash;
    }

    private static int elementHashCode(Object element) {
        if (element instanceof Object[]) {
            return Arrays.deepHashCode((Object[])element);
        }
        if (element instanceof byte[]) {
            return Arrays.hashCode((byte[])element);
        }
        if (element instanceof short[]) {
            return Arrays.hashCode((short[])element);
        }
        if (element instanceof int[]) {
            return Arrays.hashCode((int[])element);
        }
        if (element instanceof long[]) {
            return Arrays.hashCode((long[])element);
        }
        if (element instanceof char[]) {
            return Arrays.hashCode((char[])element);
        }
        if (element instanceof float[]) {
            return Arrays.hashCode((float[])element);
        }
        if (element instanceof double[]) {
            return Arrays.hashCode((double[])element);
        }
        if (element instanceof boolean[]) {
            return Arrays.hashCode((boolean[])element);
        }
        if (element != null) {
            return element.hashCode();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TupleRest other = (TupleRest)obj;
        return this.deepEquals(other);
    }

    public boolean deepEquals(TupleRest other) {
        boolean eq;
        Object e2;
        Object e1;
        int i;
        boolean checkOffsetTuple;
        Object[] otherTuple = other.tuple;
        Object[] otherOffsetTuple = other.offsetTuple;
        int otherIndex = other.index;
        boolean bl = checkOffsetTuple = this.offsetTuple != ANY_OFFSET_TUPLE && otherOffsetTuple != ANY_OFFSET_TUPLE;
        if (checkOffsetTuple) {
            if (this.offsetTuple == null || otherOffsetTuple == null) {
                return false;
            }
            if (this.offsetTuple.length != other.offsetTuple.length) {
                return false;
            }
        } else if (this.tuple == otherTuple) {
            return false;
        }
        if (this.tuple == null || otherTuple == null) {
            return false;
        }
        int length = this.tuple.length - this.index;
        if (otherTuple.length - otherIndex != length) {
            return false;
        }
        if (checkOffsetTuple) {
            for (i = 0; i < this.offsetTuple.length; ++i) {
                e1 = this.offsetTuple[i];
                e2 = otherOffsetTuple[i];
                if (e1 == e2) continue;
                if (e1 == null) {
                    return false;
                }
                eq = TupleRest.deepEquals0(e1, e2);
                if (eq) continue;
                return false;
            }
        }
        for (i = 0; i < length; ++i) {
            e1 = this.tuple[this.index + i];
            e2 = otherTuple[otherIndex + i];
            if (e1 == e2) continue;
            if (e1 == null) {
                return false;
            }
            eq = TupleRest.deepEquals0(e1, e2);
            if (eq) continue;
            return false;
        }
        return true;
    }

    private static boolean deepEquals0(Object e1, Object e2) {
        assert (e1 != null);
        boolean eq = e1 instanceof Object[] && e2 instanceof Object[] ? Arrays.deepEquals((Object[])e1, (Object[])e2) : (e1 instanceof byte[] && e2 instanceof byte[] ? Arrays.equals((byte[])e1, (byte[])e2) : (e1 instanceof short[] && e2 instanceof short[] ? Arrays.equals((short[])e1, (short[])e2) : (e1 instanceof int[] && e2 instanceof int[] ? Arrays.equals((int[])e1, (int[])e2) : (e1 instanceof long[] && e2 instanceof long[] ? Arrays.equals((long[])e1, (long[])e2) : (e1 instanceof char[] && e2 instanceof char[] ? Arrays.equals((char[])e1, (char[])e2) : (e1 instanceof float[] && e2 instanceof float[] ? Arrays.equals((float[])e1, (float[])e2) : (e1 instanceof double[] && e2 instanceof double[] ? Arrays.equals((double[])e1, (double[])e2) : (e1 instanceof boolean[] && e2 instanceof boolean[] ? Arrays.equals((boolean[])e1, (boolean[])e2) : e1.equals(e2)))))))));
        return eq;
    }
}

