/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.CorrelationQueryBuilder;
import com.blazebit.persistence.FromProvider;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.spi.ServiceProvider;
import com.blazebit.persistence.view.CorrelationBuilder;
import jakarta.persistence.metamodel.EntityType;

public class MultisetCorrelationBuilder
implements CorrelationBuilder {
    private final SubqueryInitiator<?> subqueryInitiator;
    private final ServiceProvider serviceProvider;
    private final String correlationAlias;
    private SubqueryBuilder<?> subqueryBuilder;

    public MultisetCorrelationBuilder(SubqueryInitiator<?> subqueryInitiator, ServiceProvider serviceProvider, String correlationAlias) {
        this.subqueryInitiator = subqueryInitiator;
        this.serviceProvider = serviceProvider;
        this.correlationAlias = correlationAlias;
    }

    public <T> T getService(Class<T> serviceClass) {
        return (T)this.serviceProvider.getService(serviceClass);
    }

    public FromProvider getCorrelationFromProvider() {
        return this.subqueryBuilder;
    }

    public String getCorrelationAlias() {
        return this.correlationAlias;
    }

    public SubqueryBuilder<?> getSubqueryBuilder() {
        return this.subqueryBuilder;
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(Class<?> entityClass) {
        if (this.subqueryBuilder != null) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        this.subqueryBuilder = this.subqueryInitiator.from(entityClass, this.correlationAlias);
        return (JoinOnBuilder)this.subqueryBuilder.getService(JoinOnBuilder.class);
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(EntityType<?> entityType) {
        if (this.subqueryBuilder != null) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        this.subqueryBuilder = this.subqueryInitiator.from(entityType, this.correlationAlias);
        return (JoinOnBuilder)this.subqueryBuilder.getService(JoinOnBuilder.class);
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(String correlationPath) {
        if (this.subqueryBuilder != null) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        this.subqueryBuilder = this.subqueryInitiator.from(correlationPath, this.correlationAlias);
        return (JoinOnBuilder)this.subqueryBuilder.getService(JoinOnBuilder.class);
    }
}

