/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update;

import com.blazebit.persistence.view.PostCommitListener;
import com.blazebit.persistence.view.PostPersistEntityListener;
import com.blazebit.persistence.view.PostPersistListener;
import com.blazebit.persistence.view.PostRemoveListener;
import com.blazebit.persistence.view.PostRollbackListener;
import com.blazebit.persistence.view.PostUpdateListener;
import com.blazebit.persistence.view.PrePersistEntityListener;
import com.blazebit.persistence.view.PrePersistListener;
import com.blazebit.persistence.view.PreRemoveListener;
import com.blazebit.persistence.view.PreUpdateListener;
import com.blazebit.persistence.view.ViewTransition;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.listener.ViewInstancePreRemoveListener;
import com.blazebit.persistence.view.impl.update.listener.ViewPreRemoveListenerImpl;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Listeners {
    private final Class<?> entityClass;
    private final List<ListenerEntry<PrePersistListener<Object>>> prePersistListeners;
    private final List<ListenerEntry<PrePersistEntityListener<Object, Object>>> prePersistEntityListeners;
    private final List<ListenerEntry<PostPersistListener<Object>>> postPersistListeners;
    private final List<ListenerEntry<PostPersistEntityListener<Object, Object>>> postPersistEntityListeners;
    private final List<ListenerEntry<PreUpdateListener<Object>>> preUpdateListeners;
    private final List<ListenerEntry<PostUpdateListener<Object>>> postUpdateListeners;
    private final List<PreRemoveListenerEntry<Object>> preRemoveListeners;
    private final List<ListenerEntry<PostRemoveListener<Object>>> postRemoveListeners;
    private final List<ListenerTransitionEntry<PostCommitListener<Object>>> postCommitListeners;
    private final List<ListenerTransitionEntry<PostRollbackListener<Object>>> postRollbackListeners;

    public Listeners(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.prePersistListeners = new ArrayList<ListenerEntry<PrePersistListener<Object>>>();
        this.prePersistEntityListeners = new ArrayList<ListenerEntry<PrePersistEntityListener<Object, Object>>>();
        this.postPersistListeners = new ArrayList<ListenerEntry<PostPersistListener<Object>>>();
        this.postPersistEntityListeners = new ArrayList<ListenerEntry<PostPersistEntityListener<Object, Object>>>();
        this.preUpdateListeners = new ArrayList<ListenerEntry<PreUpdateListener<Object>>>();
        this.postUpdateListeners = new ArrayList<ListenerEntry<PostUpdateListener<Object>>>();
        this.preRemoveListeners = new ArrayList<PreRemoveListenerEntry<Object>>();
        this.postRemoveListeners = new ArrayList<ListenerEntry<PostRemoveListener<Object>>>();
        this.postCommitListeners = new ArrayList<ListenerTransitionEntry<PostCommitListener<Object>>>();
        this.postRollbackListeners = new ArrayList<ListenerTransitionEntry<PostRollbackListener<Object>>>();
    }

    public void invokePrePersist(UpdateContext context, EntityViewProxy updatableProxy, Object entity) {
        EntityViewProxy view;
        ListenerEntry<PrePersistListener<Object>> entry;
        int i;
        for (i = 0; i < this.prePersistListeners.size(); ++i) {
            entry = this.prePersistListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PrePersistListener)((ListenerEntry)entry).listener).prePersist(context.getEntityViewManager().getSerializableDelegate(updatableProxy.$$_getEntityViewClass()), context.getEntityManager(), (Object)updatableProxy);
                continue;
            }
            view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, true, true);
            if (view == null) continue;
            ((PrePersistListener)((ListenerEntry)entry).listener).prePersist(context.getEntityViewManager().getSerializableDelegate(view.$$_getEntityViewClass()), context.getEntityManager(), (Object)view);
        }
        for (i = 0; i < this.prePersistEntityListeners.size(); ++i) {
            entry = this.prePersistEntityListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PrePersistEntityListener)((ListenerEntry)entry).listener).prePersist(context.getEntityViewManager().getSerializableDelegate(updatableProxy.$$_getEntityViewClass()), context.getEntityManager(), (Object)updatableProxy, entity);
                continue;
            }
            view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, true, true);
            if (view == null) continue;
            ((PrePersistEntityListener)((ListenerEntry)entry).listener).prePersist(context.getEntityViewManager().getSerializableDelegate(view.$$_getEntityViewClass()), context.getEntityManager(), (Object)view, entity);
        }
    }

    public void invokePostPersist(UpdateContext context, EntityViewProxy updatableProxy, Object entity) {
        EntityViewProxy view;
        ListenerEntry<PostPersistListener<Object>> entry;
        int i;
        for (i = 0; i < this.postPersistListeners.size(); ++i) {
            entry = this.postPersistListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PostPersistListener)((ListenerEntry)entry).listener).postPersist(context.getEntityViewManager().getSerializableDelegate(updatableProxy.$$_getEntityViewClass()), context.getEntityManager(), (Object)updatableProxy);
                continue;
            }
            view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, false, false);
            ((PostPersistListener)((ListenerEntry)entry).listener).postPersist(context.getEntityViewManager().getSerializableDelegate(view.$$_getEntityViewClass()), context.getEntityManager(), (Object)view);
        }
        for (i = 0; i < this.postPersistEntityListeners.size(); ++i) {
            entry = this.postPersistEntityListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PostPersistEntityListener)((ListenerEntry)entry).listener).postPersist(context.getEntityViewManager().getSerializableDelegate(updatableProxy.$$_getEntityViewClass()), context.getEntityManager(), (Object)updatableProxy, entity);
                continue;
            }
            view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, false, false);
            ((PostPersistEntityListener)((ListenerEntry)entry).listener).postPersist(context.getEntityViewManager().getSerializableDelegate(view.$$_getEntityViewClass()), context.getEntityManager(), (Object)view, entity);
        }
    }

    public boolean invokePreUpdate(UpdateContext context, EntityViewProxy updatableProxy) {
        for (int i = 0; i < this.preUpdateListeners.size(); ++i) {
            ListenerEntry<PreUpdateListener<Object>> entry = this.preUpdateListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PreUpdateListener)((ListenerEntry)entry).listener).preUpdate(context.getEntityViewManager().getSerializableDelegate(updatableProxy.$$_getEntityViewClass()), context.getEntityManager(), (Object)updatableProxy);
                continue;
            }
            EntityViewProxy view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, false, true);
            ((PreUpdateListener)((ListenerEntry)entry).listener).preUpdate(context.getEntityViewManager().getSerializableDelegate(view.$$_getEntityViewClass()), context.getEntityManager(), (Object)view);
        }
        return !this.preUpdateListeners.isEmpty();
    }

    public void invokePostUpdate(UpdateContext context, EntityViewProxy updatableProxy) {
        for (int i = 0; i < this.postUpdateListeners.size(); ++i) {
            ListenerEntry<PostUpdateListener<Object>> entry = this.postUpdateListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(updatableProxy)) {
                ((PostUpdateListener)((ListenerEntry)entry).listener).postUpdate(context.getEntityViewManager().getSerializableDelegate(updatableProxy.$$_getEntityViewClass()), context.getEntityManager(), (Object)updatableProxy);
                continue;
            }
            EntityViewProxy view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, updatableProxy, false, false);
            ((PostUpdateListener)((ListenerEntry)entry).listener).postUpdate(context.getEntityViewManager().getSerializableDelegate(view.$$_getEntityViewClass()), context.getEntityManager(), (Object)view);
        }
    }

    public boolean invokePreRemove(UpdateContext context, EntityViewProxy entityView, Object entityId) {
        for (int i = 0; i < this.preRemoveListeners.size(); ++i) {
            PreRemoveListenerEntry<Object> entry = this.preRemoveListeners.get(i);
            if (((PreRemoveListenerEntry)entry).entityViewClass.isInstance(entityView)) {
                if (((PreRemoveListenerEntry)entry).listener.preRemove(context.getEntityViewManager().getSerializableDelegate(entityView.$$_getEntityViewClass()), context.getEntityManager(), (Object)entityView)) continue;
                return false;
            }
            EntityViewProxy view = context.getEntityView(((PreRemoveListenerEntry)entry).entityViewClass, this.entityClass, entityView == null ? entityId : entityView, false, true);
            if (((PreRemoveListenerEntry)entry).listener.preRemove(context.getEntityViewManager().getSerializableDelegate(view.$$_getEntityViewClass()), context.getEntityManager(), (Object)view)) continue;
            return false;
        }
        return true;
    }

    public void preparePostRemove(UpdateContext context, EntityViewProxy entityView, Object entityId) {
        Object entry;
        int i;
        for (i = 0; i < this.postRemoveListeners.size(); ++i) {
            entry = this.postRemoveListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(entityView)) continue;
            context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, entityView == null ? entityId : entityView, false, false);
        }
        for (i = 0; i < this.postCommitListeners.size(); ++i) {
            entry = this.postCommitListeners.get(i);
            if (!((ListenerTransitionEntry)entry).viewTransitions.contains(ViewTransition.REMOVE) || ((ListenerTransitionEntry)entry).entityViewClass.isInstance(entityView)) continue;
            context.getEntityView(((ListenerTransitionEntry)entry).entityViewClass, this.entityClass, entityView == null ? entityId : entityView, false, false);
        }
    }

    public void invokePostRemove(UpdateContext context, EntityViewProxy entityView, Object entityId) {
        for (int i = 0; i < this.postRemoveListeners.size(); ++i) {
            ListenerEntry<PostRemoveListener<Object>> entry = this.postRemoveListeners.get(i);
            if (((ListenerEntry)entry).entityViewClass.isInstance(entityView)) {
                ((PostRemoveListener)((ListenerEntry)entry).listener).postRemove(context.getEntityViewManager().getSerializableDelegate(entityView.$$_getEntityViewClass()), context.getEntityManager(), (Object)entityView);
                continue;
            }
            EntityViewProxy view = context.getEntityView(((ListenerEntry)entry).entityViewClass, this.entityClass, entityView == null ? entityId : entityView, false, false);
            ((PostRemoveListener)((ListenerEntry)entry).listener).postRemove(context.getEntityViewManager().getSerializableDelegate(view.$$_getEntityViewClass()), context.getEntityManager(), (Object)view);
        }
    }

    public void invokePostCommit(UpdateContext context, EntityViewProxy entityView, ViewTransition viewTransition) {
        for (int i = 0; i < this.postCommitListeners.size(); ++i) {
            ListenerTransitionEntry<PostCommitListener<Object>> entry = this.postCommitListeners.get(i);
            if (!((ListenerTransitionEntry)entry).viewTransitions.contains(viewTransition)) continue;
            if (((ListenerTransitionEntry)entry).entityViewClass.isInstance(entityView)) {
                ((PostCommitListener)((ListenerTransitionEntry)entry).listener).postCommit(context.getEntityViewManager().getSerializableDelegate(entityView.$$_getEntityViewClass()), context.getEntityManager(), (Object)entityView, viewTransition);
                continue;
            }
            EntityViewProxy view = context.getEntityView(((ListenerTransitionEntry)entry).entityViewClass, this.entityClass, entityView, false, false);
            ((PostCommitListener)((ListenerTransitionEntry)entry).listener).postCommit(context.getEntityViewManager().getSerializableDelegate(view.$$_getEntityViewClass()), context.getEntityManager(), (Object)view, viewTransition);
        }
    }

    public void invokePostRollback(UpdateContext context, EntityViewProxy entityView, ViewTransition viewTransition, EntityManager em) {
        for (int i = 0; i < this.postRollbackListeners.size(); ++i) {
            ListenerTransitionEntry<PostRollbackListener<Object>> entry = this.postRollbackListeners.get(i);
            if (!((ListenerTransitionEntry)entry).viewTransitions.contains(viewTransition)) continue;
            if (((ListenerTransitionEntry)entry).entityViewClass.isInstance(entityView)) {
                ((PostRollbackListener)((ListenerTransitionEntry)entry).listener).postRollback(context.getEntityViewManager().getSerializableDelegate(entityView.$$_getEntityViewClass()), context.getEntityManager(), (Object)entityView, viewTransition);
                continue;
            }
            if (viewTransition == ViewTransition.PERSIST) continue;
            EntityViewProxy view = context.getEntityView(((ListenerTransitionEntry)entry).entityViewClass, this.entityClass, entityView, false, false, em);
            ((PostRollbackListener)((ListenerTransitionEntry)entry).listener).postRollback(context.getEntityViewManager().getSerializableDelegate(view.$$_getEntityViewClass()), context.getEntityManager(), (Object)view, viewTransition);
        }
    }

    public void addPrePersistListener(Class<?> entityViewClass, PrePersistListener<?> listener) {
        this.prePersistListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPrePersistEntityListener(Class<?> entityViewClass, PrePersistEntityListener<?, ?> listener) {
        this.prePersistEntityListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPostPersistListener(Class<?> entityViewClass, PostPersistListener<?> listener) {
        this.postPersistListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPostPersistEntityListener(Class<?> entityViewClass, PostPersistEntityListener<?, ?> listener) {
        this.postPersistEntityListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPreUpdateListener(Class<?> entityViewClass, PreUpdateListener<?> listener) {
        this.preUpdateListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPostUpdateListener(Class<?> entityViewClass, PostUpdateListener<?> listener) {
        this.postUpdateListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPreRemoveListener(Class<?> entityViewClass, PreRemoveListener<?> listener) {
        this.preRemoveListeners.add(new PreRemoveListenerEntry(entityViewClass, listener));
    }

    public void addPostRemoveListener(Class<?> entityViewClass, PostRemoveListener<?> listener) {
        this.postRemoveListeners.add(new ListenerEntry(entityViewClass, listener));
    }

    public void addPostCommitListener(Class<?> entityViewClass, PostCommitListener<?> listener, Set<ViewTransition> viewTransitions) {
        this.postCommitListeners.add(new ListenerTransitionEntry(entityViewClass, viewTransitions, listener));
    }

    public void addPostRollbackListener(Class<?> entityViewClass, PostRollbackListener<?> listener, Set<ViewTransition> viewTransitions) {
        this.postRollbackListeners.add(new ListenerTransitionEntry(entityViewClass, viewTransitions, listener));
    }

    public boolean hasPostCommitListeners() {
        return !this.postCommitListeners.isEmpty();
    }

    public boolean hasPostRollbackListeners() {
        return !this.postRollbackListeners.isEmpty();
    }

    public boolean hasRemoveListeners() {
        if (!this.preRemoveListeners.isEmpty() || !this.postRemoveListeners.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.postCommitListeners.size(); ++i) {
            if (!((ListenerTransitionEntry)this.postCommitListeners.get(i)).viewTransitions.contains(ViewTransition.REMOVE)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPossiblyCancellingRemoveListeners() {
        for (int i = 0; i < this.preRemoveListeners.size(); ++i) {
            if (!((PreRemoveListenerEntry)this.preRemoveListeners.get(i)).possiblyCancelling) continue;
            return true;
        }
        return false;
    }

    private static class ListenerEntry<T> {
        private final Class<?> entityViewClass;
        private final T listener;

        public ListenerEntry(Class<?> entityViewClass, T listener) {
            this.entityViewClass = entityViewClass;
            this.listener = listener;
        }
    }

    private static class PreRemoveListenerEntry<T> {
        private final Class<?> entityViewClass;
        private final boolean possiblyCancelling;
        private final PreRemoveListener<T> listener;

        public PreRemoveListenerEntry(Class<?> entityViewClass, PreRemoveListener<T> listener) {
            this.entityViewClass = entityViewClass;
            this.listener = listener;
            this.possiblyCancelling = listener instanceof ViewInstancePreRemoveListener ? ((ViewInstancePreRemoveListener)listener).isPossiblyCancelling() : !(listener instanceof ViewPreRemoveListenerImpl);
        }
    }

    private static class ListenerTransitionEntry<T> {
        private final Class<?> entityViewClass;
        private final Set<ViewTransition> viewTransitions;
        private final T listener;

        public ListenerTransitionEntry(Class<?> entityViewClass, Set<ViewTransition> viewTransitions, T listener) {
            this.entityViewClass = entityViewClass;
            this.viewTransitions = viewTransitions;
            this.listener = listener;
        }
    }
}

