/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.AllowUpdatableEntityViews;
import com.blazebit.persistence.view.AttributeFilter;
import com.blazebit.persistence.view.AttributeFilters;
import com.blazebit.persistence.view.IdMapping;
import com.blazebit.persistence.view.MappingIndex;
import com.blazebit.persistence.view.MappingInheritance;
import com.blazebit.persistence.view.MappingInheritanceMapKey;
import com.blazebit.persistence.view.MappingInheritanceSubtype;
import com.blazebit.persistence.view.MappingInverse;
import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.MappingSingular;
import com.blazebit.persistence.view.OptimisticLock;
import com.blazebit.persistence.view.UpdatableMapping;
import com.blazebit.persistence.view.impl.metamodel.AbstractAnnotationAttributeMappingReader;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MethodAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AnnotationMethodAttributeMappingReader
extends AbstractAnnotationAttributeMappingReader {
    public AnnotationMethodAttributeMappingReader(MetamodelBootContext context) {
        super(context);
    }

    public MethodAttributeMapping readMethodAttributeMapping(ViewMapping viewMapping, Annotation mapping, String attributeName, Method method, AnnotatedElement annotatedElement, int attributeIndex) {
        MappingInverse inverseMapping;
        UpdatableMapping updatableMapping;
        Class elementType;
        Class keyType;
        Type declaredElementType;
        Type declaredKeyType;
        Type declaredType;
        Class entityViewClass = viewMapping.getEntityViewClass();
        Type returnType = ReflectionUtils.resolve((Class)entityViewClass, (Type)method.getGenericReturnType());
        Class type = ReflectionUtils.resolveType((Class)entityViewClass, (Type)returnType);
        boolean forceSingular = annotatedElement.isAnnotationPresent(MappingSingular.class) || annotatedElement.isAnnotationPresent(MappingParameter.class);
        boolean isCollection = !forceSingular && (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type));
        PluralAttribute.ElementCollectionType elementCollectionType = null;
        if (isCollection) {
            Type[] typeArguments = ((ParameterizedType)returnType).getActualTypeArguments();
            declaredType = returnType;
            declaredKeyType = typeArguments.length > 1 ? typeArguments[0] : null;
            declaredElementType = typeArguments[typeArguments.length - 1];
            keyType = ReflectionUtils.resolveType((Class)entityViewClass, (Type)declaredKeyType);
            elementType = ReflectionUtils.resolveType((Class)entityViewClass, (Type)declaredElementType);
            if (elementType != null && Collection.class.isAssignableFrom(elementType)) {
                Type[] elementTypeArguments = ((ParameterizedType)declaredElementType).getActualTypeArguments();
                elementCollectionType = this.getElementCollectionType(elementType);
                declaredElementType = elementTypeArguments[0];
                elementType = ReflectionUtils.resolveType((Class)entityViewClass, (Type)declaredElementType);
            }
        } else {
            declaredType = returnType;
            declaredKeyType = null;
            declaredElementType = null;
            keyType = null;
            elementType = null;
        }
        Map<Class<?>, String> typeMappings = this.resolveInheritanceSubtypeMappings(annotatedElement, type);
        Map<Class<?>, String> keyTypeMappings = this.resolveKeyInheritanceSubtypeMappings(annotatedElement, keyType);
        Map<Class<?>, String> elementTypeMappings = this.resolveElementInheritanceSubtypeMappings(annotatedElement, elementType);
        MethodAttributeMapping attributeMapping = new MethodAttributeMapping(viewMapping, mapping, annotatedElement.getAnnotation(MappingIndex.class), this.context, attributeName, method, attributeIndex, isCollection, elementCollectionType, type, keyType, elementType, declaredType, declaredKeyType, declaredElementType, typeMappings, keyTypeMappings, elementTypeMappings);
        if (annotatedElement.isAnnotationPresent(IdMapping.class)) {
            viewMapping.setIdAttributeMapping(attributeMapping);
        }
        this.applyCommonMappings(attributeMapping, annotatedElement);
        HashMap attributeFilterProviders = new HashMap();
        AttributeFilter filterMapping = annotatedElement.getAnnotation(AttributeFilter.class);
        AttributeFilters filtersMapping = annotatedElement.getAnnotation(AttributeFilters.class);
        if (filterMapping != null) {
            attributeFilterProviders.put(filterMapping.name(), filterMapping.value());
        }
        if (filtersMapping != null) {
            for (AttributeFilter f : filtersMapping.value()) {
                String filterName = f.name();
                if (attributeFilterProviders.containsKey(filterName)) {
                    this.context.addError("Illegal duplicate filter name mapping '" + filterName + "' at " + attributeMapping.getErrorLocation());
                }
                attributeFilterProviders.put(filterName, f.value());
            }
        }
        attributeMapping.setAttributeFilterProviders(attributeFilterProviders);
        OptimisticLock optimisticLock = annotatedElement.getAnnotation(OptimisticLock.class);
        if (optimisticLock != null) {
            attributeMapping.setOptimisticLockProtected(!optimisticLock.exclude());
        }
        if ((updatableMapping = annotatedElement.getAnnotation(UpdatableMapping.class)) != null) {
            attributeMapping.setUpdatable(updatableMapping.updatable(), updatableMapping.orphanRemoval(), updatableMapping.cascade(), updatableMapping.subtypes(), updatableMapping.persistSubtypes(), updatableMapping.updateSubtypes());
        }
        if (annotatedElement.getAnnotation(AllowUpdatableEntityViews.class) != null) {
            attributeMapping.setDisallowOwnedUpdatableSubview(false);
        }
        if ((inverseMapping = annotatedElement.getAnnotation(MappingInverse.class)) != null) {
            attributeMapping.setInverseRemoveStrategy(inverseMapping.removeStrategy());
            String mappedBy = inverseMapping.mappedBy();
            if (!mappedBy.isEmpty()) {
                attributeMapping.setMappedBy(mappedBy);
            }
        }
        return attributeMapping;
    }

    private Map<Class<?>, String> resolveInheritanceSubtypeMappings(AnnotatedElement annotatedElement, Class<?> type) {
        MappingInheritance inheritance = annotatedElement.getAnnotation(MappingInheritance.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = type;
            }
            return this.resolveInheritanceSubtypeMappings(annotatedElement, baseType, inheritance.value());
        }
        return this.resolveInheritanceSubtypeMappings(annotatedElement, null, null);
    }

    private Map<Class<?>, String> resolveKeyInheritanceSubtypeMappings(AnnotatedElement annotatedElement, Class<?> keyType) {
        MappingInheritanceMapKey inheritance = annotatedElement.getAnnotation(MappingInheritanceMapKey.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = keyType;
            }
            return this.resolveInheritanceSubtypeMappings(annotatedElement, baseType, inheritance.value());
        }
        return null;
    }

    private Map<Class<?>, String> resolveElementInheritanceSubtypeMappings(AnnotatedElement annotatedElement, Class<?> elementType) {
        MappingInheritance inheritance = annotatedElement.getAnnotation(MappingInheritance.class);
        if (inheritance != null) {
            Class<?> baseType = null;
            if (!inheritance.onlySubtypes()) {
                baseType = elementType;
            }
            return this.resolveInheritanceSubtypeMappings(annotatedElement, baseType, inheritance.value());
        }
        return this.resolveInheritanceSubtypeMappings(annotatedElement, null, null);
    }

    private Map<Class<?>, String> resolveInheritanceSubtypeMappings(AnnotatedElement annotatedElement, Class<?> baseType, MappingInheritanceSubtype[] subtypes) {
        if (subtypes == null) {
            MappingInheritanceSubtype subtype = annotatedElement.getAnnotation(MappingInheritanceSubtype.class);
            if (subtype == null) {
                return null;
            }
            subtypes = new MappingInheritanceSubtype[]{subtype};
        }
        HashMap mappings = new HashMap(subtypes.length);
        if (baseType != null) {
            mappings.put(baseType, null);
        }
        for (MappingInheritanceSubtype subtype : subtypes) {
            String mapping = subtype.mapping();
            if (mapping.isEmpty()) {
                mapping = null;
            }
            mappings.put(subtype.value(), mapping);
        }
        return mappings;
    }
}

