/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.mapper;

import com.blazebit.persistence.CaseWhenStarterBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.SimpleCaseWhenStarterBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.AliasedTupleElementMapper;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.ConstrainedSelectBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.ConsumingTupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.ExpressionTupleElementMapper;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.SubqueryTupleElementMapper;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.TupleElementMapper;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.TupleElementMapperBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformatorFactory;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.spi.ViewJpqlMacro;
import com.blazebit.persistence.view.spi.type.BasicUserTypeStringSupport;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;

public class ConstrainedTupleElementMapper
implements AliasedTupleElementMapper {
    private final Map.Entry<String, TupleElementMapper>[] mappers;
    private final Map.Entry<String, TupleElementMapper>[] subqueryMappers;
    private final String attributePath;
    private final String alias;

    private ConstrainedTupleElementMapper(List<Map.Entry<String, TupleElementMapper>> mappers, List<Map.Entry<String, TupleElementMapper>> subqueryMappers, String attributePath, String alias) {
        this.mappers = mappers.toArray(new Map.Entry[mappers.size()]);
        this.subqueryMappers = subqueryMappers.toArray(new Map.Entry[subqueryMappers.size()]);
        this.attributePath = attributePath;
        this.alias = alias;
    }

    @Override
    public String getAttributePath() {
        return this.attributePath;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public BasicUserTypeStringSupport<Object> getBasicTypeStringSupport() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyMapping(SelectBuilder<?> queryBuilder, ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, ViewJpqlMacro viewJpqlMacro, EmbeddingViewJpqlMacro embeddingViewJpqlMacro, NavigableSet<String> fetches, boolean asString) {
        StringBuilder sb = new StringBuilder();
        FullQueryBuilder<?, ?> fullQueryBuilder = queryBuilder instanceof ConstrainedSelectBuilder ? ((ConstrainedSelectBuilder)queryBuilder).getQueryBuilder() : (FullQueryBuilder<?, ?>)queryBuilder;
        StringBuilderSelectBuilder selectBuilder = new StringBuilderSelectBuilder(sb, fullQueryBuilder);
        sb.append("CASE");
        for (Map.Entry<String, TupleElementMapper> entry : this.mappers) {
            if (entry.getKey() != null) {
                sb.append(" WHEN ");
                sb.append(entry.getKey());
                sb.append(" THEN ");
            } else {
                sb.append(" ELSE ");
            }
            entry.getValue().applyMapping(selectBuilder, parameterHolder, optionalParameters, viewJpqlMacro, embeddingViewJpqlMacro, fetches, asString);
        }
        sb.append(" END");
        if (this.subqueryMappers.length == 0) {
            if (this.alias != null) {
                queryBuilder.select(sb.toString(), this.alias);
            } else {
                queryBuilder.select(sb.toString());
            }
        } else {
            MultipleSubqueryInitiator initiator = this.alias != null ? queryBuilder.selectSubqueries(sb.toString(), this.alias) : queryBuilder.selectSubqueries(sb.toString());
            for (Map.Entry<String, TupleElementMapper> entry : this.subqueryMappers) {
                selectBuilder.setInitiator(initiator.with(entry.getKey()));
                entry.getValue().applyMapping(selectBuilder, parameterHolder, optionalParameters, viewJpqlMacro, embeddingViewJpqlMacro, fetches, asString);
            }
            initiator.end();
        }
    }

    public static void addMappers(int classMappingIndex, List<TupleElementMapper> mappingList, List<String> parameterMappingList, TupleTransformatorFactory tupleTransformatorFactory, List<ConstrainedTupleElementMapperBuilder> builders) {
        ArrayList subtypeMappersPerAttribute = new ArrayList();
        TreeSet<Integer> consumableIndexes = new TreeSet<Integer>();
        for (ConstrainedTupleElementMapperBuilder builderEntry : builders) {
            String constraint = builderEntry.constraint;
            TupleElementMapperBuilder tupleElementMapperBuilder = builderEntry.tupleElementMapperBuilder;
            tupleTransformatorFactory.add(consumableIndexes, classMappingIndex, builderEntry.subtypeIndexes, tupleElementMapperBuilder.getTupleTransformatorFactory());
            int attributeIndex = 0;
            for (TupleElementMapper mapper : tupleElementMapperBuilder.getMappers()) {
                ArrayList<AbstractMap.SimpleEntry<String, TupleElementMapper>> list;
                ArrayList<AbstractMap.SimpleEntry<String, TupleElementMapper>> arrayList = list = subtypeMappersPerAttribute.size() > attributeIndex ? (ArrayList<AbstractMap.SimpleEntry<String, TupleElementMapper>>)subtypeMappersPerAttribute.get(attributeIndex) : null;
                if (list == null) {
                    list = new ArrayList<AbstractMap.SimpleEntry<String, TupleElementMapper>>();
                    subtypeMappersPerAttribute.add(attributeIndex, list);
                }
                list.add(new AbstractMap.SimpleEntry<String, TupleElementMapper>(constraint, mapper));
                ++attributeIndex;
            }
        }
        consumableIndexes.remove(-1);
        int[] consumableIndexArray = new int[consumableIndexes.size()];
        int i = 0;
        Iterator iter = consumableIndexes.iterator();
        while (iter.hasNext()) {
            consumableIndexArray[i] = (Integer)iter.next();
            ++i;
        }
        tupleTransformatorFactory.add(new ConsumingTupleTransformer(consumableIndexArray));
        for (List list : subtypeMappersPerAttribute) {
            ArrayList<Map.Entry<String, TupleElementMapper>> mappers = new ArrayList<Map.Entry<String, TupleElementMapper>>();
            ArrayList<Map.Entry<String, TupleElementMapper>> subqueryMappers = new ArrayList<Map.Entry<String, TupleElementMapper>>();
            String attributePath = null;
            String alias = null;
            AbstractMap.SimpleEntry<String, TupleElementMapper> defaultEntry = null;
            for (Map.Entry subtypeEntry : list) {
                AbstractMap.SimpleEntry<String, TupleElementMapper> entry;
                String constraint = (String)subtypeEntry.getKey();
                TupleElementMapper mapper = (TupleElementMapper)subtypeEntry.getValue();
                if (mapper instanceof SubqueryTupleElementMapper) {
                    SubqueryTupleElementMapper subqueryMapper = (SubqueryTupleElementMapper)mapper;
                    String subqueryAlias = "_inheritance_subquery_" + subqueryMappers.size();
                    String subqueryExpression = subqueryMapper.getSubqueryAlias() == null ? subqueryAlias : subqueryMapper.getSubqueryExpression().replaceAll(subqueryMapper.getSubqueryAlias(), subqueryAlias);
                    entry = new AbstractMap.SimpleEntry<String, ExpressionTupleElementMapper>(constraint, new ExpressionTupleElementMapper(mapper.getBasicTypeStringSupport(), subqueryExpression, mapper.getAttributePath(), subqueryMapper.getViewPath(), subqueryMapper.getEmbeddingViewPath()));
                    subqueryMappers.add(new AbstractMap.SimpleEntry<String, TupleElementMapper>(subqueryAlias, mapper));
                } else {
                    entry = new AbstractMap.SimpleEntry<String, TupleElementMapper>(constraint, mapper);
                }
                if (constraint == null) {
                    defaultEntry = entry;
                } else {
                    mappers.add(entry);
                }
                if (!(mapper instanceof AliasedTupleElementMapper)) continue;
                attributePath = mapper.getAttributePath();
                alias = ((AliasedTupleElementMapper)mapper).getAlias();
            }
            if (defaultEntry != null) {
                mappers.add(defaultEntry);
            }
            mappingList.add(new ConstrainedTupleElementMapper(mappers, subqueryMappers, attributePath, alias));
            parameterMappingList.add(null);
        }
    }

    private static class StringBuilderSelectBuilder
    implements ConstrainedSelectBuilder {
        private final StringBuilder sb;
        private final FullQueryBuilder<?, ?> queryBuilder;
        private SubqueryInitiator<Object> initiator;

        public StringBuilderSelectBuilder(StringBuilder sb, FullQueryBuilder<?, ?> queryBuilder) {
            this.sb = sb;
            this.queryBuilder = queryBuilder;
        }

        @Override
        public FullQueryBuilder<?, ?> getQueryBuilder() {
            return this.queryBuilder;
        }

        public void setInitiator(SubqueryInitiator<?> initiator) {
            this.initiator = initiator;
        }

        public CaseWhenStarterBuilder<Object> selectCase() {
            throw new UnsupportedOperationException();
        }

        public CaseWhenStarterBuilder<Object> selectCase(String alias) {
            throw new UnsupportedOperationException();
        }

        public SimpleCaseWhenStarterBuilder<Object> selectSimpleCase(String caseOperand) {
            throw new UnsupportedOperationException();
        }

        public SimpleCaseWhenStarterBuilder<Object> selectSimpleCase(String caseOperand, String alias) {
            throw new UnsupportedOperationException();
        }

        public SubqueryInitiator<Object> selectSubquery() {
            return this.initiator;
        }

        public SubqueryInitiator<Object> selectSubquery(String alias) {
            return this.initiator;
        }

        public SubqueryInitiator<Object> selectSubquery(String subqueryAlias, String expression, String selectAlias) {
            return this.initiator;
        }

        public SubqueryInitiator<Object> selectSubquery(String subqueryAlias, String expression) {
            return this.initiator;
        }

        public MultipleSubqueryInitiator<Object> selectSubqueries(String expression, String selectAlias) {
            throw new UnsupportedOperationException();
        }

        public MultipleSubqueryInitiator<Object> selectSubqueries(String expression) {
            throw new UnsupportedOperationException();
        }

        public SubqueryBuilder<Object> selectSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
            throw new UnsupportedOperationException();
        }

        public SubqueryBuilder<Object> selectSubquery(String alias, FullQueryBuilder<?, ?> criteriaBuilder) {
            throw new UnsupportedOperationException();
        }

        public SubqueryBuilder<Object> selectSubquery(String subqueryAlias, String expression, String selectAlias, FullQueryBuilder<?, ?> criteriaBuilder) {
            throw new UnsupportedOperationException();
        }

        public SubqueryBuilder<Object> selectSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
            throw new UnsupportedOperationException();
        }

        public Object select(String expression) {
            this.sb.append(expression);
            return this;
        }

        public Object select(String expression, String alias) {
            this.sb.append(expression);
            return this;
        }
    }

    public static class ConstrainedTupleElementMapperBuilder {
        private final String constraint;
        private final int[] subtypeIndexes;
        private final TupleElementMapperBuilder tupleElementMapperBuilder;

        public ConstrainedTupleElementMapperBuilder(String constraint, int[] subtypeIndexes, TupleElementMapperBuilder tupleElementMapperBuilder) {
            this.constraint = constraint;
            this.subtypeIndexes = subtypeIndexes;
            this.tupleElementMapperBuilder = tupleElementMapperBuilder;
        }
    }
}

