/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.mapper;

import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.view.SubqueryProvider;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.SubqueryTupleElementMapper;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.TypeUtils;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.spi.ViewJpqlMacro;
import com.blazebit.persistence.view.spi.type.BasicUserTypeStringSupport;
import java.util.Map;
import java.util.NavigableSet;

public class ExpressionSubqueryTupleElementMapper
implements SubqueryTupleElementMapper {
    protected final BasicUserTypeStringSupport<Object> basicTypeStringSupport;
    protected final SubqueryProvider provider;
    protected final String subqueryExpression;
    protected final String subqueryAlias;
    protected final String attributePath;
    protected final String viewPath;
    protected final String embeddingViewPath;

    public ExpressionSubqueryTupleElementMapper(Type<?> type, SubqueryProvider provider, String subqueryExpression, String subqueryAlias, String attributePath, String viewPath, String embeddingViewPath) {
        this.basicTypeStringSupport = TypeUtils.forType(type);
        this.provider = provider;
        this.subqueryExpression = subqueryExpression;
        this.subqueryAlias = subqueryAlias;
        this.attributePath = attributePath;
        this.viewPath = viewPath;
        this.embeddingViewPath = embeddingViewPath;
    }

    @Override
    public void applyMapping(SelectBuilder<?> queryBuilder, ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, ViewJpqlMacro viewJpqlMacro, EmbeddingViewJpqlMacro embeddingViewJpqlMacro, NavigableSet<String> fetches, boolean asString) {
        String oldViewPath = viewJpqlMacro.getViewPath();
        String oldEmbeddingViewPath = embeddingViewJpqlMacro.getEmbeddingViewPath();
        viewJpqlMacro.setViewPath(null);
        embeddingViewJpqlMacro.setEmbeddingViewPath(this.viewPath);
        this.provider.createSubquery(this.subqueryInitiator(queryBuilder, viewJpqlMacro, embeddingViewJpqlMacro, asString));
        embeddingViewJpqlMacro.setEmbeddingViewPath(oldEmbeddingViewPath);
        viewJpqlMacro.setViewPath(oldViewPath);
    }

    protected SubqueryInitiator<?> subqueryInitiator(SelectBuilder<?> queryBuilder, ViewJpqlMacro viewJpqlMacro, EmbeddingViewJpqlMacro embeddingViewJpqlMacro, boolean asString) {
        String oldViewPath = viewJpqlMacro.getViewPath();
        String oldEmbeddingViewPath = embeddingViewJpqlMacro.getEmbeddingViewPath();
        viewJpqlMacro.setViewPath(this.viewPath);
        embeddingViewJpqlMacro.setEmbeddingViewPath(this.embeddingViewPath);
        SubqueryInitiator subqueryInitiator = asString && this.basicTypeStringSupport != null ? queryBuilder.selectSubquery(this.subqueryAlias, this.basicTypeStringSupport.toStringExpression(this.subqueryExpression)) : queryBuilder.selectSubquery(this.subqueryAlias, this.subqueryExpression);
        embeddingViewJpqlMacro.setEmbeddingViewPath(oldEmbeddingViewPath);
        viewJpqlMacro.setViewPath(oldViewPath);
        return subqueryInitiator;
    }

    @Override
    public String getAttributePath() {
        return this.attributePath;
    }

    @Override
    public String getViewPath() {
        return this.viewPath;
    }

    @Override
    public String getEmbeddingViewPath() {
        return this.embeddingViewPath;
    }

    @Override
    public String getSubqueryAlias() {
        return this.subqueryAlias;
    }

    @Override
    public String getSubqueryExpression() {
        return this.subqueryExpression;
    }

    @Override
    public BasicUserTypeStringSupport<Object> getBasicTypeStringSupport() {
        return this.basicTypeStringSupport;
    }
}

