/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.objectbuilder.ContainerAccumulator;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.IndexedTupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.NullListTupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformerFactory;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.Map;

public class IndexedTupleListTransformerFactory
implements TupleListTransformerFactory {
    protected final String attributePath;
    private final int startIndex;
    private final int[] parentIdPositions;
    private final int valueStartIndex;
    private final ContainerAccumulator<Object> containerAccumulator;
    private final boolean dirtyTracking;
    private final TypeConverter<Object, Object> keyConverter;
    private final TypeConverter<Object, Object> valueConverter;

    public IndexedTupleListTransformerFactory(String attributePath, int[] parentIdPositions, int startIndex, int valueStartIndex, ContainerAccumulator<?> containerAccumulator, boolean dirtyTracking, TypeConverter<Object, Object> keyConverter, TypeConverter<Object, Object> valueConverter) {
        this.attributePath = attributePath;
        this.startIndex = startIndex;
        this.parentIdPositions = parentIdPositions;
        this.valueStartIndex = valueStartIndex;
        this.containerAccumulator = containerAccumulator;
        this.dirtyTracking = dirtyTracking;
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
    }

    @Override
    public int getConsumableIndex() {
        return this.startIndex;
    }

    @Override
    public TupleListTransformer create(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, EntityViewConfiguration config) {
        if (!config.hasSubFetches(this.attributePath)) {
            return new NullListTupleTransformer(this.startIndex, this.valueStartIndex);
        }
        return new IndexedTupleListTransformer(this.parentIdPositions, this.startIndex, this.valueStartIndex, this.containerAccumulator, this.dirtyTracking, this.keyConverter, this.valueConverter);
    }
}

