/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.collection.CollectionInstantiatorImplementor;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.NonIndexedTupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.NullListTupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleListTransformerFactory;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.Map;

public class NonIndexedTupleListTransformerFactory
implements TupleListTransformerFactory {
    protected final String attributePath;
    private final int startIndex;
    private final int[] parentIdPositions;
    private final CollectionInstantiatorImplementor<?, ?> collectionInstantiator;
    private final boolean dirtyTracking;
    private final TypeConverter<Object, Object> elementConverter;

    public NonIndexedTupleListTransformerFactory(String attributePath, int[] parentIdPositions, int startIndex, CollectionInstantiatorImplementor<?, ?> collectionInstantiator, boolean dirtyTracking, TypeConverter<Object, Object> elementConverter) {
        this.attributePath = attributePath;
        this.startIndex = startIndex;
        this.parentIdPositions = parentIdPositions;
        this.collectionInstantiator = collectionInstantiator;
        this.dirtyTracking = dirtyTracking;
        this.elementConverter = elementConverter;
    }

    @Override
    public int getConsumableIndex() {
        return -1;
    }

    @Override
    public TupleListTransformer create(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, EntityViewConfiguration config) {
        if (!config.hasSubFetches(this.attributePath)) {
            return new NullListTupleTransformer(this.startIndex, this.startIndex);
        }
        return new NonIndexedTupleListTransformer(this.parentIdPositions, this.startIndex, this.collectionInstantiator, this.dirtyTracking, this.elementConverter);
    }
}

