/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.impl.type.AbstractLocalDateTimeTypeConverter;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.Date;

public abstract class DateToLocalDateTimeTypeConverter<T extends Date>
extends AbstractLocalDateTimeTypeConverter<T> {
    public static final DateToLocalDateTimeTypeConverter<Date> JAVA_UTIL_DATE_CONVERTER = new DateToLocalDateTimeTypeConverter<Date>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return Date.class;
        }

        public Date convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            return new Date(this.toEpochMillis(object));
        }
    };
    public static final DateToLocalDateTimeTypeConverter<Date> JAVA_SQL_TIMESTAMP_CONVERTER = new DateToLocalDateTimeTypeConverter<Date>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return Timestamp.class;
        }

        public Date convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            return new Timestamp(this.toEpochMillis(object));
        }
    };

    public Object convertToViewType(Date object) {
        if (object == null) {
            return null;
        }
        return this.ofEpochMilli(object.getTime());
    }
}

