/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.ImmutableBasicUserType;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;

public class LocalTimeBasicUserType
extends ImmutableBasicUserType<LocalTime> {
    public static final BasicUserType<LocalTime> INSTANCE = new LocalTimeBasicUserType();

    public LocalTime fromString(CharSequence sequence) {
        String input = sequence.toString();
        try {
            return LocalTime.parse(input);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid time format: " + input, e);
        }
    }

    public String toStringExpression(String expression) {
        return "TIME_ISO(" + expression + ")";
    }
}

