/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.MapAction;
import com.blazebit.persistence.view.impl.entity.MapViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MapPutAction<C extends Map<K, V>, K, V>
implements MapAction<C> {
    private final K key;
    private final V value;
    private final V removedValueInView;

    public MapPutAction(K key, V value, Map<K, V> delegate) {
        this.key = key;
        this.value = value;
        this.removedValueInView = delegate == null ? null : delegate.get(key);
    }

    public MapPutAction(K key, V value, V removedValueInView) {
        this.key = key;
        this.value = value;
        this.removedValueInView = removedValueInView;
    }

    @Override
    public void doAction(C map, UpdateContext context, MapViewToEntityMapper mapper, CollectionRemoveListener keyRemoveListener, CollectionRemoveListener valueRemoveListener) {
        V oldValue;
        if (mapper != null) {
            Object k = this.key;
            Object v = this.value;
            if (mapper.getKeyMapper() != null) {
                k = mapper.getKeyMapper().applyToEntity(context, null, k);
            }
            if (mapper.getValueMapper() != null) {
                v = mapper.getValueMapper().applyToEntity(context, null, v);
            }
            oldValue = map.put(k, v);
        } else {
            oldValue = map.put(this.key, this.value);
        }
        if (valueRemoveListener != null && oldValue != null) {
            valueRemoveListener.onCollectionRemove(context, this.removedValueInView);
        }
    }

    @Override
    public void undo(C map, Collection<?> removedKeys, Collection<?> addedKeys, Collection<?> removedElements, Collection<?> addedElements) {
        if (addedKeys.contains(this.key) || addedElements.contains(this.value)) {
            map.put(this.key, this.removedValueInView);
        }
    }

    @Override
    public Collection<Object> getAddedKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public Collection<Object> getRemovedKeys() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getAddedElements() {
        return Collections.singletonList(this.value);
    }

    @Override
    public Collection<Object> getRemovedElements() {
        if (this.removedValueInView != null) {
            return Collections.singleton(this.removedValueInView);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getAddedKeys(C collection) {
        return Collections.singleton(this.key);
    }

    @Override
    public Collection<Object> getRemovedKeys(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getAddedElements(C collection) {
        return Collections.singletonList(this.value);
    }

    @Override
    public Collection<Object> getRemovedElements(C collection) {
        Object oldValue = collection.get(this.key);
        if (oldValue != null && !oldValue.equals(this.value)) {
            return Collections.singleton(oldValue);
        }
        return Collections.emptyList();
    }

    @Override
    public MapAction<C> replaceObject(Object oldKey, Object oldValue, Object newKey, Object newValue) {
        if (oldKey == this.key || oldValue == this.value) {
            return new MapPutAction<C, Object, Object>(newKey, newValue, this.removedValueInView);
        }
        return null;
    }

    @Override
    public MapAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        if (objectMapping == null) {
            return this;
        }
        Object newKey = objectMapping.get(this.key);
        Object newValue = objectMapping.get(this.value);
        Object newRemovedValueInView = objectMapping.get(this.removedValueInView);
        if (newKey != null) {
            if (newValue != null) {
                if (newRemovedValueInView == null) {
                    return new MapPutAction<C, Object, Object>(newKey, newValue, this.removedValueInView);
                }
                return new MapPutAction<C, Object, Object>(newKey, newValue, newRemovedValueInView);
            }
            if (newRemovedValueInView != null) {
                return new MapPutAction<C, Object, Object>(newKey, this.value, newRemovedValueInView);
            }
            return new MapPutAction<C, Object, V>(newKey, this.value, this.removedValueInView);
        }
        if (newValue != null) {
            if (newRemovedValueInView == null) {
                return new MapPutAction<C, K, Object>(this.key, newValue, this.removedValueInView);
            }
            return new MapPutAction<C, K, Object>(this.key, newValue, newRemovedValueInView);
        }
        if (newRemovedValueInView != null) {
            return new MapPutAction<C, K, Object>(this.key, this.value, newRemovedValueInView);
        }
        return this;
    }

    @Override
    public void addAction(List<MapAction<C>> actions, Collection<Object> addedKeys, Collection<Object> removedKeys, Collection<Object> addedElements, Collection<Object> removedElements) {
        actions.add(this);
    }
}

