/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.view.impl.change.DirtyChecker;
import com.blazebit.persistence.view.impl.entity.AbstractEntityToEntityMapper;
import com.blazebit.persistence.view.impl.entity.EntityLoaderFetchGraphNode;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.BasicDirtyChecker;
import com.blazebit.persistence.view.impl.update.flush.TypeDescriptor;
import com.blazebit.persistence.view.impl.update.flush.UnmappedAttributeCascadeDeleter;
import com.blazebit.persistence.view.spi.type.BasicUserType;

public class DefaultEntityToEntityMapper
extends AbstractEntityToEntityMapper {
    private final boolean shouldPersist;
    private final boolean shouldMerge;
    private final BasicUserType<Object> basicUserType;
    private final BasicDirtyChecker<Object> dirtyChecker;

    public DefaultEntityToEntityMapper(boolean shouldPersist, boolean shouldMerge, Class<?> jpaType, BasicUserType<?> basicUserType, EntityLoaderFetchGraphNode<?> entityLoaderFetchGraphNode, UnmappedAttributeCascadeDeleter deleter) {
        super(entityLoaderFetchGraphNode, deleter);
        this.shouldPersist = shouldPersist;
        this.shouldMerge = shouldMerge;
        this.basicUserType = basicUserType;
        this.dirtyChecker = new BasicDirtyChecker(new TypeDescriptor(true, true, true, true, shouldMerge, shouldPersist, shouldPersist, shouldMerge, null, null, jpaType, null, basicUserType, null, null, null));
    }

    @Override
    public Object applyToEntity(UpdateContext context, Object entity, Object dirtyEntity) {
        if (dirtyEntity == null) {
            return null;
        }
        if (this.basicUserType.shouldPersist(dirtyEntity) && this.shouldPersist) {
            context.getEntityManager().persist(dirtyEntity);
        }
        Object id = this.entityLoaderFetchGraphNode.getEntityId(context, dirtyEntity);
        Object loadedEntity = this.entityLoaderFetchGraphNode.toEntity(context, null, id);
        if (this.shouldMerge) {
            return context.getEntityManager().merge(dirtyEntity);
        }
        return loadedEntity;
    }

    @Override
    public DirtyChecker<?> getDirtyChecker() {
        return this.dirtyChecker;
    }
}

