/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.parser.PathTargetResolvingExpressionVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.view.AttributeFilterProvider;
import com.blazebit.persistence.view.InverseRemoveStrategy;
import com.blazebit.persistence.view.LockMode;
import com.blazebit.persistence.view.impl.UpdatableExpressionVisitor;
import com.blazebit.persistence.view.impl.collection.ListFactory;
import com.blazebit.persistence.view.impl.collection.MapFactory;
import com.blazebit.persistence.view.impl.collection.PluralObjectFactory;
import com.blazebit.persistence.view.impl.collection.SetFactory;
import com.blazebit.persistence.view.impl.collection.SortedMapFactory;
import com.blazebit.persistence.view.impl.collection.SortedSetFactory;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.AttributeFilterMappingImpl;
import com.blazebit.persistence.view.impl.metamodel.BasicTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.MethodAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.SetView;
import com.blazebit.persistence.view.impl.metamodel.ViewTypeImpl;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.AttributeFilterMapping;
import com.blazebit.persistence.view.metamodel.BasicType;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.reflection.ReflectionUtils;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public abstract class AbstractMethodAttribute<X, Y>
extends AbstractAttribute<X, Y>
implements MethodAttribute<X, Y> {
    private final int attributeIndex;
    private final String name;
    private final Method javaMethod;
    private final Method setterMethod;
    private final Map<String, AttributeFilterMapping<X, ?>> filterMappings;

    protected AbstractMethodAttribute(ManagedViewTypeImplementor<X> viewType, MethodAttributeMapping mapping, int attributeIndex, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        super(viewType, mapping, context, embeddableMapping);
        this.attributeIndex = attributeIndex;
        this.name = mapping.getName();
        this.javaMethod = mapping.getMethod();
        this.setterMethod = mapping.getSetterMethod();
        if (mapping.getAttributeFilterProviders() == null) {
            this.filterMappings = Collections.emptyMap();
        } else {
            HashMap filterMappings = new HashMap();
            for (Map.Entry<String, Class<AttributeFilterProvider<?>>> entry : mapping.getAttributeFilterProviders().entrySet()) {
                filterMappings.put(entry.getKey(), new AttributeFilterMappingImpl(this, entry.getKey(), entry.getValue()));
            }
            this.filterMappings = Collections.unmodifiableMap(filterMappings);
        }
    }

    public Set<ManagedViewType<?>> getViewTypes() {
        com.blazebit.persistence.view.metamodel.Type<?> elementType = this.getElementType();
        if (elementType instanceof ManagedViewType) {
            Set<com.blazebit.persistence.view.metamodel.Type<?>> updateCascadeAllowedSubtypes = this.getUpdateCascadeAllowedSubtypes();
            Set persistCascadeAllowedSubtypes = this.getPersistCascadeAllowedSubtypes();
            Set readOnlyAllowedSubtypes = this.getReadOnlyAllowedSubtypes();
            HashSet viewTypes = new HashSet(persistCascadeAllowedSubtypes.size() + updateCascadeAllowedSubtypes.size() + readOnlyAllowedSubtypes.size() + 1);
            viewTypes.add((ManagedViewType)elementType);
            viewTypes.addAll(persistCascadeAllowedSubtypes);
            viewTypes.addAll(updateCascadeAllowedSubtypes);
            viewTypes.addAll(readOnlyAllowedSubtypes);
            return viewTypes;
        }
        return Collections.emptySet();
    }

    @Override
    protected Class<?>[] getTypeArguments() {
        return ReflectionUtils.getResolvedMethodReturnTypeArguments((Class)this.getDeclaringType().getJavaType(), (Method)this.getJavaMethod());
    }

    protected int determineDirtyStateIndex(int dirtyStateIndex) {
        if (this.isUpdatable() || this.isMutable() && (this.isPersistCascaded() || this.isUpdateCascaded())) {
            return dirtyStateIndex;
        }
        return -1;
    }

    protected Set<com.blazebit.persistence.view.metamodel.Type<?>> determinePersistSubtypeSet(com.blazebit.persistence.view.metamodel.Type<?> superType, Set<ManagedViewTypeImplementor<?>> subtypes1, Set<ManagedViewTypeImplementor<?>> subtypes2, MetamodelBuildingContext context) {
        Class superTypeClass = superType.getJavaType();
        HashSet set = new HashSet(subtypes1.size() + subtypes2.size());
        if (superType.getMappingType() == Type.MappingType.BASIC && context.getEntityMetamodel().getManagedType(superType.getJavaType()) != null || superType.getMappingType() != Type.MappingType.BASIC && ((ManagedViewType)superType).isCreatable()) {
            set.add(superType);
        }
        this.addToPersistSubtypeSet(set, superTypeClass, subtypes1, context, false);
        this.addToPersistSubtypeSet(set, superTypeClass, subtypes2, context, true);
        return Collections.unmodifiableSet(set);
    }

    protected Set<com.blazebit.persistence.view.metamodel.Type<?>> determineUpdateSubtypeSet(com.blazebit.persistence.view.metamodel.Type<?> superType, Set<ManagedViewTypeImplementor<?>> subtypes1, Set<ManagedViewTypeImplementor<?>> subtypes2, MetamodelBuildingContext context) {
        Class superTypeClass = superType.getJavaType();
        HashSet set = new HashSet(subtypes1.size() + subtypes2.size());
        if (superType.getMappingType() == Type.MappingType.BASIC && ((BasicType)superType).getUserType().isMutable() || superType.getMappingType() != Type.MappingType.BASIC && ((ManagedViewType)superType).isUpdatable()) {
            set.add(superType);
        }
        this.addToUpdateSubtypeSet(set, superTypeClass, subtypes1, context, false);
        this.addToUpdateSubtypeSet(set, superTypeClass, subtypes2, context, true);
        return Collections.unmodifiableSet(set);
    }

    private void addToPersistSubtypeSet(Set<com.blazebit.persistence.view.metamodel.Type<?>> set, Class<?> superType, Set<ManagedViewTypeImplementor<?>> subtypes, MetamodelBuildingContext context, boolean failIfNotCreatable) {
        for (ManagedViewTypeImplementor<?> type : subtypes) {
            Class c = type.getJavaType();
            if (c == superType) continue;
            if (!superType.isAssignableFrom(c)) {
                context.addError("Invalid subtype [" + c.getName() + "] in updatable mapping is not a subtype of declared attribute element type [" + superType.getName() + "] in the " + this.getLocation());
            }
            if (type.isCreatable()) {
                set.add((com.blazebit.persistence.view.metamodel.Type<?>)type);
                continue;
            }
            if (!failIfNotCreatable) continue;
            context.addError("Invalid subtype [" + c.getName() + "] in updatable mapping is not creatable in the " + this.getLocation());
        }
    }

    private void addToUpdateSubtypeSet(Set<com.blazebit.persistence.view.metamodel.Type<?>> set, Class<?> superType, Set<ManagedViewTypeImplementor<?>> subtypes, MetamodelBuildingContext context, boolean failIfNotUpdatable) {
        for (ManagedViewTypeImplementor<?> type : subtypes) {
            Class c = type.getJavaType();
            if (c == superType) continue;
            if (!superType.isAssignableFrom(c)) {
                context.addError("Invalid subtype [" + c.getName() + "] in updatable mapping is not a subtype of declared attribute element type [" + superType.getName() + "] in the " + this.getLocation());
            }
            if (type.isUpdatable()) {
                set.add((com.blazebit.persistence.view.metamodel.Type<?>)type);
                continue;
            }
            if (!failIfNotUpdatable) continue;
            context.addError("Invalid subtype [" + c.getName() + "] in updatable mapping is not updatable in the " + this.getLocation());
        }
    }

    protected boolean determineMutable(com.blazebit.persistence.view.metamodel.Type<?> elementType) {
        if (this.isUpdatable()) {
            return true;
        }
        if (elementType == null) {
            return false;
        }
        return this.isUpdateCascaded();
    }

    protected final PluralObjectFactory<? extends Collection<?>> createCollectionFactory(MetamodelBuildingContext context) {
        Class<?> pluralContainerType = this.getPluralContainerType(context);
        if (pluralContainerType == null) {
            return null;
        }
        if (SortedSet.class.isAssignableFrom(pluralContainerType)) {
            return SortedSetFactory.INSTANCE;
        }
        if (Set.class.isAssignableFrom(pluralContainerType)) {
            return SetFactory.INSTANCE;
        }
        return ListFactory.INSTANCE;
    }

    protected final PluralObjectFactory<? extends Map<?, ?>> createMapFactory(MetamodelBuildingContext context) {
        Class<?> pluralContainerType = this.getPluralContainerType(context);
        if (pluralContainerType == null) {
            return null;
        }
        if (SortedMap.class.isAssignableFrom(pluralContainerType)) {
            return SortedMapFactory.INSTANCE;
        }
        return MapFactory.INSTANCE;
    }

    private Class<?> getPluralContainerType(MetamodelBuildingContext context) {
        if (this.isMutable() && (this.declaringType.isUpdatable() || this.declaringType.isCreatable())) {
            if (this.mapping == null) {
                switch (this.getCollectionType()) {
                    case MAP: {
                        return Map.class;
                    }
                    case SET: {
                        return Set.class;
                    }
                    case LIST: {
                        return List.class;
                    }
                    case COLLECTION: {
                        return Collection.class;
                    }
                }
                return null;
            }
            if (this.mappingExpression != null) {
                UpdatableExpressionVisitor visitor = new UpdatableExpressionVisitor(context.getEntityMetamodel(), this.getDeclaringType().getEntityClass(), this.isUpdatable(), this.getDeclaringType().getEntityViewRootTypes());
                try {
                    this.mappingExpression.accept((Expression.Visitor)visitor);
                    Map<Attribute<?, ?>, Type<?>> possibleTargets = visitor.getPossibleTargets();
                    if (possibleTargets.size() > 1) {
                        context.addError("Multiple possible target type for the mapping in the " + this.getLocation() + ": " + possibleTargets);
                    }
                    return possibleTargets.values().iterator().next().getJavaType();
                }
                catch (IllegalArgumentException ex) {
                    context.addError("There is an error for the " + this.getLocation() + ": " + ex.getMessage());
                }
            }
        }
        return null;
    }

    protected boolean determineOptimisticLockProtected(MethodAttributeMapping mapping, MetamodelBuildingContext context, boolean mutable) {
        Boolean isOptimisticLockProtected = mapping.getOptimisticLockProtected();
        if (isOptimisticLockProtected != null) {
            if (!this.declaringType.isUpdatable() && !this.declaringType.isCreatable()) {
                context.addError("The usage of @OptimisticLock is only allowed on updatable or creatable entity view types! Invalid definition on the " + mapping.getErrorLocation());
            }
            return isOptimisticLockProtected;
        }
        if (!mutable) {
            return false;
        }
        if (this.declaringType instanceof ViewTypeImpl) {
            ViewTypeImpl owner = (ViewTypeImpl)this.declaringType;
            return owner.getLockMode() == LockMode.AUTO || owner.getLockMode() == LockMode.OPTIMISTIC;
        }
        return true;
    }

    @Override
    public void checkAttribute(ManagedType<?> managedType, MetamodelBuildingContext context) {
        String mappedBy;
        super.checkAttribute(managedType, context);
        if (this.isUpdatable() && this.declaringType.isUpdatable() && (mappedBy = this.getMappedBy()) != null && this.getInverseRemoveStrategy() == InverseRemoveStrategy.SET_NULL) {
            com.blazebit.persistence.view.metamodel.Type<?> elementType = this.getElementType();
            Object elementJpaType = elementType instanceof ManagedViewTypeImplementor ? ((ManagedViewTypeImplementor)elementType).getJpaManagedType() : ((BasicTypeImpl)elementType).getManagedType();
            Map<String, String> writableMappedByMappings = this.getWritableMappedByMappings();
            if (writableMappedByMappings == null) {
                Attribute attribute = elementJpaType.getAttribute(mappedBy);
                if (attribute instanceof SingularAttribute && !((SingularAttribute)attribute).isOptional()) {
                    context.addError("Illegal use of the remove strategy SET_NULL for non-nullable mapped by attribute '" + mappedBy + "' at " + this.getLocation() + " Use a different strategy via @MappingInverse(removeStrategy = InverseRemoveStrategy...)");
                }
            } else {
                PathTargetResolvingExpressionVisitor visitor = new PathTargetResolvingExpressionVisitor(context.getEntityMetamodel(), elementJpaType, null);
                for (String value : writableMappedByMappings.values()) {
                    Attribute attribute;
                    visitor.clear();
                    context.getTypeValidationExpressionFactory().createPathExpression(value).accept((Expression.Visitor)visitor);
                    Map possibleTargets = visitor.getPossibleTargets();
                    if (possibleTargets.size() > 1) {
                        context.addError("Multiple possible target type for the mapping in the " + this.getLocation() + ": " + possibleTargets);
                    }
                    if (!((attribute = (Attribute)possibleTargets.keySet().iterator().next()) instanceof SingularAttribute) || ((SingularAttribute)attribute).isOptional()) continue;
                    context.addError("Illegal use of the remove strategy SET_NULL for non-nullable mapped by attribute '" + mappedBy + "' because writable mapping '" + value + "' is non-optional at " + this.getLocation() + " Use a different strategy via @MappingInverse(removeStrategy = InverseRemoveStrategy...)");
                }
            }
        }
    }

    protected static String getAttributeName(Method getterOrSetter) {
        String name = getterOrSetter.getName();
        StringBuilder sb = new StringBuilder(name.length());
        int index = name.startsWith("is") ? 2 : 3;
        char firstAttributeNameChar = name.charAt(index);
        return sb.append(Character.toLowerCase(firstAttributeNameChar)).append(name, index + 1, name.length()).toString();
    }

    @Override
    public String getLocation() {
        return MethodAttributeMapping.getLocation(this.getName(), this.getJavaMethod());
    }

    public String getName() {
        return this.name;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    @Override
    public boolean needsDirtyTracker() {
        return this.isUpdatable() || this.isUpdateCascaded() && !this.getUpdateCascadeAllowedSubtypes().isEmpty();
    }

    @Override
    public boolean hasDirtyStateIndex() {
        return this.getDirtyStateIndex() != -1;
    }

    public Method getSetterMethod() {
        return this.setterMethod;
    }

    public int getAttributeIndex() {
        return this.attributeIndex;
    }

    public Y getValue(Object o) {
        try {
            return (Y)this.javaMethod.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't get value!", e);
        }
    }

    public abstract int getDirtyStateIndex();

    public boolean isUpdatableOnly() {
        return this.hasDirtyStateIndex() && !this.isPersistCascaded() && !this.isUpdateCascaded();
    }

    public abstract Map<String, String> getWritableMappedByMappings();

    protected final Set<Class<?>> createAllowedSubtypesSet() {
        Set readOnlyAllowedSubtypes = this.getReadOnlyAllowedSubtypes();
        Set persistAllowedSubtypes = this.getPersistCascadeAllowedSubtypes();
        Set<com.blazebit.persistence.view.metamodel.Type<?>> updateAllowedSubtypes = this.getUpdateCascadeAllowedSubtypes();
        HashSet<Class> allowedSubtypes = new HashSet<Class>(readOnlyAllowedSubtypes.size() + persistAllowedSubtypes.size() + updateAllowedSubtypes.size());
        for (com.blazebit.persistence.view.metamodel.Type type : readOnlyAllowedSubtypes) {
            allowedSubtypes.add(type.getJavaType());
        }
        for (com.blazebit.persistence.view.metamodel.Type type : persistAllowedSubtypes) {
            allowedSubtypes.add(type.getJavaType());
        }
        for (com.blazebit.persistence.view.metamodel.Type type : updateAllowedSubtypes) {
            allowedSubtypes.add(type.getJavaType());
        }
        return Collections.unmodifiableSet(allowedSubtypes);
    }

    protected final Set<Class<?>> createParentRequiringUpdateSubtypesSet() {
        Set readOnlyAllowedSubtypes = this.getReadOnlyAllowedSubtypes();
        Set persistAllowedSubtypes = this.getPersistCascadeAllowedSubtypes();
        Set<com.blazebit.persistence.view.metamodel.Type<?>> updateAllowedSubtypes = this.getUpdateCascadeAllowedSubtypes();
        HashSet<Class> allowedSubtypes = new HashSet<Class>(readOnlyAllowedSubtypes.size());
        for (com.blazebit.persistence.view.metamodel.Type t : readOnlyAllowedSubtypes) {
            ManagedViewTypeImplementor viewType;
            if (!(t instanceof ManagedViewTypeImplementor) || (!(viewType = (ManagedViewTypeImplementor)t).isUpdatable() || updateAllowedSubtypes.contains(t)) && (!viewType.isCreatable() || persistAllowedSubtypes.contains(t))) continue;
            allowedSubtypes.add(t.getJavaType());
        }
        return Collections.unmodifiableSet(allowedSubtypes);
    }

    protected final Set<Class<?>> createParentRequiringCreateSubtypesSet() {
        Set readOnlyAllowedSubtypes = this.getReadOnlyAllowedSubtypes();
        Set persistAllowedSubtypes = this.getPersistCascadeAllowedSubtypes();
        Set<com.blazebit.persistence.view.metamodel.Type<?>> updateAllowedSubtypes = this.getUpdateCascadeAllowedSubtypes();
        HashSet<Class> allowedSubtypes = new HashSet<Class>(readOnlyAllowedSubtypes.size());
        for (com.blazebit.persistence.view.metamodel.Type t : readOnlyAllowedSubtypes) {
            ManagedViewTypeImplementor viewType;
            if (!(t instanceof ManagedViewTypeImplementor) || (!(viewType = (ManagedViewTypeImplementor)t).isUpdatable() || updateAllowedSubtypes.contains(t)) && (!viewType.isCreatable() || persistAllowedSubtypes.contains(t))) continue;
            allowedSubtypes.add(t.getJavaType());
        }
        return Collections.unmodifiableSet(allowedSubtypes);
    }

    @Override
    public boolean isOptimizeCollectionActionsEnabled() {
        return this.isOptimisticLockProtected();
    }

    public Attribute.MemberType getMemberType() {
        return Attribute.MemberType.METHOD;
    }

    public AttributeFilterMapping<X, ?> getFilter(String filterName) {
        return this.filterMappings.get(filterName);
    }

    public Set<AttributeFilterMapping<X, ?>> getFilters() {
        return new SetView(this.filterMappings.values());
    }

    public static String extractAttributeName(Class<?> viewType, Method m, MetamodelBootContext context) {
        if (ReflectionUtils.isSetter((Method)m)) {
            String attributeName = AbstractMethodAttribute.getAttributeName(m);
            Method getter = ReflectionUtils.getGetter(viewType, (String)attributeName);
            if (getter == null) {
                context.addError("The setter '" + m.getName() + "' from the entity view '" + viewType.getName() + "' has no corresponding getter!");
                return null;
            }
            if (ReflectionUtils.getResolvedMethodParameterTypes(viewType, (Method)m)[0] != ReflectionUtils.getResolvedMethodReturnType(viewType, (Method)getter)) {
                context.addError("The setter '" + m.getName() + "' of the class '" + viewType.getName() + "' must accept an argument of the same type as it's corresponding getter returns!");
                return null;
            }
            for (Annotation annotation : m.getAnnotations()) {
                if (!annotation.annotationType().getPackage().getName().startsWith("com.blazebit.persistence.view")) continue;
                context.addError("The setter '" + m.getName() + "' of the class '" + viewType.getName() + "' has entity view annotations, but these annotations must be on the getter only!");
                break;
            }
            return null;
        }
        if (!ReflectionUtils.isGetter((Method)m)) {
            context.addError("The given method '" + m.getName() + "' from the entity view '" + viewType.getName() + "' is no bean style getter or setter!");
            return null;
        }
        String attributeName = AbstractMethodAttribute.getAttributeName(m);
        if (m.getExceptionTypes().length > 0) {
            context.addError("The given method '" + m.getName() + "' from the entity view '" + viewType.getName() + "' must not throw an exception!");
            return null;
        }
        return attributeName;
    }
}

