/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.BasicTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.FlatViewTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.SetView;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewTypeImpl;
import com.blazebit.persistence.view.impl.type.BasicUserTypeRegistry;
import com.blazebit.persistence.view.metamodel.FlatViewType;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MappingConstructor;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.ParameterAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewMetamodel;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.reflection.ReflectionUtils;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class ViewMetamodelImpl
implements ViewMetamodel {
    private final EntityMetamodel metamodel;
    private final BasicUserTypeRegistry basicUserTypeRegistry;
    private final Map<Class<?>, ViewTypeImpl<?>> views;
    private final Map<Class<?>, FlatViewTypeImpl<?>> flatViews;
    private final Map<Class<?>, ManagedViewTypeImplementor<?>> managedViews;

    public ViewMetamodelImpl(EntityMetamodel entityMetamodel, MetamodelBuildingContext context, Map<Class<?>, Object> typeTestValues, boolean validateManagedTypes, boolean validateExpressions) {
        this.metamodel = entityMetamodel;
        this.basicUserTypeRegistry = context.getBasicUserTypeRegistry();
        Collection<ViewMapping> viewMappings = context.getViewMappings();
        HashMap<Class, ViewTypeImpl> views = new HashMap<Class, ViewTypeImpl>(viewMappings.size());
        HashMap<Class, FlatViewTypeImpl> flatViews = new HashMap<Class, FlatViewTypeImpl>(viewMappings.size());
        HashMap managedViews = new HashMap(viewMappings.size());
        for (ViewMapping viewMapping : viewMappings) {
            viewMapping.initializeViewMappings(context, null);
        }
        Set<Class<?>> dependencies = Collections.newSetFromMap(new IdentityHashMap(viewMappings.size()));
        for (ViewMapping viewMapping : viewMappings) {
            viewMapping.validateDependencies(context, dependencies, null, null, true);
        }
        for (ViewMapping viewMapping : viewMappings) {
            ManagedViewTypeImplementor<?> managedViewTypeImplementor = context.getManagedViewType(viewMapping, null);
            managedViews.put(viewMapping.getEntityViewClass(), managedViewTypeImplementor);
            if (managedViewTypeImplementor instanceof FlatViewType) {
                flatViews.put(viewMapping.getEntityViewClass(), (FlatViewTypeImpl)managedViewTypeImplementor);
                continue;
            }
            views.put(viewMapping.getEntityViewClass(), (ViewTypeImpl)managedViewTypeImplementor);
        }
        this.views = Collections.unmodifiableMap(views);
        this.flatViews = Collections.unmodifiableMap(flatViews);
        this.managedViews = Collections.unmodifiableMap(managedViews);
        if (!context.hasErrors() && validateExpressions) {
            ArrayList arrayList = new ArrayList();
            for (ManagedViewTypeImplementor managedViewTypeImplementor : managedViews.values()) {
                managedViewTypeImplementor.checkAttributes(context);
                managedViewTypeImplementor.checkNestedAttributes(arrayList, context, false);
            }
        }
        if (validateManagedTypes) {
            HashSet hashSet = new HashSet();
            for (ManagedViewTypeImplementor managedViewTypeImplementor : managedViews.values()) {
                for (MethodAttribute attribute : managedViewTypeImplementor.getAttributes()) {
                    Type<?> keyType = ((AbstractAttribute)attribute).getKeyType();
                    Type<?> elementType = ((AbstractAttribute)attribute).getElementType();
                    if (keyType instanceof BasicTypeImpl) {
                        hashSet.add(((BasicTypeImpl)keyType).getManagedType());
                    }
                    if (!(elementType instanceof BasicTypeImpl)) continue;
                    hashSet.add(((BasicTypeImpl)elementType).getManagedType());
                }
                for (MappingConstructor constructor : managedViewTypeImplementor.getConstructors()) {
                    for (ParameterAttribute parameterAttribute : constructor.getParameterAttributes()) {
                        Type<?> keyType = ((AbstractAttribute)parameterAttribute).getKeyType();
                        Type<?> elementType = ((AbstractAttribute)parameterAttribute).getElementType();
                        if (keyType instanceof BasicTypeImpl) {
                            hashSet.add(((BasicTypeImpl)keyType).getManagedType());
                        }
                        if (!(elementType instanceof BasicTypeImpl)) continue;
                        hashSet.add(((BasicTypeImpl)elementType).getManagedType());
                    }
                }
            }
            hashSet.remove(null);
            for (ManagedType managedType : hashSet) {
                Class javaType = managedType.getJavaType();
                if ((javaType.getModifiers() & 0x400) != 0) continue;
                try {
                    Constructor declaredConstructor = javaType.getDeclaredConstructor(new Class[0]);
                    declaredConstructor.setAccessible(true);
                    Object instance1 = declaredConstructor.newInstance(new Object[0]);
                    Object instance2 = declaredConstructor.newInstance(new Object[0]);
                    Object instance3 = declaredConstructor.newInstance(new Object[0]);
                    String error = this.createValue(managedType, instance2, typeTestValues, true);
                    if (error != null) {
                        context.addError(error);
                        continue;
                    }
                    error = this.createValue(managedType, instance3, typeTestValues, true);
                    if (error != null) {
                        context.addError(error);
                        continue;
                    }
                    String infoText = "Equals/hashCode should be based on the identifier for entities and the full state for embeddables. Consider using a subview instead or add a proper equals/hashCode implementation!";
                    if (!instance2.equals(instance3)) {
                        context.addError("The use of the JPA managed type '" + javaType.getName() + "' in entity views is problematic because two instances with the same state are not equal. " + infoText);
                    }
                    if (instance2.hashCode() != instance3.hashCode()) {
                        context.addError("The use of the JPA managed type '" + javaType.getName() + "' in entity views is problematic because two instances with the same state do not have the same hashCode. " + infoText);
                    }
                    if (!instance1.equals(instance3)) continue;
                    context.addError("The use of the JPA managed type '" + javaType.getName() + "' in entity views is problematic because two instances with different state are equal. " + infoText);
                }
                catch (Exception ex) {
                    StringWriter sw = new StringWriter();
                    sw.append("Error during validation of equals/hashCode implementations of managed type [").append(javaType.getName()).append("]. If you think this is due to a bug, please report the problem and temporarily deactivate the type checking by setting the property '").append("com.blazebit.persistence.view.managed_type_validation_disabled").append("' to true.\n");
                    ex.printStackTrace(new PrintWriter(sw));
                    context.addError(sw.toString());
                }
            }
        }
    }

    private String createValue(ManagedType<?> jpaManagedType, Object instance, Map<Class<?>, Object> typeTestValues, boolean root) throws Exception {
        boolean setAnyValue = false;
        Class javaType = jpaManagedType.getJavaType();
        if ((javaType.getModifiers() & 0x400) == 0) {
            Set jpaAttributes;
            if (JpaMetamodelUtils.isIdentifiable(jpaManagedType) && !root) {
                jpaAttributes = JpaMetamodelUtils.getIdAttributes((IdentifiableType)((IdentifiableType)jpaManagedType));
                if (jpaAttributes.isEmpty()) {
                    jpaAttributes = jpaManagedType.getSingularAttributes();
                }
            } else {
                jpaAttributes = jpaManagedType.getSingularAttributes();
            }
            for (SingularAttribute jpaAttribute : jpaAttributes) {
                jakarta.persistence.metamodel.Type type = jpaAttribute.getType();
                Class attributeType = JpaMetamodelUtils.resolveFieldClass((Class)javaType, (Attribute)jpaAttribute);
                Object value = typeTestValues.get(attributeType);
                if (value == null) {
                    if (type.getPersistenceType() == Type.PersistenceType.BASIC) {
                        if (!attributeType.isEnum()) continue;
                        value = attributeType.getEnumConstants()[0];
                    } else {
                        if ((attributeType.getModifiers() & 0x400) != 0) continue;
                        Constructor typeConstructor = attributeType.getDeclaredConstructor(new Class[0]);
                        typeConstructor.setAccessible(true);
                        value = typeConstructor.newInstance(new Object[0]);
                        String error = this.createValue(this.metamodel.getManagedType(attributeType), value, typeTestValues, false);
                        if (error != null) {
                            return error;
                        }
                    }
                }
                this.setAttribute(instance, jpaAttribute, value);
                setAnyValue = true;
            }
            if (!setAnyValue) {
                HashSet<String> typeNames = new HashSet<String>(jpaAttributes.size());
                for (SingularAttribute jpaAttribute : jpaAttributes) {
                    typeNames.add(jpaAttribute.getType().getJavaType().getName());
                }
                return "Can't check if the equals/hashCode implementation of the JPA managed type '" + javaType.getName() + "' which is used in entity views is problematic because there are no type test values registered in the EntityViewConfiguration for any of the types: " + typeNames;
            }
        }
        return null;
    }

    private void setAttribute(Object instance, SingularAttribute<?, ?> jpaAttribute, Object value) throws Exception {
        if (jpaAttribute.getJavaMember() instanceof Method) {
            Method setter = ReflectionUtils.getSetter(instance.getClass(), (String)jpaAttribute.getName());
            setter.setAccessible(true);
            setter.invoke(instance, value);
        } else if (jpaAttribute.getJavaMember() instanceof Field) {
            Field field = (Field)jpaAttribute.getJavaMember();
            field.setAccessible(true);
            field.set(instance, value);
        } else {
            throw new IllegalArgumentException("Unsupported JPA member type: " + jpaAttribute.getJavaMember());
        }
    }

    public EntityMetamodel getEntityMetamodel() {
        return this.metamodel;
    }

    public <X> BasicUserType<X> getBasicUserType(Class<X> clazz) {
        return this.basicUserTypeRegistry.getBasicUserType(clazz);
    }

    public <X> ViewTypeImpl<X> view(Class<X> clazz) {
        return this.views.get(clazz);
    }

    public <X> ViewTypeImpl<X> viewOrError(Class<X> clazz) {
        ViewTypeImpl<?> view = this.views.get(clazz);
        if (view == null) {
            throw new IllegalArgumentException("The class " + (clazz == null ? "null" : clazz.getName()) + " is not a view type!");
        }
        return view;
    }

    public Set<ViewType<?>> getViews() {
        return new SetView(this.views.values());
    }

    public Collection<ViewTypeImpl<?>> views() {
        return this.views.values();
    }

    public <X> ManagedViewTypeImplementor<X> managedView(Class<X> clazz) {
        return this.managedViews.get(clazz);
    }

    public <X> ManagedViewTypeImplementor<X> managedViewOrError(Class<X> clazz) {
        ManagedViewTypeImplementor<?> view = this.managedViews.get(clazz);
        if (view == null) {
            throw new IllegalArgumentException("The class " + (clazz == null ? "null" : clazz.getName()) + " is not a managed view type!");
        }
        return view;
    }

    public Set<ManagedViewType<?>> getManagedViews() {
        return new SetView(this.managedViews.values());
    }

    public <X> FlatViewTypeImpl<X> flatView(Class<X> clazz) {
        return this.flatViews.get(clazz);
    }

    public <X> FlatViewTypeImpl<X> flatViewOrError(Class<X> clazz) {
        FlatViewTypeImpl<?> view = this.flatViews.get(clazz);
        if (view == null) {
            throw new IllegalArgumentException("The class " + (clazz == null ? "null" : clazz.getName()) + " is not a flat view type!");
        }
        return view;
    }

    public Set<FlatViewType<?>> getFlatViews() {
        return new SetView(this.flatViews.values());
    }
}

