/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.objectbuilder.ContainerAccumulator;
import com.blazebit.persistence.view.impl.objectbuilder.ViewTypeObjectBuilderTemplate;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.TupleElementMapper;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.TupleTransformator;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.MultisetTupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.NullTupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformerFactory;
import com.blazebit.persistence.view.spi.type.BasicUserTypeStringSupport;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.util.ArrayList;
import java.util.Map;

public class CollectionMultisetTupleTransformerFactory
implements TupleTransformerFactory {
    private final int startIndex;
    private final String mapping;
    private final String attributePath;
    private final String multisetResultAlias;
    private final BasicUserTypeStringSupport<Object>[] fieldConverters;
    private final TypeConverter<Object, Object> elementConverter;
    private final ContainerAccumulator<Object> containerAccumulator;
    private final boolean dirtyTracking;
    private final ViewTypeObjectBuilderTemplate<Object[]> template;
    private final ViewTypeObjectBuilderTemplate<Object[]> indexTemplate;
    private final TupleTransformerFactory subviewTupleTransformerFactory;
    private final TupleTransformerFactory indexSubviewTupleTransformerFactory;
    private final BasicUserTypeStringSupport<?> valueBasicTypeSupport;
    private final BasicUserTypeStringSupport<?> indexBasicTypeSupport;
    private final boolean hasSelectOrSubselectFetchedAttributes;

    public CollectionMultisetTupleTransformerFactory(int startIndex, String mapping, String attributePath, String multisetResultAlias, TypeConverter<Object, Object> elementConverter, ContainerAccumulator<?> containerAccumulator, boolean dirtyTracking, ViewTypeObjectBuilderTemplate<Object[]> template, ViewTypeObjectBuilderTemplate<Object[]> indexTemplate, boolean hasSelectOrSubselectFetchedAttributes, TupleTransformerFactory subviewTupleTransformerFactory, TupleTransformerFactory indexSubviewTupleTransformerFactory, BasicUserTypeStringSupport<?> valueBasicTypeSupport, BasicUserTypeStringSupport<?> indexBasicTypeSupport) {
        int i;
        TupleElementMapper[] mappers;
        this.startIndex = startIndex;
        this.mapping = mapping;
        this.attributePath = attributePath;
        this.multisetResultAlias = multisetResultAlias;
        this.elementConverter = elementConverter;
        this.containerAccumulator = containerAccumulator;
        this.dirtyTracking = dirtyTracking;
        this.template = template;
        this.indexTemplate = indexTemplate;
        this.hasSelectOrSubselectFetchedAttributes = hasSelectOrSubselectFetchedAttributes;
        this.indexSubviewTupleTransformerFactory = indexSubviewTupleTransformerFactory;
        this.valueBasicTypeSupport = valueBasicTypeSupport;
        this.indexBasicTypeSupport = indexBasicTypeSupport;
        ArrayList fieldConverters = new ArrayList();
        if (template == null) {
            fieldConverters.add(valueBasicTypeSupport);
        } else {
            mappers = template.getMappers();
            for (i = 0; i < mappers.length; ++i) {
                fieldConverters.add(mappers[i].getBasicTypeStringSupport());
            }
        }
        if (indexTemplate == null) {
            if (indexBasicTypeSupport != null) {
                fieldConverters.add(indexBasicTypeSupport);
            }
        } else {
            mappers = indexTemplate.getMappers();
            for (i = 0; i < mappers.length; ++i) {
                fieldConverters.add(mappers[i].getBasicTypeStringSupport());
            }
        }
        this.fieldConverters = fieldConverters.toArray(new BasicUserTypeStringSupport[0]);
        this.subviewTupleTransformerFactory = subviewTupleTransformerFactory;
    }

    @Override
    public int getConsumeStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getConsumeEndIndex() {
        return this.startIndex + 1;
    }

    @Override
    public TupleTransformer create(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, EntityViewConfiguration entityViewConfiguration) {
        if (!entityViewConfiguration.hasSubFetches(this.attributePath)) {
            return NullTupleTransformer.forMultiset(this.startIndex);
        }
        if (this.mapping != null) {
            if (parameterHolder instanceof FullQueryBuilder) {
                FullQueryBuilder queryBuilder = parameterHolder;
                if (this.hasSelectOrSubselectFetchedAttributes) {
                    queryBuilder = queryBuilder.copyCriteriaBuilder(Object[].class, false);
                    queryBuilder.innerJoin(this.mapping, this.multisetResultAlias);
                    parameterHolder = queryBuilder;
                }
                entityViewConfiguration = entityViewConfiguration.forSubview(queryBuilder, this.attributePath, entityViewConfiguration.getEmbeddingViewJpqlMacro());
            } else {
                throw new UnsupportedOperationException("Converting views with correlated attributes isn't supported!");
            }
        }
        TupleTransformator tupleTransformator = this.template == null ? null : this.template.getTupleTransformatorFactory().create((ParameterHolder<?>)parameterHolder, optionalParameters, entityViewConfiguration);
        TupleTransformer subviewTupleTransformer = this.subviewTupleTransformerFactory == null ? null : this.subviewTupleTransformerFactory.create((ParameterHolder<?>)parameterHolder, optionalParameters, entityViewConfiguration);
        TupleTransformer indexSubviewTupleTransformer = this.indexSubviewTupleTransformerFactory == null ? null : this.indexSubviewTupleTransformerFactory.create((ParameterHolder<?>)parameterHolder, optionalParameters, entityViewConfiguration);
        return new MultisetTupleTransformer(this.startIndex, this.hasSelectOrSubselectFetchedAttributes, tupleTransformator, subviewTupleTransformer, indexSubviewTupleTransformer, this.indexBasicTypeSupport == null ? -1 : this.fieldConverters.length - 1, this.fieldConverters, this.elementConverter, this.containerAccumulator, this.dirtyTracking);
    }
}

