/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.tx;

import com.blazebit.exception.ExceptionUtils;
import com.blazebit.persistence.view.impl.tx.JtaResources;
import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionSupport;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;

public class JtaTransactionSynchronizationStrategy
implements TransactionAccess,
TransactionSupport {
    private final TransactionManager tm;
    private final TransactionSynchronizationRegistry synchronizationRegistry;

    public JtaTransactionSynchronizationStrategy(JtaResources jtaResources) {
        this(jtaResources.getTransactionManager(), jtaResources.getTransactionSynchronizationRegistry());
    }

    public JtaTransactionSynchronizationStrategy(TransactionManager tm, TransactionSynchronizationRegistry synchronizationRegistry) {
        this.tm = tm;
        this.synchronizationRegistry = synchronizationRegistry;
    }

    public boolean isActive() {
        return this.synchronizationRegistry.getTransactionStatus() == 0;
    }

    public Object getTransaction() {
        try {
            return this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void markRollbackOnly() {
        this.synchronizationRegistry.setRollbackOnly();
    }

    public void registerSynchronization(Synchronization synchronization) {
        this.synchronizationRegistry.registerInterposedSynchronization(synchronization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transactional(Runnable runnable) {
        tx = null;
        suspendedTx = null;
        exception = null;
        try {
            status = this.tm.getStatus();
            if (status == 6) {
                this.tm.begin();
                tx = this.tm.getTransaction();
            } else {
                suspendedTx = this.tm.suspend();
                this.tm.begin();
                tx = this.tm.getTransaction();
            }
            runnable.run();
            return;
        }
        catch (Throwable t) {
            exception = t;
            if (tx != null) {
                try {
                    tx.setRollbackOnly();
                }
                catch (Throwable e) {
                    t.addSuppressed(e);
                }
            }
            ExceptionUtils.doThrow((Throwable)t);
            return;
        }
        finally {
            try {
                if (tx != null) {
                    switch (tx.getStatus()) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            this.tm.commit();
                            ** break;
lbl32:
                            // 1 sources

                            break;
                        }
                        default: {
                            this.tm.rollback();
                            break;
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (exception != null) {
                    exception.addSuppressed(e);
                }
            }
            finally {
                block54: {
                    if (suspendedTx != null) {
                        try {
                            this.tm.resume(suspendedTx);
                        }
                        catch (Throwable e) {
                            if (exception == null) break block54;
                            exception.addSuppressed(e);
                        }
                    }
                }
            }
        }
    }
}

