/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.VersionBasicUserType;
import java.sql.Timestamp;
import java.util.Date;

public class DateBasicUserType
implements BasicUserType<Date>,
VersionBasicUserType<Date> {
    public static final BasicUserType<?> INSTANCE = new DateBasicUserType();

    public boolean isMutable() {
        return true;
    }

    public boolean supportsDirtyChecking() {
        return false;
    }

    public boolean supportsDirtyTracking() {
        return false;
    }

    public boolean supportsDeepEqualChecking() {
        return true;
    }

    public boolean supportsDeepCloning() {
        return true;
    }

    public boolean isEqual(Date initial, Date current) {
        return initial.getTime() == current.getTime();
    }

    public boolean isDeepEqual(Date initial, Date current) {
        return initial.getTime() == current.getTime();
    }

    public int hashCode(Date object) {
        return object.hashCode();
    }

    public boolean shouldPersist(Date entity) {
        return false;
    }

    public String[] getDirtyProperties(Date entity) {
        return DIRTY_MARKER;
    }

    public Date deepClone(Date object) {
        return (Date)object.clone();
    }

    public Date nextValue(Date current) {
        return new Date();
    }

    public Date fromString(CharSequence sequence) {
        return new Date(this.parseTimestamp(sequence).getTime());
    }

    protected Timestamp parseTimestamp(CharSequence sequence) {
        int i;
        char[] chars = new char[29];
        int length = sequence.length();
        for (i = 0; i < length; ++i) {
            chars[i] = sequence.charAt(i);
        }
        for (i = length; i < chars.length; ++i) {
            chars[i] = 48;
        }
        chars[10] = 32;
        return Timestamp.valueOf(new String(chars));
    }

    public String toStringExpression(String expression) {
        return "TIMESTAMP_ISO(" + expression + ")";
    }
}

