/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.impl.type.AbstractLocalDateTypeConverter;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.Date;

public abstract class DateToLocalDateTypeConverter<T extends Date>
extends AbstractLocalDateTypeConverter<T> {
    public static final DateToLocalDateTypeConverter<Date> JAVA_UTIL_DATE_CONVERTER = new DateToLocalDateTypeConverter<Date>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return Date.class;
        }

        public Date convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            return new Date(this.toEpochDay(object) * 86400000L);
        }
    };
    public static final DateToLocalDateTypeConverter<Date> JAVA_SQL_DATE_CONVERTER = new DateToLocalDateTypeConverter<Date>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return java.sql.Date.class;
        }

        public Date convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            return new java.sql.Date(this.toEpochDay(object) * 86400000L);
        }
    };
    public static final DateToLocalDateTypeConverter<Date> JAVA_SQL_TIMESTAMP_CONVERTER = new DateToLocalDateTypeConverter<Date>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return Timestamp.class;
        }

        public Date convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            return new Timestamp(this.toEpochDay(object) * 86400000L);
        }
    };

    public Object convertToViewType(Date object) {
        if (object == null) {
            return null;
        }
        return this.ofEpochDay(object.getTime() / 86400000L);
    }
}

