/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.ImmutableBasicUserType;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;

public class OffsetTimeBasicUserType
extends ImmutableBasicUserType<OffsetTime> {
    public static final BasicUserType<OffsetTime> INSTANCE = new OffsetTimeBasicUserType();

    public OffsetTime fromString(CharSequence sequence) {
        String input = sequence.toString();
        try {
            return LocalTime.parse(input).atOffset(ZoneOffset.UTC);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Invalid time format: " + input, e);
        }
    }

    public String toStringExpression(String expression) {
        return "TIME_ISO(" + expression + ")";
    }
}

