/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.accessor;

import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.AttributePath;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.DirtyStateViewAttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.EntityFieldAttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.EntityMethodAttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.InitialValueAttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.NestedAttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.ViewAttributeAccessor;
import com.blazebit.persistence.view.impl.accessor.ViewIdAttributeAccessor;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.BasicTypeImpl;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.reflection.ReflectionUtils;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Accessors {
    private Accessors() {
    }

    public static AttributeAccessor forViewId(EntityViewManagerImpl evm, ViewType<?> viewType, boolean readonly) {
        return new ViewIdAttributeAccessor(evm, viewType, readonly);
    }

    public static AttributeAccessor forSubviewAssociationId(EntityViewManagerImpl evm, ManagedViewType<?> viewType, String attributeMapping, boolean readonly) {
        AttributeAccessor viewIdAccessor;
        if (attributeMapping != null && (viewIdAccessor = Accessors.forEntityMappingAsViewAccessor(evm, viewType, attributeMapping, readonly)) != null) {
            return viewIdAccessor;
        }
        return Accessors.forViewId(evm, (ViewType)viewType, readonly);
    }

    public static AttributeAccessor forViewAttribute(EntityViewManagerImpl evm, MethodAttribute<?, ?> attribute, boolean readonly) {
        if (readonly || ((AbstractMethodAttribute)attribute).getDirtyStateIndex() == -1) {
            return new ViewAttributeAccessor(evm, attribute, readonly);
        }
        return Accessors.forMutableViewAttribute(evm, attribute);
    }

    public static InitialValueAttributeAccessor forMutableViewAttribute(EntityViewManagerImpl evm, MethodAttribute<?, ?> attribute) {
        return new DirtyStateViewAttributeAccessor(evm, attribute);
    }

    public static AttributeAccessor forViewAttributePath(EntityViewManagerImpl evm, ManagedViewType<?> viewType, String attributePath, boolean readonly) {
        if (attributePath.indexOf(46) == -1) {
            return Accessors.forViewAttribute(evm, viewType.getAttribute(attributePath), readonly);
        }
        String[] attributeParts = attributePath.split("\\.");
        ArrayList<AttributeAccessor> mappers = new ArrayList<AttributeAccessor>(attributeParts.length);
        for (int i = 0; i < attributeParts.length - 1; ++i) {
            MethodAttribute attribute = viewType.getAttribute(attributeParts[i]);
            mappers.add(Accessors.forViewAttribute(evm, attribute, readonly));
            viewType = (ManagedViewType)((SingularAttribute)attribute).getType();
        }
        mappers.add(Accessors.forViewAttribute(evm, viewType.getAttribute(attributeParts[attributeParts.length - 1]), readonly));
        return new NestedAttributeAccessor(mappers);
    }

    public static AttributeAccessor forEntityMappingAsViewAccessor(EntityViewManagerImpl evm, ManagedViewType<?> viewType, String attributePath, boolean readonly) {
        if (attributePath.indexOf(46) == -1) {
            MethodAttribute foundAttribute = null;
            for (MethodAttribute methodAttribute : viewType.getAttributes()) {
                String attributeMapping;
                if (!(methodAttribute instanceof MappingAttribute) || !(attributeMapping = ((MappingAttribute)methodAttribute).getMapping()).equals(attributePath)) continue;
                if (foundAttribute != null) {
                    throw new IllegalArgumentException("Could not determine view attribute accessor because of ambiguous attributes: [" + foundAttribute + ", " + methodAttribute + "]");
                }
                foundAttribute = methodAttribute;
            }
            if (foundAttribute == null) {
                return null;
            }
            return Accessors.forViewAttribute(evm, foundAttribute, readonly);
        }
        String[] attributeParts = attributePath.split("\\.");
        AttributeEntry root = new AttributeEntry(viewType, attributeParts[0]);
        for (int i = 1; i < attributeParts.length; ++i) {
            root.addAttributeMapping(attributeParts[i]);
        }
        return root.getAttributeAccessor(attributeParts.length, evm, readonly);
    }

    private static AttributeAccessor forEntityAttribute(EntityViewManagerImpl evm, Class<?> entityClass, Attribute<?, ?> attribute) {
        return Accessors.forEntityAttribute(evm, entityClass, attribute, null);
    }

    public static AttributeAccessor forEntityMapping(EntityViewManagerImpl evm, MethodAttribute<?, ?> attribute) {
        if (((AbstractMethodAttribute)attribute).getUpdateMappableAttribute() != null) {
            return Accessors.forEntityMapping(evm, attribute.getDeclaringType().getEntityClass(), ((MappingAttribute)attribute).getMapping());
        }
        return null;
    }

    public static AttributeAccessor forEntityMapping(EntityViewManagerImpl evm, Class<?> entityClass, String mapping) {
        if (mapping == null || mapping.isEmpty()) {
            return new NestedAttributeAccessor(Collections.emptyList());
        }
        EntityMetamodel entityMetamodel = evm.getMetamodel().getEntityMetamodel();
        AttributePath path = evm.getJpaProvider().getJpaMetamodelAccessor().getBasicAttributePath((Metamodel)entityMetamodel, entityMetamodel.managedType(entityClass), mapping);
        List attributes = path.getAttributes();
        if (attributes.size() == 1) {
            return Accessors.forEntityAttribute(evm, entityClass, (Attribute)attributes.get(0), null);
        }
        ArrayList<AttributeAccessor> mappers = new ArrayList<AttributeAccessor>(attributes.size());
        Class targetClass = entityClass;
        for (int i = 0; i < attributes.size() - 1; ++i) {
            Attribute attribute = (Attribute)attributes.get(i);
            Class attributeClass = JpaMetamodelUtils.resolveFieldClass(targetClass, (Attribute)attribute);
            mappers.add(Accessors.forEntityAttribute(evm, targetClass, attribute, attributeClass));
            targetClass = attributeClass;
        }
        mappers.add(Accessors.forEntityAttribute(evm, targetClass, (Attribute)attributes.get(attributes.size() - 1), null));
        return new NestedAttributeAccessor(mappers);
    }

    private static AttributeAccessor forEntityAttribute(EntityViewManagerImpl evm, Class<?> entityClass, Attribute<?, ?> attribute, Class<?> targetType) {
        Member member = attribute.getJavaMember();
        if (member instanceof Field) {
            return new EntityFieldAttributeAccessor(evm.getJpaProvider(), (Field)member, targetType);
        }
        if (member instanceof Method) {
            Method getter = ReflectionUtils.getGetter(entityClass, (String)attribute.getName());
            Method setter = ReflectionUtils.getSetter(entityClass, (String)attribute.getName());
            return new EntityMethodAttributeAccessor(getter, setter, targetType);
        }
        throw new IllegalArgumentException("Unsupported java member for id attribute: " + member);
    }

    private static final class AttributeEntry {
        private final AttributeEntry parent;
        private final MethodAttribute<?, ?> attribute;
        private final ManagedType<?> jpaAttributeOwner;
        private final Attribute<?, ?> jpaAttribute;
        private final List<AttributeEntry> possibleAttributes = new ArrayList<AttributeEntry>(1);
        private List<List<AttributeEntry>> currentPossibleAttributes;

        public AttributeEntry(ManagedViewType<?> viewType, String mapping) {
            for (MethodAttribute methodAttribute : viewType.getAttributes()) {
                String attributeMapping;
                if (!(methodAttribute instanceof MappingAttribute) || !(attributeMapping = ((MappingAttribute)methodAttribute).getMapping()).equals(mapping)) continue;
                this.possibleAttributes.add(new AttributeEntry(this, methodAttribute));
            }
            this.currentPossibleAttributes = new ArrayList<List<AttributeEntry>>();
            this.currentPossibleAttributes.add(this.possibleAttributes);
            this.parent = null;
            this.attribute = null;
            this.jpaAttributeOwner = null;
            this.jpaAttribute = null;
        }

        private AttributeEntry(AttributeEntry parent, MethodAttribute<?, ?> attribute) {
            this.parent = parent;
            this.attribute = attribute;
            this.jpaAttributeOwner = null;
            this.jpaAttribute = null;
        }

        public AttributeEntry(AttributeEntry parent, ManagedType<?> jpaAttributeOwner, Attribute<?, ?> jpaAttribute) {
            this.parent = parent;
            this.attribute = null;
            this.jpaAttributeOwner = jpaAttributeOwner;
            this.jpaAttribute = jpaAttribute;
        }

        final void removeIfEmpty() {
            if (this.possibleAttributes.isEmpty() && this.parent != null) {
                this.parent.possibleAttributes.remove(this);
                this.parent.removeIfEmpty();
            }
        }

        final void collectAttributeAccessors(List<AttributeAccessor> accessors, EntityViewManagerImpl evm, boolean readonly) {
            if (this.attribute != null) {
                accessors.add(Accessors.forViewAttribute(evm, this.attribute, readonly));
            }
            if (this.jpaAttribute != null) {
                accessors.add(Accessors.forEntityAttribute(evm, this.jpaAttributeOwner.getJavaType(), this.jpaAttribute));
            }
            if (!this.possibleAttributes.isEmpty()) {
                if (this.possibleAttributes.size() > 1) {
                    throw new IllegalArgumentException("Could not determine view attribute accessor because of ambiguous attributes: " + this.possibleAttributes);
                }
                this.possibleAttributes.get(0).collectAttributeAccessors(accessors, evm, readonly);
            }
        }

        public final void addAttributeMapping(String mapping) {
            ArrayList<List<AttributeEntry>> newCurrentPossibleAttributes = new ArrayList<List<AttributeEntry>>();
            for (List<AttributeEntry> possibleAttributesCandidate : this.currentPossibleAttributes) {
                for (AttributeEntry attributeEntry : possibleAttributesCandidate) {
                    Type type = ((SingularAttribute)attributeEntry.attribute).getType();
                    if (type instanceof ManagedViewType) {
                        ManagedViewType viewType = (ManagedViewType)type;
                        for (MethodAttribute methodAttribute : viewType.getAttributes()) {
                            String attributeMapping;
                            if (!(methodAttribute instanceof MappingAttribute) || !(attributeMapping = ((MappingAttribute)methodAttribute).getMapping()).equals(mapping)) continue;
                            attributeEntry.possibleAttributes.add(new AttributeEntry(this, methodAttribute));
                            newCurrentPossibleAttributes.add(attributeEntry.possibleAttributes);
                        }
                        attributeEntry.removeIfEmpty();
                        continue;
                    }
                    ManagedType managedType = ((BasicTypeImpl)type).getManagedType();
                    for (Attribute attribute : managedType.getAttributes()) {
                        if (!attribute.getName().equals(mapping)) continue;
                        attributeEntry.possibleAttributes.add(new AttributeEntry(this, managedType, attribute));
                        newCurrentPossibleAttributes.add(attributeEntry.possibleAttributes);
                    }
                    attributeEntry.removeIfEmpty();
                }
            }
            this.currentPossibleAttributes = newCurrentPossibleAttributes;
        }

        public final AttributeAccessor getAttributeAccessor(int attributeParts, EntityViewManagerImpl evm, boolean readonly) {
            ArrayList<AttributeAccessor> mappers = new ArrayList<AttributeAccessor>(attributeParts);
            this.collectAttributeAccessors(mappers, evm, readonly);
            return new NestedAttributeAccessor(mappers);
        }
    }
}

