/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.MapAction;
import com.blazebit.persistence.view.impl.collection.RecordingUtils;
import com.blazebit.persistence.view.impl.entity.MapViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapPutAllAction<C extends Map<K, V>, K, V>
implements MapAction<C> {
    private final Map<? extends K, ? extends V> elements;
    private final Map<K, V> removedObjectsInView;

    public MapPutAllAction(Map<? extends K, ? extends V> map, Map<K, V> delegate) {
        this.elements = new LinkedHashMap<K, V>(map);
        this.removedObjectsInView = new LinkedHashMap(this.elements.size());
        for (Map.Entry<K, V> entry : this.elements.entrySet()) {
            V oldValue = delegate.get(entry.getKey());
            if (oldValue == null) continue;
            this.removedObjectsInView.put(entry.getKey(), oldValue);
        }
    }

    private MapPutAllAction(Map<? extends K, ? extends V> map, Map<K, V> removedObjectsInView, boolean a) {
        this.elements = map;
        this.removedObjectsInView = removedObjectsInView;
    }

    @Override
    public void doAction(C map, UpdateContext context, MapViewToEntityMapper mapper, CollectionRemoveListener keyRemoveListener, CollectionRemoveListener valueRemoveListener) {
        if (mapper != null) {
            ViewToEntityMapper keyMapper = mapper.getKeyMapper();
            ViewToEntityMapper valueMapper = mapper.getValueMapper();
            if (this.elements.size() == 1) {
                Map.Entry<K, V> e = this.elements.entrySet().iterator().next();
                Object k = e.getKey();
                Object v = e.getValue();
                if (keyMapper != null) {
                    k = keyMapper.applyToEntity(context, null, k);
                }
                if (valueMapper != null) {
                    v = valueMapper.applyToEntity(context, null, v);
                }
                V oldValue = map.put(k, v);
                if (valueRemoveListener != null && oldValue != null) {
                    valueRemoveListener.onCollectionRemove(context, this.removedObjectsInView.get(e.getKey()));
                }
            } else if (keyMapper == null) {
                if (valueMapper == null) {
                    for (Map.Entry<K, V> e : this.elements.entrySet()) {
                        V oldValue = map.put(e.getKey(), e.getValue());
                        if (valueRemoveListener == null || oldValue == null) continue;
                        valueRemoveListener.onCollectionRemove(context, this.removedObjectsInView.get(e.getKey()));
                    }
                } else {
                    ArrayList<Object> entities = new ArrayList<Object>(this.elements.size());
                    entities.addAll(this.elements.values());
                    valueMapper.applyAll(context, entities);
                    int i = 0;
                    for (Map.Entry<K, V> e : this.elements.entrySet()) {
                        Object value = entities.get(i++);
                        Object oldValue = map.put(e.getKey(), value);
                        if (valueRemoveListener == null || oldValue == null) continue;
                        valueRemoveListener.onCollectionRemove(context, this.removedObjectsInView.get(e.getKey()));
                    }
                }
            } else if (valueMapper == null) {
                ArrayList<Object> entities = new ArrayList<Object>(this.elements.size());
                entities.addAll(this.elements.keySet());
                keyMapper.applyAll(context, entities);
                int i = 0;
                for (Map.Entry<K, V> e : this.elements.entrySet()) {
                    Object key = entities.get(i++);
                    V oldValue = map.put(key, e.getValue());
                    if (valueRemoveListener == null || oldValue == null) continue;
                    valueRemoveListener.onCollectionRemove(context, this.removedObjectsInView.get(e.getKey()));
                }
            } else {
                ArrayList<Object> keyEntities = new ArrayList<Object>(this.elements.size());
                ArrayList<Object> valueEntities = new ArrayList<Object>(this.elements.size());
                for (Map.Entry<K, V> entry : this.elements.entrySet()) {
                    keyEntities.add(entry.getKey());
                    valueEntities.add(entry.getValue());
                }
                keyMapper.applyAll(context, keyEntities);
                valueMapper.applyAll(context, valueEntities);
                int i = 0;
                for (Map.Entry<K, V> e : this.elements.entrySet()) {
                    Object key = keyEntities.get(i);
                    Object value = valueEntities.get(i++);
                    Object oldValue = map.put(key, value);
                    if (valueRemoveListener == null || oldValue == null) continue;
                    valueRemoveListener.onCollectionRemove(context, this.removedObjectsInView.get(e.getKey()));
                }
            }
        } else if (map.size() > 0 && valueRemoveListener != null) {
            for (Map.Entry<K, V> e : this.elements.entrySet()) {
                V oldValue = map.put(e.getKey(), e.getValue());
                if (oldValue == null) continue;
                valueRemoveListener.onCollectionRemove(context, this.removedObjectsInView.get(e.getKey()));
            }
        } else {
            map.putAll(this.elements);
        }
    }

    @Override
    public void undo(C map, Collection<?> removedKeys, Collection<?> addedKeys, Collection<?> removedElements, Collection<?> addedElements) {
        for (Map.Entry<K, V> entry : this.removedObjectsInView.entrySet()) {
            if (!addedKeys.contains(entry.getKey()) && !addedElements.contains(entry.getValue())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Collection<Object> getAddedKeys() {
        return this.elements.keySet();
    }

    @Override
    public Collection<Object> getRemovedKeys() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getAddedElements() {
        return this.elements.values();
    }

    @Override
    public Collection<Object> getRemovedElements() {
        return this.removedObjectsInView.values();
    }

    @Override
    public Collection<Object> getAddedKeys(C collection) {
        return this.elements.keySet();
    }

    @Override
    public Collection<Object> getRemovedKeys(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getAddedElements(C collection) {
        return this.elements.values();
    }

    @Override
    public Collection<Object> getRemovedElements(C collection) {
        ArrayList<Object> removedObjects = new ArrayList<Object>();
        for (Map.Entry<K, V> entry : this.elements.entrySet()) {
            Object oldValue = collection.get(entry.getKey());
            if (oldValue == null || oldValue.equals(entry.getValue())) continue;
            removedObjects.add(oldValue);
        }
        return removedObjects;
    }

    @Override
    public MapAction<C> replaceObject(Object oldKey, Object oldValue, Object newKey, Object newValue) {
        Map<Object, Object> newElements = RecordingUtils.replaceElements(this.elements, oldKey, oldValue, newKey, newValue);
        if (newElements == null) {
            return null;
        }
        return new MapPutAllAction<C, Object, Object>(newElements, this.removedObjectsInView, false);
    }

    @Override
    public MapAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        if (objectMapping == null) {
            return this;
        }
        Map<Object, Object> newElements = RecordingUtils.replaceElements(this.elements, objectMapping);
        Map<Object, Object> newRemovedObjectsInView = RecordingUtils.replaceElements(this.removedObjectsInView, objectMapping);
        if (newElements != null) {
            if (newRemovedObjectsInView == null) {
                return new MapPutAllAction<C, Object, Object>(newElements, this.removedObjectsInView, false);
            }
            return new MapPutAllAction<C, Object, Object>(newElements, newRemovedObjectsInView, false);
        }
        if (newRemovedObjectsInView != null) {
            return new MapPutAllAction<C, Object, Object>(this.elements, newRemovedObjectsInView, false);
        }
        return this;
    }

    @Override
    public void addAction(List<MapAction<C>> actions, Collection<Object> addedKeys, Collection<Object> removedKeys, Collection<Object> addedElements, Collection<Object> removedElements) {
        actions.add(this);
    }
}

