/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.EntityLoader;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.update.EntityViewUpdater;
import com.blazebit.persistence.view.impl.update.EntityViewUpdaterImpl;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.FetchGraphNode;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import com.blazebit.persistence.view.spi.type.MutableStateTrackable;
import jakarta.persistence.Query;
import jakarta.persistence.metamodel.EntityType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractViewToEntityMapper
implements ViewToEntityMapper {
    protected final String attributeLocation;
    protected final Set<Class<?>> viewTypeClasses;
    protected final boolean isEmbeddable;
    protected final EntityViewUpdater defaultUpdater;
    protected final Map<Class<?>, EntityViewUpdater> persistUpdater;
    protected final Map<Class<?>, EntityViewUpdater> updateUpdater;
    protected final Map<Class<?>, EntityViewUpdater> removeUpdater;
    protected final EntityLoader entityLoader;
    protected final AttributeAccessor viewIdAccessor;
    protected final AttributeAccessor entityIdAccessor;
    protected final boolean persistAllowed;

    public AbstractViewToEntityMapper(String attributeLocation, EntityViewManagerImpl evm, Class<?> viewTypeClass, Set<Type<?>> readOnlyAllowedSubtypes, Set<Type<?>> persistAllowedSubtypes, Set<Type<?>> updateAllowedSubtypes, EntityLoader entityLoader, AttributeAccessor viewIdAccessor, AttributeAccessor entityIdAccessor, boolean persistAllowed, EntityViewUpdaterImpl owner, String ownerMapping, Map<Object, EntityViewUpdaterImpl> localCache) {
        EntityViewUpdaterImpl updater;
        this.attributeLocation = attributeLocation;
        ManagedViewType managedViewTypeImplementor = evm.getMetamodel().managedView(viewTypeClass);
        this.isEmbeddable = !(managedViewTypeImplementor.getJpaManagedType() instanceof EntityType);
        HashMap<Class, EntityViewUpdaterImpl> persistUpdater = new HashMap<Class, EntityViewUpdaterImpl>();
        HashMap<Class, EntityViewUpdaterImpl> updateUpdater = new HashMap<Class, EntityViewUpdaterImpl>();
        HashMap<Class, EntityViewUpdater> removeUpdater = new HashMap<Class, EntityViewUpdater>();
        for (Type<?> t : persistAllowedSubtypes) {
            updater = evm.getUpdater(localCache, (ManagedViewTypeImplementor)t, (ManagedViewTypeImplementor<?>)managedViewTypeImplementor, owner, ownerMapping);
            persistUpdater.put(t.getJavaType(), updater);
            removeUpdater.put(t.getJavaType(), updater);
        }
        for (Type<?> t : updateAllowedSubtypes) {
            updater = evm.getUpdater(localCache, (ManagedViewTypeImplementor)t, null, owner, ownerMapping);
            updateUpdater.put(t.getJavaType(), updater);
            removeUpdater.put(t.getJavaType(), updater);
        }
        this.defaultUpdater = evm.getUpdater(localCache, (ManagedViewTypeImplementor<?>)managedViewTypeImplementor, null, owner, ownerMapping);
        removeUpdater.put(viewTypeClass, this.defaultUpdater);
        HashSet<Class> viewTypeClasses = new HashSet<Class>();
        for (Type<?> readOnlyType : readOnlyAllowedSubtypes) {
            viewTypeClasses.add(readOnlyType.getJavaType());
            if (!(readOnlyType instanceof ManagedViewTypeImplementor)) continue;
            if (this.isEmbeddable) {
                removeUpdater.put(readOnlyType.getJavaType(), evm.getUpdater(localCache, (ManagedViewTypeImplementor)readOnlyType, null, owner, ownerMapping));
                continue;
            }
            removeUpdater.put(readOnlyType.getJavaType(), evm.getUpdater(localCache, (ManagedViewTypeImplementor)readOnlyType, null, null, null));
        }
        this.viewTypeClasses = Collections.unmodifiableSet(viewTypeClasses);
        this.persistUpdater = Collections.unmodifiableMap(persistUpdater);
        this.updateUpdater = Collections.unmodifiableMap(updateUpdater);
        this.removeUpdater = Collections.unmodifiableMap(removeUpdater);
        this.entityLoader = entityLoader;
        this.viewIdAccessor = viewIdAccessor;
        this.entityIdAccessor = entityIdAccessor;
        this.persistAllowed = persistAllowed;
    }

    @Override
    public FetchGraphNode<?> getFullGraphNode() {
        return this.defaultUpdater.getFullGraphNode();
    }

    @Override
    public DirtyAttributeFlusher<?, ?, ?> getIdFlusher() {
        return this.defaultUpdater.getIdFlusher();
    }

    @Override
    public EntityViewUpdater getUpdater(Object current) {
        Class<?> viewTypeClass = this.getViewTypeClass(current);
        Object id = null;
        if (this.viewIdAccessor != null) {
            id = this.viewIdAccessor.getValue(current);
        }
        if (this.shouldPersist(current, id)) {
            if (!this.persistAllowed) {
                return null;
            }
            return this.persistUpdater.get(viewTypeClass);
        }
        return this.defaultUpdater;
    }

    @Override
    public void remove(UpdateContext context, Object element) {
        Class<?> viewTypeClass = this.getViewTypeClass(element);
        EntityViewUpdater updater = this.persistUpdater.get(viewTypeClass);
        if (updater == null && (updater = this.updateUpdater.get(viewTypeClass)) == null) {
            updater = this.removeUpdater.get(viewTypeClass);
        }
        updater.remove(context, (EntityViewProxy)element);
    }

    @Override
    public boolean cascades(Object element) {
        Class<?> viewTypeClass = this.getViewTypeClass(element);
        return this.persistUpdater.containsKey(viewTypeClass) || this.updateUpdater.containsKey(viewTypeClass);
    }

    @Override
    public void removeById(UpdateContext context, Object id) {
        this.defaultUpdater.remove(context, id);
    }

    @Override
    public Object applyToEntity(UpdateContext context, Object entity, Object element) {
        return null;
    }

    @Override
    public void applyAll(UpdateContext context, List<Object> elements) {
        for (int i = 0; i < elements.size(); ++i) {
            elements.set(i, this.applyToEntity(context, null, elements.get(i)));
        }
    }

    @Override
    public void loadEntities(UpdateContext context, List<Object> views) {
        ArrayList<Object> ids = new ArrayList<Object>(views.size());
        if (this.viewIdAccessor == null) {
            for (int i = 0; i < views.size(); ++i) {
                views.set(i, this.loadEntity(context, views.get(i)));
            }
        } else {
            for (int i = 0; i < views.size(); ++i) {
                ids.add(this.viewIdAccessor.getValue(views.get(i)));
            }
            this.entityLoader.toEntities(context, views, ids);
        }
    }

    @Override
    public Object loadEntity(UpdateContext context, Object view) {
        if (view == null) {
            return null;
        }
        Object id = null;
        if (this.viewIdAccessor != null) {
            id = this.viewIdAccessor.getValue(view);
        }
        return this.entityLoader.toEntity(context, view, id);
    }

    @Override
    public <T extends DirtyAttributeFlusher<T, E, V>, E, V> DirtyAttributeFlusher<T, E, V> getNestedDirtyFlusher(UpdateContext context, MutableStateTrackable current, DirtyAttributeFlusher<T, E, V> fullFlusher) {
        if (current == null) {
            return fullFlusher;
        }
        Object id = null;
        if (this.viewIdAccessor != null) {
            id = this.viewIdAccessor.getValue(current);
        }
        Class<?> viewTypeClass = this.getViewTypeClass(current);
        if (this.shouldPersist(current, id)) {
            if (!this.persistAllowed) {
                return null;
            }
            EntityViewUpdater updater = this.persistUpdater.get(viewTypeClass);
            if (updater == null) {
                return null;
            }
            return updater.getNestedDirtyFlusher(context, current, fullFlusher);
        }
        return null;
    }

    @Override
    public Query createUpdateQuery(UpdateContext context, MutableStateTrackable view, DirtyAttributeFlusher<?, ?, ?> nestedGraphNode) {
        return null;
    }

    protected Object persist(UpdateContext context, Object entity, Object view) {
        if (this.persistAllowed) {
            Class<?> viewTypeClass = this.getViewTypeClass(view);
            EntityViewUpdater updater = this.persistUpdater.get(viewTypeClass);
            if (updater == null) {
                throw new IllegalStateException("Couldn't persist object for " + this.attributeLocation + ". Expected subviews of the types " + AbstractViewToEntityMapper.names(this.persistUpdater.keySet()) + " but got: " + view);
            }
            if (entity != null) {
                return updater.executePersist(context, entity, (MutableStateTrackable)view);
            }
            return updater.executePersist(context, (MutableStateTrackable)view);
        }
        return entity;
    }

    protected boolean shouldPersist(Object view, Object id) {
        if (this.isEmbeddable) {
            return true;
        }
        return id == null || view instanceof EntityViewProxy && ((EntityViewProxy)view).$$_isNew();
    }

    protected Class<?> getViewTypeClass(Object view) {
        if (view instanceof EntityViewProxy) {
            return ((EntityViewProxy)view).$$_getEntityViewClass();
        }
        return view.getClass();
    }

    protected static String names(Set<Class<?>> viewTypeClasses) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Class<?> aClass : viewTypeClasses) {
            sb.append(aClass.getName());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public AttributeAccessor getViewIdAccessor() {
        return this.viewIdAccessor;
    }

    @Override
    public AttributeAccessor getEntityIdAccessor() {
        return this.entityIdAccessor;
    }
}

