/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.lang.StringUtils;
import com.blazebit.persistence.LimitBuilder;
import com.blazebit.persistence.OrderByBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.parser.AliasReplacementVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.NumericType;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.SyntaxErrorException;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.LateralStyle;
import com.blazebit.persistence.spi.ServiceProvider;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.EntityView;
import com.blazebit.persistence.view.FetchStrategy;
import com.blazebit.persistence.view.IdMapping;
import com.blazebit.persistence.view.Mapping;
import com.blazebit.persistence.view.MappingCorrelated;
import com.blazebit.persistence.view.MappingCorrelatedSimple;
import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.MappingSubquery;
import com.blazebit.persistence.view.Self;
import com.blazebit.persistence.view.SubqueryProvider;
import com.blazebit.persistence.view.SubqueryProviderFactory;
import com.blazebit.persistence.view.impl.CollectionJoinMappingGathererExpressionVisitor;
import com.blazebit.persistence.view.impl.CorrelationProviderHelper;
import com.blazebit.persistence.view.impl.PrefixingQueryGenerator;
import com.blazebit.persistence.view.impl.ScalarTargetResolvingExpressionVisitor;
import com.blazebit.persistence.view.impl.StaticCorrelationProvider;
import com.blazebit.persistence.view.impl.StaticPathCorrelationProvider;
import com.blazebit.persistence.view.impl.SubqueryProviderHelper;
import com.blazebit.persistence.view.impl.TypeExtractingCorrelationBuilder;
import com.blazebit.persistence.view.impl.UpdatableExpressionVisitor;
import com.blazebit.persistence.view.impl.collection.CollectionInstantiatorImplementor;
import com.blazebit.persistence.view.impl.collection.ListCollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.ListFactory;
import com.blazebit.persistence.view.impl.collection.MapInstantiatorImplementor;
import com.blazebit.persistence.view.impl.collection.OrderedCollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.OrderedMapInstantiator;
import com.blazebit.persistence.view.impl.collection.OrderedSetCollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.PluralObjectFactory;
import com.blazebit.persistence.view.impl.collection.SetFactory;
import com.blazebit.persistence.view.impl.collection.SortedMapInstantiator;
import com.blazebit.persistence.view.impl.collection.SortedSetCollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.SortedSetFactory;
import com.blazebit.persistence.view.impl.collection.UnorderedMapInstantiator;
import com.blazebit.persistence.view.impl.collection.UnorderedSetCollectionInstantiator;
import com.blazebit.persistence.view.impl.metamodel.AggregateDetectionVisitor;
import com.blazebit.persistence.view.impl.metamodel.AttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.BasicTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelUtils;
import com.blazebit.persistence.view.impl.objectbuilder.ContainerAccumulator;
import com.blazebit.persistence.view.impl.objectbuilder.NullFilteringCollectionAccumulator;
import com.blazebit.persistence.view.impl.objectbuilder.SimpleCollectionAccumulator;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.OrderByItem;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.reflection.ReflectionUtils;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class AbstractAttribute<X, Y>
implements com.blazebit.persistence.view.metamodel.Attribute<X, Y> {
    protected static final String[] EMPTY = new String[0];
    private static final String THIS = "this";
    private static final Pattern PREFIX_THIS_REPLACE_PATTERN = Pattern.compile("([^a-zA-Z0-9\\.])this\\.");
    protected final ManagedViewTypeImplementor<X> declaringType;
    protected final Class<Y> javaType;
    protected final Class<?> convertedJavaType;
    protected final String mapping;
    protected final Expression mappingExpression;
    protected final String[] fetches;
    protected final FetchStrategy fetchStrategy;
    protected final int batchSize;
    protected final List<OrderByItem> orderByItems;
    protected final String limitExpression;
    protected final String offsetExpression;
    protected final SubqueryProviderFactory subqueryProviderFactory;
    protected final Class<? extends SubqueryProvider> subqueryProvider;
    protected final String subqueryExpression;
    protected final Expression subqueryResultExpression;
    protected final String subqueryAlias;
    protected final CorrelationProviderFactory correlationProviderFactory;
    protected final Class<? extends CorrelationProvider> correlationProvider;
    protected final String correlationBasis;
    protected final String correlationResult;
    protected final Class<?> correlated;
    protected final String correlationKeyAlias;
    protected final String correlationExpression;
    protected final Expression correlationBasisExpression;
    protected final Expression correlationResultExpression;
    protected final Attribute.MappingType mappingType;
    protected final boolean id;
    protected final boolean isAggregate;
    protected final Attribute<?, ?> updateMappableAttribute;
    private final List<ScalarTargetResolvingExpressionVisitor.TargetType> possibleTargetTypes;
    private final List<ScalarTargetResolvingExpressionVisitor.TargetType> possibleIndexTargetTypes;

    public AbstractAttribute(ManagedViewTypeImplementor<X> declaringType, AttributeMapping mapping, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        List<Object> orderByItems;
        String offsetExpression;
        String limitExpression;
        int batchSize;
        Class<?> javaType = null;
        try {
            javaType = mapping.getJavaType(context, embeddableMapping);
            if (javaType == null) {
                context.addError("The attribute type is not resolvable at the " + mapping.getErrorLocation());
            }
        }
        catch (IllegalArgumentException ex) {
            context.addError("An error occurred while trying to resolve the attribute type at the " + mapping.getErrorLocation());
        }
        this.possibleTargetTypes = mapping.getPossibleTargetTypes(context);
        this.possibleIndexTargetTypes = mapping.getPossibleIndexTargetTypes(context);
        Integer defaultBatchSize = mapping.getDefaultBatchSize();
        if (defaultBatchSize == null || defaultBatchSize == -1) {
            batchSize = -1;
        } else if (defaultBatchSize < 1) {
            context.addError("Illegal batch fetch size lower than 1 defined at '" + mapping.getErrorLocation() + "'!");
            batchSize = Integer.MIN_VALUE;
        } else {
            batchSize = defaultBatchSize;
        }
        if (mapping.getLimitExpression() == null) {
            limitExpression = null;
            offsetExpression = null;
            orderByItems = Collections.emptyList();
        } else {
            limitExpression = mapping.getLimitExpression();
            offsetExpression = mapping.getOffsetExpression();
            if (offsetExpression == null || offsetExpression.isEmpty()) {
                offsetExpression = "0";
            }
            List<String> orderByItemExpressions = mapping.getOrderByItems();
            orderByItems = AbstractAttribute.parseOrderByItems(orderByItemExpressions);
        }
        this.declaringType = declaringType;
        this.javaType = javaType;
        this.convertedJavaType = AbstractAttribute.getConvertedType(declaringType.getJavaType(), mapping.getType(context, embeddableMapping).getConvertedType(), javaType);
        Annotation mappingAnnotation = mapping.getMapping();
        String mappingString = null;
        Expression mappingExpression = null;
        String[] fetches = EMPTY;
        FetchStrategy fetchStrategy = FetchStrategy.JOIN;
        SubqueryProviderFactory subqueryProviderFactory = null;
        Class subqueryProvider = null;
        boolean id = false;
        Attribute<?, ?> updateMappableAttribute = null;
        String subqueryExpression = null;
        Expression subqueryResultExpression = null;
        String subqueryAlias = null;
        String correlationBasis = null;
        String correlationResult = null;
        Class correlationProvider = null;
        Object correlationProviderFactory = null;
        Class correlated = null;
        String correlationKeyAlias = null;
        String correlationExpression = null;
        Expression correlationBasisExpression = null;
        Expression correlationResultExpression = null;
        if (mappingAnnotation instanceof IdMapping) {
            mappingString = ((IdMapping)mappingAnnotation).value();
            mappingExpression = AbstractAttribute.createSimpleExpression(mappingString, mapping, context, ExpressionLocation.MAPPING);
            batchSize = -1;
            limitExpression = null;
            offsetExpression = null;
            orderByItems = Collections.emptyList();
            fetchStrategy = FetchStrategy.JOIN;
            id = true;
            updateMappableAttribute = this.getUpdateMappableAttribute(context, mappingExpression);
            this.mappingType = Attribute.MappingType.BASIC;
            this.isAggregate = AbstractAttribute.isAggregate(mappingExpression);
        } else if (mappingAnnotation instanceof Mapping) {
            Mapping m = (Mapping)mappingAnnotation;
            mappingString = m.value();
            mappingExpression = AbstractAttribute.createSimpleExpression(mappingString, mapping, context, ExpressionLocation.MAPPING);
            fetches = m.fetches();
            fetchStrategy = m.fetch();
            updateMappableAttribute = this.getUpdateMappableAttribute(context, mappingExpression);
            this.mappingType = Attribute.MappingType.BASIC;
            this.isAggregate = AbstractAttribute.isAggregate(mappingExpression);
            if (fetchStrategy != FetchStrategy.JOIN || limitExpression != null) {
                int index;
                ExtendedManagedType managedType = (ExtendedManagedType)context.getEntityMetamodel().getManagedType(ExtendedManagedType.class, declaringType.getJpaManagedType());
                ExtendedAttribute attribute = (ExtendedAttribute)managedType.getOwnedAttributes().get(mappingString);
                correlationKeyAlias = "__correlationAlias";
                String correlationPath = null;
                if (fetchStrategy == FetchStrategy.SELECT && attribute != null && attribute.hasJoinCondition()) {
                    correlated = declaringType.getEntityClass();
                    correlationExpression = "this IN __correlationAlias";
                    correlationResult = mappingString;
                    correlationResultExpression = mappingExpression;
                } else if (attribute == null && (index = mappingString.indexOf(46)) != -1 && mappingString.indexOf(40) == -1 && (attribute = (ExtendedAttribute)managedType.getOwnedAttributes().get(mappingString.substring(0, index))) != null && !StringUtils.isEmpty((CharSequence)attribute.getMappedBy()) && !attribute.hasJoinCondition()) {
                    correlated = attribute.getElementClass();
                    correlationExpression = attribute.getMappedBy() + " IN __correlationAlias";
                    correlationResult = mappingString.substring(index + 1);
                    correlationResultExpression = mappingExpression instanceof PathExpression ? ((PathExpression)mappingExpression).withoutFirst() : new PathExpression();
                } else if (attribute != null && !StringUtils.isEmpty((CharSequence)attribute.getMappedBy()) && !attribute.hasJoinCondition()) {
                    correlated = attribute.getElementClass();
                    correlationExpression = attribute.getMappedBy() + " IN __correlationAlias";
                    correlationResult = "";
                    correlationResultExpression = new PathExpression();
                } else {
                    correlated = declaringType.getEntityClass();
                    correlationExpression = "this IN __correlationAlias";
                    correlationResult = mappingString;
                    correlationResultExpression = mappingExpression;
                    if (fetchStrategy == FetchStrategy.JOIN && !orderByItems.isEmpty() && mappingExpression instanceof PathExpression) {
                        correlated = null;
                        correlationPath = mappingString;
                        correlationResult = "";
                        correlationResultExpression = new PathExpression();
                    }
                }
                correlationBasis = THIS;
                correlationBasisExpression = new PathExpression((PathElementExpression)new PropertyExpression(THIS));
                correlationProviderFactory = correlated == null ? new StaticPathCorrelationProvider(correlationPath, declaringType.getEntityViewRootTypes().keySet()) : new StaticCorrelationProvider(correlated, correlationKeyAlias, correlationExpression, AbstractAttribute.createPredicate(correlationExpression, mapping, context, ExpressionLocation.CORRELATION_EXPRESSION), declaringType.getEntityViewRootTypes().keySet());
                correlated = null;
            }
        } else if (mappingAnnotation instanceof MappingParameter) {
            mappingString = ((MappingParameter)mappingAnnotation).value();
            fetchStrategy = FetchStrategy.JOIN;
            batchSize = -1;
            limitExpression = null;
            offsetExpression = null;
            this.mappingType = Attribute.MappingType.PARAMETER;
            this.isAggregate = false;
        } else if (mappingAnnotation instanceof Self) {
            mappingString = "NULL";
            mappingExpression = NullExpression.INSTANCE;
            batchSize = -1;
            limitExpression = null;
            offsetExpression = null;
            orderByItems = Collections.emptyList();
            this.mappingType = Attribute.MappingType.PARAMETER;
            this.isAggregate = false;
        } else if (mappingAnnotation instanceof MappingSubquery) {
            MappingSubquery mappingSubquery = (MappingSubquery)mappingAnnotation;
            subqueryProvider = mappingSubquery.value();
            subqueryProviderFactory = SubqueryProviderHelper.getFactory(subqueryProvider);
            fetchStrategy = FetchStrategy.JOIN;
            batchSize = -1;
            limitExpression = null;
            offsetExpression = null;
            orderByItems = Collections.emptyList();
            this.mappingType = Attribute.MappingType.SUBQUERY;
            subqueryExpression = mappingSubquery.expression();
            subqueryAlias = mappingSubquery.subqueryAlias();
            subqueryResultExpression = AbstractAttribute.createSimpleExpression(subqueryExpression, mapping, context, ExpressionLocation.SUBQUERY_EXPRESSION);
            this.isAggregate = AbstractAttribute.isAggregate(subqueryResultExpression);
            if (!subqueryExpression.isEmpty() && subqueryAlias.isEmpty()) {
                context.addError("The subquery alias is empty although the subquery expression is not " + mapping.getErrorLocation());
            }
            if (subqueryProvider.getEnclosingClass() != null && !Modifier.isStatic(subqueryProvider.getModifiers())) {
                context.addError("The subquery provider is defined as non-static inner class. Make it static, otherwise it can't be instantiated: " + mapping.getErrorLocation());
            }
        } else if (mappingAnnotation instanceof MappingCorrelated) {
            ScalarTargetResolvingExpressionVisitor resolver;
            jakarta.persistence.metamodel.Type<?> type;
            MappingCorrelated mappingCorrelated = (MappingCorrelated)mappingAnnotation;
            fetches = mappingCorrelated.fetches();
            fetchStrategy = mappingCorrelated.fetch();
            if (fetchStrategy != FetchStrategy.SELECT) {
                batchSize = -1;
            }
            this.mappingType = Attribute.MappingType.CORRELATED;
            correlationBasis = mappingCorrelated.correlationBasis();
            correlationResult = mappingCorrelated.correlationResult();
            correlationProvider = mappingCorrelated.correlator();
            correlationBasisExpression = AbstractAttribute.createSimpleExpression(correlationBasis, mapping, context, ExpressionLocation.CORRELATION_BASIS);
            correlationResultExpression = AbstractAttribute.createSimpleExpression(correlationResult, mapping, context, ExpressionLocation.CORRELATION_RESULT);
            this.isAggregate = AbstractAttribute.isAggregate(correlationResultExpression);
            if (correlationProvider.getEnclosingClass() != null && !Modifier.isStatic(correlationProvider.getModifiers())) {
                context.addError("The correlation provider is defined as non-static inner class. Make it static, otherwise it can't be instantiated: " + mapping.getErrorLocation());
            }
            correlated = (type = TypeExtractingCorrelationBuilder.extractType(correlationProviderFactory = CorrelationProviderHelper.getFactory(correlationProvider), "_alias", context, resolver = new ScalarTargetResolvingExpressionVisitor(declaringType.getJpaManagedType(), context.getEntityMetamodel(), context.getJpqlFunctions(), declaringType.getEntityViewRootTypes()))) == null ? null : type.getJavaType();
        } else if (mappingAnnotation instanceof MappingCorrelatedSimple) {
            MappingCorrelatedSimple mappingCorrelated = (MappingCorrelatedSimple)mappingAnnotation;
            fetches = mappingCorrelated.fetches();
            fetchStrategy = mappingCorrelated.fetch();
            if (fetchStrategy != FetchStrategy.SELECT) {
                batchSize = -1;
            }
            this.mappingType = Attribute.MappingType.CORRELATED;
            correlationBasis = mappingCorrelated.correlationBasis();
            correlationResult = mappingCorrelated.correlationResult();
            correlated = mappingCorrelated.correlated();
            correlationKeyAlias = mappingCorrelated.correlationKeyAlias();
            correlationExpression = mappingCorrelated.correlationExpression();
            correlationBasisExpression = AbstractAttribute.createSimpleExpression(correlationBasis, mapping, context, ExpressionLocation.CORRELATION_BASIS);
            correlationResultExpression = AbstractAttribute.createSimpleExpression(correlationResult, mapping, context, ExpressionLocation.CORRELATION_RESULT);
            correlationProviderFactory = new StaticCorrelationProvider(correlated, correlationKeyAlias, correlationExpression, AbstractAttribute.createPredicate(correlationExpression, mapping, context, ExpressionLocation.CORRELATION_EXPRESSION), declaringType.getEntityViewRootTypes().keySet());
            this.isAggregate = AbstractAttribute.isAggregate(correlationResultExpression);
            if (mappingCorrelated.correlationBasis().isEmpty()) {
                context.addError("Illegal empty correlation basis in the " + mapping.getErrorLocation());
            }
            if (!(declaringType instanceof ViewType) && (fetchStrategy == FetchStrategy.SELECT || fetchStrategy == FetchStrategy.SUBSELECT) && mappingCorrelated.correlationExpression().toUpperCase().contains("EMBEDDING_VIEW")) {
                context.addError("The use of EMBEDDING_VIEW in the correlation for '" + mapping.getErrorLocation() + "' is illegal because the embedding view type '" + declaringType.getJavaType().getName() + "' does not declare a @IdMapping!");
            }
        } else {
            context.addError("No mapping annotation could be found " + mapping.getErrorLocation());
            this.mappingType = null;
            this.isAggregate = false;
        }
        if (limitExpression != null && fetchStrategy == FetchStrategy.MULTISET && context.getDbmsDialect().getLateralStyle() == LateralStyle.NONE && !context.getDbmsDialect().supportsWindowFunctions()) {
            context.addError("The use of the MULTISET fetch strategy with a limit in the '" + mapping.getErrorLocation() + "' requires lateral joins or window functions which are unsupported by the DBMS!");
        }
        this.mapping = mappingString;
        this.mappingExpression = mappingExpression;
        this.fetches = fetches;
        this.fetchStrategy = fetchStrategy;
        this.batchSize = batchSize;
        this.orderByItems = orderByItems;
        this.limitExpression = limitExpression;
        this.offsetExpression = offsetExpression;
        this.subqueryProviderFactory = subqueryProviderFactory;
        this.subqueryProvider = subqueryProvider;
        this.id = id;
        this.updateMappableAttribute = updateMappableAttribute;
        this.subqueryExpression = subqueryExpression;
        this.subqueryResultExpression = subqueryResultExpression;
        this.subqueryAlias = subqueryAlias;
        this.correlationBasis = correlationBasis;
        this.correlationResult = correlationResult;
        this.correlationProvider = correlationProvider;
        this.correlationProviderFactory = correlationProviderFactory;
        this.correlated = correlated;
        this.correlationKeyAlias = correlationKeyAlias;
        this.correlationExpression = correlationExpression;
        this.correlationBasisExpression = correlationBasisExpression;
        this.correlationResultExpression = correlationResultExpression;
    }

    private static boolean isAggregate(Expression expression) {
        return expression != null && Boolean.TRUE.equals(expression.accept(AggregateDetectionVisitor.INSTANCE));
    }

    public static List<OrderByItem> parseOrderByItems(List<String> orderByItemExpressions) {
        ArrayList<OrderByItem> orderByItems = new ArrayList<OrderByItem>(orderByItemExpressions.size());
        for (int i = 0; i < orderByItemExpressions.size(); ++i) {
            String expression = orderByItemExpressions.get(i);
            String upperExpression = expression.toUpperCase();
            boolean ascending = true;
            boolean nullsFirst = false;
            if (upperExpression.endsWith(" NULLS LAST")) {
                upperExpression = upperExpression.substring(0, upperExpression.length() - " NULLS LAST".length());
            } else if (upperExpression.endsWith(" NULLS FIRST")) {
                nullsFirst = true;
                upperExpression = upperExpression.substring(0, upperExpression.length() - " NULLS FIRST".length());
            }
            if (upperExpression.endsWith(" ASC")) {
                upperExpression = upperExpression.substring(0, upperExpression.length() - " ASC".length());
            } else if (upperExpression.endsWith(" DESC")) {
                ascending = false;
                upperExpression = upperExpression.substring(0, upperExpression.length() - " DESC".length());
            }
            expression = expression.substring(0, upperExpression.length());
            orderByItems.add(new OrderByItem(expression, ascending, nullsFirst));
        }
        return Collections.unmodifiableList(orderByItems);
    }

    protected static Expression createSimpleExpression(String expression, AttributeMapping mapping, MetamodelBuildingContext context, ExpressionLocation expressionLocation) {
        if (expression == null || expression.isEmpty()) {
            return null;
        }
        try {
            return context.getTypeValidationExpressionFactory().createSimpleExpression(expression, false, expressionLocation == ExpressionLocation.SUBQUERY_EXPRESSION, true);
        }
        catch (SyntaxErrorException ex) {
            context.addError("Syntax error in " + (Object)((Object)expressionLocation) + " '" + expression + "' of the " + mapping.getErrorLocation() + ": " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            context.addError("An error occurred while trying to resolve the " + (Object)((Object)expressionLocation) + " of the " + mapping.getErrorLocation() + ": " + ex.getMessage());
        }
        return null;
    }

    private static Predicate createPredicate(String expression, AttributeMapping mapping, MetamodelBuildingContext context, ExpressionLocation expressionLocation) {
        try {
            return context.getTypeValidationExpressionFactory().createBooleanExpression(expression, false);
        }
        catch (SyntaxErrorException ex) {
            context.addError("Syntax error in " + (Object)((Object)expressionLocation) + " '" + expression + "' of the " + mapping.getErrorLocation() + ": " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            context.addError("An error occurred while trying to resolve the " + (Object)((Object)expressionLocation) + " of the " + mapping.getErrorLocation() + ": " + ex.getMessage());
        }
        return null;
    }

    private static Class<?> getConvertedType(Class<?> declaringClass, java.lang.reflect.Type convertedType, Class<?> javaType) {
        if (convertedType == null) {
            return javaType;
        }
        return ReflectionUtils.resolveType(declaringClass, (java.lang.reflect.Type)convertedType);
    }

    private Attribute<?, ?> getUpdateMappableAttribute(MetamodelBuildingContext context, Expression mappingExpression) {
        if (mappingExpression != null) {
            try {
                UpdatableExpressionVisitor visitor = new UpdatableExpressionVisitor(context.getEntityMetamodel(), this.declaringType.getEntityClass(), true, this.declaringType.getEntityViewRootTypes());
                mappingExpression.accept((Expression.Visitor)visitor);
                Iterator<Attribute<?, ?>> iterator = visitor.getPossibleTargets().keySet().iterator();
                if (iterator.hasNext()) {
                    return iterator.next();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String stripThisFromMapping(String mapping) {
        return AbstractAttribute.replaceThisFromMapping(mapping, "");
    }

    public static String replaceThisFromMapping(String mapping, String root) {
        if (mapping == null) {
            return null;
        }
        if ((mapping = mapping.trim()).startsWith(THIS)) {
            if (mapping.length() == THIS.length()) {
                return root;
            }
            if (root.isEmpty()) {
                char nextChar = mapping.charAt(THIS.length());
                if (nextChar == '.') {
                    mapping = mapping.substring(THIS.length() + 1);
                }
            } else {
                mapping = root + mapping.substring(THIS.length());
            }
        }
        String replacement = root.isEmpty() ? "$1" : "$1" + root + ".";
        mapping = PREFIX_THIS_REPLACE_PATTERN.matcher(mapping).replaceAll(replacement);
        return mapping;
    }

    public final void renderSubqueryExpression(String parent, ServiceProvider serviceProvider, StringBuilder sb) {
        this.renderExpression(parent, this.subqueryResultExpression, this.subqueryAlias, serviceProvider, sb);
    }

    public final void renderSubqueryExpression(String parent, String subqueryExpression, String subqueryAlias, ServiceProvider serviceProvider, StringBuilder sb) {
        ExpressionFactory ef = (ExpressionFactory)serviceProvider.getService(ExpressionFactory.class);
        Expression expr = ef.createSimpleExpression(subqueryExpression, false, false, true);
        this.renderExpression(parent, expr, subqueryAlias, serviceProvider, sb);
    }

    public final void renderCorrelationBasis(String parent, ServiceProvider serviceProvider, StringBuilder sb) {
        this.renderExpression(parent, this.correlationBasisExpression, null, serviceProvider, sb);
    }

    public final void renderCorrelationResult(String parent, ServiceProvider serviceProvider, StringBuilder sb) {
        this.renderExpression(parent, this.correlationResultExpression, null, serviceProvider, sb);
    }

    public final void renderMapping(String parent, ServiceProvider serviceProvider, StringBuilder sb) {
        this.renderExpression(parent, this.mappingExpression, null, serviceProvider, sb);
    }

    protected final void renderExpression(String parent, Expression expression, String aliasToSkip, ServiceProvider serviceProvider, StringBuilder sb) {
        if (parent != null && !parent.isEmpty()) {
            ExpressionFactory ef = (ExpressionFactory)serviceProvider.getService(ExpressionFactory.class);
            PrefixingQueryGenerator generator = new PrefixingQueryGenerator(ef, parent, aliasToSkip, aliasToSkip, this.declaringType.getEntityViewRootTypes().keySet(), true, false);
            generator.setQueryBuffer(sb);
            expression.accept((Expression.Visitor)generator);
        } else {
            sb.append(expression);
        }
    }

    public <T extends LimitBuilder<?> & OrderByBuilder<?>> void renderLimit(String parent, ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, T builder) {
        if (this.limitExpression != null) {
            ExpressionFactory expressionFactory = (ExpressionFactory)((ServiceProvider)builder).getService(ExpressionFactory.class);
            this.declaringType.createLimiter(expressionFactory, parent, this.limitExpression, this.offsetExpression, this.orderByItems).apply(parameterHolder, optionalParameters, builder);
        }
    }

    public Map<String, Boolean> getCollectionJoinMappings(ManagedType<?> managedType, MetamodelBuildingContext context) {
        if (this.mappingExpression == null || this.isQueryParameter() || this.getFetchStrategy() != FetchStrategy.JOIN) {
            return Collections.emptyMap();
        }
        CollectionJoinMappingGathererExpressionVisitor visitor = new CollectionJoinMappingGathererExpressionVisitor(managedType, context.getEntityMetamodel());
        this.mappingExpression.accept((Expression.Visitor)visitor);
        HashMap<String, Boolean> mappings = new HashMap<String, Boolean>();
        boolean aggregate = this.getAttributeType() == Attribute.AttributeType.SINGULAR;
        for (String s : visitor.getPaths()) {
            mappings.put(s, aggregate);
        }
        return mappings;
    }

    public boolean hasJoinFetchedCollections() {
        return this.getFetchStrategy() == FetchStrategy.JOIN && (this.isCollection() || this.getElementType() instanceof ManagedViewTypeImpl && ((ManagedViewTypeImplementor)this.getElementType()).hasJoinFetchedCollections());
    }

    public boolean hasSelectOrSubselectFetchedAttributes() {
        return this.getFetchStrategy() == FetchStrategy.SELECT || this.getFetchStrategy() == FetchStrategy.SUBSELECT || this.getElementType() instanceof ManagedViewTypeImpl && ((ManagedViewTypeImplementor)this.getElementType()).hasSelectOrSubselectFetchedAttributes();
    }

    public boolean hasJpaManagedAttributes() {
        return this.getElementType() instanceof BasicTypeImpl && ((BasicTypeImpl)this.getElementType()).isJpaManaged() || this.getElementType() instanceof ManagedViewTypeImpl && ((ManagedViewTypeImplementor)this.getElementType()).hasJpaManagedAttributes();
    }

    protected String determineIndexMapping(AttributeMapping mapping) {
        String indexMapping = null;
        if (mapping.getMappingIndex() != null && (indexMapping = mapping.getMappingIndex().value()).isEmpty()) {
            indexMapping = "INDEX(this)";
        }
        return indexMapping;
    }

    protected String determineKeyMapping(AttributeMapping mapping) {
        String keyMapping = null;
        if (mapping.getMappingIndex() != null) {
            keyMapping = mapping.getMappingIndex().value();
        }
        if (keyMapping == null || keyMapping.isEmpty()) {
            keyMapping = "KEY(this)";
        }
        return keyMapping;
    }

    protected boolean determineForcedUnique(MetamodelBuildingContext context) {
        ExtendedManagedType managedType;
        ExtendedAttribute attribute;
        if (this.isCollection() && this.getMapping() != null && this.getMapping().indexOf(46) == -1 && this.getMappingIndexExpression() == null && this.getKeyMappingExpression() == null && (attribute = (ExtendedAttribute)(managedType = (ExtendedManagedType)context.getEntityMetamodel().getManagedType(ExtendedManagedType.class, this.getDeclaringType().getJpaManagedType())).getOwnedAttributes().get(this.getMapping())) != null && attribute.getAttribute() instanceof PluralAttribute) {
            return !(((PluralAttribute)attribute.getAttribute()).getCollectionType() == PluralAttribute.CollectionType.MAP || StringUtils.isEmpty((CharSequence)attribute.getMappedBy()) && attribute.isBag() || attribute.getJoinTable() != null && attribute.getJoinTable().getKeyColumnMappings() != null || MetamodelUtils.isIndexedList(context.getEntityMetamodel(), managedType.getType().getJavaType(), this.mappingExpression, this.mapping));
        }
        return false;
    }

    public Attribute<?, ?> getUpdateMappableAttribute() {
        return this.updateMappableAttribute;
    }

    protected boolean isFilterNulls() {
        return !this.isCorrelated() || this.getCorrelationProviderFactory() != null;
    }

    public boolean isUpdateMappable() {
        return this.hasDirtyStateIndex() || this.updateMappableAttribute != null;
    }

    public Class<?> getCorrelated() {
        return this.correlated;
    }

    public String getCorrelationKeyAlias() {
        return this.correlationKeyAlias;
    }

    public String getCorrelationExpression() {
        return this.correlationExpression;
    }

    public Predicate getCorrelationPredicate() {
        if (this.correlationProviderFactory instanceof StaticCorrelationProvider) {
            return ((StaticCorrelationProvider)this.correlationProviderFactory).getCorrelationPredicate();
        }
        if (this.correlationProviderFactory instanceof StaticPathCorrelationProvider) {
            return ((StaticPathCorrelationProvider)this.correlationProviderFactory).getCorrelationPredicate();
        }
        return null;
    }

    public abstract boolean needsDirtyTracker();

    public abstract boolean hasDirtyStateIndex();

    private static boolean isCompatible(ScalarTargetResolvingExpressionVisitor.TargetType t, Class<?> targetType, Class<?> targetElementType, boolean updatable, boolean singular) {
        if (t.hasCollectionJoin()) {
            return AbstractAttribute.isCompatible(t.getLeafMethod(), t.getLeafBaseClass(), t.getLeafBaseValueClass(), targetType, targetElementType, updatable, singular);
        }
        Class<?> entityAttributeElementType = AbstractAttribute.getElementTypeOrNull(t, singular);
        return AbstractAttribute.isCompatible(t.getLeafMethod(), t.getLeafBaseClass(), entityAttributeElementType, targetType, targetElementType, updatable, singular);
    }

    private static Class<?> getElementTypeOrNull(ScalarTargetResolvingExpressionVisitor.TargetType t, boolean singular) {
        if (singular && t.getLeafMethod() != null && t.getLeafBaseClass() == t.getLeafBaseValueClass() && (Collection.class.isAssignableFrom(t.getLeafBaseClass()) || Map.class.isAssignableFrom(t.getLeafBaseClass()))) {
            Class elementClass;
            Member javaMember = t.getLeafMethod().getJavaMember();
            if (javaMember instanceof Field) {
                Class[] resolvedFieldTypeArguments = ReflectionUtils.getResolvedFieldTypeArguments((Class)t.getLeafMethod().getDeclaringType().getJavaType(), (Field)((Field)javaMember));
                elementClass = resolvedFieldTypeArguments[resolvedFieldTypeArguments.length - 1];
            } else if (javaMember instanceof Method) {
                Class[] resolvedMethodReturnTypeArguments = ReflectionUtils.getResolvedMethodReturnTypeArguments((Class)t.getLeafMethod().getDeclaringType().getJavaType(), (Method)((Method)javaMember));
                elementClass = resolvedMethodReturnTypeArguments[resolvedMethodReturnTypeArguments.length - 1];
            } else {
                elementClass = null;
            }
            if (elementClass != t.getLeafBaseValueClass()) {
                return elementClass;
            }
        }
        return null;
    }

    private static boolean isCompatible(Attribute<?, ?> attribute, Class<?> entityAttributeType, Class<?> entityAttributeElementType, Class<?> viewAttributeType, Class<?> viewAttributeElementType, boolean updatable, boolean singular) {
        if (entityAttributeType == null) {
            return true;
        }
        if (updatable) {
            if (entityAttributeElementType != null) {
                if (viewAttributeElementType != null) {
                    if (singular) {
                        return viewAttributeType == entityAttributeType && viewAttributeElementType == entityAttributeElementType;
                    }
                    if (attribute instanceof ListAttribute ? !List.class.isAssignableFrom(viewAttributeType) : (attribute instanceof MapAttribute ? !Map.class.isAssignableFrom(viewAttributeType) : !Collection.class.isAssignableFrom(viewAttributeType))) {
                        return false;
                    }
                    return viewAttributeElementType == entityAttributeElementType;
                }
                if (singular) {
                    return viewAttributeType == entityAttributeType;
                }
                return viewAttributeType == entityAttributeElementType;
            }
            if (viewAttributeElementType != null) {
                return viewAttributeElementType == entityAttributeType;
            }
            return viewAttributeType == entityAttributeType;
        }
        if (entityAttributeElementType != null) {
            if (viewAttributeElementType != null) {
                return (viewAttributeType.isAssignableFrom(entityAttributeType) || !singular && Map.class.isAssignableFrom(entityAttributeType) && Collection.class.isAssignableFrom(viewAttributeType)) && viewAttributeElementType.isAssignableFrom(entityAttributeElementType);
            }
            return viewAttributeType.isAssignableFrom(entityAttributeElementType);
        }
        if (viewAttributeElementType != null) {
            return viewAttributeElementType.isAssignableFrom(entityAttributeType);
        }
        return viewAttributeType.isAssignableFrom(entityAttributeType);
    }

    private static void validateTypesCompatible(ManagedType<?> managedType, Expression expression, Class<?> targetType, Class<?> targetElementType, boolean updatable, boolean singular, Map<String, jakarta.persistence.metamodel.Type<?>> rootTypes, MetamodelBuildingContext context, ExpressionLocation expressionLocation, String location) {
        ScalarTargetResolvingExpressionVisitor visitor = new ScalarTargetResolvingExpressionVisitor(managedType, context.getEntityMetamodel(), context.getJpqlFunctions(), rootTypes);
        try {
            expression.accept((Expression.Visitor)visitor);
        }
        catch (IllegalArgumentException ex) {
            context.addError("An error occurred while trying to resolve the " + (Object)((Object)expressionLocation) + " of the " + location + ": " + ex.getMessage());
        }
        AbstractAttribute.validateTypesCompatible(visitor.getPossibleTargetTypes(), targetType, targetElementType, updatable, singular, context, expressionLocation, location);
    }

    private static void validateTypesCompatible(List<ScalarTargetResolvingExpressionVisitor.TargetType> possibleTargets, Class<?> targetType, Class<?> targetElementType, boolean updatable, boolean singular, MetamodelBuildingContext context, ExpressionLocation expressionLocation, String location) {
        Class expressionType = targetType;
        if (!possibleTargets.isEmpty()) {
            boolean error = true;
            for (ScalarTargetResolvingExpressionVisitor.TargetType t : possibleTargets) {
                if (!AbstractAttribute.isCompatible(t, targetType, targetElementType, updatable, singular)) continue;
                error = false;
                break;
            }
            if (error && (targetType = targetType.isPrimitive() ? ReflectionUtils.getObjectClassOfPrimitve(targetType) : ReflectionUtils.getPrimitiveClassOfWrapper(targetType)) != null) {
                for (ScalarTargetResolvingExpressionVisitor.TargetType t : possibleTargets) {
                    if (!AbstractAttribute.isCompatible(t, targetType, targetElementType, updatable, singular)) continue;
                    error = false;
                    break;
                }
            }
            if (error) {
                context.addError(AbstractAttribute.typeCompatibilityError(possibleTargets, expressionType, targetElementType, expressionLocation, location));
            }
        }
    }

    private static String typeCompatibilityError(List<ScalarTargetResolvingExpressionVisitor.TargetType> possibleTargets, Class<?> targetType, Class<?> targetElementType, ExpressionLocation expressionLocation, String location) {
        StringBuilder sb = new StringBuilder();
        sb.append("The resolved possible types ");
        sb.append('[');
        for (ScalarTargetResolvingExpressionVisitor.TargetType t : possibleTargets) {
            sb.append(t.getLeafBaseClass().getName());
            if (t.getLeafBaseValueClass() != null && t.getLeafBaseClass() != t.getLeafBaseValueClass()) {
                sb.append('<');
                sb.append(t.getLeafBaseValueClass().getName());
                sb.append('>');
            }
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(']');
        sb.append(" are not assignable to the given expression type '");
        sb.append(targetType.getName());
        if (targetElementType != null && targetElementType != targetType) {
            sb.append('<');
            sb.append(targetElementType.getName());
            sb.append('>');
        }
        sb.append("' of the ");
        sb.append((Object)expressionLocation);
        sb.append(" declared by the ");
        sb.append(location);
        sb.append("!");
        return sb.toString();
    }

    public void checkAttribute(ManagedType<?> managedType, MetamodelBuildingContext context) {
        int i;
        Attribute<?, ?> elementAttribute;
        ManagedType elementManagedType;
        Class<Collection> expressionType = this.getJavaType();
        Class keyType = null;
        Class elementType = null;
        if (this.possibleTargetTypes.size() != 1) {
            elementManagedType = this.getElementType() instanceof ManagedViewType ? context.getEntityMetamodel().getManagedType(((ManagedViewType)this.getElementType()).getEntityClass()) : context.getEntityMetamodel().getManagedType(this.getElementType().getJavaType());
            elementAttribute = null;
        } else {
            elementManagedType = context.getEntityMetamodel().getManagedType(this.possibleTargetTypes.get(0).getLeafBaseValueClass());
            elementAttribute = this.possibleTargetTypes.get(0).getLeafMethod();
        }
        ScalarTargetResolvingExpressionVisitor visitor = new ScalarTargetResolvingExpressionVisitor(elementManagedType, elementAttribute, context.getEntityMetamodel(), context.getJpqlFunctions(), this.declaringType.getEntityViewRootTypes());
        if (this.fetches.length != 0) {
            if (context.getEntityMetamodel().getManagedType(this.getElementType().getJavaType()) == null) {
                context.addError("Specifying fetches for non-entity attribute type [" + Arrays.toString(this.fetches) + "] at the " + this.getLocation() + " is not allowed!");
            } else {
                for (i = 0; i < this.fetches.length; ++i) {
                    String fetch = this.fetches[i];
                    String errorLocation = this.fetches.length == 1 ? "the fetch expression" : "the " + (i + 1) + ". fetch expression";
                    visitor.clear();
                    try {
                        context.getExpressionFactory().createPathExpression(fetch).accept((Expression.Visitor)visitor);
                        continue;
                    }
                    catch (SyntaxErrorException ex) {
                        try {
                            context.getExpressionFactory().createSimpleExpression(fetch, false, false, true);
                            context.addError("Invalid fetch expression '" + fetch + "' of the " + this.getLocation() + ". Simplify the fetch expression to a simple path expression. Encountered error: " + ex.getMessage());
                        }
                        catch (SyntaxErrorException ex2) {
                            context.addError("Syntax error in " + errorLocation + " '" + fetch + "' of the " + this.getLocation() + ": " + ex.getMessage());
                        }
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        context.addError("An error occurred while trying to resolve the " + errorLocation + " '" + fetch + "' of the " + this.getLocation() + ": " + ex.getMessage());
                    }
                }
            }
        }
        if (this.limitExpression != null) {
            Expression inItemExpression;
            try {
                inItemExpression = context.getTypeValidationExpressionFactory().createInItemExpression(this.limitExpression);
                if (!(inItemExpression instanceof ParameterExpression) && !(inItemExpression instanceof NumericLiteral) || inItemExpression instanceof NumericLiteral && ((NumericLiteral)inItemExpression).getNumericType() != NumericType.INTEGER) {
                    context.addError("Syntax error in the limit expression '" + this.limitExpression + "' of the " + this.getLocation() + ": The expression must be a integer literal or a parameter expression");
                }
            }
            catch (SyntaxErrorException ex) {
                context.addError("Syntax error in the limit expression '" + this.limitExpression + "' of the " + this.getLocation() + ": " + ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                context.addError("An error occurred while trying to resolve the limit expression '" + this.limitExpression + "' of the " + this.getLocation() + ": " + ex.getMessage());
            }
            try {
                inItemExpression = context.getTypeValidationExpressionFactory().createInItemExpression(this.offsetExpression);
                if (!(inItemExpression instanceof ParameterExpression) && !(inItemExpression instanceof NumericLiteral) || inItemExpression instanceof NumericLiteral && ((NumericLiteral)inItemExpression).getNumericType() != NumericType.INTEGER) {
                    context.addError("Syntax error in the offset expression '" + this.offsetExpression + "' of the " + this.getLocation() + ": The expression must be a integer literal or a parameter expression");
                }
            }
            catch (SyntaxErrorException ex) {
                context.addError("Syntax error in the offset expression '" + this.offsetExpression + "' of the " + this.getLocation() + ": " + ex.getMessage());
            }
            catch (IllegalArgumentException ex) {
                context.addError("An error occurred while trying to resolve the offset expression '" + this.offsetExpression + "' of the " + this.getLocation() + ": " + ex.getMessage());
            }
            for (i = 0; i < this.orderByItems.size(); ++i) {
                OrderByItem orderByItem = this.orderByItems.get(i);
                String expression = orderByItem.getExpression();
                try {
                    visitor.clear();
                    context.getTypeValidationExpressionFactory().createSimpleExpression(expression, false, false, true).accept((Expression.Visitor)visitor);
                    continue;
                }
                catch (SyntaxErrorException ex) {
                    context.addError("Syntax error in the " + (i + 1) + "th order by expression '" + expression + "' of the " + this.getLocation() + ": " + ex.getMessage());
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    context.addError("An error occurred while trying to resolve the " + (i + 1) + "th order by expression '" + expression + "' of the " + this.getLocation() + ": " + ex.getMessage());
                }
            }
        }
        if (this.fetchStrategy == FetchStrategy.MULTISET) {
            if (this.getElementType() instanceof ManagedViewTypeImplementor && ((ManagedViewTypeImplementor)this.getElementType()).hasJpaManagedAttributes()) {
                context.addError("Using the MULTISET fetch strategy is not allowed when the subview contains attributes with entity types. MULTISET at the " + this.getLocation() + " is not allowed!");
            } else if (this.getElementType() instanceof BasicTypeImpl && ((BasicTypeImpl)this.getElementType()).isJpaManaged()) {
                context.addError("Using the MULTISET fetch strategy is not allowed with entity types. MULTISET at the " + this.getLocation() + " is not allowed!");
            }
        }
        Expression indexExpression = null;
        if (this.isCollection()) {
            elementType = this.getElementType().getJavaType();
            if (!this.isUpdatable()) {
                if (this.isIndexed()) {
                    if (this.getCollectionType() == PluralAttribute.CollectionType.MAP) {
                        expressionType = Collection.class;
                        keyType = this.getKeyType().getJavaType();
                    } else {
                        expressionType = Collection.class;
                        keyType = Integer.class;
                    }
                } else {
                    expressionType = Collection.class;
                }
            }
            if (this.isIndexed()) {
                if (this.getCollectionType() == PluralAttribute.CollectionType.MAP) {
                    indexExpression = this.getKeyMappingExpression();
                    Object[] keyFetches = this.getKeyFetches();
                    if (keyFetches.length != 0) {
                        ManagedType managedKeyType = context.getEntityMetamodel().getManagedType(this.getKeyType().getJavaType());
                        if (managedKeyType == null) {
                            context.addError("Specifying key fetches for non-entity attribute key type [" + Arrays.toString(keyFetches) + "] at the " + this.getLocation() + " is not allowed!");
                        } else {
                            ScalarTargetResolvingExpressionVisitor keyVisitor = new ScalarTargetResolvingExpressionVisitor(managedKeyType, context.getEntityMetamodel(), context.getJpqlFunctions(), this.declaringType.getEntityViewRootTypes());
                            for (int i2 = 0; i2 < keyFetches.length; ++i2) {
                                Object fetch = keyFetches[i2];
                                String errorLocation = keyFetches.length == 1 ? "the key fetch expression" : "the " + (i2 + 1) + ". key fetch expression";
                                keyVisitor.clear();
                                try {
                                    context.getExpressionFactory().createPathExpression((String)fetch).accept((Expression.Visitor)keyVisitor);
                                    continue;
                                }
                                catch (SyntaxErrorException ex) {
                                    try {
                                        context.getExpressionFactory().createSimpleExpression((String)fetch, false, false, true);
                                        context.addError("Invalid key fetch expression '" + (String)fetch + "' of the " + this.getLocation() + ". Simplify the key fetch expression to a simple path expression. Encountered error: " + ex.getMessage());
                                    }
                                    catch (SyntaxErrorException ex2) {
                                        context.addError("Syntax error in " + errorLocation + " '" + (String)fetch + "' of the " + this.getLocation() + ": " + ex.getMessage());
                                    }
                                    continue;
                                }
                                catch (IllegalArgumentException ex) {
                                    context.addError("An error occurred while trying to resolve the " + errorLocation + " '" + (String)fetch + "' of the " + this.getLocation() + ": " + ex.getMessage());
                                }
                            }
                        }
                    }
                } else {
                    indexExpression = this.getMappingIndexExpression();
                }
            }
        }
        if (this.isSubview()) {
            ManagedViewTypeImplementor subviewType = (ManagedViewTypeImplementor)this.getElementType();
            if (this.isCollection()) {
                elementType = subviewType.getEntityClass();
            } else {
                expressionType = subviewType.getEntityClass();
            }
        } else {
            Class elementJavaType = this.getElementType().getJavaType();
            if ((elementJavaType.getModifiers() & 0x400) != 0 && !this.isQueryParameter() && AnnotationUtils.findAnnotation((Class)elementJavaType, EntityView.class) != null && this.getElementType().getConvertedType() == null) {
                context.addError("The element type '" + elementJavaType.getName() + "' is considered basic although the class is annotated with @EntityView. Add a type converter or add the java class to the entity view configuration! Problematic attribute " + this.getLocation());
            }
        }
        if (this.isKeySubview()) {
            keyType = ((ManagedViewTypeImplementor)this.getKeyType()).getEntityClass();
        }
        if (keyType != null) {
            AbstractAttribute.validateTypesCompatible(this.possibleIndexTargetTypes, keyType, null, this.isUpdatable(), true, context, ExpressionLocation.MAPPING_INDEX, this.getLocation());
        }
        if (this.isCorrelated()) {
            AbstractAttribute.validateTypesCompatible(managedType, this.correlationBasisExpression, Object.class, null, false, true, this.declaringType.getEntityViewRootTypes(), context, ExpressionLocation.CORRELATION_BASIS, this.getLocation());
            if (this.correlated != null) {
                AbstractAttribute.validateTypesCompatible(this.possibleTargetTypes, expressionType, elementType, false, !this.isCollection(), context, ExpressionLocation.CORRELATION_RESULT, this.getLocation());
                Predicate correlationPredicate = this.getCorrelationPredicate();
                if (correlationPredicate != null) {
                    ExpressionFactory ef = context.getTypeValidationExpressionFactory();
                    PrefixingQueryGenerator prefixingQueryGenerator = new PrefixingQueryGenerator(ef, this.correlationKeyAlias, null, null, this.declaringType.getEntityViewRootTypes().keySet(), false, false);
                    prefixingQueryGenerator.setQueryBuffer(new StringBuilder());
                    this.correlationBasisExpression.accept((Expression.Visitor)prefixingQueryGenerator);
                    AliasReplacementVisitor aliasReplacementVisitor = new AliasReplacementVisitor(ef.createSimpleExpression(prefixingQueryGenerator.getQueryBuffer().toString()), this.correlationKeyAlias);
                    correlationPredicate = correlationPredicate.copy(ExpressionCopyContext.EMPTY);
                    correlationPredicate.accept((Expression.ResultVisitor)aliasReplacementVisitor);
                    try {
                        HashMap rootTypes = new HashMap(this.declaringType.getEntityViewRootTypes());
                        rootTypes.put(this.correlationKeyAlias, (jakarta.persistence.metamodel.Type<?>)managedType);
                        ScalarTargetResolvingExpressionVisitor correlationVisitor = new ScalarTargetResolvingExpressionVisitor(this.correlated, context.getEntityMetamodel(), context.getJpqlFunctions(), rootTypes);
                        correlationPredicate.accept((Expression.Visitor)correlationVisitor);
                    }
                    catch (SyntaxErrorException ex) {
                        context.addError("Syntax error in the condition expression '" + correlationPredicate + "' of the " + this.getLocation() + ": " + ex.getMessage());
                    }
                    catch (IllegalArgumentException ex) {
                        context.addError("An error occurred while trying to resolve the condition expression '" + correlationPredicate + "' of the " + this.getLocation() + ": " + ex.getMessage());
                    }
                }
            }
        } else if (this.isSubquery()) {
            if (this.subqueryExpression != null && !this.subqueryExpression.isEmpty() && this.getElementType().getConvertedType() == null) {
                AbstractAttribute.validateTypesCompatible(this.possibleTargetTypes, expressionType, elementType, false, !this.isCollection(), context, ExpressionLocation.SUBQUERY_EXPRESSION, this.getLocation());
            }
        } else if (!this.isQueryParameter()) {
            if (!this.isCollection() && (Collection.class.isAssignableFrom(expressionType) || Map.class.isAssignableFrom(expressionType))) {
                Class[] typeArguments = this.getTypeArguments();
                elementType = typeArguments[typeArguments.length - 1];
            }
            if (this.getElementType().getConvertedType() == null) {
                AbstractAttribute.validateTypesCompatible(this.possibleTargetTypes, expressionType, elementType, this.isUpdatable(), !this.isCollection(), context, ExpressionLocation.MAPPING, this.getLocation());
            }
            if (this.isMutable() && (this.declaringType.isUpdatable() || this.declaringType.isCreatable())) {
                UpdatableExpressionVisitor updatableVisitor = new UpdatableExpressionVisitor(context.getEntityMetamodel(), managedType.getJavaType(), this.isUpdatable(), this.declaringType.getEntityViewRootTypes());
                try {
                    this.mappingExpression.accept((Expression.Visitor)updatableVisitor);
                    Map<Attribute<?, ?>, jakarta.persistence.metamodel.Type<?>> possibleTargets = updatableVisitor.getPossibleTargets();
                    if (possibleTargets.size() > 1) {
                        context.addError("Multiple possible target type for the mapping in the " + this.getLocation() + ": " + possibleTargets);
                    }
                    if (this.isDisallowOwnedUpdatableSubview()) {
                        for (Type<?> updateCascadeAllowedSubtype : this.getUpdateCascadeAllowedSubtypes()) {
                            ManagedViewType managedViewType = (ManagedViewType)updateCascadeAllowedSubtype;
                            if (!managedViewType.isUpdatable()) continue;
                            context.addError("Invalid use of @UpdatableEntityView type '" + managedViewType.getJavaType().getName() + "' for the " + this.getLocation() + ". Consider using a read-only view type instead or use @AllowUpdatableEntityViews! For further information on this topic, please consult the documentation https://persistence.blazebit.com/documentation/entity-view/manual/en_US/index.html#updatable-mappings-subview");
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    context.addError("There is an error for the " + this.getLocation() + ": " + ex.getMessage());
                }
                if (this.isUpdatable() && this.isCollection() && this.getElementCollectionType() != null) {
                    context.addError("The use of a multi-collection i.e. List<Collection<?>> or Map<?, Collection<?>> at the " + this.getLocation() + " is unsupported for updatable collections!");
                }
                if ((this.isUpdatable() || this.isKeySubview() && ((ManagedViewTypeImplementor)this.getKeyType()).isUpdatable()) && indexExpression != null) {
                    boolean invalid;
                    if (this.getCollectionType() == PluralAttribute.CollectionType.MAP) {
                        invalid = !(indexExpression instanceof MapKeyExpression) || !THIS.equals(((MapKeyExpression)indexExpression).getPath().getPath());
                    } else {
                        boolean bl = invalid = !(indexExpression instanceof ListIndexExpression) || !THIS.equals(((ListIndexExpression)indexExpression).getPath().getPath());
                    }
                    if (invalid) {
                        context.addError("The @MappingIndex at the " + this.getLocation() + " is a complex mapping and can thus not be updatable!");
                    }
                }
            }
        }
    }

    protected abstract boolean isDisallowOwnedUpdatableSubview();

    public void checkNestedAttribute(List<AbstractAttribute<?, ?>> parents, ManagedType<?> managedType, MetamodelBuildingContext context, boolean hasMultisetParent) {
        if (hasMultisetParent) {
            if (!this.isQueryParameter()) {
                if (this.getElementType() instanceof BasicTypeImpl) {
                    context.checkMultisetSupport(parents, this, ((BasicTypeImpl)this.getElementType()).getUserType());
                }
                if (this.getKeyType() instanceof BasicTypeImpl) {
                    context.checkMultisetSupport(parents, this, ((BasicTypeImpl)this.getKeyType()).getUserType());
                }
            }
        } else if (this.fetchStrategy == FetchStrategy.MULTISET) {
            hasMultisetParent = true;
            if (!this.isQueryParameter()) {
                if (this.getElementType() instanceof BasicTypeImpl) {
                    context.checkMultisetSupport(this, ((BasicTypeImpl)this.getElementType()).getUserType());
                }
                if (this.getKeyType() instanceof BasicTypeImpl) {
                    context.checkMultisetSupport(this, ((BasicTypeImpl)this.getKeyType()).getUserType());
                }
            }
        }
        if (!parents.isEmpty() && this.getDeclaringType().getMappingType() == Type.MappingType.FLAT_VIEW && this.isCollection() && this.getFetchStrategy() == FetchStrategy.JOIN) {
            for (int i = parents.size() - 1; i >= 0; --i) {
                AbstractAttribute<?, ?> parentAttribute = parents.get(i);
                if (parentAttribute.isCollection() && !parentAttribute.isIndexed()) {
                    String path = parents.get(0).getDeclaringType().getJavaType().getName();
                    for (i = 0; i < parents.size(); ++i) {
                        path = path + " > " + parents.get(i).getLocation();
                    }
                    context.addError("Illegal mapping of join fetched collection for the " + this.getLocation() + " via the path: " + path + ". Join fetched collections in flat views are only allowed for when the flat view is contained in an indexed collections or in a view.");
                    break;
                }
                if (parentAttribute.getDeclaringType().getMappingType() == Type.MappingType.VIEW) break;
            }
        }
        if (this.isSubview()) {
            Map<ManagedViewTypeImplementor<?>, String> inheritanceSubtypeMappings = this.elementInheritanceSubtypeMappings();
            if (inheritanceSubtypeMappings.isEmpty()) {
                context.addError("Illegal empty inheritance subtype mappings for the " + this.getLocation() + ". Remove the @MappingInheritance annotation, set the 'onlySubtypes' attribute to false or add a @MappingInheritanceSubtype element!");
            }
            for (ManagedViewTypeImplementor<?> subviewType : inheritanceSubtypeMappings.keySet()) {
                parents.add(this);
                subviewType.checkNestedAttributes(parents, context, hasMultisetParent);
                parents.remove(parents.size() - 1);
            }
        }
        if (this.isKeySubview()) {
            Map<ManagedViewTypeImplementor<?>, String> inheritanceSubtypeMappings = this.keyInheritanceSubtypeMappings();
            if (inheritanceSubtypeMappings.isEmpty()) {
                context.addError("Illegal empty inheritance subtype mappings for the " + this.getLocation() + ". Remove the @MappingInheritance annotation, set the 'onlySubtypes' attribute to false or add a @MappingInheritanceSubtype element!");
            }
            for (ManagedViewTypeImplementor<?> subviewType : inheritanceSubtypeMappings.keySet()) {
                parents.add(this);
                subviewType.checkNestedAttributes(parents, context, hasMultisetParent);
                parents.remove(parents.size() - 1);
            }
        }
    }

    protected boolean isEmbedded() {
        return this.getDeclaringType().getMappingType() == Type.MappingType.FLAT_VIEW && THIS.equals(this.mapping);
    }

    protected abstract Class[] getTypeArguments();

    public abstract String getLocation();

    public abstract boolean isUpdatable();

    public abstract boolean isMutable();

    public abstract String getMappedBy();

    public abstract boolean isUpdateCascaded();

    public abstract Set<Type<?>> getUpdateCascadeAllowedSubtypes();

    protected abstract boolean isIndexed();

    protected abstract boolean isSorted();

    protected abstract boolean isForcedUnique();

    protected abstract boolean isElementCollectionOrdered();

    protected abstract boolean isElementCollectionSorted();

    protected abstract boolean isElementCollectionForcedUnique();

    protected abstract PluralAttribute.CollectionType getCollectionType();

    protected abstract PluralAttribute.ElementCollectionType getElementCollectionType();

    public abstract Type<?> getElementType();

    protected abstract Map<ManagedViewTypeImplementor<?>, String> elementInheritanceSubtypeMappings();

    protected String[] getKeyFetches() {
        return EMPTY;
    }

    public Expression getKeyMappingExpression() {
        return null;
    }

    public Expression getMappingIndexExpression() {
        return null;
    }

    protected abstract Type<?> getKeyType();

    protected abstract Map<ManagedViewTypeImplementor<?>, String> keyInheritanceSubtypeMappings();

    protected abstract boolean isKeySubview();

    public abstract Set<Class<?>> getAllowedSubtypes();

    public abstract Set<Class<?>> getParentRequiringUpdateSubtypes();

    public abstract Set<Class<?>> getParentRequiringCreateSubtypes();

    public abstract boolean isOptimizeCollectionActionsEnabled();

    public abstract ContainerAccumulator<?> getContainerAccumulator();

    public abstract CollectionInstantiatorImplementor<?, ?> getCollectionInstantiator();

    public abstract MapInstantiatorImplementor<?, ?> getMapInstantiator();

    protected final ContainerAccumulator<?> createValueContainerAccumulator(Comparator<Object> comparator) {
        PluralObjectFactory<NavigableSet<?>> instance;
        if (this.getElementCollectionType() == null) {
            return null;
        }
        boolean forcedUnique = false;
        switch (this.getElementCollectionType()) {
            case COLLECTION: 
            case LIST: {
                forcedUnique = this.isElementCollectionForcedUnique();
                instance = ListFactory.INSTANCE;
                break;
            }
            case SET: {
                if (!this.isElementCollectionSorted()) {
                    instance = SetFactory.INSTANCE;
                    break;
                }
            }
            case SORTED_SET: {
                if (comparator == null) {
                    instance = SortedSetFactory.INSTANCE;
                    break;
                }
                instance = new SortedSetFactory(comparator);
                comparator = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported element collection type: " + this.getElementCollectionType());
            }
        }
        if (this.isFilterNulls()) {
            return new NullFilteringCollectionAccumulator(instance, forcedUnique, comparator);
        }
        return new SimpleCollectionAccumulator(instance, forcedUnique, comparator);
    }

    protected final CollectionInstantiatorImplementor<?, ?> createCollectionInstantiator(MetamodelBuildingContext context, PluralObjectFactory<? extends Collection<?>> collectionFactory, boolean indexed, boolean sorted, boolean ordered, Comparator comparator) {
        if (indexed) {
            if (this.isForcedUnique()) {
                context.addError("Forcing uniqueness for indexed attribute is invalid at the " + this.getLocation());
            }
            if (comparator != null) {
                context.addError("Comparator can't be defined for indexed attribute at the " + this.getLocation());
            }
            return new ListCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), true, this.isOptimizeCollectionActionsEnabled(), false, context.isStrictCascadingCheck(), null);
        }
        if (sorted) {
            return new SortedSetCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck(), comparator);
        }
        if (this.getCollectionType() == PluralAttribute.CollectionType.SET) {
            if (comparator != null) {
                context.addError("Comparator can't be defined for non-sorted set attribute at the " + this.getLocation());
            }
            if (ordered) {
                return new OrderedSetCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck());
            }
            return new UnorderedSetCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck());
        }
        if (this.getCollectionType() == PluralAttribute.CollectionType.LIST) {
            return new ListCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), false, this.isOptimizeCollectionActionsEnabled(), this.isForcedUnique(), context.isStrictCascadingCheck(), comparator);
        }
        return new OrderedCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), this.isForcedUnique(), context.isStrictCascadingCheck(), comparator);
    }

    protected final MapInstantiatorImplementor<?, ?> createMapInstantiator(MetamodelBuildingContext context, PluralObjectFactory<? extends Map<?, ?>> mapFactory, boolean sorted, boolean ordered, Comparator comparator) {
        if (sorted) {
            return new SortedMapInstantiator(mapFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck(), comparator);
        }
        if (ordered) {
            return new OrderedMapInstantiator(mapFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck());
        }
        return new UnorderedMapInstantiator(mapFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck());
    }

    public final Attribute.MappingType getMappingType() {
        return this.mappingType;
    }

    public final boolean isQueryParameter() {
        return this.mappingType == Attribute.MappingType.PARAMETER;
    }

    public final boolean isId() {
        return this.id;
    }

    public final SubqueryProviderFactory getSubqueryProviderFactory() {
        return this.subqueryProviderFactory;
    }

    public final Class<? extends SubqueryProvider> getSubqueryProvider() {
        return this.subqueryProvider;
    }

    public final String getSubqueryExpression() {
        return this.subqueryExpression;
    }

    public final String getSubqueryAlias() {
        return this.subqueryAlias;
    }

    public CorrelationProviderFactory getCorrelationProviderFactory() {
        return this.correlationProviderFactory;
    }

    public final Class<? extends CorrelationProvider> getCorrelationProvider() {
        return this.correlationProvider;
    }

    public final String getCorrelationBasis() {
        return this.correlationBasis;
    }

    public final String getCorrelationResult() {
        return this.correlationResult;
    }

    public Expression getCorrelationBasisExpression() {
        return this.correlationBasisExpression;
    }

    public Expression getCorrelationResultExpression() {
        return this.correlationResultExpression;
    }

    public final FetchStrategy getFetchStrategy() {
        return this.fetchStrategy;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    public final List<OrderByItem> getOrderByItems() {
        return this.orderByItems;
    }

    public final String getLimitExpression() {
        return this.limitExpression;
    }

    public final String getOffsetExpression() {
        return this.offsetExpression;
    }

    public final String getMapping() {
        return this.mapping;
    }

    public Expression getMappingExpression() {
        return this.mappingExpression;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public final boolean isSubquery() {
        return this.mappingType == Attribute.MappingType.SUBQUERY;
    }

    public final ManagedViewTypeImplementor<X> getDeclaringType() {
        return this.declaringType;
    }

    public final Class<Y> getJavaType() {
        return this.javaType;
    }

    public Class<?> getConvertedJavaType() {
        return this.convertedJavaType;
    }

    public final String[] getFetches() {
        return this.fetches;
    }

    protected static enum ExpressionLocation {
        MAPPING("mapping expression"),
        MAPPING_INDEX("mapping index expression"),
        SUBQUERY_EXPRESSION("subquery expression"),
        CORRELATION_BASIS("correlation basis"),
        CORRELATION_RESULT("correlation result"),
        CORRELATION_EXPRESSION("correlation expression");

        private final String location;

        private ExpressionLocation(String location) {
            this.location = location;
        }

        public String toString() {
            return this.location;
        }
    }
}

