/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.LockMode;
import com.blazebit.persistence.view.ViewFilterProvider;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.SetView;
import com.blazebit.persistence.view.impl.metamodel.ViewFilterMappingImpl;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewTypeImplementor;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewFilterMapping;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class ViewTypeImpl<X>
extends ManagedViewTypeImpl<X>
implements ViewTypeImplementor<X> {
    private static final Logger LOG = Logger.getLogger(ViewTypeImpl.class.getName());
    private final String lockOwner;
    private final MethodAttribute<? super X, ?> idAttribute;
    private final MethodAttribute<? super X, ?> versionAttribute;
    private final Map<String, ViewFilterMapping> viewFilters;
    private final boolean supportsInterfaceEquals;
    private final boolean supportsUserTypeEquals;

    public ViewTypeImpl(ViewMapping viewMapping, ManagedType<?> managedType, MetamodelBuildingContext context) {
        super(viewMapping, managedType, context, null);
        if (viewMapping.getViewFilterProviders() == null) {
            this.viewFilters = Collections.emptyMap();
        } else {
            HashMap<String, ViewFilterMappingImpl> viewFilters = new HashMap<String, ViewFilterMappingImpl>();
            for (Map.Entry<String, Class<? extends ViewFilterProvider>> entry : viewMapping.getViewFilterProviders().entrySet()) {
                viewFilters.put(entry.getKey(), new ViewFilterMappingImpl(this, entry.getKey(), entry.getValue()));
            }
            this.viewFilters = Collections.unmodifiableMap(viewFilters);
        }
        this.idAttribute = viewMapping.getIdAttribute().getMethodAttribute(this, -1, -1, context, null);
        if (this.getLockMode() != LockMode.NONE) {
            this.versionAttribute = viewMapping.getVersionAttribute() != null ? viewMapping.getVersionAttribute().getMethodAttribute(this, -1, -1, context, null) : null;
            this.lockOwner = viewMapping.getLockOwner();
        } else {
            this.versionAttribute = null;
            this.lockOwner = null;
            if (viewMapping.getVersionAttribute() != null) {
                context.addError("Invalid version attribute mapping defined for managed view type '" + this.getJavaType().getName() + "'!");
            }
            if (viewMapping.getLockOwner() != null) {
                context.addError("Invalid lock owner mapping defined for managed view type '" + this.getJavaType().getName() + "'!");
            }
        }
        boolean supportsInterfaceEquals = true;
        boolean supportsUserTypeEquals = true;
        Method javaMethod = this.idAttribute.getJavaMethod();
        if (!Modifier.isPublic(javaMethod.getModifiers()) && !Objects.equals(this.getJavaType().getPackage(), javaMethod.getDeclaringClass().getPackage())) {
            supportsInterfaceEquals = false;
            supportsUserTypeEquals = false;
            LOG.warning("The method for the " + ((AbstractMethodAttribute)this.idAttribute).getLocation() + " is non-public and declared in a different package " + javaMethod.getDeclaringClass().getPackage() + " than the view type " + this.getJavaType().getName() + " which makes it impossible to allow checking for equality with user provided implementations of the view type. If you don't need that, you can ignore this warning.");
        } else if (this.getJpaManagedType().getPersistenceType() != Type.PersistenceType.ENTITY || Modifier.isAbstract(this.getJpaManagedType().getJavaType().getModifiers())) {
            supportsUserTypeEquals = false;
            LOG.warning("The view class " + this.getJavaType().getName() + " is defined for an abstract or non-entity type which is why id-based equality can't be checked on a user provided instance. If you don't need that, you can ignore this warning.");
        }
        this.supportsInterfaceEquals = supportsInterfaceEquals;
        this.supportsUserTypeEquals = supportsUserTypeEquals;
        context.finishViewType(this);
    }

    @Override
    public ViewTypeImplementor<X> getRealType() {
        return this;
    }

    @Override
    protected boolean hasId() {
        return true;
    }

    public Type.MappingType getMappingType() {
        return Type.MappingType.VIEW;
    }

    @Override
    public boolean supportsInterfaceEquals() {
        return this.supportsInterfaceEquals;
    }

    @Override
    public boolean supportsUserTypeEquals() {
        return this.supportsUserTypeEquals;
    }

    public MethodAttribute<? super X, ?> getIdAttribute() {
        return this.idAttribute;
    }

    public MethodAttribute<? super X, ?> getVersionAttribute() {
        return this.versionAttribute;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public ViewFilterMapping getViewFilter(String filterName) {
        return this.viewFilters.get(filterName);
    }

    public Set<ViewFilterMapping> getViewFilters() {
        return new SetView<ViewFilterMapping>(this.viewFilters.values());
    }
}

