/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.objectbuilder.ViewTypeObjectBuilderTemplate;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.SubviewTupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformerFactory;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.UpdatableSubviewTupleTransformer;
import java.util.Map;

public class SubviewTupleTransformerFactory
implements TupleTransformerFactory {
    private final String attributePath;
    private final ViewTypeObjectBuilderTemplate<Object[]> template;
    private final boolean updatable;
    private final boolean nullIfEmpty;

    public SubviewTupleTransformerFactory(String attributePath, ViewTypeObjectBuilderTemplate<Object[]> template, boolean updatable, boolean nullIfEmpty) {
        this.attributePath = attributePath;
        this.template = template;
        this.updatable = updatable;
        this.nullIfEmpty = nullIfEmpty;
    }

    @Override
    public int getConsumeStartIndex() {
        return this.template.getTupleOffset() + 1;
    }

    @Override
    public int getConsumeEndIndex() {
        return this.template.getTupleOffset() + this.template.getMappers().length;
    }

    @Override
    public TupleTransformer create(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, EntityViewConfiguration entityViewConfiguration) {
        ObjectBuilder<Object[]> objectBuilder = this.template.createObjectBuilder(parameterHolder, optionalParameters, entityViewConfiguration, 0, true, this.nullIfEmpty);
        if (this.updatable) {
            return new UpdatableSubviewTupleTransformer(this.template, objectBuilder, this.nullIfEmpty);
        }
        return new SubviewTupleTransformer(this.template, objectBuilder);
    }
}

