/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.BaseFromQueryBuilder;
import com.blazebit.persistence.CorrelationQueryBuilder;
import com.blazebit.persistence.FromBuilder;
import com.blazebit.persistence.FromProvider;
import com.blazebit.persistence.FullSelectCTECriteriaBuilder;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.LateralStyle;
import com.blazebit.persistence.spi.ServiceProvider;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.Limiter;
import jakarta.persistence.metamodel.EntityType;
import java.util.Map;

public class JoinCorrelationBuilder
implements CorrelationBuilder {
    private final ParameterHolder<?> parameterHolder;
    private final Map<String, Object> optionalParameters;
    private final FromBuilder<?> criteriaBuilder;
    private final String joinBase;
    private final String correlationAlias;
    private final String correlationExternalAlias;
    private final String attributePath;
    private final JoinType joinType;
    private final Limiter limiter;
    private boolean correlated;
    private Object correlationBuilder;

    public JoinCorrelationBuilder(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, FromBuilder<?> criteriaBuilder, String joinBase, String correlationAlias, String correlationExternalAlias, String attributePath, JoinType joinType, Limiter limiter) {
        this.parameterHolder = parameterHolder;
        this.optionalParameters = optionalParameters;
        this.criteriaBuilder = criteriaBuilder;
        this.joinBase = joinBase;
        this.correlationAlias = correlationAlias;
        this.correlationExternalAlias = correlationExternalAlias;
        this.attributePath = attributePath;
        this.joinType = joinType;
        this.limiter = limiter;
    }

    public <T> T getService(Class<T> serviceClass) {
        return (T)((ServiceProvider)this.criteriaBuilder).getService(serviceClass);
    }

    public FromProvider getCorrelationFromProvider() {
        return this.criteriaBuilder;
    }

    public String getCorrelationAlias() {
        return this.correlationAlias;
    }

    public void finish() {
        if (this.correlationBuilder instanceof SubqueryBuilder) {
            ((SubqueryBuilder)this.correlationBuilder).end();
        } else if (this.correlationBuilder instanceof FullSelectCTECriteriaBuilder) {
            ((FullSelectCTECriteriaBuilder)this.correlationBuilder).end();
        }
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(Class<?> entityClass) {
        if (this.correlated) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        this.correlated = true;
        if (this.limiter == null) {
            return this.criteriaBuilder.joinOn(this.joinBase, entityClass, this.correlationAlias, this.joinType);
        }
        this.checkLimitSupport();
        BaseFromQueryBuilder lateralBuilder = this.criteriaBuilder.joinLateralEntitySubquery(this.joinBase, entityClass, this.correlationExternalAlias, this.correlationAlias, this.joinType);
        this.limiter.apply(this.parameterHolder, this.optionalParameters, lateralBuilder);
        this.correlationBuilder = lateralBuilder;
        return (JoinOnBuilder)lateralBuilder.getService(JoinOnBuilder.class);
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(EntityType<?> entityType) {
        if (this.correlated) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        this.correlated = true;
        if (this.limiter == null) {
            return this.criteriaBuilder.joinOn(this.joinBase, entityType, this.correlationAlias, this.joinType);
        }
        this.checkLimitSupport();
        BaseFromQueryBuilder lateralBuilder = this.criteriaBuilder.joinLateralEntitySubquery(this.joinBase, entityType, this.correlationExternalAlias, this.correlationAlias, this.joinType);
        this.limiter.apply(this.parameterHolder, this.optionalParameters, lateralBuilder);
        this.correlationBuilder = lateralBuilder;
        return (JoinOnBuilder)lateralBuilder.getService(JoinOnBuilder.class);
    }

    public JoinOnBuilder<CorrelationQueryBuilder> correlate(String correlationPath) {
        if (this.correlated) {
            throw new IllegalArgumentException("Can not correlate with multiple entity classes!");
        }
        this.correlated = true;
        if (this.limiter == null) {
            return this.criteriaBuilder.joinOn(correlationPath, this.correlationAlias, this.joinType);
        }
        BaseFromQueryBuilder lateralBuilder = this.criteriaBuilder.joinLateralEntitySubquery(correlationPath, this.correlationExternalAlias, this.correlationAlias, this.joinType);
        this.limiter.apply(this.parameterHolder, this.optionalParameters, lateralBuilder);
        this.correlationBuilder = lateralBuilder;
        return (JoinOnBuilder)lateralBuilder.getService(JoinOnBuilder.class);
    }

    private void checkLimitSupport() {
        if (this.getService(DbmsDialect.class).getLateralStyle() == LateralStyle.NONE && !this.getService(DbmsDialect.class).supportsLimitInQuantifiedPredicateSubquery()) {
            throw new IllegalStateException("Can't limit the amount of elements for the attribute path " + this.attributePath + " because the DBMS doesn't support lateral or the use of LIMIT in quantified predicates! Use the SELECT strategy with batch size 1 if you really need this.");
        }
    }
}

