/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.update.flush;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.DeleteCriteriaBuilder;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.view.ConvertOption;
import com.blazebit.persistence.view.FlushMode;
import com.blazebit.persistence.view.FlushStrategy;
import com.blazebit.persistence.view.OptimisticLockException;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.change.DirtyChecker;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingMap;
import com.blazebit.persistence.view.impl.entity.EntityLoader;
import com.blazebit.persistence.view.impl.entity.EntityTupleizer;
import com.blazebit.persistence.view.impl.entity.FlusherBasedEntityLoader;
import com.blazebit.persistence.view.impl.entity.ReferenceEntityLoader;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.mapper.ViewMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.UpdateQueryFactory;
import com.blazebit.persistence.view.impl.update.flush.BasicAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.CompositeAttributeFetchGraphNode;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.EmbeddableAttributeFlusher;
import com.blazebit.persistence.view.impl.update.flush.FetchGraphNode;
import com.blazebit.persistence.view.impl.update.flush.PostFlushDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedAttributeCascadeDeleter;
import com.blazebit.persistence.view.impl.update.flush.UnmappedOwnerAwareDeleter;
import com.blazebit.persistence.view.impl.update.flush.VersionAttributeFlusher;
import com.blazebit.persistence.view.spi.type.BasicDirtyTracker;
import com.blazebit.persistence.view.spi.type.DirtyStateTrackable;
import com.blazebit.persistence.view.spi.type.DirtyTracker;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import com.blazebit.persistence.view.spi.type.MutableStateTrackable;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CompositeAttributeFlusher
extends CompositeAttributeFetchGraphNode<CompositeAttributeFlusher, DirtyAttributeFlusher<?, Object, Object>>
implements DirtyAttributeFlusher<CompositeAttributeFlusher, Object, Object> {
    private static final Runnable EMPTY_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final int FEATURE_SUPPORTS_QUERY_FLUSH = 1;
    private static final int FEATURE_HAS_PASS_THROUGH_FLUSHER = 2;
    private static final int FEATURE_IS_ANY_OPTIMISTIC_LOCK_PROTECTED = 4;
    private static final int FEATURE_LOAD_FOR_ENTITY_FLUSH = 8;
    private static final UnmappedAttributeCascadeDeleter[] EMPTY = new UnmappedAttributeCascadeDeleter[0];
    private final Class<?> entityClass;
    private final boolean persistable;
    private final ViewMapper<Object, Object> persistViewMapper;
    private final SingularAttribute<?, ?> jpaIdAttribute;
    private final ViewToEntityMapper viewIdMapper;
    private final AttributeAccessor viewIdAccessor;
    private final AttributeAccessor entityIdAccessor;
    private final EntityTupleizer tupleizer;
    private final EntityLoader jpaIdInstantiator;
    private final ObjectBuilder<Object> idViewBuilder;
    private final DirtyAttributeFlusher<?, Object, Object> idFlusher;
    private final VersionAttributeFlusher<Object, Object> versionFlusher;
    private final DirtyAttributeFlusher<?, Object, Object>[] fullFlushers;
    private final UnmappedAttributeCascadeDeleter[] unmappedPreRemoveCascadeDeleters;
    private final UnmappedAttributeCascadeDeleter[] unmappedPostRemoveCascadeDeleters;
    private final UnmappedOwnerAwareDeleter[] unmappedOwnerAwareCascadeDeleters;
    private final FlushMode flushMode;
    private final FlushStrategy flushStrategy;
    private final EntityLoader entityLoader;
    private final EntityLoader referenceEntityLoader;
    private final String deleteQuery;
    private final String versionedDeleteQuery;
    private final String lockOwner;
    private final int features;
    private final Object element;

    public CompositeAttributeFlusher(EntityViewManagerImpl evm, Class<?> viewType, Class<?> entityClass, ManagedType<?> managedType, boolean persistable, ViewMapper<Object, Object> persistViewMapper, SingularAttribute<?, ?> jpaIdAttribute, SingularAttribute<?, ?> viewIdMappingAttribute, AttributeAccessor entityIdAccessor, ViewToEntityMapper viewIdMapper, AttributeAccessor viewIdAccessor, EntityTupleizer tupleizer, EntityLoader jpaIdInstantiator, ObjectBuilder<Object> idViewBuilder, DirtyAttributeFlusher<?, Object, Object> idFlusher, VersionAttributeFlusher<Object, Object> versionFlusher, String lockOwner, UnmappedAttributeCascadeDeleter[] cascadeDeleteUnmappedFlushers, UnmappedAttributeCascadeDeleter[][] flusherWiseCascadeDeleteUnmappedFlushers, DirtyAttributeFlusher[] flushers, FlushMode flushMode, FlushStrategy flushStrategy) {
        super(viewType, (FetchGraphNode[])flushers, null);
        this.entityClass = entityClass;
        this.persistable = persistable;
        this.persistViewMapper = persistViewMapper;
        this.jpaIdAttribute = jpaIdAttribute;
        this.viewIdMapper = viewIdMapper;
        this.viewIdAccessor = viewIdAccessor;
        this.entityIdAccessor = entityIdAccessor;
        this.tupleizer = tupleizer;
        this.jpaIdInstantiator = jpaIdInstantiator;
        this.idViewBuilder = idViewBuilder;
        this.idFlusher = idFlusher;
        this.versionFlusher = versionFlusher;
        this.fullFlushers = flushers;
        this.unmappedPreRemoveCascadeDeleters = this.getPreRemoveFlushers(cascadeDeleteUnmappedFlushers);
        this.unmappedPostRemoveCascadeDeleters = this.getPostRemoveFlushers(cascadeDeleteUnmappedFlushers);
        this.unmappedOwnerAwareCascadeDeleters = this.getOwnerAwareDeleters(flusherWiseCascadeDeleteUnmappedFlushers);
        this.flushMode = flushMode;
        this.flushStrategy = flushStrategy;
        this.lockOwner = lockOwner;
        this.entityLoader = new FlusherBasedEntityLoader(evm, entityClass, jpaIdAttribute, viewIdMapper, entityIdAccessor, flushers);
        this.referenceEntityLoader = new ReferenceEntityLoader(evm, entityClass, jpaIdAttribute, viewIdMappingAttribute, viewIdMapper, entityIdAccessor, false);
        this.deleteQuery = this.createDeleteQuery(managedType, jpaIdAttribute);
        this.versionedDeleteQuery = this.createVersionedDeleteQuery(this.deleteQuery, versionFlusher);
        this.features = CompositeAttributeFlusher.determineFeatures(flushStrategy, flushers);
        this.element = null;
    }

    private CompositeAttributeFlusher(EntityViewManagerImpl evm, CompositeAttributeFlusher original, DirtyAttributeFlusher[] flushers, Object element, boolean persist) {
        super(original.viewType, original.attributeIndexMapping, (FetchGraphNode[])flushers, Boolean.valueOf(persist));
        this.entityClass = original.entityClass;
        this.persistable = original.persistable;
        this.persistViewMapper = original.persistViewMapper;
        this.jpaIdAttribute = original.jpaIdAttribute;
        this.viewIdMapper = original.viewIdMapper;
        this.viewIdAccessor = original.viewIdAccessor;
        this.entityIdAccessor = original.entityIdAccessor;
        this.tupleizer = original.tupleizer;
        this.jpaIdInstantiator = original.jpaIdInstantiator;
        this.idViewBuilder = original.idViewBuilder;
        this.idFlusher = original.idFlusher;
        this.fullFlushers = original.fullFlushers;
        this.unmappedPreRemoveCascadeDeleters = original.unmappedPreRemoveCascadeDeleters;
        this.unmappedPostRemoveCascadeDeleters = original.unmappedPostRemoveCascadeDeleters;
        this.unmappedOwnerAwareCascadeDeleters = original.unmappedOwnerAwareCascadeDeleters;
        this.flushMode = original.flushMode;
        this.flushStrategy = original.flushStrategy;
        this.lockOwner = original.lockOwner;
        this.entityLoader = new FlusherBasedEntityLoader(evm, this.entityClass, this.jpaIdAttribute, this.viewIdMapper, this.entityIdAccessor, flushers);
        this.referenceEntityLoader = original.referenceEntityLoader;
        this.deleteQuery = original.deleteQuery;
        int features = CompositeAttributeFlusher.determineFeatures(this.flushStrategy, flushers);
        this.element = element;
        if (original.versionFlusher == null || original.versionFlusher.getViewAttributeAccessor().getValue(element) == null) {
            this.versionedDeleteQuery = null;
            this.features = features & 0xFFFFFFFB;
        } else {
            this.versionedDeleteQuery = original.versionedDeleteQuery;
            this.features = features;
        }
        this.versionFlusher = original.versionFlusher;
    }

    private UnmappedOwnerAwareDeleter[] getOwnerAwareDeleters(UnmappedAttributeCascadeDeleter[][] flusherWiseCascadeDeleteUnmappedFlushers) {
        if (flusherWiseCascadeDeleteUnmappedFlushers == null) {
            return null;
        }
        UnmappedOwnerAwareDeleter[] preRemoveCascadeDeleteUnmappedFlushers = new UnmappedOwnerAwareDeleter[flusherWiseCascadeDeleteUnmappedFlushers.length];
        boolean hasDeleters = false;
        for (int i = 0; i < flusherWiseCascadeDeleteUnmappedFlushers.length; ++i) {
            UnmappedAttributeCascadeDeleter[] preRemoveFlushers = this.getPreRemoveFlushers(flusherWiseCascadeDeleteUnmappedFlushers[i]);
            UnmappedAttributeCascadeDeleter[] postRemoveFlushers = this.getPostRemoveFlushers(flusherWiseCascadeDeleteUnmappedFlushers[i]);
            if (preRemoveFlushers == null && postRemoveFlushers == null) {
                preRemoveCascadeDeleteUnmappedFlushers[i] = null;
                continue;
            }
            preRemoveCascadeDeleteUnmappedFlushers[i] = new UnmappedOwnerAwareDeleter(this.idFlusher, preRemoveFlushers, postRemoveFlushers);
            hasDeleters = true;
        }
        if (hasDeleters) {
            return preRemoveCascadeDeleteUnmappedFlushers;
        }
        return null;
    }

    private UnmappedAttributeCascadeDeleter[] getPreRemoveFlushers(UnmappedAttributeCascadeDeleter[] cascadeDeleteUnmappedFlushers) {
        if (cascadeDeleteUnmappedFlushers == null || cascadeDeleteUnmappedFlushers.length == 0) {
            return EMPTY;
        }
        ArrayList<UnmappedAttributeCascadeDeleter> flusherList = new ArrayList<UnmappedAttributeCascadeDeleter>(cascadeDeleteUnmappedFlushers.length);
        for (UnmappedAttributeCascadeDeleter flusher : cascadeDeleteUnmappedFlushers) {
            if (flusher.requiresDeleteCascadeAfterRemove()) continue;
            flusherList.add(flusher);
        }
        return flusherList.toArray(new UnmappedAttributeCascadeDeleter[flusherList.size()]);
    }

    private UnmappedAttributeCascadeDeleter[] getPostRemoveFlushers(UnmappedAttributeCascadeDeleter[] cascadeDeleteUnmappedFlushers) {
        if (cascadeDeleteUnmappedFlushers == null || cascadeDeleteUnmappedFlushers.length == 0) {
            return EMPTY;
        }
        ArrayList<UnmappedAttributeCascadeDeleter> flusherList = new ArrayList<UnmappedAttributeCascadeDeleter>(cascadeDeleteUnmappedFlushers.length);
        for (UnmappedAttributeCascadeDeleter flusher : cascadeDeleteUnmappedFlushers) {
            if (!flusher.requiresDeleteCascadeAfterRemove()) continue;
            flusherList.add(flusher);
        }
        return flusherList.toArray(new UnmappedAttributeCascadeDeleter[flusherList.size()]);
    }

    private String createDeleteQuery(ManagedType<?> managedType, SingularAttribute<?, ?> jpaIdAttribute) {
        if (managedType instanceof EntityType && jpaIdAttribute != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("DELETE FROM ").append(((EntityType)managedType).getName()).append(" e WHERE ");
            this.idFlusher.appendUpdateQueryFragment(null, sb, "e.", "_", " AND ");
            return sb.toString();
        }
        return null;
    }

    private String createVersionedDeleteQuery(String deleteQuery, DirtyAttributeFlusher versionFlusher) {
        if (deleteQuery != null && versionFlusher != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(deleteQuery);
            sb.append(" AND ");
            versionFlusher.appendUpdateQueryFragment(null, sb, "e.", "_", " AND ");
            return sb.toString();
        }
        return null;
    }

    private static int determineFeatures(FlushStrategy flushStrategy, DirtyAttributeFlusher[] flushers) {
        boolean hasPassThroughFlusher = false;
        boolean supportsQueryFlush = flushStrategy != FlushStrategy.ENTITY;
        boolean anyOptimisticLockProtected = false;
        boolean loadForEntityFlush = false;
        for (int i = 0; i < flushers.length; ++i) {
            DirtyAttributeFlusher f = flushers[i];
            if (f == null) continue;
            hasPassThroughFlusher = hasPassThroughFlusher || f.isPassThrough();
            supportsQueryFlush = supportsQueryFlush && f.supportsQueryFlush();
            anyOptimisticLockProtected = anyOptimisticLockProtected || f.isOptimisticLockProtected();
            loadForEntityFlush = loadForEntityFlush || f.loadForEntityFlush() && (flushStrategy == FlushStrategy.ENTITY || !f.supportsQueryFlush());
        }
        int features = 0;
        if (hasPassThroughFlusher) {
            features |= 2;
        }
        if (supportsQueryFlush) {
            features |= 1;
        }
        if (anyOptimisticLockProtected) {
            features |= 4;
        }
        if (loadForEntityFlush) {
            features |= 8;
        }
        return features;
    }

    public Class<?> getViewTypeClass() {
        return this.viewType;
    }

    public boolean hasVersionFlusher() {
        return this.versionFlusher != null;
    }

    @Override
    public Object cloneDeep(Object view, Object oldValue, Object newValue) {
        return newValue;
    }

    @Override
    public Object getNewInitialValue(UpdateContext context, Object clonedValue, Object currentValue) {
        return currentValue;
    }

    @Override
    public boolean appendUpdateQueryFragment(UpdateContext context, StringBuilder sb, String mappingPrefix, String parameterPrefix, String separator) {
        int clauseEndIndex = sb.length();
        boolean wasDirty = false;
        boolean optimisticLock = false;
        for (int i = 0; i < ((DirtyAttributeFlusher[])this.flushers).length; ++i) {
            DirtyAttributeFlusher flusher = ((DirtyAttributeFlusher[])this.flushers)[i];
            if (flusher == null) continue;
            int endIndex = sb.length();
            if (flusher.appendUpdateQueryFragment(context, sb, mappingPrefix, parameterPrefix, separator)) {
                wasDirty = true;
                optimisticLock |= flusher.isOptimisticLockProtected();
            }
            if (endIndex == sb.length()) continue;
            clauseEndIndex = sb.length();
            sb.append(separator);
        }
        if (optimisticLock && this.isOptimisticLockProtected() && this.versionFlusher != null) {
            this.versionFlusher.appendUpdateQueryFragment(context, sb, mappingPrefix, parameterPrefix, separator);
            if (clauseEndIndex != sb.length()) {
                clauseEndIndex = sb.length();
                sb.append(separator);
            }
        }
        if (clauseEndIndex + separator.length() == sb.length()) {
            sb.setLength(clauseEndIndex);
        }
        return wasDirty;
    }

    @Override
    public boolean supportsQueryFlush() {
        return (this.features & 1) != 0;
    }

    @Override
    public boolean loadForEntityFlush() {
        return (this.features & 8) != 0;
    }

    @Override
    public Query flushQuery(UpdateContext context, String parameterPrefix, UpdateQueryFactory queryFactory, Query query, Object ownerView, Object view, Object value, UnmappedOwnerAwareDeleter ownerAwareDeleter, DirtyAttributeFlusher<?, ?, ?> ownerFlusher) {
        int i;
        DirtyAttributeFlusher flusher;
        boolean shouldPersist;
        if (this.element != null) {
            value = this.element;
        } else {
            if (value == null) {
                int i2;
                if (this.idFlusher != null) {
                    return null;
                }
                context.invokePreRemove((EntityViewProxy)view);
                if (ownerAwareDeleter != null) {
                    ownerAwareDeleter.preDelete(context, (EntityViewProxy)view);
                }
                if (query == null) {
                    query = queryFactory.createUpdateQuery(context, (MutableStateTrackable)ownerView, ownerFlusher);
                }
                List deferredFlushers = null;
                for (i2 = 0; i2 < ((DirtyAttributeFlusher[])this.flushers).length; ++i2) {
                    DirtyAttributeFlusher flusher2 = ((DirtyAttributeFlusher[])this.flushers)[i2];
                    if (flusher2 == null) continue;
                    query = flusher2.flushQuery(context, parameterPrefix, queryFactory, query, ownerView, view, null, ownerAwareDeleter == null ? null : ownerAwareDeleter.getSubDeleter(flusher2), ownerFlusher);
                }
                if (deferredFlushers != null) {
                    for (i2 = 0; i2 < deferredFlushers.size(); ++i2) {
                        int index = (Integer)deferredFlushers.get(i2);
                        DirtyAttributeFlusher flusher3 = ((DirtyAttributeFlusher[])this.flushers)[index];
                        query = flusher3.flushQuery(context, parameterPrefix, queryFactory, query, ownerView, view, null, ownerAwareDeleter == null ? null : ownerAwareDeleter.getSubDeleter(flusher3), ownerFlusher);
                    }
                }
                if (ownerAwareDeleter != null) {
                    ownerAwareDeleter.postDelete(context, (EntityViewProxy)view);
                }
                context.invokePostRemove((EntityViewProxy)view);
                return query;
            }
            if (!(value instanceof MutableStateTrackable)) {
                if (query == null) {
                    query = queryFactory.createUpdateQuery(context, (MutableStateTrackable)ownerView, ownerFlusher);
                }
                for (int i3 = 0; i3 < ((DirtyAttributeFlusher[])this.flushers).length; ++i3) {
                    DirtyAttributeFlusher flusher4 = ((DirtyAttributeFlusher[])this.flushers)[i3];
                    if (flusher4 == null) continue;
                    query = flusher4.flushQuery(context, parameterPrefix, queryFactory, query, ownerView, view, flusher4.getViewAttributeAccessor().getValue(value), ownerAwareDeleter, ownerFlusher);
                }
                return query;
            }
        }
        MutableStateTrackable element = (MutableStateTrackable)value;
        if (this.idFlusher != null && (context.isRemovedObject(element) || !element.$$_hasParent() && view != value)) {
            return null;
        }
        boolean bl = shouldPersist = this.persistable && (this.persist == Boolean.TRUE || this.persist == null && element.$$_isNew());
        if (shouldPersist) {
            this.flushEntity(context, (Object)null, ownerView, value, value, (Runnable)null);
            return null;
        }
        Object[] state = element.$$_getMutableState();
        boolean optimisticLock = false;
        ArrayList<Integer> deferredFlushers = null;
        if (value instanceof DirtyStateTrackable) {
            if (this.preUpdate(context, element)) {
                Query oldQuery = query;
                query = queryFactory.createUpdateQuery(context, (MutableStateTrackable)ownerView, ownerFlusher);
                if (oldQuery != null) {
                    for (Parameter parameter : oldQuery.getParameters()) {
                        if (!oldQuery.isBound(parameter)) continue;
                        query.setParameter(parameter.getName(), oldQuery.getParameterValue(parameter));
                    }
                }
            }
            Object[] initialState = ((DirtyStateTrackable)value).$$_getInitialState();
            context.getInitialStateResetter().addState(initialState, (Object[])initialState.clone());
            if (query == null && queryFactory != null) {
                query = queryFactory.createUpdateQuery(context, (MutableStateTrackable)ownerView, ownerFlusher);
            }
            for (int i4 = 0; i4 < state.length; ++i4) {
                flusher = ((DirtyAttributeFlusher[])this.flushers)[i4];
                if (flusher == null) continue;
                if (flusher.requiresDeferredFlush(state[i4])) {
                    if (deferredFlushers == null) {
                        deferredFlushers = new ArrayList();
                    }
                    deferredFlushers.add(i4);
                    optimisticLock |= flusher.isOptimisticLockProtected();
                    continue;
                }
                optimisticLock |= flusher.isOptimisticLockProtected();
                Object newInitialValue = flusher.cloneDeep(value, initialState[i4], state[i4]);
                query = flusher.flushQuery(context, parameterPrefix, queryFactory, query, ownerView, value, state[i4], this.unmappedOwnerAwareCascadeDeleters == null ? null : this.unmappedOwnerAwareCascadeDeleters[i4], ownerFlusher);
                initialState[i4] = flusher.getNewInitialValue(context, newInitialValue, state[i4]);
            }
        } else {
            if (this.preUpdate(context, element)) {
                Query oldQuery = query;
                query = queryFactory.createUpdateQuery(context, (MutableStateTrackable)ownerView, ownerFlusher);
                if (oldQuery != null) {
                    for (Parameter parameter : oldQuery.getParameters()) {
                        if (!oldQuery.isBound(parameter)) continue;
                        query.setParameter(parameter.getName(), oldQuery.getParameterValue(parameter));
                    }
                }
            }
            if (query == null) {
                query = queryFactory.createUpdateQuery(context, (MutableStateTrackable)ownerView, ownerFlusher);
            }
            for (int i5 = 0; i5 < state.length; ++i5) {
                DirtyAttributeFlusher flusher5 = ((DirtyAttributeFlusher[])this.flushers)[i5];
                if (flusher5 == null) continue;
                if (flusher5.requiresDeferredFlush(state[i5])) {
                    if (deferredFlushers == null) {
                        deferredFlushers = new ArrayList<Integer>();
                    }
                    deferredFlushers.add(i5);
                    optimisticLock |= flusher5.isOptimisticLockProtected();
                    continue;
                }
                optimisticLock |= flusher5.isOptimisticLockProtected();
                query = flusher5.flushQuery(context, parameterPrefix, queryFactory, query, ownerView, value, state[i5], this.unmappedOwnerAwareCascadeDeleters == null ? null : this.unmappedOwnerAwareCascadeDeleters[i5], ownerFlusher);
            }
        }
        for (i = state.length; i < ((DirtyAttributeFlusher[])this.flushers).length; ++i) {
            DirtyAttributeFlusher flusher6 = ((DirtyAttributeFlusher[])this.flushers)[i];
            if (flusher6 == null) continue;
            optimisticLock |= flusher6.isOptimisticLockProtected();
            query = flusher6.flushQuery(context, parameterPrefix, queryFactory, query, ownerView, value, flusher6.getViewAttributeAccessor().getValue(value), this.unmappedOwnerAwareCascadeDeleters == null ? null : this.unmappedOwnerAwareCascadeDeleters[i], ownerFlusher);
        }
        if (optimisticLock && this.isOptimisticLockProtected() && this.versionFlusher != null) {
            context.getInitialStateResetter().addVersionedView(element, element.$$_getVersion());
            this.versionFlusher.flushQuery(context, parameterPrefix, queryFactory, query, ownerView, value, element.$$_getVersion(), null, ownerFlusher);
        }
        if (deferredFlushers != null) {
            if (value instanceof DirtyStateTrackable) {
                Object[] initialState = ((DirtyStateTrackable)value).$$_getInitialState();
                context.getInitialStateResetter().addState(initialState, (Object[])initialState.clone());
                for (int i6 = 0; i6 < deferredFlushers.size(); ++i6) {
                    int index = (Integer)deferredFlushers.get(i6);
                    DirtyAttributeFlusher flusher7 = ((DirtyAttributeFlusher[])this.flushers)[index];
                    if (flusher7 == null) continue;
                    optimisticLock |= flusher7.isOptimisticLockProtected();
                    Object newInitialValue = flusher7.cloneDeep(value, initialState[index], state[index]);
                    query = flusher7.flushQuery(context, parameterPrefix, queryFactory, query, ownerView, value, state[index], this.unmappedOwnerAwareCascadeDeleters == null ? null : this.unmappedOwnerAwareCascadeDeleters[index], ownerFlusher);
                    initialState[index] = flusher7.getNewInitialValue(context, newInitialValue, state[index]);
                }
            } else {
                for (i = 0; i < deferredFlushers.size(); ++i) {
                    int index = (Integer)deferredFlushers.get(i);
                    flusher = ((DirtyAttributeFlusher[])this.flushers)[index];
                    if (flusher == null) continue;
                    optimisticLock |= flusher.isOptimisticLockProtected();
                    query = flusher.flushQuery(context, parameterPrefix, queryFactory, query, ownerView, value, state[index], this.unmappedOwnerAwareCascadeDeleters == null ? null : this.unmappedOwnerAwareCascadeDeleters[index], ownerFlusher);
                }
            }
        }
        context.invokePostUpdate(element);
        return query;
    }

    public Object getEntityIdCopy(UpdateContext context, EntityViewProxy updatableProxy) {
        if (this.jpaIdInstantiator != null) {
            Object oldId = this.jpaIdInstantiator.toEntity(context, null, null);
            if (this.idFlusher instanceof BasicAttributeFlusher) {
                ((BasicAttributeFlusher)this.idFlusher).flushEntityComponents(context, oldId, updatableProxy.$$_getId());
            } else if (this.idFlusher instanceof EmbeddableAttributeFlusher) {
                ((EmbeddableAttributeFlusher)this.idFlusher).getViewToEntityMapper().flushToEntity(context, oldId, updatableProxy.$$_getId());
            } else {
                this.idFlusher.flushEntity(context, oldId, updatableProxy, updatableProxy.$$_getId(), updatableProxy.$$_getId(), null);
            }
            return oldId;
        }
        return updatableProxy.$$_getId();
    }

    public Object createViewIdByEntityId(Object id) {
        if (this.tupleizer == null) {
            return id;
        }
        Object[] tuple = this.tupleizer.tupleize(id);
        return this.idViewBuilder.build(tuple);
    }

    private Object determineOldId(UpdateContext context, EntityViewProxy updatableProxy, Runnable postReplaceListener) {
        if (updatableProxy.$$_getId() != null && postReplaceListener != null) {
            if (updatableProxy.$$_getId() instanceof EntityViewProxy) {
                return context.getEntityViewManager().convert(updatableProxy.$$_getId(), ((EntityViewProxy)updatableProxy.$$_getId()).$$_getEntityViewClass(), new ConvertOption[0]);
            }
            if (this.jpaIdInstantiator != null) {
                Object oldId = this.jpaIdInstantiator.toEntity(context, null, null);
                ((BasicAttributeFlusher)this.idFlusher).flushEntityComponents(context, oldId, updatableProxy.$$_getId());
                return oldId;
            }
            return updatableProxy.$$_getId();
        }
        return updatableProxy.$$_getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean flushEntity(UpdateContext context, Object entity, Object ownerView, Object view, Object value, Runnable postReplaceListener) {
        if (this.element != null) {
            value = this.element;
        }
        if (!(value instanceof MutableStateTrackable)) {
            for (int i = 0; i < ((DirtyAttributeFlusher[])this.flushers).length; ++i) {
                DirtyAttributeFlusher flusher = ((DirtyAttributeFlusher[])this.flushers)[i];
                if (flusher == null) continue;
                flusher.flushEntity(context, entity, ownerView, value, flusher.getViewAttributeAccessor().getValue(value), null);
            }
            return false;
        }
        MutableStateTrackable updatableProxy = (MutableStateTrackable)value;
        if (context.isRemovedObject(updatableProxy) || !updatableProxy.$$_hasParent() && view != value) {
            return false;
        }
        boolean shouldPersist = this.persist == Boolean.TRUE || this.persist == null && updatableProxy.$$_isNew();
        boolean doPersist = shouldPersist && this.persistable;
        Object oldId = this.determineOldId(context, (EntityViewProxy)updatableProxy, postReplaceListener);
        int parentIndex = updatableProxy.$$_getParentIndex();
        DirtyTracker parent = updatableProxy.$$_getParent();
        RecordingCollection recordingCollection = null;
        RecordingMap recordingMap = null;
        Object removedValue = null;
        HashSet<Object> removedKeys = null;
        ArrayList<Integer> afterPersistFlushers = null;
        ArrayList<Integer> deferredFlushers = null;
        boolean successful = false;
        try {
            Object id = updatableProxy.$$_getId();
            if (doPersist) {
                if (!this.entityClass.isInstance(entity)) {
                    entity = this.entityLoader.toEntity(context, null, null);
                }
                context.invokePrePersist(updatableProxy, entity);
                if (parent != null) {
                    if (parent instanceof RecordingCollection && ((recordingCollection = (RecordingCollection)parent).isHashBased() || this.persistViewMapper != null)) {
                        if (recordingCollection.getCurrentIterator() == null) {
                            recordingCollection.getDelegate().remove(updatableProxy);
                        } else {
                            recordingCollection.getCurrentIterator().replace();
                        }
                    } else if (parent instanceof RecordingMap && (this.persistViewMapper != null || updatableProxy.$$_getParentIndex() == 1 && (recordingMap = (RecordingMap)parent).isHashBased())) {
                        recordingMap = (RecordingMap)parent;
                        if (updatableProxy.$$_getParentIndex() == 1) {
                            removedValue = recordingMap.getCurrentIterator() == null ? (Object)recordingMap.getDelegate().remove(updatableProxy) : (Object)recordingMap.getCurrentIterator().replace();
                        } else {
                            if (removedKeys == null) {
                                removedKeys = new HashSet<Object>();
                            }
                            if (recordingMap.getCurrentIterator() == null) {
                                for (Map.Entry entry : recordingMap.getDelegate().entrySet()) {
                                    if (!entry.getValue().equals(updatableProxy)) continue;
                                    removedKeys.add(entry.getKey());
                                }
                            } else {
                                recordingMap.getCurrentIterator().replaceValue(removedKeys);
                            }
                        }
                    }
                }
                if (postReplaceListener != null) {
                    postReplaceListener.run();
                }
                if (id != null) {
                    this.idFlusher.flushEntity(context, entity, ownerView, updatableProxy, id, null);
                }
                context.getInitialStateResetter().addUpdatedView(updatableProxy);
            } else {
                if ((this.loadForEntityFlush() || this.viewIdAccessor == null) && !this.entityClass.isInstance(entity)) {
                    entity = this.entityLoader.toEntity(context, view, id);
                }
                this.preUpdate(context, updatableProxy);
            }
            Object[] state = updatableProxy.$$_getMutableState();
            boolean wasDirty = false;
            boolean optimisticLock = false;
            if (updatableProxy instanceof DirtyStateTrackable) {
                Object[] initialState = ((DirtyStateTrackable)updatableProxy).$$_getInitialState();
                context.getInitialStateResetter().addState(initialState, (Object[])initialState.clone());
                for (int i = 0; i < state.length; ++i) {
                    DirtyAttributeFlusher flusher = ((DirtyAttributeFlusher[])this.flushers)[i];
                    if (flusher == null) continue;
                    if (doPersist && flusher.requiresFlushAfterPersist(state[i])) {
                        if (afterPersistFlushers == null) {
                            afterPersistFlushers = new ArrayList();
                        }
                        afterPersistFlushers.add(i);
                        wasDirty = true;
                        optimisticLock |= flusher.isOptimisticLockProtected();
                        continue;
                    }
                    if (flusher.requiresDeferredFlush(state[i])) {
                        if (deferredFlushers == null) {
                            deferredFlushers = new ArrayList();
                        }
                        deferredFlushers.add(i);
                        wasDirty = true;
                        optimisticLock |= flusher.isOptimisticLockProtected();
                        continue;
                    }
                    Object newInitialValue = flusher.cloneDeep(value, initialState[i], state[i]);
                    if (flusher.flushEntity(context, entity, ownerView, value, state[i], null)) {
                        wasDirty = true;
                        optimisticLock |= flusher.isOptimisticLockProtected();
                    }
                    initialState[i] = flusher.getNewInitialValue(context, newInitialValue, state[i]);
                }
            } else {
                for (int i = 0; i < state.length; ++i) {
                    DirtyAttributeFlusher flusher = ((DirtyAttributeFlusher[])this.flushers)[i];
                    if (flusher == null) continue;
                    if (doPersist && flusher.requiresFlushAfterPersist(state[i])) {
                        if (afterPersistFlushers == null) {
                            afterPersistFlushers = new ArrayList<Integer>();
                        }
                        afterPersistFlushers.add(i);
                        wasDirty = true;
                        optimisticLock |= flusher.isOptimisticLockProtected();
                        continue;
                    }
                    if (flusher.requiresDeferredFlush(state[i])) {
                        if (deferredFlushers == null) {
                            deferredFlushers = new ArrayList<Integer>();
                        }
                        deferredFlushers.add(i);
                        wasDirty = true;
                        optimisticLock |= flusher.isOptimisticLockProtected();
                        continue;
                    }
                    if (!flusher.flushEntity(context, entity, ownerView, value, state[i], null)) continue;
                    wasDirty = true;
                    optimisticLock |= flusher.isOptimisticLockProtected();
                }
            }
            for (int i = state.length; i < ((DirtyAttributeFlusher[])this.flushers).length; ++i) {
                DirtyAttributeFlusher flusher = ((DirtyAttributeFlusher[])this.flushers)[i];
                if (flusher == null || !flusher.flushEntity(context, entity, ownerView, value, flusher.getViewAttributeAccessor().getValue(value), null)) continue;
                wasDirty = true;
                optimisticLock |= flusher.isOptimisticLockProtected();
            }
            if (this.versionFlusher != null && this.isOptimisticLockProtected() && optimisticLock) {
                context.getInitialStateResetter().addVersionedView(updatableProxy, updatableProxy.$$_getVersion());
                if (!this.entityClass.isInstance(entity)) {
                    entity = this.entityLoader.toEntity(context, view, id);
                }
                this.versionFlusher.flushEntity(context, entity, ownerView, value, updatableProxy.$$_getVersion(), null);
            }
            if (deferredFlushers != null) {
                this.deferredFlushEntity(context, entity, ownerView, updatableProxy, deferredFlushers);
            }
            if (doPersist) {
                context.getEntityManager().persist(entity);
                id = this.createViewIdByEntityId(this.entityLoader.getEntityId(context, entity));
                this.viewIdAccessor.setValue(updatableProxy, id);
            }
            successful = true;
            boolean bl = wasDirty;
            return bl;
        }
        finally {
            int newObjectIndex = -1;
            if (shouldPersist) {
                newObjectIndex = this.idFlusher == null ? context.getInitialStateResetter().addPersistedView(updatableProxy) : context.getInitialStateResetter().addPersistedView(updatableProxy, oldId);
                if (successful && afterPersistFlushers != null) {
                    this.deferredFlushEntity(context, entity, ownerView, updatableProxy, afterPersistFlushers);
                }
            } else if (successful && afterPersistFlushers != null) {
                this.deferredFlushEntity(context, entity, ownerView, updatableProxy, afterPersistFlushers);
            }
            Object newObject = null;
            if (doPersist) {
                newObject = updatableProxy;
                if (this.persistViewMapper != null) {
                    newObject = this.persistViewMapper.map(newObject, context.getEntityViewManager().getOptionalParameters());
                    context.getInitialStateResetter().addPersistedViewNewObject(newObjectIndex, newObject);
                }
                if (recordingCollection != null && (recordingCollection.isHashBased() || this.persistViewMapper != null)) {
                    this.resetParents(updatableProxy, parentIndex, parent, newObject);
                    if (recordingCollection.getCurrentIterator() == null) {
                        recordingCollection.getDelegate().add(newObject);
                    } else {
                        recordingCollection.getCurrentIterator().add((MutableStateTrackable)newObject);
                    }
                } else if (recordingMap != null && (this.persistViewMapper != null || updatableProxy.$$_getParentIndex() == 1 && recordingMap.isHashBased())) {
                    this.resetParents(updatableProxy, parentIndex, parent, newObject);
                    if (updatableProxy.$$_getParentIndex() == 1) {
                        if (recordingMap.getCurrentIterator() == null) {
                            recordingMap.getDelegate().put(newObject, removedValue);
                        } else {
                            recordingMap.getCurrentIterator().add((MutableStateTrackable)newObject, removedValue);
                        }
                    } else {
                        for (Object e : removedKeys) {
                            if (recordingMap.getCurrentIterator() == null) {
                                recordingMap.getDelegate().put(e, newObject);
                                continue;
                            }
                            recordingMap.getCurrentIterator().add(e, (MutableStateTrackable)newObject);
                        }
                    }
                } else if (parent != null && this.persistViewMapper != null) {
                    ((MutableStateTrackable)parent).$$_getMutableState()[parentIndex] = newObject;
                    updatableProxy.$$_unsetParent();
                }
                context.invokePostPersist(updatableProxy, entity);
            } else {
                context.invokePostUpdate(updatableProxy);
            }
        }
    }

    private boolean preUpdate(UpdateContext context, MutableStateTrackable element) {
        long[] dirtyMask = context.getInitialStateResetter().addUpdatedView(element);
        boolean ranPreUpdate = context.invokePreUpdate(element);
        if (ranPreUpdate && this.fullFlushers != this.flushers && element.$$_getSimpleDirty() != 0L) {
            dirtyMask[0] = dirtyMask[0] | element.$$_getSimpleDirty();
            element.$$_setDirty(dirtyMask);
            this.updateFlushers(context, element, (DirtyAttributeFlusher[])this.flushers);
            element.$$_resetDirty();
            return true;
        }
        return false;
    }

    private void resetParents(MutableStateTrackable updatableProxy, int parentIndex, DirtyTracker parent, Object newObject) {
        ArrayList readOnlyParents = updatableProxy.$$_getReadOnlyParents();
        if (newObject != updatableProxy) {
            Object newReadOnlyParent = null;
            if (newObject instanceof BasicDirtyTracker) {
                ((BasicDirtyTracker)newObject).$$_setParent((BasicDirtyTracker)parent, parentIndex);
                if (newObject instanceof MutableStateTrackable && readOnlyParents != null) {
                    newReadOnlyParent = newObject;
                }
            }
            if (readOnlyParents != null) {
                readOnlyParents = new ArrayList(readOnlyParents);
                for (int i = 0; i < readOnlyParents.size(); i += 2) {
                    ((DirtyTracker)readOnlyParents.get(i)).$$_replaceAttribute((Object)updatableProxy, ((Integer)readOnlyParents.get(i + 1)).intValue(), newReadOnlyParent);
                }
            }
            updatableProxy.$$_unsetParent();
        }
    }

    private void deferredFlushEntity(UpdateContext context, Object entity, Object ownerView, MutableStateTrackable updatableProxy, List<Integer> deferredFlushers) {
        Object[] state = updatableProxy.$$_getMutableState();
        if (updatableProxy instanceof DirtyStateTrackable) {
            Object[] initialState = ((DirtyStateTrackable)updatableProxy).$$_getInitialState();
            for (int i = 0; i < deferredFlushers.size(); ++i) {
                int index = deferredFlushers.get(i);
                DirtyAttributeFlusher flusher = ((DirtyAttributeFlusher[])this.flushers)[index];
                Object newInitialValue = flusher.cloneDeep(updatableProxy, initialState[index], state[index]);
                flusher.flushEntity(context, entity, ownerView, updatableProxy, state[index], null);
                initialState[index] = flusher.getNewInitialValue(context, newInitialValue, state[index]);
            }
        } else {
            for (int i = 0; i < deferredFlushers.size(); ++i) {
                int index = deferredFlushers.get(i);
                DirtyAttributeFlusher flusher = ((DirtyAttributeFlusher[])this.flushers)[index];
                flusher.flushEntity(context, entity, ownerView, updatableProxy, state[index], null);
            }
        }
    }

    @Override
    public List<PostFlushDeleter> remove(UpdateContext context, Object entity, Object view, Object value) {
        EntityViewProxy entityView = (EntityViewProxy)value;
        if (entityView instanceof MutableStateTrackable && !entityView.$$_isReference()) {
            MutableStateTrackable updatableProxy = (MutableStateTrackable)entityView;
            if (this.persistable && context.addRemovedObject(entityView) && !updatableProxy.$$_isNew()) {
                if (context.invokePreRemove(entityView)) {
                    DirtyAttributeFlusher flusher;
                    Object[] state = updatableProxy.$$_getMutableState();
                    ArrayList<PostFlushDeleter> postFlushDeleters = new ArrayList<PostFlushDeleter>();
                    for (int i = 0; i < state.length; ++i) {
                        flusher = ((DirtyAttributeFlusher[])this.flushers)[i];
                        if (flusher == null || flusher.requiresDeleteCascadeAfterRemove()) continue;
                        postFlushDeleters.addAll(flusher.remove(context, entity, entityView, state[i]));
                    }
                    this.remove(context, entity, updatableProxy, updatableProxy, updatableProxy.$$_getId(), updatableProxy.$$_getVersion(), false);
                    for (PostFlushDeleter postFlushDeleter : postFlushDeleters) {
                        postFlushDeleter.execute(context);
                    }
                    for (int i = 0; i < state.length; ++i) {
                        flusher = ((DirtyAttributeFlusher[])this.flushers)[i];
                        if (flusher == null || !flusher.requiresDeleteCascadeAfterRemove()) continue;
                        flusher.remove(context, entity, entityView, state[i]);
                    }
                } else {
                    context.removeRemovedObject(entityView);
                    context.getEntityViewManager().update(context, (Object)entityView);
                }
            }
        } else if (context.addRemovedObject(entityView)) {
            if (context.invokePreRemove(entityView)) {
                this.remove(context, entity, entityView, entityView, entityView.$$_getId(), entityView.$$_getVersion(), true);
            } else {
                context.removeRemovedObject(entityView);
                context.getEntityViewManager().update(context, (Object)entityView);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void remove(UpdateContext context, Object viewId) {
        EntityViewProxy reference = (EntityViewProxy)context.getEntityViewManager().getReference(this.viewType, viewId);
        if (context.invokePreRemove(reference)) {
            this.remove(context, null, null, reference, viewId, null, true);
        }
    }

    @Override
    public void removeFromEntity(UpdateContext context, Object entity) {
        throw new UnsupportedOperationException();
    }

    private boolean remove(UpdateContext context, Object entity, Object ownerView, Object view, Object viewId, Object version, boolean cascadeMappedDeletes) {
        block31: {
            DirtyAttributeFlusher flusher;
            block30: {
                DirtyAttributeFlusher flusher2;
                int i;
                if (view != null) {
                    context.getInitialStateResetter().addRemovedView((EntityViewProxy)view);
                }
                if (this.flushStrategy != FlushStrategy.ENTITY) break block30;
                if (entity == null) {
                    entity = this.referenceEntityLoader.toEntity(context, view, viewId);
                }
                if (version != null && this.versionFlusher != null) {
                    this.versionFlusher.remove(context, entity, null, version);
                }
                boolean hasAfterRemoveFlusher = false;
                if (cascadeMappedDeletes) {
                    for (i = 0; i < ((DirtyAttributeFlusher[])this.flushers).length; ++i) {
                        flusher2 = ((DirtyAttributeFlusher[])this.flushers)[i];
                        if (flusher2 == null) continue;
                        if (flusher2.requiresDeleteCascadeAfterRemove()) {
                            hasAfterRemoveFlusher = true;
                            continue;
                        }
                        flusher2.removeFromEntity(context, entity);
                    }
                }
                if (hasAfterRemoveFlusher && context.getEntityViewManager().getJpaProvider().supportsProxyRemove()) {
                    context.getEntityViewManager().getJpaProvider().initialize(entity);
                }
                context.getEntityManager().remove(entity);
                context.invokePostRemove((EntityViewProxy)view);
                if (!cascadeMappedDeletes) break block31;
                for (i = 0; i < ((DirtyAttributeFlusher[])this.flushers).length; ++i) {
                    flusher2 = ((DirtyAttributeFlusher[])this.flushers)[i];
                    if (flusher2 == null || !flusher2.requiresDeleteCascadeAfterRemove()) continue;
                    flusher2.removeFromEntity(context, entity);
                }
                break block31;
            }
            Object entityId = this.idFlusher instanceof EmbeddableAttributeFlusher ? ((EmbeddableAttributeFlusher)this.idFlusher).getViewToEntityMapper().applyToEntity(context, null, viewId) : viewId;
            for (int i = 0; i < this.unmappedPreRemoveCascadeDeleters.length; ++i) {
                this.unmappedPreRemoveCascadeDeleters[i].removeByOwnerId(context, entityId);
            }
            Object[] returnedValues = null;
            ArrayList<PostFlushDeleter> postFlushDeleters = new ArrayList<PostFlushDeleter>();
            if (cascadeMappedDeletes) {
                for (int i = 0; i < ((DirtyAttributeFlusher[])this.flushers).length; ++i) {
                    DirtyAttributeFlusher flusher3 = ((DirtyAttributeFlusher[])this.flushers)[i];
                    if (flusher3 == null || flusher3.requiresDeleteCascadeAfterRemove()) continue;
                    postFlushDeleters.addAll(flusher3.removeByOwnerId(context, entityId));
                }
            }
            boolean doDelete = true;
            if (cascadeMappedDeletes || this.unmappedPostRemoveCascadeDeleters.length != 0) {
                int i;
                ArrayList<String> returningAttributes = new ArrayList<String>();
                for (i = 0; i < this.unmappedPostRemoveCascadeDeleters.length; ++i) {
                    returningAttributes.add(this.unmappedPostRemoveCascadeDeleters[i].getAttributeValuePath());
                }
                if (cascadeMappedDeletes) {
                    for (i = 0; i < ((DirtyAttributeFlusher[])this.flushers).length; ++i) {
                        String elementIdAttributeName;
                        flusher = ((DirtyAttributeFlusher[])this.flushers)[i];
                        if (flusher == null || !flusher.requiresDeleteCascadeAfterRemove() || (elementIdAttributeName = ((DirtyAttributeFlusher[])this.flushers)[i].getElementIdAttributeName()) == null) continue;
                        returningAttributes.add(elementIdAttributeName);
                    }
                }
                if (!returningAttributes.isEmpty()) {
                    Object result;
                    if (context.getEntityViewManager().getDbmsDialect().supportsReturningColumns()) {
                        DeleteCriteriaBuilder cb = context.getEntityViewManager().getCriteriaBuilderFactory().delete(context.getEntityManager(), this.entityClass);
                        cb.where(this.idFlusher.getMapping()).eq(entityId);
                        if (version != null && this.isOptimisticLockProtected() && this.versionFlusher != null) {
                            cb.where(this.versionFlusher.getMapping()).eq(version);
                        }
                        result = cb.executeWithReturning(returningAttributes.toArray(new String[returningAttributes.size()]));
                        if (version != null && this.versionFlusher != null && result.getUpdateCount() != 1) {
                            throw new OptimisticLockException("The remove operation did not return the expected update count!", entity, view);
                        }
                        returnedValues = ((Tuple)result.getLastResult()).toArray();
                        doDelete = false;
                    } else {
                        CriteriaBuilder cb = context.getEntityViewManager().getCriteriaBuilderFactory().create(context.getEntityManager(), Object[].class);
                        cb.from(this.entityClass);
                        cb.where(this.idFlusher.getMapping()).eq(entityId);
                        for (String attribute : returningAttributes) {
                            cb.select(attribute);
                        }
                        result = cb.getSingleResult();
                        returnedValues = result instanceof Object[] ? (Object[])result : new Object[]{result};
                    }
                }
            }
            if (doDelete) {
                Query query;
                if (version != null && this.isOptimisticLockProtected() && this.versionFlusher != null) {
                    query = context.getEntityManager().createQuery(this.versionedDeleteQuery);
                    this.idFlusher.flushQuery(context, "_", null, query, ownerView, view, viewId, null, null);
                    this.versionFlusher.flushQueryInitialVersion(context, "_", query, view, version);
                    int updated = query.executeUpdate();
                    if (updated != 1) {
                        throw new OptimisticLockException("The remove operation did not return the expected update count!", entity, view);
                    }
                } else {
                    query = context.getEntityManager().createQuery(this.deleteQuery);
                    this.idFlusher.flushQuery(context, "_", null, query, ownerView, view, viewId, null, null);
                    query.executeUpdate();
                }
            }
            context.invokePostRemove((EntityViewProxy)view);
            for (PostFlushDeleter postFlushDeleter : postFlushDeleters) {
                postFlushDeleter.execute(context);
            }
            for (int i = 0; i < this.unmappedPostRemoveCascadeDeleters.length; ++i) {
                if (returnedValues[i] == null) continue;
                this.unmappedPostRemoveCascadeDeleters[i].removeById(context, returnedValues[i]);
            }
            if (cascadeMappedDeletes) {
                int valueIndex = this.unmappedPostRemoveCascadeDeleters.length;
                for (int i = 0; i < ((DirtyAttributeFlusher[])this.flushers).length; ++i) {
                    flusher = ((DirtyAttributeFlusher[])this.flushers)[i];
                    if (flusher == null || !flusher.requiresDeleteCascadeAfterRemove() || flusher.getElementIdAttributeName() == null) continue;
                    if (returnedValues[valueIndex] != null) {
                        flusher.remove(context, returnedValues[valueIndex]);
                    }
                    ++valueIndex;
                }
            }
        }
        return true;
    }

    public DirtyAttributeFlusher<?, Object, Object> getIdFlusher() {
        return this.idFlusher;
    }

    @Override
    public List<PostFlushDeleter> removeByOwnerId(UpdateContext context, Object id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean requiresDeleteCascadeAfterRemove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isViewOnlyDeleteCascaded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPassThrough() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getElementIdAttributeName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AttributeAccessor getViewAttributeAccessor() {
        return null;
    }

    @Override
    public AttributeAccessor getEntityAttributeAccessor() {
        return null;
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public boolean isOptimisticLockProtected() {
        return (this.features & 4) != 0;
    }

    @Override
    public boolean requiresFlushAfterPersist(Object value) {
        return false;
    }

    @Override
    public boolean requiresDeferredFlush(Object value) {
        return false;
    }

    @Override
    public DirtyAttributeFlusher<CompositeAttributeFlusher, Object, Object> getDirtyFlusher(UpdateContext context, Object view, Object initial, Object current) {
        return this;
    }

    @Override
    public <X> DirtyChecker<X>[] getNestedCheckers(Object current) {
        return (DirtyChecker[])this.flushers;
    }

    @Override
    public DirtyChecker.DirtyKind getDirtyKind(Object initial, Object current) {
        if (current == null) {
            if (initial == null) {
                return DirtyChecker.DirtyKind.NONE;
            }
            return DirtyChecker.DirtyKind.UPDATED;
        }
        if (initial == null) {
            return DirtyChecker.DirtyKind.UPDATED;
        }
        DirtyStateTrackable initialObject = (DirtyStateTrackable)initial;
        DirtyStateTrackable currentObject = (DirtyStateTrackable)current;
        if (initialObject != currentObject && !initialObject.equals(currentObject)) {
            return DirtyChecker.DirtyKind.UPDATED;
        }
        if (!currentObject.$$_isDirty()) {
            return DirtyChecker.DirtyKind.NONE;
        }
        long dirty = currentObject.$$_getSimpleDirty();
        Object[] initialState = initialObject.$$_getInitialState();
        Object[] dirtyState = currentObject.$$_getMutableState();
        for (int i = 0; i < initialState.length; ++i) {
            long mask = 1L << i;
            if ((dirty & mask) == 0L || ((DirtyAttributeFlusher[])this.flushers)[i].getDirtyKind(initialState[i], dirtyState[i]) == DirtyChecker.DirtyKind.NONE) continue;
            return DirtyChecker.DirtyKind.MUTATED;
        }
        return DirtyChecker.DirtyKind.NONE;
    }

    public <T extends DirtyAttributeFlusher<T, E, V>, E, V> DirtyAttributeFlusher<T, E, V> getNestedDirtyFlusher(UpdateContext context, MutableStateTrackable updatableProxy) {
        boolean shouldPersist;
        boolean bl = shouldPersist = updatableProxy.$$_isNew() && this.jpaIdAttribute != null;
        if (context.isForceFull() || this.flushMode == FlushMode.FULL || shouldPersist || !(updatableProxy instanceof DirtyStateTrackable)) {
            return this;
        }
        Object[] originalDirtyState = updatableProxy.$$_getMutableState();
        DirtyAttributeFlusher[] flushers = this.updateFlushers(context, updatableProxy, new DirtyAttributeFlusher[originalDirtyState.length]);
        if (flushers == null) {
            return null;
        }
        return new CompositeAttributeFlusher(context.getEntityViewManager(), this, flushers, updatableProxy, false);
    }

    private DirtyAttributeFlusher[] updateFlushers(UpdateContext context, MutableStateTrackable updatableProxy, DirtyAttributeFlusher[] flushers) {
        int i;
        Object[] initialState = ((DirtyStateTrackable)updatableProxy).$$_getInitialState();
        Object[] originalDirtyState = updatableProxy.$$_getMutableState();
        if (!updatableProxy.$$_copyDirty((Object[])this.fullFlushers, (Object[])flushers)) {
            return null;
        }
        boolean first = true;
        for (i = 0; i < originalDirtyState.length; ++i) {
            if (flushers[i] == null) continue;
            Object newState = originalDirtyState[i];
            DirtyAttributeFlusher flusher = flushers[i].getDirtyFlusher(context, updatableProxy, initialState[i], newState);
            if (flusher == null) {
                flushers[i] = null;
                continue;
            }
            flushers[i] = flusher;
            if (!first) continue;
            first = false;
        }
        if (first) {
            return null;
        }
        if ((this.features & 2) != 0) {
            for (i = originalDirtyState.length; i < flushers.length; ++i) {
                DirtyAttributeFlusher flusher = ((DirtyAttributeFlusher[])this.flushers)[i];
                if (flusher == null || !flusher.isPassThrough()) continue;
                flushers[i] = flusher;
            }
        }
        return flushers;
    }
}

