/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.impl.EntityViewListenerFactory;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.metamodel.AnnotationMappingReader;
import com.blazebit.persistence.view.impl.metamodel.MappingReader;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContextImpl;
import com.blazebit.persistence.view.impl.type.MutableBasicUserTypeRegistry;
import com.blazebit.persistence.view.spi.EntityViewConfiguration;
import com.blazebit.persistence.view.spi.EntityViewMapping;
import com.blazebit.persistence.view.spi.TransactionSupport;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import com.blazebit.persistence.view.spi.type.TypeConverter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.persistence.EntityManagerFactory;

public class EntityViewConfigurationImpl
implements EntityViewConfiguration {
    private final MutableBasicUserTypeRegistry userTypeRegistry = new MutableBasicUserTypeRegistry();
    private final MetamodelBootContext bootContext = new MetamodelBootContextImpl();
    private final MappingReader annotationMappingReader = new AnnotationMappingReader(this.bootContext);
    private final Map<Class<?>, Object> typeTestValues = new HashMap();
    private Properties properties = new Properties();
    private TransactionSupport transactionSupport;
    private Map<String, Object> optionalParameters = new HashMap<String, Object>();

    public EntityViewConfigurationImpl() {
        this.loadDefaultProperties();
    }

    private void loadDefaultProperties() {
        this.properties.put("com.blazebit.persistence.view.proxy.eager_loading", "false");
        this.properties.put("com.blazebit.persistence.view.proxy.unsafe_allowed", "true");
        this.properties.put("com.blazebit.persistence.view.managed_type_validation_disabled", "false");
        this.properties.put("com.blazebit.persistence.view.updater.disallow_owned_updatable_subview", "true");
        this.properties.put("com.blazebit.persistence.view.updater.strict_cascading_check", "true");
        this.properties.put("com.blazebit.persistence.view.updater.error_on_invalid_plural_setter", "false");
        this.properties.put("com.blazebit.persistence.view.static_builder_scanning_disabled", "false");
        this.properties.put("com.blazebit.persistence.view.static_implementation_scanning_disabled", "false");
        this.properties.put("com.blazebit.persistence.view.static_metamodel_scanning_disabled", "false");
        this.properties.put("com.blazebit.persistence.view.create_empty_flat_views", "true");
        this.typeTestValues.put(Boolean.TYPE, true);
        this.typeTestValues.put(Byte.TYPE, (byte)127);
        this.typeTestValues.put(Short.TYPE, (short)Short.MAX_VALUE);
        this.typeTestValues.put(Character.TYPE, Character.valueOf('\uffff'));
        this.typeTestValues.put(Integer.TYPE, Integer.MAX_VALUE);
        this.typeTestValues.put(Long.TYPE, Long.MAX_VALUE);
        this.typeTestValues.put(Float.TYPE, Float.valueOf(Float.MAX_VALUE));
        this.typeTestValues.put(Double.TYPE, Double.MAX_VALUE);
        this.typeTestValues.put(Boolean.class, true);
        this.typeTestValues.put(Byte.class, (byte)127);
        this.typeTestValues.put(Short.class, (short)Short.MAX_VALUE);
        this.typeTestValues.put(Character.class, Character.valueOf('\uffff'));
        this.typeTestValues.put(Integer.class, Integer.MAX_VALUE);
        this.typeTestValues.put(Long.class, Long.MAX_VALUE);
        this.typeTestValues.put(Float.class, Float.valueOf(Float.MAX_VALUE));
        this.typeTestValues.put(Double.class, Double.MAX_VALUE);
        this.typeTestValues.put(String.class, "-");
        this.typeTestValues.put(java.util.Date.class, new java.util.Date(1L));
        this.typeTestValues.put(Date.class, new Date(1L));
        this.typeTestValues.put(Time.class, new Time(1000L));
        this.typeTestValues.put(Timestamp.class, new Timestamp(1L));
        this.typeTestValues.put(Calendar.class, Calendar.getInstance());
        this.typeTestValues.put(GregorianCalendar.class, new GregorianCalendar());
        this.typeTestValues.put(TimeZone.class, TimeZone.getTimeZone("Universal"));
        this.typeTestValues.put(byte[].class, new byte[]{127});
        this.typeTestValues.put(Byte[].class, new Byte[]{(byte)127});
        this.typeTestValues.put(char[].class, new char[]{'\uffff'});
        this.typeTestValues.put(Character[].class, new Character[]{Character.valueOf('\uffff')});
        this.typeTestValues.put(BigInteger.class, BigInteger.TEN);
        this.typeTestValues.put(BigDecimal.class, BigDecimal.TEN);
        this.typeTestValues.put(Serializable.class, "-");
        this.typeTestValues.put(Class.class, EntityViewConfigurationImpl.class);
        this.typeTestValues.put(Currency.class, Currency.getInstance("XXX"));
        this.typeTestValues.put(Locale.class, new Locale("", "", ""));
        this.typeTestValues.put(UUID.class, UUID.randomUUID());
        try {
            this.typeTestValues.put(URL.class, new URL("https://blazebit.com"));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            Class<?> localDate = Class.forName("java.time.LocalDate");
            this.typeTestValues.put(localDate, localDate.getMethod("now", new Class[0]).invoke(null, new Object[0]));
            Class<?> localTime = Class.forName("java.time.LocalTime");
            this.typeTestValues.put(localTime, localTime.getMethod("now", new Class[0]).invoke(null, new Object[0]));
            Class<?> localDateTime = Class.forName("java.time.LocalDateTime");
            this.typeTestValues.put(localDateTime, localDateTime.getMethod("now", new Class[0]).invoke(null, new Object[0]));
            Class<?> offsetTime = Class.forName("java.time.OffsetTime");
            this.typeTestValues.put(offsetTime, offsetTime.getMethod("now", new Class[0]).invoke(null, new Object[0]));
            Class<?> offsetDateTime = Class.forName("java.time.OffsetDateTime");
            this.typeTestValues.put(offsetDateTime, offsetDateTime.getMethod("now", new Class[0]).invoke(null, new Object[0]));
            Class<?> zonedDateTime = Class.forName("java.time.ZonedDateTime");
            this.typeTestValues.put(zonedDateTime, zonedDateTime.getMethod("now", new Class[0]).invoke(null, new Object[0]));
            Class<?> duration = Class.forName("java.time.Duration");
            this.typeTestValues.put(duration, duration.getMethod("ofNanos", Long.TYPE).invoke(null, 1L));
            Class<?> instant = Class.forName("java.time.Instant");
            this.typeTestValues.put(instant, instant.getMethod("now", new Class[0]).invoke(null, new Object[0]));
            Class<?> monthDay = Class.forName("java.time.MonthDay");
            this.typeTestValues.put(monthDay, monthDay.getMethod("now", new Class[0]).invoke(null, new Object[0]));
            Class<?> year = Class.forName("java.time.Year");
            this.typeTestValues.put(year, year.getMethod("now", new Class[0]).invoke(null, new Object[0]));
            Class<?> yearMonth = Class.forName("java.time.YearMonth");
            this.typeTestValues.put(yearMonth, yearMonth.getMethod("now", new Class[0]).invoke(null, new Object[0]));
            Class<?> period = Class.forName("java.time.Period");
            this.typeTestValues.put(period, period.getMethod("ofDays", Integer.TYPE).invoke(null, 1));
            Class<?> zoneId = Class.forName("java.time.ZoneId");
            this.typeTestValues.put(zoneId, zoneId.getMethod("of", String.class).invoke(null, "Universal"));
            Class<?> zoneOffset = Class.forName("java.time.ZoneOffset");
            this.typeTestValues.put(zoneOffset, zoneOffset.getMethod("of", String.class).invoke(null, "+17:59:59"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public EntityViewConfiguration addEntityView(Class<?> clazz) {
        this.createEntityViewMapping(clazz);
        return this;
    }

    public EntityViewMapping createEntityViewMapping(Class<?> clazz) {
        return this.annotationMappingReader.readViewMapping(clazz);
    }

    public EntityViewConfiguration addEntityViewListener(Class<?> entityViewListenerClass) {
        for (EntityViewListenerFactory<?> viewListenerFactory : this.bootContext.createViewListenerFactories(entityViewListenerClass)) {
            this.annotationMappingReader.readViewListenerMapping(entityViewListenerClass, viewListenerFactory);
        }
        return this;
    }

    public EntityViewConfiguration addEntityViewListener(Class<?> entityViewClass, Class<?> entityViewListenerClass) {
        this.bootContext.addEntityViewListener(entityViewClass, entityViewListenerClass);
        return this;
    }

    public EntityViewConfiguration addEntityViewListener(Class<?> entityViewClass, Class<?> entityClass, Class<?> entityViewListenerClass) {
        this.bootContext.addEntityViewListener(entityViewClass, entityClass, entityViewListenerClass);
        return this;
    }

    public Set<Class<?>> getEntityViewListeners() {
        return this.bootContext.getViewListenerClasses();
    }

    public Set<Class<?>> getEntityViewListeners(Class<?> entityViewClass) {
        return this.bootContext.getViewListenerClasses(entityViewClass);
    }

    public Set<Class<?>> getEntityViewListeners(Class<?> entityViewClass, Class<?> entityClass) {
        return this.bootContext.getViewListenerClasses(entityViewClass, entityClass);
    }

    public Set<Class<?>> getEntityViews() {
        return Collections.unmodifiableSet(this.bootContext.getViewClasses());
    }

    public Collection<EntityViewMapping> getEntityViewMappings() {
        return Collections.unmodifiableCollection(this.bootContext.getViewMappings());
    }

    public <X> EntityViewConfiguration registerBasicUserType(Class<X> clazz, BasicUserType<X> userType) {
        this.userTypeRegistry.registerBasicUserType(clazz, userType);
        return this;
    }

    public <X, Y> EntityViewConfiguration registerTypeConverter(Class<X> underlyingType, Class<Y> viewModelType, TypeConverter<X, Y> converter) {
        this.userTypeRegistry.registerTypeConverter(underlyingType, viewModelType, converter);
        return this;
    }

    public Map<Class<?>, BasicUserType<?>> getBasicUserTypes() {
        return this.userTypeRegistry.getBasicUserTypes();
    }

    public Map<Class<?>, Map<Class<?>, TypeConverter<?, ?>>> getTypeConverters() {
        return this.userTypeRegistry.getTypeConverters();
    }

    public <Y> Map<Class<?>, TypeConverter<?, Y>> getTypeConverters(Class<Y> viewModelType) {
        return this.userTypeRegistry.getTypeConverter(viewModelType);
    }

    public MutableBasicUserTypeRegistry getUserTypeRegistry() {
        return this.userTypeRegistry;
    }

    public MetamodelBootContext getBootContext() {
        return this.bootContext;
    }

    public EntityViewManager createEntityViewManager(CriteriaBuilderFactory cbf) {
        return new EntityViewManagerImpl(this, cbf);
    }

    public EntityViewManager createEntityViewManager(CriteriaBuilderFactory cbf, EntityManagerFactory emf) {
        return this.createEntityViewManager(cbf);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public EntityViewConfiguration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public EntityViewConfiguration addProperties(Properties extraProperties) {
        this.properties.putAll((Map<?, ?>)extraProperties);
        return this;
    }

    public EntityViewConfiguration mergeProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public EntityViewConfiguration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }

    public Map<Class<?>, Object> getTypeTestValues() {
        return this.typeTestValues;
    }

    public <T> EntityViewConfiguration setTypeTestValue(Class<T> type, T value) {
        this.typeTestValues.put(type, value);
        return this;
    }

    public TransactionSupport getTransactionSupport() {
        return this.transactionSupport;
    }

    public EntityViewConfiguration setTransactionSupport(TransactionSupport transactionSupport) {
        this.transactionSupport = transactionSupport;
        return this;
    }

    public Map<String, Object> getOptionalParameters() {
        return this.optionalParameters;
    }

    public Object getOptionalParameter(String name) {
        return this.optionalParameters.get(name);
    }

    public EntityViewConfiguration setOptionalParameter(String name, Object value) {
        this.optionalParameters.put(name, value);
        return this;
    }

    public EntityViewConfiguration setOptionalParameters(Map<String, Object> optionalParameters) {
        this.optionalParameters = optionalParameters;
        return this;
    }

    public EntityViewConfiguration addOptionalParameters(Map<String, Object> optionalParameters) {
        this.optionalParameters.putAll(optionalParameters);
        return this;
    }
}

