/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.AbstractEntityLoader;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.metamodel.SingularAttribute;

public class FlusherBasedEntityLoader
extends AbstractEntityLoader {
    private final DirtyAttributeFlusher<?, Object, Object>[] flushers;
    private volatile String queryString;
    private volatile String queryStringMultiple;

    public FlusherBasedEntityLoader(EntityViewManagerImpl evm, Class<?> entityClass, SingularAttribute<?, ?> jpaIdAttribute, ViewToEntityMapper viewIdMapper, AttributeAccessor entityIdAccessor, DirtyAttributeFlusher<?, Object, Object>[] flushers) {
        super(evm, entityClass, jpaIdAttribute, null, viewIdMapper, entityIdAccessor);
        this.flushers = flushers;
    }

    private String getQueryString() {
        String query = this.queryString;
        if (query != null) {
            return query;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT e FROM ").append(this.entityClass.getName()).append(" e");
        for (int i = 0; i < this.flushers.length; ++i) {
            if (this.flushers[i] == null) continue;
            this.flushers[i].appendFetchJoinQueryFragment("e", sb);
        }
        sb.append(" WHERE e.").append(this.idAttributeName).append(" = :id");
        this.queryString = query = sb.toString();
        return query;
    }

    private String getQueryStringMultiple() {
        String query = this.queryStringMultiple;
        if (query != null) {
            return query;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT e FROM ").append(this.entityClass.getName()).append(" e");
        for (int i = 0; i < this.flushers.length; ++i) {
            if (this.flushers[i] == null) continue;
            this.flushers[i].appendFetchJoinQueryFragment("e", sb);
        }
        sb.append(" WHERE e.").append(this.idAttributeName).append(" IN :entityIds");
        this.queryStringMultiple = query = sb.toString();
        return query;
    }

    @Override
    public Object toEntity(UpdateContext context, Object view, Object id) {
        if (id == null || this.entityIdAccessor == null) {
            return this.createEntity();
        }
        return this.getReferenceOrLoad(context, view, id);
    }

    @Override
    public void toEntities(UpdateContext context, List<Object> views, List<Object> ids) {
        if (this.entityIdAccessor == null) {
            for (int i = 0; i < views.size(); ++i) {
                views.set(i, this.createEntity());
            }
        } else {
            this.getReferencesLoadOrCreate(context, views, ids);
        }
    }

    @Override
    protected Object queryEntity(EntityManager em, Object id) {
        List list = em.createQuery(this.getQueryString()).setParameter("id", id).getResultList();
        if (list.isEmpty()) {
            throw new EntityNotFoundException("Required entity '" + this.entityClass.getName() + "' with id '" + id + "' couldn't be found!");
        }
        return list.get(0);
    }

    @Override
    protected List<Object> queryEntities(EntityManager em, List<Object> ids) {
        List list = em.createQuery(this.getQueryStringMultiple()).setParameter("entityIds", ids).getResultList();
        if (list.size() != ids.size()) {
            throw new EntityNotFoundException("Required entities '" + this.entityClass.getName() + "' with ids '" + ids + "' couldn't all be found!");
        }
        return list;
    }
}

