/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.SecondaryMapper;
import com.blazebit.persistence.view.impl.objectbuilder.ViewTypeObjectBuilderTemplate;
import com.blazebit.persistence.view.impl.objectbuilder.mapper.TupleElementMapper;
import com.blazebit.persistence.view.impl.proxy.ObjectInstantiator;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.spi.ViewJpqlMacro;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;

public class ViewTypeObjectBuilder<T>
implements ObjectBuilder<T> {
    final boolean hasId;
    final boolean nullIfEmpty;
    private final ObjectInstantiator<T> objectInstantiator;
    private final TupleElementMapper[] mappers;
    private final ParameterHolder<?> parameterHolder;
    private final Map<String, Object> optionalParameters;
    private final ViewJpqlMacro viewJpqlMacro;
    private final EmbeddingViewJpqlMacro embeddingViewJpqlMacro;
    private final NavigableSet<String> fetches;
    private final SecondaryMapper[] secondaryMappers;

    public ViewTypeObjectBuilder(ViewTypeObjectBuilderTemplate<T> template, ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters, ViewJpqlMacro viewJpqlMacro, EmbeddingViewJpqlMacro embeddingViewJpqlMacro, NavigableSet<String> fetches, boolean nullIfEmpty) {
        this.hasId = template.hasId();
        this.objectInstantiator = template.getObjectInstantiator();
        this.mappers = template.getMappers();
        this.parameterHolder = parameterHolder;
        this.optionalParameters = optionalParameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(optionalParameters);
        this.viewJpqlMacro = viewJpqlMacro;
        this.embeddingViewJpqlMacro = embeddingViewJpqlMacro;
        this.fetches = fetches;
        this.nullIfEmpty = nullIfEmpty;
        this.secondaryMappers = template.getSecondaryMappers();
    }

    public T build(Object[] tuple) {
        if (this.hasId) {
            if (tuple[0] == null) {
                return null;
            }
        } else if (this.nullIfEmpty) {
            for (int i = 0; i < tuple.length; ++i) {
                if (tuple[i] == null) continue;
                return this.objectInstantiator.newInstance(tuple);
            }
            return null;
        }
        return this.objectInstantiator.newInstance(tuple);
    }

    public List<T> buildList(List<T> list) {
        return list;
    }

    public <X extends SelectBuilder<X>> void applySelects(X queryBuilder) {
        if (this.fetches == null || this.fetches.isEmpty()) {
            if (this.secondaryMappers.length != 0) {
                FullQueryBuilder fullQueryBuilder = (FullQueryBuilder)queryBuilder;
                for (SecondaryMapper viewRoot : this.secondaryMappers) {
                    viewRoot.apply(fullQueryBuilder, this.parameterHolder, this.optionalParameters, this.viewJpqlMacro, this.embeddingViewJpqlMacro);
                }
            }
            for (int i = 0; i < this.mappers.length; ++i) {
                this.mappers[i].applyMapping(queryBuilder, this.parameterHolder, this.optionalParameters, this.viewJpqlMacro, this.embeddingViewJpqlMacro, false);
            }
        } else {
            if (this.secondaryMappers.length != 0) {
                FullQueryBuilder fullQueryBuilder = (FullQueryBuilder)queryBuilder;
                for (SecondaryMapper viewRoot : this.secondaryMappers) {
                    if (!this.hasSubFetches(viewRoot.getAttributePath())) continue;
                    viewRoot.apply(fullQueryBuilder, this.parameterHolder, this.optionalParameters, this.viewJpqlMacro, this.embeddingViewJpqlMacro);
                }
            }
            for (int i = 0; i < this.mappers.length; ++i) {
                TupleElementMapper mapper = this.mappers[i];
                String attributePath = mapper.getAttributePath();
                if (attributePath != null && this.hasSubFetches(attributePath)) {
                    mapper.applyMapping(queryBuilder, this.parameterHolder, this.optionalParameters, this.viewJpqlMacro, this.embeddingViewJpqlMacro, false);
                    continue;
                }
                queryBuilder.select("NULL");
            }
        }
    }

    private boolean hasSubFetches(String attributePath) {
        String fetchedPath = this.fetches.ceiling(attributePath);
        return fetchedPath != null && (fetchedPath.length() == attributePath.length() || fetchedPath.startsWith(attributePath) && fetchedPath.length() > attributePath.length() && fetchedPath.charAt(attributePath.length()) == '.');
    }
}

