/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.LimitBuilder;
import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.PaginatedCriteriaBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpqlMacro;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.CorrelationProviderHelper;
import com.blazebit.persistence.view.impl.EntityViewConfiguration;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.ExpressionUtils;
import com.blazebit.persistence.view.impl.PrefixingQueryGenerator;
import com.blazebit.persistence.view.impl.macro.CorrelatedSubqueryViewRootJpqlMacro;
import com.blazebit.persistence.view.impl.macro.MutableEmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.impl.macro.MutableViewJpqlMacro;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.objectbuilder.ContainerAccumulator;
import com.blazebit.persistence.view.impl.objectbuilder.LateAdditionalObjectBuilder;
import com.blazebit.persistence.view.impl.objectbuilder.Limiter;
import com.blazebit.persistence.view.impl.objectbuilder.transformator.UpdatableViewMap;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.TupleTransformer;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.Correlator;
import com.blazebit.persistence.view.impl.objectbuilder.transformer.correlation.SubqueryCorrelationBuilder;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.spi.ViewJpqlMacro;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Parameter;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;

public class AbstractCorrelatedSubselectTupleTransformer
implements TupleTransformer {
    protected static final String[] EMPTY = new String[0];
    private static final Logger LOG = Logger.getLogger(AbstractCorrelatedSubselectTupleTransformer.class.getName());
    protected final EntityViewManagerImpl evm;
    protected final String viewRootAlias;
    protected final String viewRootIdExpression;
    protected final int viewRootIdMapperCount;
    protected final String embeddingViewPath;
    protected final String embeddingViewIdExpression;
    protected final int embeddingViewIdMapperCount;
    protected final int maximumViewMapperCount;
    protected final String correlationBasisExpression;
    protected final String correlationKeyExpression;
    protected final int valueIndex;
    protected final String[] fetches;
    protected final String[] indexFetches;
    protected final Correlator correlator;
    protected final Correlator indexCorrelator;
    protected final int viewRootIndex;
    protected final int embeddingViewIndex;
    protected final Class<?> correlationBasisType;
    protected final Class<?> correlationBasisEntity;
    protected final Class<?> viewRootEntityClass;
    protected final ManagedViewTypeImplementor<?> embeddingViewType;
    protected final ManagedViewTypeImplementor<?> viewRootType;
    protected final String idAttributePath;
    protected final String correlationResultExpression;
    protected final String correlationAlias;
    protected final String correlationExternalAlias;
    protected final String indexExpression;
    protected final CorrelationProviderFactory correlationProviderFactory;
    protected final EntityViewConfiguration entityViewConfiguration;
    protected final int startIndex;
    protected final String attributePath;
    protected final ContainerAccumulator<Object> containerAccumulator;
    protected final Limiter limiter;
    protected FullQueryBuilder<?, ?> criteriaBuilder;
    protected int viewIndex;
    protected Map<Object, Map<Object, Object>> collections;
    protected CorrelatedSubqueryViewRootJpqlMacro viewRootJpqlMacro;
    protected MutableEmbeddingViewJpqlMacro embeddingViewJpqlMacro;

    public AbstractCorrelatedSubselectTupleTransformer(ExpressionFactory ef, Correlator correlator, ContainerAccumulator<?> containerAccumulator, EntityViewManagerImpl evm, ManagedViewTypeImplementor<?> viewRootType, String viewRootAlias, ManagedViewTypeImplementor<?> embeddingViewType, String embeddingViewPath, Expression correlationResult, String correlationBasisExpression, String correlationKeyExpression, CorrelationProviderFactory correlationProviderFactory, String attributePath, String[] fetches, String[] indexFetches, Expression index, Correlator indexCorrelator, int viewRootIndex, int embeddingViewIndex, int tupleIndex, Class<?> correlationBasisType, Class<?> correlationBasisEntity, Limiter limiter, EntityViewConfiguration entityViewConfiguration) {
        this.startIndex = tupleIndex;
        this.attributePath = attributePath;
        this.containerAccumulator = containerAccumulator;
        this.evm = evm;
        this.correlationProviderFactory = correlationProviderFactory;
        this.entityViewConfiguration = entityViewConfiguration;
        this.correlationBasisType = correlationBasisType;
        this.viewRootAlias = viewRootAlias;
        this.viewRootIndex = viewRootIndex;
        String viewRootAliasPrefix = viewRootAlias + ".";
        this.viewRootType = viewRootType;
        this.viewRootIdExpression = viewRootAliasPrefix + this.getEntityIdName(entityViewConfiguration, viewRootType.getEntityClass());
        this.viewRootIdMapperCount = AbstractCorrelatedSubselectTupleTransformer.viewIdMapperCount(viewRootType);
        this.embeddingViewIndex = embeddingViewIndex;
        this.embeddingViewType = embeddingViewType;
        this.embeddingViewPath = embeddingViewPath;
        this.embeddingViewIdExpression = viewRootAlias.equals(embeddingViewPath) ? viewRootAliasPrefix + this.getEntityIdName(entityViewConfiguration, embeddingViewType.getEntityClass()) : embeddingViewPath + "." + this.getEntityIdName(entityViewConfiguration, embeddingViewType.getEntityClass());
        this.embeddingViewIdMapperCount = AbstractCorrelatedSubselectTupleTransformer.viewIdMapperCount(embeddingViewType);
        this.maximumViewMapperCount = Math.max(1, Math.max(this.viewRootIdMapperCount, this.embeddingViewIdMapperCount));
        this.correlationBasisExpression = correlationBasisExpression;
        this.correlationKeyExpression = correlationKeyExpression;
        this.valueIndex = correlator.getElementOffset();
        this.limiter = limiter;
        this.correlationAlias = CorrelationProviderHelper.getDefaultCorrelationAlias(attributePath);
        this.correlationExternalAlias = limiter == null ? this.correlationAlias : CorrelationProviderHelper.getDefaultExternalCorrelationAlias(attributePath);
        this.correlationResultExpression = ExpressionUtils.isEmptyOrThis(correlationResult) ? this.correlationExternalAlias : PrefixingQueryGenerator.prefix(ef, correlationResult, this.correlationExternalAlias, viewRootType.getEntityViewRootTypes().keySet(), true);
        this.indexExpression = index == null ? null : PrefixingQueryGenerator.prefix(ef, index, this.correlationResultExpression, viewRootType.getEntityViewRootTypes().keySet(), true);
        this.fetches = AbstractCorrelatedSubselectTupleTransformer.prefix(this.correlationAlias, fetches);
        this.indexFetches = AbstractCorrelatedSubselectTupleTransformer.prefix(this.indexExpression, indexFetches);
        this.correlator = correlator;
        this.indexCorrelator = indexCorrelator;
        this.correlationBasisEntity = correlationBasisEntity;
        this.viewRootEntityClass = viewRootType.getEntityClass();
        this.idAttributePath = this.getEntityIdName(entityViewConfiguration, this.viewRootEntityClass);
    }

    private void prepare() {
        ObjectBuilder<?> indexBuilder;
        EntityViewConfiguration configuration;
        int elementViewIndex;
        int elementKeyIndex;
        int maximumSlotsFilled;
        int i;
        JpaProvider jpaProvider = (JpaProvider)this.entityViewConfiguration.getCriteriaBuilder().getService(JpaProvider.class);
        FullQueryBuilder<?, ?> queryBuilder = this.entityViewConfiguration.getCriteriaBuilder();
        Map<String, Object> optionalParameters = this.entityViewConfiguration.getOptionalParameters();
        Class<?> correlationBasisEntityType = this.correlationBasisEntity;
        String viewRootExpression = this.viewRootAlias;
        EmbeddingViewJpqlMacro embeddingViewJpqlMacro = this.entityViewConfiguration.getEmbeddingViewJpqlMacro();
        ViewJpqlMacro viewJpqlMacro = this.entityViewConfiguration.getViewJpqlMacro();
        if (queryBuilder instanceof PaginatedCriteriaBuilder) {
            this.criteriaBuilder = queryBuilder.copyCriteriaBuilder(Object[].class, false);
        } else {
            LimitBuilder limitBuilder = (LimitBuilder)queryBuilder;
            if (jpaProvider.supportsSubqueryInFunction() && (limitBuilder.getFirstResult() > 0 || limitBuilder.getMaxResults() < Integer.MAX_VALUE)) {
                try {
                    this.criteriaBuilder = queryBuilder.copyCriteriaBuilder(Object[].class, true).page(limitBuilder.getFirstResult(), limitBuilder.getMaxResults()).copyCriteriaBuilder(Object[].class, false);
                }
                catch (IllegalStateException ex) {
                    LOG.log(Level.WARNING, "Could not create a paginated criteria builder for SUBSELECT fetching which might lead to bad performance", ex);
                    this.criteriaBuilder = queryBuilder.copyCriteriaBuilder(Object[].class, false);
                }
            } else {
                this.criteriaBuilder = queryBuilder.copyCriteriaBuilder(Object[].class, false);
            }
        }
        int originalFirstResult = 0;
        int originalMaxResults = Integer.MAX_VALUE;
        ((LimitBuilder)this.criteriaBuilder).setFirstResult(originalFirstResult);
        ((LimitBuilder)this.criteriaBuilder).setMaxResults(originalMaxResults);
        this.viewRootJpqlMacro = new CorrelatedSubqueryViewRootJpqlMacro(this.criteriaBuilder, optionalParameters, false, this.viewRootEntityClass, this.idAttributePath, viewRootExpression);
        this.criteriaBuilder.registerMacro("view", (JpqlMacro)viewJpqlMacro);
        this.criteriaBuilder.registerMacro("view_root", (JpqlMacro)this.viewRootJpqlMacro);
        this.criteriaBuilder.registerMacro("embedding_view", (JpqlMacro)embeddingViewJpqlMacro);
        String oldViewPath = viewJpqlMacro.getViewPath();
        String oldEmbeddingViewPath = embeddingViewJpqlMacro.getEmbeddingViewPath();
        viewJpqlMacro.setViewPath(this.correlationResultExpression);
        embeddingViewJpqlMacro.setEmbeddingViewPath(this.embeddingViewPath);
        String joinBase = this.embeddingViewPath;
        SubqueryCorrelationBuilder correlationBuilder = new SubqueryCorrelationBuilder((ParameterHolder<?>)queryBuilder, optionalParameters, this.criteriaBuilder, this.correlationAlias, this.correlationExternalAlias, this.correlationResultExpression, this.correlationBasisType, correlationBasisEntityType, joinBase, this.attributePath, 1, this.limiter, true);
        CorrelationProvider provider = this.correlationProviderFactory.create(this.entityViewConfiguration.getCriteriaBuilder(), this.entityViewConfiguration.getOptionalParameters());
        provider.applyCorrelation((CorrelationBuilder)correlationBuilder, this.correlationBasisExpression);
        if (this.criteriaBuilder instanceof LimitBuilder && (originalFirstResult != ((LimitBuilder)this.criteriaBuilder).getFirstResult() || originalMaxResults != ((LimitBuilder)this.criteriaBuilder).getMaxResults())) {
            throw new IllegalArgumentException("Correlation provider '" + provider + "' wrongly uses setFirstResult() or setMaxResults() on the query builder which might lead to wrong results. Use SELECT fetching with batch size 1 or reformulate the correlation provider to use the limit/offset in a subquery!");
        }
        if (this.fetches.length != 0) {
            for (i = 0; i < this.fetches.length; ++i) {
                this.criteriaBuilder.fetch(this.fetches[i]);
            }
        }
        if (this.indexFetches.length != 0) {
            for (i = 0; i < this.indexFetches.length; ++i) {
                this.criteriaBuilder.fetch(this.indexFetches[i]);
            }
        }
        String correlationRoot = correlationBuilder.getCorrelationRoot();
        int tupleSuffix = this.maximumViewMapperCount + 1 + (this.indexCorrelator == null && this.indexExpression == null ? 0 : 1);
        LateAdditionalObjectBuilder objectBuilder = this.correlator.finish(this.criteriaBuilder, this.entityViewConfiguration, 0, tupleSuffix, correlationRoot, embeddingViewJpqlMacro, true);
        boolean usesViewRoot = this.viewRootJpqlMacro.usesViewMacro();
        boolean usesEmbeddingView = embeddingViewJpqlMacro.usesEmbeddingView();
        if (usesEmbeddingView && !(this.embeddingViewType instanceof ViewType)) {
            throw new IllegalStateException("The use of EMBEDDING_VIEW in the correlation for '" + this.embeddingViewType.getJavaType().getName() + "." + this.attributePath.substring(this.attributePath.lastIndexOf(46) + 1) + "' is illegal because the embedding view type '" + this.embeddingViewType.getJavaType().getName() + "' does not declare a @IdMapping!");
        }
        if (usesViewRoot && !(this.viewRootType instanceof ViewType)) {
            throw new IllegalStateException("The use of VIEW_ROOT in the correlation for '" + this.embeddingViewType.getJavaType().getName() + "." + this.attributePath.substring(this.attributePath.lastIndexOf(46) + 1) + "' is illegal because the view root type '" + this.viewRootType.getJavaType().getName() + "' does not declare a @IdMapping!");
        }
        if (usesEmbeddingView) {
            maximumSlotsFilled = this.embeddingViewIdMapperCount == 0 ? 1 : this.embeddingViewIdMapperCount;
            elementKeyIndex = this.maximumViewMapperCount - maximumSlotsFilled + 2 + this.valueIndex;
            elementViewIndex = this.maximumViewMapperCount - maximumSlotsFilled + 1 + this.valueIndex;
            this.viewIndex = this.embeddingViewIndex;
        } else if (usesViewRoot) {
            maximumSlotsFilled = this.viewRootIdMapperCount == 0 ? 1 : this.viewRootIdMapperCount;
            elementKeyIndex = this.maximumViewMapperCount - maximumSlotsFilled + 2 + this.valueIndex;
            elementViewIndex = this.maximumViewMapperCount - maximumSlotsFilled + 1 + this.valueIndex;
            this.viewIndex = this.viewRootIndex;
        } else {
            maximumSlotsFilled = 0;
            elementKeyIndex = this.maximumViewMapperCount + 1 + this.valueIndex;
            elementViewIndex = 1 + this.valueIndex;
            this.viewIndex = -1;
        }
        for (int i2 = maximumSlotsFilled; i2 < this.maximumViewMapperCount; ++i2) {
            this.criteriaBuilder.select("NULL");
        }
        ExpressionFactory ef = (ExpressionFactory)this.criteriaBuilder.getService(ExpressionFactory.class);
        if (usesEmbeddingView) {
            configuration = new EntityViewConfiguration(this.criteriaBuilder, ef, (ViewJpqlMacro)new MutableViewJpqlMacro(), (EmbeddingViewJpqlMacro)new MutableEmbeddingViewJpqlMacro(), Collections.emptyMap(), Collections.emptyMap(), this.entityViewConfiguration.getFetches(), this.attributePath);
            ObjectBuilder<Object[]> embeddingViewObjectBuilder = this.createViewAwareObjectBuilder(this.criteriaBuilder, this.embeddingViewType, configuration, this.embeddingViewIdExpression);
            if (embeddingViewObjectBuilder == null) {
                this.criteriaBuilder.select(this.embeddingViewIdExpression);
            } else {
                objectBuilder = new LateAdditionalObjectBuilder(objectBuilder, embeddingViewObjectBuilder, true);
                this.criteriaBuilder.selectNew((ObjectBuilder)objectBuilder);
            }
        } else if (usesViewRoot) {
            configuration = new EntityViewConfiguration(this.criteriaBuilder, ef, (ViewJpqlMacro)new MutableViewJpqlMacro(), (EmbeddingViewJpqlMacro)new MutableEmbeddingViewJpqlMacro(), Collections.emptyMap(), Collections.emptyMap(), this.entityViewConfiguration.getFetches(), this.attributePath);
            ObjectBuilder<Object[]> viewRootObjectBuilder = this.createViewAwareObjectBuilder(this.criteriaBuilder, this.viewRootType, configuration, this.viewRootIdExpression);
            if (viewRootObjectBuilder == null) {
                this.criteriaBuilder.select(this.viewRootIdExpression);
            } else {
                objectBuilder = new LateAdditionalObjectBuilder(objectBuilder, viewRootObjectBuilder, true);
                this.criteriaBuilder.selectNew((ObjectBuilder)objectBuilder);
            }
        }
        this.criteriaBuilder.select(this.correlationKeyExpression);
        if (this.indexCorrelator != null && (indexBuilder = this.indexCorrelator.finish(this.criteriaBuilder, this.entityViewConfiguration, this.maximumViewMapperCount + 2, 0, this.indexExpression, embeddingViewJpqlMacro, true)) != null) {
            this.criteriaBuilder.selectNew((ObjectBuilder)new LateAdditionalObjectBuilder(objectBuilder, indexBuilder, false));
        }
        this.populateParameters(this.entityViewConfiguration, this.criteriaBuilder);
        viewJpqlMacro.setViewPath(oldViewPath);
        embeddingViewJpqlMacro.setEmbeddingViewPath(oldEmbeddingViewPath);
        List resultList = this.criteriaBuilder.getResultList();
        HashMap<Object, Map<Object, Object>> collections = new HashMap<Object, Map<Object, Object>>(resultList.size());
        for (int i3 = 0; i3 < resultList.size(); ++i3) {
            Object[] element = (Object[])resultList.get(i3);
            HashMap<Object, Object> viewRootResult = (HashMap<Object, Object>)collections.get(element[elementViewIndex]);
            if (viewRootResult == null) {
                viewRootResult = new HashMap<Object, Object>();
                collections.put(element[elementViewIndex], viewRootResult);
            }
            if (this.containerAccumulator == null) {
                viewRootResult.put(element[elementKeyIndex], element[this.valueIndex]);
                continue;
            }
            Object result = viewRootResult.get(element[elementKeyIndex]);
            if (result == null) {
                result = this.createDefaultResult();
                viewRootResult.put(element[elementKeyIndex], result);
            }
            Object indexObject = null;
            if (this.indexCorrelator != null || this.indexExpression != null) {
                indexObject = element[elementKeyIndex + 1];
            }
            this.containerAccumulator.add(result, indexObject, element[this.valueIndex], this.isRecording());
        }
        this.collections = collections;
    }

    @Override
    public int getConsumeStartIndex() {
        return -1;
    }

    @Override
    public int getConsumeEndIndex() {
        return -1;
    }

    protected String getEntityIdName(EntityViewConfiguration entityViewConfiguration, Class<?> entityClass) {
        ManagedType managedType = entityViewConfiguration.getCriteriaBuilder().getMetamodel().managedType(entityClass);
        if (JpaMetamodelUtils.isIdentifiable((ManagedType)managedType)) {
            return JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)((IdentifiableType)managedType)).getName();
        }
        return null;
    }

    private static String[] prefix(String prefix, String[] fetches) {
        if (fetches == null || fetches.length == 0) {
            return fetches;
        }
        String[] newFetches = new String[fetches.length];
        for (int i = 0; i < fetches.length; ++i) {
            newFetches[i] = (prefix + "." + fetches[i]).intern();
        }
        return newFetches;
    }

    private static int viewIdMapperCount(ManagedViewType<?> viewRootType) {
        MethodAttribute idAttribute;
        if (viewRootType instanceof ViewType && (idAttribute = ((ViewType)viewRootType).getIdAttribute()).isSubview()) {
            return AbstractCorrelatedSubselectTupleTransformer.viewIdMapperCount(idAttribute);
        }
        return 0;
    }

    private static int viewIdMapperCount(MethodAttribute<?, ?> attribute) {
        if (attribute.isSubview()) {
            ManagedViewType viewType = (ManagedViewType)((SingularAttribute)attribute).getType();
            int count = 0;
            for (MethodAttribute methodAttribute : viewType.getAttributes()) {
                count += AbstractCorrelatedSubselectTupleTransformer.viewIdMapperCount(methodAttribute);
            }
            return count;
        }
        return 1;
    }

    protected void populateParameters(EntityViewConfiguration entityViewConfiguration, FullQueryBuilder<?, ?> queryBuilder) {
        FullQueryBuilder<?, ?> mainBuilder = entityViewConfiguration.getCriteriaBuilder();
        for (Parameter parameter : mainBuilder.getParameters()) {
            if (!queryBuilder.containsParameter(parameter.getName()) || queryBuilder.isParameterSet(parameter.getName())) continue;
            queryBuilder.setParameter(parameter.getName(), mainBuilder.getParameterValue(parameter.getName()));
        }
        for (Map.Entry entry : entityViewConfiguration.getOptionalParameters().entrySet()) {
            if (!queryBuilder.containsParameter((String)entry.getKey()) || queryBuilder.isParameterSet((String)entry.getKey())) continue;
            queryBuilder.setParameter((String)entry.getKey(), entry.getValue());
        }
    }

    private ObjectBuilder<Object[]> createViewAwareObjectBuilder(FullQueryBuilder<?, ?> criteriaBuilder, ManagedViewType<?> viewType, EntityViewConfiguration configuration, String viewRoot) {
        MethodAttribute idAttribute;
        if (!(viewType instanceof ViewType) || !(idAttribute = ((ViewType)viewType).getIdAttribute()).isSubview()) {
            return null;
        }
        ManagedViewType idViewType = (ManagedViewType)((SingularAttribute)idAttribute).getType();
        return this.evm.createObjectBuilder((ManagedViewTypeImplementor)idViewType, null, viewRoot, "", criteriaBuilder, configuration, 1, 1, false);
    }

    protected boolean isRecording() {
        return false;
    }

    protected Object createDefaultResult() {
        return this.containerAccumulator == null ? null : this.containerAccumulator.createContainer(this.isRecording(), 0);
    }

    @Override
    public Object[] transform(Object[] tuple, UpdatableViewMap updatableViewMap) {
        if (this.collections == null) {
            this.prepare();
        }
        Object viewKey = this.viewIndex == -1 ? null : tuple[this.viewIndex];
        Map<Object, Object> collectionsByKey = this.collections.get(viewKey);
        Object correlationValueKey = tuple[this.startIndex];
        if (correlationValueKey == null) {
            tuple[this.startIndex] = this.createDefaultResult();
        } else if (collectionsByKey == null) {
            collectionsByKey = new HashMap<Object, Object>();
            this.collections.put(viewKey, collectionsByKey);
            tuple[this.startIndex] = this.createDefaultResult();
            collectionsByKey.put(correlationValueKey, tuple[this.startIndex]);
        } else {
            Object collection = collectionsByKey.get(correlationValueKey);
            if (collection == null) {
                tuple[this.startIndex] = this.createDefaultResult();
                collectionsByKey.put(correlationValueKey, tuple[this.startIndex]);
            } else {
                tuple[this.startIndex] = collection;
            }
        }
        return tuple;
    }
}

